/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.soap.parse;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceException;
import com.ibm.ws.sib.mfp.sdo.resource.WSDLMetaData;
import com.ibm.ws.sib.mfp.sdo.soap.DocumentScanner;
import com.ibm.ws.sib.mfp.sdo.soap.parse.InfoNodeStore;
import com.ibm.ws.sib.mfp.sdo.soap.parse.ParseState;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.sdo.DataMediatorException;
import com.ibm.xml.b2b.util.QName;
import java.io.IOException;

public class EnvelopeHandler
extends ParseState {
    private static TraceComponent tc = SibTr.register(EnvelopeHandler.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    InfoNodeStore infoStore;
    WSDLMetaData meta;
    boolean inEnvelope;
    boolean inHeader;
    boolean inBody;

    EnvelopeHandler(InfoNodeStore infoNodeStore, DocumentScanner documentScanner) throws ResourceException, DataMediatorException {
        super(documentScanner, true, infoNodeStore.getWSDLMetaData());
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        this.infoStore = infoNodeStore;
        this.meta = this.infoStore.getWSDLMetaData();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    private void handleEndElementEvent() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "handleEndElementEvent");
        }
        if (this.inBody) {
            this.inBody = false;
        } else if (this.inHeader) {
            this.inHeader = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "handleEndElementEvent");
        }
    }

    public void endElementEvent() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "endElementEvent");
        }
        this.handleEndElementEvent();
        super.endElementEvent();
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "endElementEvent");
        }
    }

    public void startElementEvent(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "startElementEvent");
        }
        super.startElementEvent(bl);
        QName qName = this.getScannerState().currentElement;
        if (!this.inEnvelope) {
            if (!"Envelope".equals(qName.localPart) || !this.meta.isSOAPEnvelopeNamespace(qName.namespaceURI)) {
                String string = nls.getFormattedMessage("ENVELOPE_PARSE_ERROR_CWSIF0293", new Object[]{qName.localPart, qName.namespaceURI}, "Invalid envelope");
                DataMediatorException dataMediatorException = new DataMediatorException(string);
                throw new DocumentScanner.TunneledDataMediatorException(dataMediatorException);
            }
            this.inEnvelope = true;
        } else if (!this.inHeader && !this.inBody) {
            Object object;
            if (this.meta.isSOAPEnvelopeNamespace(qName.namespaceURI)) {
                if ("Header".equals(qName.localPart)) {
                    this.inHeader = true;
                    if (!bl) {
                        try {
                            object = this.getContentAsSavedState();
                            this.infoStore.setHeaderState((DocumentScanner.SavedState)object);
                        }
                        catch (IOException iOException) {
                            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.mfp.sdo.soap.parse.EnvelopeHandler.startElementEvent", (String)"140", (Object)this);
                            TunneledIOException tunneledIOException = new TunneledIOException(iOException);
                            throw tunneledIOException;
                        }
                    }
                } else if ("Body".equals(qName.localPart)) {
                    this.inBody = true;
                    if (!bl) {
                        try {
                            object = this.getContentAsSavedState();
                            this.infoStore.setBodyState((DocumentScanner.SavedState)object);
                        }
                        catch (IOException iOException) {
                            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.mfp.sdo.soap.parse.EnvelopeHandler.startElementEvent", (String)"153", (Object)this);
                            TunneledIOException tunneledIOException = new TunneledIOException(iOException);
                            throw tunneledIOException;
                        }
                    }
                }
            }
            if (!this.inHeader && !this.inBody) {
                object = nls.getFormattedMessage("ENVELOPE_PARSE_ERROR_CWSIF0294", new Object[]{qName.localPart, qName.namespaceURI}, "Invalid element inside SOAP envelope");
                DataMediatorException dataMediatorException = new DataMediatorException((String)object);
                throw new DocumentScanner.TunneledDataMediatorException(dataMediatorException);
            }
        }
        if (bl) {
            this.handleEndElementEvent();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "startElementEvent");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/soap/parse/EnvelopeHandler.java, SIB.mfp, WAS602.SIB, o0610.11 1.13");
        }
    }

    class TunneledIOException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private IOException exception;

        TunneledIOException(IOException iOException) {
            this.exception = iOException;
        }

        IOException getException() {
            return this.exception;
        }
    }
}

