/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.soap.parse;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceException;
import com.ibm.ws.sib.mfp.sdo.soap.SOAPFormatDescriptor;
import com.ibm.ws.sib.mfp.sdo.soap.parse.BasicXMLHandler;
import com.ibm.ws.sib.mfp.sdo.soap.parse.HandlerStack;
import com.ibm.ws.sib.mfp.sdo.soap.parse.MIMEPartHandler;
import com.ibm.ws.sib.mfp.sdo.soap.parse.SOAPParser;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.sdo.DataMediatorException;
import com.ibm.xml.b2b.util.QName;
import commonj.sdo.DataObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.sdo.EProperty;

public class DocumentHandler
extends HandlerStack.HandlerBase {
    private static TraceComponent tc = SibTr.register(DocumentHandler.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private SOAPParser.BasicState state;
    private DataObject messageNode;
    private HandlerStack.HandlerBase nestedHandler;
    private List partList;
    private int partIndex;
    private Map mimeParts;
    private List mimeContentIds;

    DocumentHandler(SOAPParser.BasicState basicState, DataObject dataObject, List list) throws ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        this.state = basicState;
        this.messageNode = dataObject;
        this.partList = this.messageNode.getType().getProperties();
        SOAPFormatDescriptor sOAPFormatDescriptor = this.state.getDescriptor();
        this.mimeParts = this.state.getWsdlMetaData().getMIMEParts(sOAPFormatDescriptor);
        this.mimeContentIds = list;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    boolean allowText() {
        return false;
    }

    private void handleEndElementEvent() throws ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "handleEndElementEvent");
        }
        if (this.nestedHandler != null) {
            this.nestedHandler = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "handleEndElementEvent");
        }
    }

    public void endElementEvent() throws DataMediatorException, ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "endElementEvent");
        }
        if (this.nestedHandler != null) {
            this.nestedHandler.endElementEvent();
        }
        this.handleEndElementEvent();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "endElementEvent");
        }
    }

    public void startElementEvent(boolean bl) throws DataMediatorException, ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "startElementEvent");
        }
        HandlerStack handlerStack = this.getHandlerStack();
        QName qName = handlerStack.getScannerState().currentElement;
        EProperty eProperty = (EProperty)this.partList.get(this.partIndex++);
        String string = eProperty.getName();
        while (this.mimeParts != null && this.mimeParts.containsKey(string)) {
            boolean bl2 = false;
            if (this.mimeContentIds != null) {
                Iterator iterator = this.mimeContentIds.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (!MIMEPartHandler.matchesPartName(string, string2)) continue;
                    bl2 = true;
                }
            }
            if (string.equals(qName.localPart) || !bl2) break;
            eProperty = (EProperty)this.partList.get(this.partIndex++);
            string = eProperty.getName();
        }
        if (this.mimeParts != null && this.mimeParts.containsKey(string)) {
            MIMEPartHandler mIMEPartHandler = new MIMEPartHandler(this.state);
            mIMEPartHandler.setExpectedPart(eProperty);
            this.nestedHandler = mIMEPartHandler;
        } else {
            BasicXMLHandler basicXMLHandler = new BasicXMLHandler(this.state);
            basicXMLHandler.setCurrentNode(this.messageNode);
            basicXMLHandler.setExpectedPart(eProperty);
            this.nestedHandler = basicXMLHandler;
        }
        handlerStack.pushDocumentHandler(this.nestedHandler);
        this.nestedHandler.startElementEvent(bl);
        if (bl) {
            this.handleEndElementEvent();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "startElementEvent");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/soap/parse/DocumentHandler.java, SIB.mfp, WAS602.SIB, o0610.11 1.17");
        }
    }
}

