/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.soap.parse;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.mfp.sdo.SdoInstanceFactory;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceException;
import com.ibm.ws.sib.mfp.sdo.resource.WSDLMetaData;
import com.ibm.ws.sib.mfp.sdo.resource.XSDMetaData;
import com.ibm.ws.sib.mfp.sdo.resource.XSDResourceHelper;
import com.ibm.ws.sib.mfp.sdo.soap.parse.HandlerStack;
import com.ibm.ws.sib.mfp.sdo.soap.parse.SOAPParser;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.sdo.DataMediatorException;
import com.ibm.xml.b2b.scan.DocumentScannerSupport;
import com.ibm.xml.b2b.util.XMLName;
import com.ibm.xml.b2b.util.XMLString;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.emf.ecore.sdo.EDataObjectSimpleAnyType;
import org.eclipse.emf.ecore.sdo.EProperty;
import org.eclipse.emf.ecore.sdo.SDOPackage;
import org.eclipse.emf.ecore.sdo.util.SDOUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.xsd.util.XSDConstants;

class BasicXMLHandler
extends HandlerStack.HandlerBase {
    private static TraceComponent tc = SibTr.register(BasicXMLHandler.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private XSDMetaData util;
    private WSDLMetaData wsdlUtil;
    private EDataObject topNode;
    private EDataObject currentNode;
    private EStructuralFeature currentFeature;
    private StringBuffer currentText = new StringBuffer();
    private boolean xsiNil = false;
    private SOAPParser.BasicState state;
    private EStructuralFeature expectedPart;

    BasicXMLHandler(SOAPParser.BasicState basicState) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        this.state = basicState;
        this.util = this.state.getXsdMetaData();
        this.wsdlUtil = this.state.getWsdlMetaData();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    boolean allowText() {
        return true;
    }

    void setCurrentNode(DataObject dataObject) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setCurrentNode");
        }
        if (this.topNode == null) {
            this.topNode = (EDataObject)dataObject;
        }
        this.currentNode = (EDataObject)dataObject;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setCurrentNode");
        }
    }

    void setExpectedPart(EProperty eProperty) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setExpectedPart", eProperty);
        }
        if (eProperty != null) {
            this.expectedPart = eProperty.getEStructuralFeature();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setExpectedPart");
        }
    }

    DataObject getTopNode() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getTopNode");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getTopNode");
        }
        return this.topNode;
    }

    private String mapPrefixToNamespace(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "mapPrefixToNamespace", (Object)string);
        }
        DocumentScannerSupport documentScannerSupport = this.getHandlerStack().getScannerState();
        String string2 = null;
        for (int i = documentScannerSupport.lastMapping - 1; i >= 0; --i) {
            if (!string.equals(documentScannerSupport.prefixes[i])) continue;
            string2 = documentScannerSupport.namespaceURIs[i];
            break;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "mapPrefixToNamespace", string2);
        }
        return string2;
    }

    private Object handleValue(EDataType eDataType, String string) throws DataMediatorException {
        EFactory eFactory;
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "handleValue", new Object[]{eDataType, string});
        }
        if ((object = (eFactory = eDataType.getEPackage().getEFactoryInstance()).createFromString(eDataType, string)) == null) {
            ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
            String string2 = extendedMetaData.getName((EClassifier)eDataType);
            String string3 = extendedMetaData.getNamespace(eDataType.getEPackage());
            String string4 = nls.getFormattedMessage("VALUE_PARSE_ERROR_CWSIF0301", new Object[]{string2, string3, this.currentText}, "Unable to parse value");
            throw new DataMediatorException(string4);
        }
        if (object instanceof List) {
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                list.set(i, this.formatParsedItem(e));
            }
        } else {
            object = this.formatParsedItem(object);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "handleValue", object);
        }
        return object;
    }

    private Object formatParsedItem(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "formatParsedItem");
        }
        Object object2 = object;
        if (object instanceof QName) {
            QName qName = (QName)object;
            String string = this.mapPrefixToNamespace(qName.getPrefix());
            object2 = new QName(string, qName.getLocalPart(), qName.getPrefix());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "formatParsedItem");
        }
        return object2;
    }

    private void handleContent() throws DataMediatorException {
        String string;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "handleContent");
        }
        if (this.currentText.length() > 0 && !(string = this.currentText.toString()).matches("[ \t\n\r]*")) {
            if (this.xsiNil) {
                EClass eClass = this.currentNode.eClass();
                ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
                String string2 = extendedMetaData.getName((EClassifier)eClass);
                String string3 = extendedMetaData.getNamespace((EClassifier)eClass);
                String string4 = nls.getFormattedMessage("NIL_DATA_ERROR_CWSIF0298", new Object[]{string2, string3, string}, "Data in nil element");
                throw new DataMediatorException(string4);
            }
            EStructuralFeature eStructuralFeature = this.currentFeature;
            if (eStructuralFeature == null) {
                eStructuralFeature = ExtendedMetaData.INSTANCE.getSimpleFeature(this.currentNode.eClass());
            }
            if (eStructuralFeature != null) {
                Object object = this.handleValue((EDataType)eStructuralFeature.getEType(), string);
                this.setValue(eStructuralFeature, object);
            } else {
                ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
                EClass eClass = this.currentNode.eClass();
                EAttribute eAttribute = extendedMetaData.getMixedFeature(eClass);
                if (eAttribute != null) {
                    Sequence sequence = this.currentNode.getSequence(eAttribute.getFeatureID());
                    EAttribute eAttribute2 = XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Text();
                    EProperty eProperty = SDOUtil.adaptProperty((EStructuralFeature)eAttribute2);
                    sequence.add((Property)eProperty, (Object)string);
                } else {
                    String string5 = extendedMetaData.getName((EClassifier)eClass);
                    String string6 = extendedMetaData.getNamespace((EClassifier)eClass);
                    String string7 = nls.getFormattedMessage("VALUE_PARSE_ERROR_CWSIF0302", new Object[]{string5, string6, this.currentText}, "Unable to store mixed text.");
                    throw new DataMediatorException(string7);
                }
            }
        }
        this.currentText.delete(0, this.currentText.length());
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "handleContent");
        }
    }

    private void handleChild(EStructuralFeature eStructuralFeature, EClassifier eClassifier) throws ResourceException, DataMediatorException {
        EDataObjectSimpleAnyType eDataObjectSimpleAnyType;
        DataObject dataObject;
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "handleChild", new Object[]{eStructuralFeature, eClassifier});
        }
        HandlerStack handlerStack = this.getHandlerStack();
        DocumentScannerSupport documentScannerSupport = handlerStack.getScannerState();
        com.ibm.xml.b2b.util.QName qName = documentScannerSupport.currentElement;
        String string = qName.namespaceURI;
        String string2 = qName.localPart;
        String string3 = qName.prefix;
        if (eClassifier instanceof EDataType) {
            if (eStructuralFeature.getEType() instanceof EClass) {
                object = SDOPackage.eINSTANCE.getEDataObjectSimpleAnyType();
                dataObject = object.getEPackage().getEFactoryInstance();
                eDataObjectSimpleAnyType = (EDataObjectSimpleAnyType)dataObject.create((EClass)object);
                if (this.currentNode != null) {
                    this.setValue(eStructuralFeature, eDataObjectSimpleAnyType);
                }
                this.setCurrentNode((DataObject)eDataObjectSimpleAnyType);
                eDataObjectSimpleAnyType.setInstanceType((EDataType)eClassifier);
            } else {
                if (this.currentNode == null) {
                    String string4 = nls.getFormattedMessage("SIMPLE_ELEMENT_ERROR_CWSIF0309", new Object[]{string2, string}, "Simple top-level element cannot be handled.");
                    throw new DataMediatorException(string4);
                }
                this.currentFeature = eStructuralFeature;
            }
        } else {
            object = eClassifier.getEPackage().getEFactoryInstance();
            dataObject = (DataObject)object.create((EClass)eClassifier);
            if (this.currentNode != null) {
                this.setValue(eStructuralFeature, dataObject);
            }
            this.setCurrentNode(dataObject);
        }
        object = handlerStack.getProcessedAttributes();
        for (int i = 0; i < documentScannerSupport.attrCount; ++i) {
            if (object[i] == false) {
                int n;
                Object object2;
                Object object3;
                String string5;
                eDataObjectSimpleAnyType = documentScannerSupport.attrNames[i];
                string = eDataObjectSimpleAnyType.namespaceURI;
                string2 = eDataObjectSimpleAnyType.localPart;
                if (handlerStack.isSOAPEncoded() && "href".equals(string2) && "".equals(string)) {
                    EProperty eProperty;
                    string5 = documentScannerSupport.attValues[i].toString();
                    int n2 = -1;
                    if (this.currentFeature == null) {
                        object3 = (EDataObject)this.currentNode.getContainer();
                        object2 = this.getListForProperty((EDataObject)object3, (Property)(eProperty = this.currentNode.getContainmentProperty()));
                        if (object2 != null) {
                            n2 = object2.size() - 1;
                        }
                    } else {
                        object3 = this.currentNode;
                        eProperty = SDOUtil.adaptProperty((EStructuralFeature)this.currentFeature);
                        object2 = this.getListForProperty((EDataObject)object3, (Property)eProperty);
                        if (object2 != null) {
                            n2 = object2.size() * -1 - 2;
                        }
                    }
                    handlerStack.addIncompleteNode((DataObject)object3, (Property)eProperty, n2, string5);
                    continue;
                }
                if (eClassifier instanceof EDataType) {
                    string5 = nls.getFormattedMessage("ATTRIBUTE_ERROR_CWSIF0310", new Object[]{qName.localPart, qName.namespaceURI, string2, string}, "Unexpected attribute");
                    throw new DataMediatorException(string5);
                }
                string5 = documentScannerSupport.attValues[i].toString();
                if ("arrayType".equals(documentScannerSupport.attrNames[i].localPart) && this.wsdlUtil.isSOAPEncodingNamespace(documentScannerSupport.attrNames[i].namespaceURI) && (n = ((String)(object3 = documentScannerSupport.attValues[i].toString())).indexOf(58)) > 0 && n < ((String)object3).length() - 1) {
                    String string6 = ((String)object3).substring(0, n);
                    object2 = ((String)object3).substring(n);
                    string5 = this.mapPrefixToNamespace(string6) + (String)object2;
                }
                if ((eStructuralFeature = this.util.getLocalAttribute((EClass)eClassifier, string2, string)) == null) {
                    eStructuralFeature = this.util.getGlobalAttribute(string2, string, this.state.getDescriptor().getLocation());
                }
                if (eStructuralFeature == null) {
                    object3 = this.demandCreateModel(string, string3);
                    EClass eClass = this.demandCreateRoot((EPackage)object3);
                    eStructuralFeature = this.demandCreateAttribute((EPackage)object3, eClass, string2);
                }
                object3 = this.handleValue((EDataType)eStructuralFeature.getEType(), string5);
                this.currentNode.eSet(eStructuralFeature, object3);
            }
            if (!tc.isEntryEnabled()) continue;
            SibTr.exit(tc, "handleChild");
        }
    }

    private void setValue(EStructuralFeature eStructuralFeature, Object object) {
        EProperty eProperty;
        List list;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setValue", new Object[]{eStructuralFeature, object});
        }
        if ((list = this.getListForProperty(this.currentNode, (Property)(eProperty = SDOUtil.adaptProperty((EStructuralFeature)eStructuralFeature)))) != null) {
            list.add(object);
        } else {
            this.currentNode.set((Property)eProperty, object);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setValue");
        }
    }

    private List getListForProperty(EDataObject eDataObject, Property property) {
        EStructuralFeature eStructuralFeature;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getListForProperty", new Object[]{eDataObject, property});
        }
        List list = null;
        ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
        EClass eClass = eDataObject.eClass();
        EStructuralFeature eStructuralFeature2 = extendedMetaData.getAffiliation(eClass, eStructuralFeature = ((EProperty)property).getEStructuralFeature());
        if (eStructuralFeature2 != eStructuralFeature || eStructuralFeature.isMany()) {
            list = eDataObject.getList(property);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getListForProperty", list);
        }
        return list;
    }

    private EClassifier findXsiType(String string, String string2) throws ResourceException, DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "findXsiType");
        }
        HandlerStack handlerStack = this.getHandlerStack();
        DocumentScannerSupport documentScannerSupport = handlerStack.getScannerState();
        EClassifier eClassifier = null;
        boolean[] blArray = handlerStack.getProcessedAttributes();
        for (int i = 0; i < documentScannerSupport.attrCount; ++i) {
            if (blArray[i] || !"type".equals(documentScannerSupport.attrNames[i].localPart) || !XSDConstants.isSchemaInstanceNamespace((String)documentScannerSupport.attrNames[i].namespaceURI)) continue;
            blArray[i] = true;
            String string3 = documentScannerSupport.attValues[i].toString();
            String string4 = null;
            String string5 = null;
            String string6 = null;
            int n = string3.indexOf(58);
            if (n > 0 && n < string3.length() - 1) {
                string4 = string3.substring(n + 1);
                string6 = string3.substring(0, n);
                string5 = this.mapPrefixToNamespace(string6);
            }
            if (string4 == null || string5 == null) {
                String string7 = nls.getFormattedMessage("XSI_TYPE_ERROR_CWSIF0303", new Object[]{string, string2, string3}, "Invalid xsi:type value");
                throw new DataMediatorException(string7);
            }
            eClassifier = this.util.getGlobalType(string4, string5, this.state.getDescriptor().getLocation());
            if (eClassifier != null) break;
            EPackage ePackage = this.demandCreateModel(string5, string6);
            eClassifier = this.demandCreateType(ePackage, string4);
            break;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "findXsiType", eClassifier);
        }
        return eClassifier;
    }

    private boolean findXsiNil() throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "findXsiNil");
        }
        HandlerStack handlerStack = this.getHandlerStack();
        DocumentScannerSupport documentScannerSupport = handlerStack.getScannerState();
        Boolean bl = Boolean.FALSE;
        boolean[] blArray = handlerStack.getProcessedAttributes();
        for (int i = 0; i < documentScannerSupport.attrCount; ++i) {
            if (blArray[i] || !"nil".equals(documentScannerSupport.attrNames[i].localPart) || !XSDConstants.isSchemaInstanceNamespace((String)documentScannerSupport.attrNames[i].namespaceURI)) continue;
            blArray[i] = true;
            String string = documentScannerSupport.attValues[i].toString();
            EDataType eDataType = XMLTypePackage.eINSTANCE.getBoolean();
            bl = (Boolean)this.handleValue(eDataType, string);
            break;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "findXsiNil", bl);
        }
        return bl;
    }

    private EClassifier findChildTypeFromArrayType(EClassifier eClassifier) throws ResourceException {
        String string;
        String string2;
        int n;
        int n2;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "findChildTypeFromArrayType");
        }
        HandlerStack handlerStack = this.getHandlerStack();
        DocumentScannerSupport documentScannerSupport = handlerStack.getScannerState();
        EClassifier eClassifier2 = null;
        String string3 = this.state.getDescriptor().getLocation();
        String string4 = null;
        boolean[] blArray = handlerStack.getProcessedAttributes();
        for (n2 = 0; n2 < documentScannerSupport.attrCount; ++n2) {
            String string5;
            if (blArray[n2] || !"arrayType".equals(documentScannerSupport.attrNames[n2].localPart) || !this.wsdlUtil.isSOAPEncodingNamespace(documentScannerSupport.attrNames[n2].namespaceURI) || (n = (string5 = documentScannerSupport.attValues[n2].toString()).indexOf(58)) <= 0 || n >= string5.length() - 1) continue;
            string2 = string5.substring(0, n);
            String string6 = string5.substring(n);
            string4 = this.mapPrefixToNamespace(string2) + string6;
        }
        if (string4 == null && eClassifier != null) {
            string4 = this.util.getArrayType(eClassifier, string3);
        }
        if (string4 == null && (string = handlerStack.getArrayType()) != null) {
            int n3 = string.lastIndexOf(58);
            n = string.lastIndexOf(91);
            if (n > n3) {
                string4 = string.substring(0, n);
            }
        }
        if (string4 != null) {
            n2 = string4.lastIndexOf(58);
            int n4 = string4.lastIndexOf(91);
            if (n4 > n2) {
                eClassifier2 = this.util.getGlobalType("Array", "http://schemas.xmlsoap.org/soap/encoding/", null);
            } else if (string4 != null) {
                String string7 = string4.substring(0, n2);
                string2 = string4.substring(n2 + 1);
                eClassifier2 = this.util.getGlobalType(string2, string7, string3);
            }
        }
        handlerStack.pushArrayType(string4);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "findChildTypeFromArrayType", eClassifier2);
        }
        return eClassifier2;
    }

    public void processingInstruction(XMLName xMLName, XMLString xMLString) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "processingInstruction");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "processingInstruction");
        }
    }

    public void startElementEvent(boolean bl) throws DataMediatorException, ResourceException {
        String string;
        Object object;
        EClassifier eClassifier;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "startElementEvent");
        }
        HandlerStack handlerStack = this.getHandlerStack();
        DocumentScannerSupport documentScannerSupport = handlerStack.getScannerState();
        this.handleContent();
        com.ibm.xml.b2b.util.QName qName = documentScannerSupport.currentElement;
        String string2 = qName.namespaceURI;
        String string3 = qName.localPart;
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Element", new Object[]{string3, string2});
        }
        if (this.xsiNil) {
            EClass eClass = this.currentNode.eClass();
            ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
            String string4 = extendedMetaData.getName((EClassifier)eClass);
            String string5 = extendedMetaData.getNamespace((EClassifier)eClass);
            String string6 = nls.getFormattedMessage("NIL_ELEMENT_ERROR_CWSIF0299", new Object[]{string4, string5, string3, string2}, "Element within nil element");
            throw new DataMediatorException(string6);
        }
        EStructuralFeature eStructuralFeature = null;
        Object object2 = null;
        if (this.currentNode != null && (eStructuralFeature = this.util.getLocalElement(this.currentNode.eClass(), string3, string2)) == null && this.expectedPart != null) {
            eClassifier = ExtendedMetaData.INSTANCE;
            object = eClassifier.getName(this.expectedPart);
            string = eClassifier.getNamespace(this.expectedPart);
            eStructuralFeature = this.util.getLocalElement(this.currentNode.eClass(), (String)object, string);
        }
        if (this.expectedPart != null) {
            this.expectedPart = null;
        }
        if (eStructuralFeature == null) {
            eStructuralFeature = this.util.getGlobalElement(string3, string2, this.state.getDescriptor().getLocation());
        }
        if (eStructuralFeature != null) {
            object2 = eStructuralFeature.getEType();
        }
        if ((eClassifier = this.findXsiType(string3, string2)) != null) {
            object2 = eClassifier;
        }
        if (handlerStack.isSOAPEncoded() && (object = this.findChildTypeFromArrayType((EClassifier)object2)) != null) {
            object2 = object;
        }
        if (eStructuralFeature == null) {
            object = this.demandCreateModel(string2, qName.prefix);
            string = this.demandCreateRoot((EPackage)object);
            eStructuralFeature = this.demandCreateElement((EPackage)object, (EClass)string, string3);
            if (object2 == null) {
                object2 = SDOPackage.eINSTANCE.getEDataObjectAnyType();
            }
        }
        if (object2 == null) {
            object2 = eStructuralFeature.getEType();
        }
        this.xsiNil = this.findXsiNil();
        if (!this.xsiNil) {
            this.handleChild(eStructuralFeature, (EClassifier)object2);
        } else {
            if (eStructuralFeature.isUnsettable()) {
                this.setValue(eStructuralFeature, null);
            }
            object = handlerStack.getProcessedAttributes();
            for (int i = 0; i < documentScannerSupport.attrCount; ++i) {
                if (object[i] != false) continue;
                com.ibm.xml.b2b.util.QName qName2 = documentScannerSupport.attrNames[i];
                String string7 = nls.getFormattedMessage("NIL_ATTR_ERROR_CWSIF0300", new Object[]{string3, string2, qName2.localPart, qName2.namespaceURI}, "Attribute on nil element");
                throw new DataMediatorException(string7);
            }
        }
        if (bl) {
            this.endElementEvent();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "startElementEvent");
        }
    }

    public void endElementEvent() throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "endElementEvent");
        }
        this.handleContent();
        if (this.xsiNil) {
            this.xsiNil = false;
        } else if (this.currentFeature != null) {
            this.currentFeature = null;
        } else {
            this.setCurrentNode(this.currentNode.getContainer());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "endElementEvent");
        }
    }

    public void character(int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "character");
        }
        this.currentText.append((char)n);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "character");
        }
    }

    public void characters(XMLString xMLString) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "characters");
        }
        this.currentText.append(xMLString.toString());
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "characters");
        }
    }

    private EPackage demandCreateModel(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "demandCreateModel", (Object)string);
        }
        EcoreFactory ecoreFactory = EcoreFactory.eINSTANCE;
        ResourceSet resourceSet = this.state.getOnDemandResources();
        EPackage ePackage = XSDResourceHelper.locatePackage(resourceSet, string);
        if (ePackage == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Demand creating model: " + string);
            }
            URI uRI = URI.createURI((String)string);
            Resource resource = resourceSet.createResource(uRI);
            ePackage = ecoreFactory.createEPackage();
            ePackage.setNsURI(string);
            ePackage.setNsPrefix(string2);
            ePackage.setEFactoryInstance((EFactory)new SdoInstanceFactory());
            resource.getContents().add((Object)ePackage);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "demandCreateModel", ePackage);
        }
        return ePackage;
    }

    private EClass demandCreateRoot(EPackage ePackage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "demandCreateRoot", ePackage);
        }
        ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
        EcoreFactory ecoreFactory = EcoreFactory.eINSTANCE;
        EClass eClass = extendedMetaData.getDocumentRoot(ePackage);
        if (eClass == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Demand creating document root: " + extendedMetaData.getNamespace(ePackage));
            }
            eClass = ecoreFactory.createEClass();
            eClass.setName("DocumentRoot");
            ePackage.getEClassifiers().add((Object)eClass);
            extendedMetaData.setDocumentRoot(eClass);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "demandCreateRoot", eClass);
        }
        return eClass;
    }

    private EStructuralFeature demandCreateElement(EPackage ePackage, EClass eClass, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "demandCreateElement", new Object[]{ePackage, eClass, string});
        }
        ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
        EcoreFactory ecoreFactory = EcoreFactory.eINSTANCE;
        String string2 = extendedMetaData.getNamespace(ePackage);
        EStructuralFeature eStructuralFeature = extendedMetaData.getElement(eClass, string2, string);
        if (eStructuralFeature == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Demand creating element: " + string + ":" + string2);
            }
            EClass eClass2 = SDOPackage.eINSTANCE.getEDataObject();
            EReference eReference = ecoreFactory.createEReference();
            eReference.setContainment(true);
            eReference.setUnsettable(true);
            eReference.setName(string);
            eReference.setEType((EClassifier)eClass2);
            eReference.setUpperBound(-2);
            eClass.getEStructuralFeatures().add((Object)eReference);
            extendedMetaData.setName((EStructuralFeature)eReference, string);
            extendedMetaData.setNamespace((EStructuralFeature)eReference, string2);
            extendedMetaData.setFeatureKind((EStructuralFeature)eReference, 4);
            eStructuralFeature = eReference;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "demandCreateElement", eStructuralFeature);
        }
        return eStructuralFeature;
    }

    private EStructuralFeature demandCreateAttribute(EPackage ePackage, EClass eClass, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "demandCreateAttribute", new Object[]{ePackage, eClass, string});
        }
        ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
        EcoreFactory ecoreFactory = EcoreFactory.eINSTANCE;
        String string2 = extendedMetaData.getNamespace(ePackage);
        EStructuralFeature eStructuralFeature = extendedMetaData.getAttribute(eClass, string2, string);
        if (eStructuralFeature == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Demand creating attribute: " + string + ":" + string2);
            }
            EDataType eDataType = XMLTypePackage.eINSTANCE.getString();
            eStructuralFeature = ecoreFactory.createEAttribute();
            eStructuralFeature.setName(string);
            eStructuralFeature.setEType((EClassifier)eDataType);
            eStructuralFeature.setUpperBound(-2);
            eClass.getEStructuralFeatures().add((Object)eStructuralFeature);
            extendedMetaData.setName(eStructuralFeature, string);
            extendedMetaData.setNamespace(eStructuralFeature, string2);
            extendedMetaData.setFeatureKind(eStructuralFeature, 2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "demandCreateAttribute", eStructuralFeature);
        }
        return eStructuralFeature;
    }

    private EClass demandCreateType(EPackage ePackage, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "demandCreateType", new Object[]{ePackage, string});
        }
        ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
        EcoreFactory ecoreFactory = EcoreFactory.eINSTANCE;
        EClass eClass = (EClass)ePackage.getEClassifier(string);
        if (eClass == null) {
            String string2 = extendedMetaData.getNamespace(ePackage);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Demand creating type: " + string + ":" + string2);
            }
            eClass = ecoreFactory.createEClass();
            eClass.getESuperTypes().add((Object)SDOPackage.eINSTANCE.getEDataObjectAnyType());
            eClass.setName(string);
            ePackage.getEClassifiers().add((Object)eClass);
            extendedMetaData.setContentKind(eClass, 3);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "demandCreateType", eClass);
        }
        return eClass;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/soap/parse/BasicXMLHandler.java, SIB.mfp, WAS602.SIB, o0610.11 1.36");
        }
    }
}

