/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.resource.loader;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceLoader;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceNotFoundException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sdo.config.repository.RepositoryResourceNotFoundException;
import com.ibm.wsspi.sdo.config.repository.SDORepository;
import java.io.InputStream;

public class SdoRepositoryLoader
implements ResourceLoader {
    private static final TraceComponent tc = SibTr.register(SdoRepositoryLoader.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private SDORepository repos;

    public SdoRepositoryLoader() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "SdoRepositoryLoader");
        }
        this.repos = SDORepository.instance();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "SdoRepositoryLoader", this);
        }
    }

    public InputStream getInputStream(String string) throws ResourceNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getInputStream", (Object)string);
        }
        InputStream inputStream = null;
        try {
            inputStream = this.repos.getInputStream(string);
        }
        catch (RepositoryResourceNotFoundException repositoryResourceNotFoundException) {
            FFDCFilter.processException((Throwable)repositoryResourceNotFoundException, (String)"com.ibm.ws.sib.mfp.sdo.resource.loader.SdoRepositoryLoader.getInputStream", (String)"68", (Object)this);
            throw new ResourceNotFoundException(repositoryResourceNotFoundException.getMessage(), repositoryResourceNotFoundException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getInputStream", inputStream);
        }
        return inputStream;
    }

    public Long getTimestamp(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getTimestamp", (Object)string);
        }
        Long l = this.repos.getTimestamp(string);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getTimestamp", l);
        }
        return l;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/resource/loader/SdoRepositoryLoader.java, SIB.mfp, WAS602.SIB, o0610.11 1.2");
        }
    }
}

