/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.resource.loader;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sdo.config.repository.impl.URLRepository;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceLoader;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceNotFoundException;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.xsd.XSDPlugin;

public class MFPResourceLoader
implements ResourceLoader {
    private static final TraceComponent tc = SibTr.register(MFPResourceLoader.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private URLRepository urlRepository = URLRepository.DEFAULT_INSTANCE;
    private ResourceLoader userResources;
    private String xsdXsd;
    private String xmlNSXsd;

    public MFPResourceLoader(ResourceLoader resourceLoader) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "MFPResourceLoader", this.userResources);
        }
        this.userResources = resourceLoader;
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return XSDPlugin.INSTANCE.getBaseURL().toString();
            }
        });
        this.xsdXsd = string + "cache/www.w3.org/2001/XMLSchema.xsd";
        this.xmlNSXsd = string + "cache/www.w3.org/2001/xml.xsd";
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "MFPResourceLoader", this);
        }
    }

    public InputStream getInputStream(String string) throws ResourceNotFoundException {
        InputStream inputStream;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getInputStream", (Object)string);
        }
        if ((inputStream = this.urlRepository.getInputStream(string = this.unMangleResource(string))) == null) {
            inputStream = this.userResources.getInputStream(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getInputStream", inputStream);
        }
        return inputStream;
    }

    public Long getTimestamp(String string) {
        Long l;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getTimestamp", (Object)string);
        }
        if ((l = this.urlRepository.getTimestamp(string = this.unMangleResource(string))) == null) {
            l = this.userResources.getTimestamp(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getTimestamp", l);
        }
        return l;
    }

    private String unMangleResource(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "unMangleResource", (Object)string);
        }
        if (this.xmlNSXsd.equals(string)) {
            string = "http://www.w3.org/XML/1998/namespace";
        } else if (this.xsdXsd.equals(string)) {
            string = "http://www.w3.org/2001/XMLSchema";
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "unMangleResource", (Object)string);
        }
        return string;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/resource/loader/MFPResourceLoader.java, SIB.mfp, WAS602.SIB, o0610.11 1.3");
        }
    }
}

