/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.resource;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.sdo.SdoInstanceFactory;
import com.ibm.ws.sib.mfp.sdo.bean.BeanDataMediatorFactory;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceCache;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceException;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceLoader;
import com.ibm.ws.sib.mfp.sdo.resource.WSDLLocator;
import com.ibm.ws.sib.mfp.sdo.resource.WSDLMetaData;
import com.ibm.ws.sib.mfp.sdo.resource.XSDMetaData;
import com.ibm.ws.sib.mfp.sdo.resource.XSDResourceHelper;
import com.ibm.ws.sib.mfp.sdo.resource.XSDResourceLoader;
import com.ibm.ws.sib.mfp.sdo.resource.type.JSXMLTypePackage;
import com.ibm.ws.sib.mfp.sdo.soap.SOAPDataMediatorFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDLResourceLoader {
    private static TraceComponent tc = SibTr.register(WSDLResourceLoader.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private ExtendedMetaData extMeta = ExtendedMetaData.INSTANCE;
    private EcoreFactory ecoreFac = EcoreFactory.eINSTANCE;
    private WSDLMetaData wsdlMeta;
    private XSDMetaData xsdMeta;
    private ResourceSet resources;
    private ResourceCache cache;
    private ResourceLoader loader;

    public WSDLResourceLoader(ResourceLoader resourceLoader, ResourceCache resourceCache) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "WSDLResourceLoader", new Object[]{resourceLoader, resourceCache});
        }
        this.cache = resourceCache;
        this.loader = resourceLoader;
        this.wsdlMeta = new WSDLMetaData(resourceCache);
        this.xsdMeta = new XSDMetaData(resourceCache);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "WSDLResourceLoader", this);
        }
    }

    public List loadWSDL(String string) throws ResourceException {
        ArrayList<Object> arrayList;
        block8: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "loadWSDL");
            }
            arrayList = null;
            try {
                WSDLFactory wSDLFactory;
                block9: {
                    if (this.loader.getTimestamp(string) == null) break block8;
                    wSDLFactory = null;
                    try {
                        wSDLFactory = WSDLFactory.newInstance((String)"com.ibm.ws.sib.webservices.utils.WSGWWSDLFactory");
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block9;
                        SibTr.exception(tc, exception);
                    }
                }
                if (wSDLFactory == null) {
                    wSDLFactory = WSDLFactory.newInstance();
                }
                WSDLLocator wSDLLocator = new WSDLLocator(string, this.loader);
                WSDLReader wSDLReader = wSDLFactory.newWSDLReader();
                wSDLReader.setFeature("javax.wsdl.verbose", false);
                wSDLReader.setFeature("javax.wsdl.importDocuments", true);
                Definition definition = wSDLReader.readWSDL((javax.wsdl.xml.WSDLLocator)wSDLLocator);
                ResourceSet resourceSet = this.convertWSDL(definition);
                arrayList = new ArrayList<Object>();
                arrayList.add(definition);
                arrayList.add(resourceSet);
            }
            catch (WSDLLocator.TunneledResourceException tunneledResourceException) {
                ResourceException resourceException = tunneledResourceException.getException();
                throw resourceException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mfp.sdo.resource.WSDLResourceLoader.loadWSDL", (String)"211", (Object)this);
                String string2 = nls.getFormattedMessage("INVALID_WSDL_CWSIF0232", new Object[]{string, exception}, "Invalid WSDL file");
                throw new ResourceException(string2, exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "loadWSDL");
        }
        return arrayList;
    }

    private ResourceSet convertWSDL(Definition definition) throws ResourceException {
        EPackage ePackage;
        Definition definition2;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "convertWSDL");
        }
        this.resources = XSDResourceHelper.createResourceSet(definition.getDocumentBaseURI(), this.cache);
        List list = this.importWSDL(definition);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.checkDefinition((Definition)iterator.next());
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            this.importTypes((Definition)iterator.next());
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            definition2 = (Definition)iterator.next();
            this.setupPackage(definition2);
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            definition2 = (Definition)iterator.next();
            ePackage = XSDResourceHelper.locatePackage(this.resources, definition2.getTargetNamespace(), definition2.getDocumentBaseURI());
            this.importMessages(definition2, ePackage);
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            definition2 = (Definition)iterator.next();
            ePackage = XSDResourceHelper.locatePackage(this.resources, definition2.getTargetNamespace(), definition2.getDocumentBaseURI());
            this.importOperations(definition2, ePackage);
        }
        definition2 = this.resources;
        this.resources = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "convertWSDL", definition2);
        }
        return definition2;
    }

    private List importWSDL(Definition definition) throws ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "importWSDL");
        }
        ArrayList<Definition> arrayList = new ArrayList<Definition>();
        arrayList.add(definition);
        Map map = definition.getImports();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            List list = (List)map.get(iterator.next());
            for (int i = 0; i < list.size(); ++i) {
                Import import_ = (Import)list.get(i);
                Definition definition2 = import_.getDefinition();
                if (definition2 == null) continue;
                arrayList.addAll(this.importWSDL(definition2));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "importWSDL");
        }
        return arrayList;
    }

    private void importTypes(Definition definition) throws ResourceException {
        Resource resource;
        URI uRI;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "importTypes");
        }
        ArrayList<XSDSchema> arrayList = new ArrayList<XSDSchema>();
        Types types = definition.getTypes();
        if (types != null) {
            uRI = types.getExtensibilityElements().iterator();
            while (uRI.hasNext()) {
                resource = (UnknownExtensibilityElement)uRI.next();
                QName qName = resource.getElementType();
                if (!"schema".equals(qName.getLocalPart()) || !XSDConstants.isSchemaForSchemaNamespace((String)qName.getNamespaceURI())) continue;
                Element element = resource.getElement();
                XSDSchema xSDSchema = XSDSchemaImpl.createSchema((Node)element);
                arrayList.add(xSDSchema);
            }
        }
        uRI = URI.createURI((String)definition.getDocumentBaseURI());
        resource = this.resources.createResource(uRI);
        resource.eAdapters().add((Object)new XSDResourceImpl.SchemaLocator());
        resource.getContents().addAll(arrayList);
        if (this.resources.getResources().size() > 0) {
            XSDResourceLoader.convertSchema(this.resources);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "importTypes");
        }
    }

    private void importMessages(Definition definition, EPackage ePackage) throws ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "importMessages");
        }
        EClass eClass = (EClass)this.xsdMeta.getGlobalType("BodyType", "http://www.ibm.com/ns/2004/05/webservices/messagemodel", "http://www.ibm.com/ns/2004/05/webservices/messagemodel");
        Iterator iterator = definition.getMessages().values().iterator();
        while (iterator.hasNext()) {
            Message message = (Message)iterator.next();
            String string = message.getQName().getLocalPart();
            EClass eClass2 = this.ecoreFac.createEClass();
            eClass2.setName(this.mangleClassName(ePackage, string));
            ePackage.getEClassifiers().add((Object)eClass2);
            this.wsdlMeta.setName((ENamedElement)eClass2, string);
            this.wsdlMeta.setSource((EModelElement)eClass2, "message");
            eClass2.getESuperTypes().add((Object)eClass);
            this.importParts(eClass2, message);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "importMessages");
        }
    }

    private void importParts(EClass eClass, Message message) throws ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "importParts");
        }
        Iterator iterator = message.getOrderedParts(null).iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            String string;
            Object object3;
            Part part = (Part)iterator.next();
            String string2 = part.getName();
            EClassifier eClassifier = null;
            QName qName = null;
            if (part.getTypeName() != null) {
                object3 = part.getTypeName();
                string = ((QName)object3).getNamespaceURI();
                object2 = null;
                if (XSDConstants.isSchemaForSchemaNamespace((String)string)) {
                    object2 = JSXMLTypePackage.eINSTANCE;
                    if (this.extMeta.getType((EPackage)object2, ((QName)object3).getLocalPart()) == null) {
                        object2 = XMLTypePackage.eINSTANCE;
                    }
                    eClassifier = this.extMeta.getType((EPackage)object2, ((QName)object3).getLocalPart());
                } else {
                    object2 = XSDResourceHelper.locatePackage(this.resources, string);
                    if (object2 != null) {
                        eClassifier = this.extMeta.getType((EPackage)object2, ((QName)object3).getLocalPart());
                    }
                    if (eClassifier == null && (object2 = this.cache.getEcoreModel(string, null)) != null) {
                        eClassifier = this.extMeta.getType((EPackage)object2, ((QName)object3).getLocalPart());
                    }
                }
                if (eClassifier == null) {
                    object = nls.getFormattedMessage("INVALID_WSDL_CWSIF0233", new Object[]{object3, string}, "Unable to locate type.");
                    throw new ResourceException((String)object);
                }
            } else {
                qName = part.getElementName();
                if (qName == null) {
                    object3 = nls.getFormattedMessage("NO_TYPE_FOR_PART_CWSIF0431", new Object[]{string2, message.getQName()}, "WSDL message part has no type");
                    throw new ResourceException((String)object3);
                }
                object3 = qName.getNamespaceURI();
                string = XSDResourceHelper.locatePackage(this.resources, (String)object3);
                if (string != null && (object2 = this.extMeta.getDocumentRoot((EPackage)string)) != null && (object = this.extMeta.getElement((EClass)object2, (String)object3, qName.getLocalPart())) != null) {
                    eClassifier = object.getEType();
                }
                if (eClassifier == null && (string = this.cache.getEcoreModel((String)object3, null)) != null && (object2 = this.extMeta.getDocumentRoot((EPackage)string)) != null && (object = this.extMeta.getElement((EClass)object2, (String)object3, qName.getLocalPart())) != null) {
                    eClassifier = object.getEType();
                }
                if (eClassifier == null) {
                    object2 = nls.getFormattedMessage("INVALID_WSDL_CWSIF0234", new Object[]{qName, object3}, "Unable to locate element.");
                    throw new ResourceException((String)object2);
                }
            }
            object3 = null;
            if (eClassifier instanceof EDataType) {
                object3 = this.ecoreFac.createEAttribute();
            } else {
                string = this.ecoreFac.createEReference();
                string.setContainment(true);
                object3 = string;
            }
            object3.setName(string2);
            object3.setEType(eClassifier);
            object3.setUnsettable(true);
            eClass.getEStructuralFeatures().add(object3);
            this.extMeta.setFeatureKind((EStructuralFeature)object3, 4);
            if (qName != null) {
                this.extMeta.setName((EStructuralFeature)object3, qName.getLocalPart());
                this.extMeta.setNamespace((EStructuralFeature)object3, qName.getNamespaceURI());
            }
            this.wsdlMeta.setSource((EModelElement)object3, "part");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "importParts");
        }
    }

    private void importOperations(Definition definition, EPackage ePackage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "importOperations");
        }
        Iterator iterator = definition.getPortTypes().values().iterator();
        while (iterator.hasNext()) {
            PortType portType = (PortType)iterator.next();
            Iterator iterator2 = portType.getOperations().iterator();
            while (iterator2.hasNext()) {
                Operation operation = (Operation)iterator2.next();
                String string = operation.getName();
                EClass eClass = this.ecoreFac.createEClass();
                eClass.setName(this.mangleClassName(ePackage, string));
                ePackage.getEClassifiers().add((Object)eClass);
                this.wsdlMeta.setName((ENamedElement)eClass, string);
                this.wsdlMeta.setSource((EModelElement)eClass, "operation");
                this.wsdlMeta.setPortType((ENamedElement)eClass, portType.getQName());
                EClass eClass2 = this.extMeta.getDocumentRoot(ePackage);
                EReference eReference = this.ecoreFac.createEReference();
                eReference.setName(this.mangleFeatureName(eClass2, string));
                eReference.setEType((EClassifier)eClass);
                eReference.setContainment(true);
                eClass2.getEStructuralFeatures().add((Object)eReference);
                this.wsdlMeta.setName((ENamedElement)eReference, string);
                this.wsdlMeta.setSource((EModelElement)eReference, "operation");
                this.importMessageFeatures(eClass, operation);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "importOperations");
        }
    }

    private void importMessageFeatures(EClass eClass, Operation operation) {
        Message message;
        Object object;
        Object object2;
        Input input;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "importMessageFeatures");
        }
        if ((input = operation.getInput()) != null) {
            object2 = this.wsdlMeta.getMessageName(operation, input);
            object = input.getMessage();
            this.importMessageFeature(eClass, (String)object2, (Message)object);
        }
        if ((object2 = operation.getOutput()) != null) {
            object = this.wsdlMeta.getMessageName(operation, object2);
            message = object2.getMessage();
            this.importMessageFeature(eClass, (String)object, message);
        }
        object = operation.getFaults().values().iterator();
        while (object.hasNext()) {
            message = (Fault)object.next();
            String string = message.getName();
            Message message2 = message.getMessage();
            this.importMessageFeature(eClass, string, message2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "importMessageFeatures");
        }
    }

    private void importMessageFeature(EClass eClass, String string, Message message) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "importMessageFeature");
        }
        QName qName = message.getQName();
        String string2 = qName.getNamespaceURI();
        String string3 = qName.getLocalPart();
        EPackage ePackage = XSDResourceHelper.locatePackage(this.resources, string2);
        EClass eClass2 = this.wsdlMeta.getMessage(ePackage, string3);
        EReference eReference = this.ecoreFac.createEReference();
        eReference.setName(this.mangleFeatureName(eClass, string));
        eReference.setEType((EClassifier)eClass2);
        eReference.setContainment(true);
        eReference.setUpperBound(-2);
        eClass.getEStructuralFeatures().add((Object)eReference);
        this.wsdlMeta.setSource((EModelElement)eReference, "message");
        this.extMeta.setFeatureKind((EStructuralFeature)eReference, 4);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "importMessageFeature");
        }
    }

    private String mangleClassName(EPackage ePackage, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "mangleClassName", (Object)string);
        }
        String string2 = string;
        int n = 1;
        while (ePackage.getEClassifier(string2) != null) {
            string2 = string + n++;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "mangleClassName", (Object)string2);
        }
        return string2;
    }

    private String mangleFeatureName(EClass eClass, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "mangleFeatureName", (Object)string);
        }
        String string2 = string;
        int n = 1;
        while (eClass.getEStructuralFeature(string2) != null) {
            string2 = string + n++;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "mangleFeatureName", (Object)string2);
        }
        return string2;
    }

    private void setupPackage(Definition definition) {
        URI uRI;
        EPackage ePackage;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setupPackage");
        }
        if ((ePackage = XSDResourceHelper.locatePackage(this.resources, definition.getTargetNamespace())) == null) {
            uRI = URI.createURI((String)definition.getDocumentBaseURI());
            Resource resource = this.resources.getResource(uRI, false);
            ePackage = this.ecoreFac.createEPackage();
            ePackage.setNsURI(definition.getTargetNamespace());
            ePackage.setEFactoryInstance((EFactory)new SdoInstanceFactory());
            resource.getContents().add((Object)ePackage);
        }
        if ((uRI = this.extMeta.getDocumentRoot(ePackage)) == null) {
            uRI = this.ecoreFac.createEClass();
            uRI.setName(this.mangleClassName(ePackage, "wsdlRoot"));
            ePackage.getEClassifiers().add((Object)uRI);
            this.extMeta.setDocumentRoot((EClass)uRI);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setupPackage");
        }
    }

    private void checkDefinition(Definition definition) throws ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "checkDefinition");
        }
        this.checkMessages(definition);
        this.checkPortTypes(definition);
        this.checkBindings(definition);
        this.checkServices(definition);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "checkDefinition");
        }
    }

    private void checkMessages(Definition definition) throws ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "checkMessages");
        }
        Iterator iterator = definition.getMessages().values().iterator();
        while (iterator.hasNext()) {
            Message message = (Message)iterator.next();
            if (!message.isUndefined()) continue;
            String string = nls.getFormattedMessage("INVALID_WSDL_CWSIF0240", new Object[]{"Message", message.getQName(), definition.getDocumentBaseURI()}, "Undefined WSDL Message");
            throw new ResourceException(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "checkMessages");
        }
    }

    private void checkPortTypes(Definition definition) throws ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "checkPortTypes");
        }
        Iterator iterator = definition.getPortTypes().values().iterator();
        while (iterator.hasNext()) {
            Object object;
            PortType portType = (PortType)iterator.next();
            if (portType.isUndefined()) {
                object = nls.getFormattedMessage("INVALID_WSDL_CWSIF0240", new Object[]{"Port Type", portType.getQName(), definition.getDocumentBaseURI()}, "Undefined WSDL Port Type");
                throw new ResourceException((String)object);
            }
            object = portType.getOperations().iterator();
            while (object.hasNext()) {
                Object object2;
                Object object3;
                Message message;
                Object object4;
                Operation operation = (Operation)object.next();
                if (operation.isUndefined()) {
                    object4 = nls.getFormattedMessage("INVALID_WSDL_CWSIF0240", new Object[]{"Operation", operation.getName(), definition.getDocumentBaseURI()}, "Undefined WSDL Operation");
                    throw new ResourceException((String)object4);
                }
                object4 = operation.getInput();
                if (object4 != null && (message = object4.getMessage()).isUndefined()) {
                    object3 = nls.getFormattedMessage("INVALID_WSDL_CWSIF0240", new Object[]{"Message", message.getQName(), definition.getDocumentBaseURI()}, "Undefined WSDL Message");
                    throw new ResourceException((String)object3);
                }
                message = operation.getOutput();
                if (message != null && (object3 = message.getMessage()).isUndefined()) {
                    object2 = nls.getFormattedMessage("INVALID_WSDL_CWSIF0240", new Object[]{"Message", object3.getQName(), definition.getDocumentBaseURI()}, "Undefined WSDL Message");
                    throw new ResourceException((String)object2);
                }
                object3 = operation.getFaults().values().iterator();
                while (object3.hasNext()) {
                    object2 = (Fault)object3.next();
                    Message message2 = object2.getMessage();
                    if (!message2.isUndefined()) continue;
                    String string = nls.getFormattedMessage("INVALID_WSDL_CWSIF0240", new Object[]{"Message", message2.getQName(), definition.getDocumentBaseURI()}, "Undefined WSDL Message");
                    throw new ResourceException(string);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "checkPortTypes");
        }
    }

    private void checkBindings(Definition definition) throws ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "checkBindings");
        }
        Iterator iterator = definition.getBindings().values().iterator();
        while (iterator.hasNext()) {
            Object object;
            Binding binding = (Binding)iterator.next();
            if (binding.isUndefined()) {
                object = nls.getFormattedMessage("INVALID_WSDL_CWSIF0240", new Object[]{"Binding", binding.getQName(), definition.getDocumentBaseURI()}, "Undefined WSDL Binding");
                throw new ResourceException((String)object);
            }
            object = binding.getBindingOperations().iterator();
            while (object.hasNext()) {
                BindingOperation bindingOperation = (BindingOperation)object.next();
                Operation operation = bindingOperation.getOperation();
                if (!operation.isUndefined()) continue;
                String string = nls.getFormattedMessage("INVALID_WSDL_CWSIF0240", new Object[]{"Operation", operation.getName(), definition.getDocumentBaseURI()}, "Undefined WSDL Operation");
                throw new ResourceException(string);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "checkBindings");
        }
    }

    private void checkServices(Definition definition) throws ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "checkServices");
        }
        Iterator iterator = definition.getServices().values().iterator();
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            Iterator iterator2 = service.getPorts().values().iterator();
            while (iterator2.hasNext()) {
                Port port = (Port)iterator2.next();
                Binding binding = port.getBinding();
                if (!binding.isUndefined()) continue;
                String string = nls.getFormattedMessage("INVALID_WSDL_CWSIF0240", new Object[]{"Operation", binding.getQName(), definition.getDocumentBaseURI()}, "Undefined WSDL Binding");
                throw new ResourceException(string);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "checkServices");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/resource/WSDLResourceLoader.java, SIB.mfp, WAS602.SIB, o0610.11 1.27");
        }
        SOAPDataMediatorFactory sOAPDataMediatorFactory = SOAPDataMediatorFactory.getInstance();
        BeanDataMediatorFactory beanDataMediatorFactory = BeanDataMediatorFactory.getInstance();
    }
}

