/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.mime.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIMessageParseException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.sdo.mime.MimeElement;
import com.ibm.ws.sib.mfp.sdo.mime.MimeFactory;
import com.ibm.ws.sib.mfp.sdo.mime.impl.MergedInputStream;
import com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementListImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.sdo.DataMediatorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;

public class MimeElementImpl
implements MimeElement {
    private static TraceComponent tc = SibTr.register(MimeElementImpl.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private MimeElementListImpl list = null;
    private MimeBodyPart mbp = null;
    private static final byte[] DUMMY_BYTES;
    private static final int DUMMY_BYTES_LENGTH;
    private static final String DEFAULT_CONTENT_TRANSFER_ENCODING = "8bit";

    public MimeElementImpl(MimeElementListImpl mimeElementListImpl, MimeBodyPart mimeBodyPart) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "MimeElementImpl", new Object[]{mimeElementListImpl, mimeBodyPart});
        }
        this.list = mimeElementListImpl;
        this.mbp = mimeBodyPart;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "MimeElementImpl", this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MimeElementImpl(byte[] byArray, int n, int n2, String string, String string2, String string3) throws DataMediatorException {
        try {
            try {
                if (tc.isEntryEnabled()) {
                    SibTr.entry(tc, "MimeElementImpl", new Object[]{byArray, new Integer(n), new Integer(n2), string, string2, string3});
                }
                if (byArray == null) {
                    String string4 = nls.getFormattedMessage("INVALID_ARGUMENT_CWSIF0371", new Object[]{byArray, "byte[]", "createNewMimeElement"}, "Invalid Argument to createNewMimeElement");
                    throw new DataMediatorException(string4);
                }
                if (string == null) {
                    String string5 = nls.getFormattedMessage("INVALID_ARGUMENT_CWSIF0371", new Object[]{byArray, "mimeType", "createNewMimeElement"}, "Invalid Argument to createNewMimeElement");
                    throw new DataMediatorException(string5);
                }
                if (null == string3) {
                    string3 = DEFAULT_CONTENT_TRANSFER_ENCODING;
                }
                this.list = null;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
                String string6 = "";
                if (string != null && !"".equals(string)) {
                    string6 = string6 + "Content-Type: " + string + "\n";
                }
                if (string3 != null && !"".equals(string3)) {
                    string6 = string6 + "Content-Transfer-Encoding: " + string3 + "\n";
                }
                if (string2 != null && !"".equals(string2)) {
                    string6 = string6 + "Content-ID: <" + string2 + ">\n";
                }
                string6 = string6 + "\n";
                MergedInputStream mergedInputStream = new MergedInputStream(string6, byteArrayInputStream);
                this.mbp = new MimeBodyPartWrapper(mergedInputStream);
                ((MimeBodyPartWrapper)this.mbp).updateHeaders();
            }
            catch (DataMediatorException dataMediatorException) {
                FFDCFilter.processException((Throwable)dataMediatorException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementImpl.MimeElementImpl", (String)"146", (Object)this);
                throw dataMediatorException;
            }
            catch (MessagingException messagingException) {
                FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementImpl.MimeElementImpl", (String)"127", (Object)this);
                dataMediatorException = new DataMediatorException(messagingException.getMessage());
                dataMediatorException.initCause(messagingException);
                throw dataMediatorException;
            }
            Object var11_15 = null;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "MimeElementImpl", this);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit(tc, "MimeElementImpl", this);
    }

    public MimeElementImpl(String string, String string2, String string3, String string4) throws DataMediatorException {
        this(DUMMY_BYTES, 0, DUMMY_BYTES_LENGTH, string2, string3, string4);
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "MimeElementImpl", new Object[]{string, string2, string3, string4});
            }
            String string5 = this.mbp.getContentType();
            String string6 = this.mbp.getEncoding();
            this.mbp.setContent((Object)string, string5);
            this.mbp.setHeader("Content-Type", string5);
            if (string6 != null) {
                this.mbp.setHeader("Content-Transfer-Encoding", string6);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "MimeElementImpl", this);
            }
        }
        catch (MessagingException messagingException) {
            FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementImpl.MimeElementImpl", (String)"230", (Object)this);
            DataMediatorException dataMediatorException = new DataMediatorException(messagingException.getMessage());
            dataMediatorException.initCause(messagingException);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "MimeElementImpl", dataMediatorException);
            }
            throw dataMediatorException;
        }
    }

    public String getContentType() throws DataMediatorException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getContentType");
            }
            String string = this.mbp.getContentType();
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getContentType", (Object)string);
            }
            return string;
        }
        catch (MessagingException messagingException) {
            FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementImpl.getContentType", (String)"155", (Object)this);
            DataMediatorException dataMediatorException = new DataMediatorException(messagingException.getMessage());
            dataMediatorException.initCause(messagingException);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getContentType", dataMediatorException);
            }
            throw dataMediatorException;
        }
    }

    public boolean isMimeType(String string) throws DataMediatorException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "isMimeType", (Object)string);
            }
            boolean bl = this.mbp.isMimeType(string);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "isMimeType", new Boolean(bl));
            }
            return bl;
        }
        catch (MessagingException messagingException) {
            FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementImpl.isMimeType", (String)"182", (Object)this);
            DataMediatorException dataMediatorException = new DataMediatorException(messagingException.getMessage());
            dataMediatorException.initCause(messagingException);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "isMimeType", dataMediatorException);
            }
            throw dataMediatorException;
        }
    }

    public String getContentID() throws DataMediatorException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getContentID");
            }
            String string = this.mbp.getContentID();
            string = MimeElementListImpl.stripChevrons(string);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getContentID", (Object)string);
            }
            return string;
        }
        catch (MessagingException messagingException) {
            FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementImpl.getContentID", (String)"208", (Object)this);
            DataMediatorException dataMediatorException = new DataMediatorException(messagingException.getMessage());
            dataMediatorException.initCause(messagingException);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getContentID", dataMediatorException);
            }
            throw dataMediatorException;
        }
    }

    public String getEncoding() throws DataMediatorException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getEncoding");
            }
            String string = this.mbp.getEncoding();
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getEncoding", (Object)string);
            }
            return string;
        }
        catch (MessagingException messagingException) {
            FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementImpl.getEncoding", (String)"303", (Object)this);
            DataMediatorException dataMediatorException = new DataMediatorException(messagingException.getMessage());
            dataMediatorException.initCause(messagingException);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getEncoding", dataMediatorException);
            }
            throw dataMediatorException;
        }
    }

    public Object getContent() throws DataMediatorException {
        try {
            Object object;
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getContent");
            }
            if ((object = this.mbp.getContent()) instanceof InputStream) {
                object = this.list.decodeFromInputStream(this.mbp.getContentType(), (InputStream)object);
            } else if (object instanceof String) {
                object = ((String)object).trim();
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getContent", object);
            }
            return object;
        }
        catch (MessagingException messagingException) {
            FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementImpl.getContent", (String)"240", (Object)this);
            DataMediatorException dataMediatorException = new DataMediatorException(messagingException.getMessage());
            dataMediatorException.initCause(messagingException);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getContent", dataMediatorException);
            }
            throw dataMediatorException;
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementImpl.getContent", (String)"244", (Object)this);
            String string = nls.getFormattedMessage("UNABLE_TO_GET_CONTENT_CWSIF0372", null, "IOException on getContent");
            DataMediatorException dataMediatorException = new DataMediatorException(string);
            dataMediatorException.initCause(iOException);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getContent", dataMediatorException);
            }
            throw dataMediatorException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getInputStream() throws DataMediatorException {
        InputStream inputStream;
        try {
            try {
                if (tc.isEntryEnabled()) {
                    SibTr.entry(tc, "getInputStream");
                }
                InputStream inputStream2 = this.mbp.getInputStream();
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "InputStream: " + inputStream2);
                }
                inputStream = inputStream2;
                Object var4_7 = null;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementImpl.getInputStream", (String)"332", (Object)this);
                DataMediatorException dataMediatorException = new DataMediatorException(iOException);
                throw dataMediatorException;
            }
            catch (MessagingException messagingException) {
                FFDCFilter.processException((Throwable)messagingException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementImpl.getInputStream", (String)"335", (Object)this);
                DataMediatorException dataMediatorException = new DataMediatorException(messagingException);
                throw dataMediatorException;
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            SibTr.exit(tc, "getInputStream");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return inputStream;
        SibTr.exit(tc, "getInputStream");
        return inputStream;
    }

    public boolean isStart() throws DataMediatorException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "isStart");
            }
            boolean bl = false;
            bl = this.list != null ? this.list.isFirstPart(this) : false;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "isStart", new Boolean(bl));
            }
            return bl;
        }
        catch (DataMediatorException dataMediatorException) {
            FFDCFilter.processException((Throwable)dataMediatorException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementImpl.isStart", (String)"282", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "isStart", dataMediatorException);
            }
            throw dataMediatorException;
        }
    }

    protected MimeBodyPart getMimeBodyPart() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getMimeBodyPart");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getMimeBodyPart", this.mbp);
        }
        return this.mbp;
    }

    protected void setMimeElementList(MimeElementListImpl mimeElementListImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setMimeElementList", mimeElementListImpl);
        }
        this.list = mimeElementListImpl;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setMimeElementList");
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MimeElementImpl) {
            MimeElementImpl mimeElementImpl = (MimeElementImpl)object;
            if (this.mbp != null) {
                try {
                    if (!this.getContentType().equals(mimeElementImpl.getContentType())) {
                        return false;
                    }
                    if (!this.getContentID().equals(mimeElementImpl.getContentID())) {
                        return false;
                    }
                    return this.getContent().equals(mimeElementImpl.getContent());
                }
                catch (DataMediatorException dataMediatorException) {
                    FFDCFilter.processException((Throwable)dataMediatorException, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementImpl.equals", (String)"350", (Object)this);
                    return false;
                }
            }
            return mimeElementImpl.mbp == null;
        }
        return false;
    }

    public MimeElement copy() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "copy");
        }
        MimeElement mimeElement = null;
        try {
            InputStream inputStream = this.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            mimeElement = MimeFactory.createNewMimeElement(byArray2, 0, byArray2.length, this.getContentType(), this.getContentID(), this.getEncoding());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mfp.sdo.mime.impl.MimeElementImpl.copy", (String)"604", (Object)this);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Failed to copy MimeElement: " + exception);
            }
            String string = nls.getFormattedMessage("ELEMENT_LIST_COPY_ERROR_CWSIF0386", new Object[]{exception}, "A problem was encountered during the copying of the MimeElement");
            throw new SIMessageParseException(string, exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "copy");
        }
        return mimeElement;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/mime/impl/MimeElementImpl.java, SIB.mfp, WAS602.SIB, o0610.11 1.13");
        }
        DUMMY_BYTES = "ABC".getBytes();
        DUMMY_BYTES_LENGTH = DUMMY_BYTES.length;
    }

    private class MimeBodyPartWrapper
    extends MimeBodyPart {
        public MimeBodyPartWrapper(InputStream inputStream) throws MessagingException {
            super(inputStream);
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "MimeBodyPartWrapper");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "MimeBodyPartWrapper", (Object)this);
            }
        }

        public void updateHeaders() throws MessagingException {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "updateHeaders");
            }
            super.updateHeaders();
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "updateHeaders");
            }
        }
    }
}

