/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.mediators;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.MfpConstants;
import com.ibm.ws.sib.mfp.jmf.JMFException;
import com.ibm.ws.sib.mfp.jmf.JMFMessage;
import com.ibm.ws.sib.mfp.jmf.JMFNativePart;
import com.ibm.ws.sib.mfp.jmf.JMFRegistry;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.mfp.sdo.OutputHelper;
import com.ibm.ws.sib.mfp.sdo.mediators.JmfDataMediatorFactory;
import com.ibm.ws.sib.mfp.sdo.mediators.JmfFormatDescriptor;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceCache;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceCacheFactory;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceException;
import com.ibm.ws.sib.mfp.sdo.resource.type.JSXMLTypePackage;
import com.ibm.ws.sib.mfp.sdo.sdooverjmf.SDOoverJMF;
import com.ibm.ws.sib.mfp.sdo.tools.EcoreConverter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.sdo.DataMediator;
import com.ibm.wsspi.sib.sdo.DataMediatorException;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.sdo.EType;
import org.eclipse.emf.ecore.sdo.SDOPackage;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;

public class JmfDataMediator
implements DataMediator {
    private static TraceComponent tc = SibTr.register(JmfDataMediator.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");

    JmfDataMediator(String string) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>", (Object)string);
        }
        JmfFormatDescriptor jmfFormatDescriptor = new JmfFormatDescriptor(string);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    public DataGraph createDataGraph() {
        throw new UnsupportedOperationException();
    }

    public DataObject read(byte[] byArray, int n, int n2) throws DataMediatorException {
        DataObject dataObject;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "read");
        }
        try {
            Object object;
            JMFSchema jMFSchema = JmfDataMediatorFactory.getEnvelopeSchema();
            int n3 = JmfDataMediatorFactory.getPackageAccessor();
            int n4 = JmfDataMediatorFactory.getLocationAccessor();
            int n5 = JmfDataMediatorFactory.getContentAccessor();
            JMFMessage jMFMessage = JMFRegistry.instance.decode(jMFSchema, byArray, n, n2);
            List list = (List)jMFMessage.getValue(n3);
            List list2 = (List)jMFMessage.getValue(n4);
            this.loadJmfSchemas(list, list2);
            if (tc.isDebugEnabled()) {
                object = "Required JMF schema for message: ";
                JMFSchema[] jMFSchemaArray = jMFMessage.getSchemata();
                for (int i = 0; i < jMFSchemaArray.length; ++i) {
                    object = (String)object + " " + Long.toHexString(jMFSchemaArray[i].getID());
                }
                SibTr.debug(tc, (String)object);
            }
            object = (JMFNativePart)jMFMessage.getValue(n5);
            dataObject = (DataObject)SDOoverJMF.getDataObject((JMFNativePart)object);
        }
        catch (ResourceException resourceException) {
            throw new DataMediatorException(resourceException);
        }
        catch (JMFException jMFException) {
            FFDCFilter.processException((Throwable)jMFException, (String)"com.ibm.ws.sib.mfp.sdo.mediators.JmfDataMediator.read", (String)"159", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, byArray, new Integer(n), new Integer(n2)});
            String string = nls.getFormattedMessage("JMF_PARSE_FAILURE_CWSIF0311", new Object[]{jMFException}, "JMF data mediator read failure.");
            throw new DataMediatorException(string, jMFException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "read");
        }
        return dataObject;
    }

    public int getLength(DataObject dataObject, DataMediator.State state) throws DataMediatorException {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getLength");
        }
        try {
            JMFMessage jMFMessage;
            if (state != null && state.value != null) {
                jMFMessage = (JMFMessage)state.value;
            } else {
                jMFMessage = this.getJmfMessage(dataObject);
                if (state != null) {
                    state.value = jMFMessage;
                }
            }
            n = jMFMessage.getEncodedLength();
        }
        catch (ResourceException resourceException) {
            throw new DataMediatorException(resourceException);
        }
        catch (JMFException jMFException) {
            FFDCFilter.processException((Throwable)jMFException, (String)"com.ibm.ws.sib.mfp.sdo.mediators.JmfDataMediator.getLength", (String)"196", (Object)this);
            String string = nls.getFormattedMessage("JMF_LENGTH_FAILURE_CWSIF0312", new Object[]{jMFException}, "JMF data mediator getLength failure.");
            throw new DataMediatorException(string, jMFException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getLength");
        }
        return n;
    }

    public int write(DataObject dataObject, byte[] byArray, int n, int n2, DataMediator.State state) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "write");
        }
        try {
            JMFMessage jMFMessage;
            if (state != null && state.value != null) {
                jMFMessage = (JMFMessage)state.value;
            } else {
                jMFMessage = this.getJmfMessage(dataObject);
                int n3 = jMFMessage.getEncodedLength();
                if (n3 != n2) {
                    String string = nls.getFormattedMessage("JMF_WRITE_FAILURE_CWSIF0314", new Object[]{new Integer(n3), new Integer(n2)}, "Incorrect message length.");
                    throw new DataMediatorException(string);
                }
            }
            jMFMessage.toByteArray(byArray, n, n2);
        }
        catch (ResourceException resourceException) {
            throw new DataMediatorException(resourceException);
        }
        catch (JMFException jMFException) {
            FFDCFilter.processException((Throwable)jMFException, (String)"com.ibm.ws.sib.mfp.sdo.mediators.JmfDataMediator.write", (String)"234", (Object)this);
            String string = nls.getFormattedMessage("JMF_WRITE_FAILURE_CWSIF0313", new Object[]{jMFException}, "JMF data mediator write failure.");
            throw new DataMediatorException(string, jMFException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "write");
        }
        return n2;
    }

    public DataObject readTransform(byte[] byArray, String string) throws DataMediatorException {
        throw new UnsupportedOperationException();
    }

    public byte[] writeTransform(DataObject dataObject, String string) throws DataMediatorException {
        throw new UnsupportedOperationException();
    }

    private void loadJmfSchemas(List list, List list2) throws JMFException, DataMediatorException, ResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "loadJmfSchemas");
        }
        ResourceCacheFactory resourceCacheFactory = ResourceCacheFactory.getInstance();
        ResourceCache resourceCache = resourceCacheFactory.getSdoRepositoryCache();
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Object object;
            String string = (String)iterator.next();
            String string2 = (String)iterator2.next();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Checking schemas for package: " + string + " at location: " + string2);
            }
            if ((object = "http://www.eclipse.org/emf/2003/XMLType".equals(string) ? XMLTypePackage.eINSTANCE : ("http://www.ibm.com/ns/2004/05/webservices/JSTypePackage".equals(string) ? JSXMLTypePackage.eINSTANCE : ("http://www.eclipse.org/emf/2003/SDO".equals(string) ? SDOPackage.eINSTANCE : resourceCache.getEcoreModel(string, string2)))) != null) {
                Iterator iterator3 = object.getEClassifiers().iterator();
                while (iterator3.hasNext()) {
                    Object e = iterator3.next();
                    if (!(e instanceof EClass)) continue;
                    this.getJmfSchema((EClass)e);
                }
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            SibTr.debug(tc, "EPackage not found in registry");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "loadJmfSchemas");
        }
    }

    private void checkJmfSchemas(Object object, List list, List list2) throws JMFException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "checkJmfSchemas", object);
        }
        if (object instanceof DataObject) {
            this.checkJmfSchemas((DataObject)object, list, list2);
        } else if (object instanceof Sequence) {
            Sequence sequence = (Sequence)object;
            for (int i = 0; i < sequence.size(); ++i) {
                Object object2 = sequence.getValue(i);
                this.checkJmfSchemas(object2, list, list2);
            }
        } else if (object instanceof List) {
            Iterator iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                this.checkJmfSchemas(iterator.next(), list, list2);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "checkJmfSchemas");
        }
    }

    private void checkJmfSchemas(DataObject dataObject, List list, List list2) throws JMFException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "checkJmfSchemas", dataObject);
        }
        ResourceCacheFactory resourceCacheFactory = ResourceCacheFactory.getInstance();
        ResourceCache resourceCache = resourceCacheFactory.getSdoRepositoryCache();
        ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
        EClass eClass = (EClass)((EType)dataObject.getType()).getEClassifier();
        EPackage ePackage = eClass.getEPackage();
        Resource resource = ePackage.eResource();
        this.getJmfSchema(eClass);
        String string = extendedMetaData.getNamespace(ePackage);
        String string2 = resource.getURI().toString();
        if (!list.contains(string)) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Adding schema for package: " + string + " at location: " + string2);
            }
            list.add(string);
            list2.add(string2);
        }
        Iterator iterator = dataObject.getType().getProperties().iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            String string3 = property.getName();
            Object object = dataObject.get(property);
            boolean bl = property.isContainment();
            boolean bl2 = OutputHelper.isVirtual(property);
            if (bl2 || object instanceof DataObject && !bl) continue;
            this.checkJmfSchemas(object, list, list2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "checkJmfSchemas");
        }
    }

    private JMFSchema getJmfSchema(DataObject dataObject) throws JMFException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getJmfSchema(DataObject)");
        }
        JMFSchema jMFSchema = this.getJmfSchema(((EObject)dataObject).eClass());
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getJmfSchema(DataObject)");
        }
        return jMFSchema;
    }

    private JMFSchema getJmfSchema(EClass eClass) throws JMFException {
        JMFSchema jMFSchema;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getJmfSchema(EClass)");
        }
        if ((jMFSchema = JMFRegistry.instance.retrieve(eClass)) == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "No schema registered for: " + eClass.getName());
            }
            jMFSchema = JMFRegistry.instance.createJMFSchema(EcoreConverter.convert(eClass, true, true));
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Added schema: " + Long.toHexString(jMFSchema.getID()));
            }
            JMFRegistry.instance.registerAll(jMFSchema);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getJmfSchema(EClass)");
        }
        return jMFSchema;
    }

    private JMFMessage getJmfMessage(DataObject dataObject) throws JMFException, DataMediatorException, ResourceException {
        int n;
        JMFSchema[] jMFSchemaArray;
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getJmfMessage");
        }
        JMFSchema jMFSchema = JmfDataMediatorFactory.getEnvelopeSchema();
        int n2 = JmfDataMediatorFactory.getPackageAccessor();
        int n3 = JmfDataMediatorFactory.getLocationAccessor();
        int n4 = JmfDataMediatorFactory.getContentAccessor();
        JMFMessage jMFMessage = JMFRegistry.instance.newMessage(jMFSchema);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        JMFNativePart jMFNativePart = SDOoverJMF.getNativePart((EObject)dataObject);
        if (jMFNativePart == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Transcribing SDO to JMF");
            }
            this.checkJmfSchemas(dataObject, (List)arrayList, (List)arrayList2);
            jMFNativePart = JMFRegistry.instance.newNativePart(this.getJmfSchema(dataObject));
            SDOoverJMF.transcribe((EObject)dataObject, jMFNativePart, true);
            jMFMessage.setValue(n4, jMFNativePart);
        } else {
            jMFMessage.setValue(n4, jMFNativePart);
            object = ExtendedMetaData.INSTANCE;
            jMFSchemaArray = jMFMessage.getSchemata();
            for (n = 0; n < jMFSchemaArray.length; ++n) {
                Object object2 = jMFSchemaArray[n].getJMFType().getAssociation();
                if (!(object2 instanceof EClass)) continue;
                EPackage ePackage = ((EClass)object2).getEPackage();
                Resource resource = ePackage.eResource();
                String string = object.getNamespace(ePackage);
                String string2 = resource.getURI().toString();
                if (arrayList.contains(string)) continue;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Adding schema for package: " + string + " at location: " + string2);
                }
                arrayList.add(string);
                arrayList2.add(string2);
            }
        }
        jMFMessage.setValue(n2, arrayList);
        jMFMessage.setValue(n3, arrayList2);
        if (tc.isDebugEnabled()) {
            object = "Required JMF schema for message: ";
            jMFSchemaArray = jMFMessage.getSchemata();
            for (n = 0; n < jMFSchemaArray.length; ++n) {
                object = (String)object + " " + Long.toHexString(jMFSchemaArray[n].getID());
            }
            SibTr.debug(tc, (String)object);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getJmfMessage");
        }
        return jMFMessage;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/mediators/JmfDataMediator.java, SIB.mfp, WAS602.SIB, o0610.11 1.24");
        }
    }
}

