/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.jms;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.mfp.sdo.jms.JmsModelGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class JmsStreamHandler
extends DefaultHandler {
    private static final TraceComponent tc = SibTr.register(JmsStreamHandler.class, null, null);
    private static final int readyForDocumentState = 1;
    private static final int readyForDataElementState = 2;
    private static final int readyForElementState = 3;
    private static final int readyForValueState = 4;
    private static final int readyForEndElementState = 5;
    private static final int readyForEndDocumentState = 6;
    private static final int completeState = 7;
    private static final String[] stateNames = new String[]{"illegal", "readyForDocument", "readyForDataElement", "readyForElement", "readyForValue", "readyForEndElement", "readyForEndDocument", "complete"};
    private DataGraph graph = null;
    private DataObject data = null;
    private boolean nilObject = false;
    private int state = 1;
    private StringBuffer currentText = new StringBuffer();
    private EDataType incomingType = null;
    private Map prefixes = new HashMap();

    public JmsStreamHandler(DataGraph dataGraph) {
        this.graph = dataGraph;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "characters", new Object[]{cArray, new Integer(n), new Integer(n2)});
        }
        this.currentText.append(cArray, n, n2);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "characters");
        }
    }

    public void endDocument() throws SAXException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "endDocument");
        }
        if (this.state != 6) {
            SAXException sAXException = new SAXException("End of document encountered while in state " + stateNames[this.state]);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "endDocument", sAXException);
            }
            throw sAXException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "endDocument");
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "endElement", new Object[]{string, string2, string3});
        }
        if (!"http://www.ibm.com/xmlns/prod/websphere/messaging/jms".equals(string)) {
            SAXException sAXException = new SAXException("Element " + string3 + " from namespace " + string + "not permitted in a JMS stream message");
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "endElement", sAXException);
            }
            throw sAXException;
        }
        switch (this.state) {
            case 4: 
            case 5: {
                if ("value".equals(string2)) {
                    Object object = this.getValue();
                    this.data.getList("value").add(object);
                    this.state = 3;
                    break;
                }
                SAXException sAXException = new SAXException("Found end element " + string3 + "in JMS Stream message when expecting end of \"value\" element");
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "endElement", sAXException);
                }
                throw sAXException;
            }
            case 3: {
                if ("data".equals(string2)) {
                    this.state = 6;
                    break;
                }
                SAXException sAXException = new SAXException("Found end element " + string3 + "in JMS Stream message when expecting end of \"data\" element");
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "endElement", sAXException);
                }
                throw sAXException;
            }
            default: {
                SAXException sAXException = new SAXException("End of element encountered while in state " + stateNames[this.state]);
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "endElement", sAXException);
                }
                throw sAXException;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "endElement");
        }
    }

    private Object getValue() throws SAXException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getValue");
        }
        Object object = null;
        if (!this.nilObject) {
            if (this.incomingType == JmsModelGenerator.characterEDatatype) {
                char[] cArray = this.currentText.toString().toCharArray();
                if (cArray.length != 1) {
                    SAXException sAXException = new SAXException("A JMS Character element must have one character");
                    if (tc.isEntryEnabled()) {
                        SibTr.exit(tc, "getValue", sAXException);
                    }
                    throw sAXException;
                }
                object = new Character(cArray[0]);
            } else {
                EFactory eFactory = this.incomingType.getEPackage().getEFactoryInstance();
                object = eFactory.createFromString(this.incomingType, this.currentText.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getValue", object);
        }
        return object;
    }

    public void endPrefixMapping(String string) throws SAXException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "endPrefixMapping", (Object)string);
        }
        this.prefixes.remove(string);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "endPrefixMapping");
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void startDocument() throws SAXException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "startDocument");
        }
        if (this.state != 1) {
            SAXException sAXException = new SAXException("Start of document encountered while in state " + stateNames[this.state]);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "startDocument", sAXException);
            }
            throw sAXException;
        }
        this.state = 2;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "startDocument");
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "startElement", new Object[]{string, string2, string3, attributes});
        }
        if (!"http://www.ibm.com/xmlns/prod/websphere/messaging/jms".equals(string)) {
            SAXException sAXException = new SAXException("Element " + string3 + " from namespace " + string + "not permitted in a JMS stream message");
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "startElement", sAXException);
            }
            throw sAXException;
        }
        this.currentText.delete(0, this.currentText.length());
        this.nilObject = false;
        switch (this.state) {
            case 2: {
                if ("data".equals(string2)) {
                    this.data = this.graph.getRootObject().createDataObject("data");
                    this.state = 3;
                    break;
                }
                SAXException sAXException = new SAXException("Found end element " + string3 + "in JMS Stream message when expecting end of \"data\" element");
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "startElement", sAXException);
                }
                throw sAXException;
            }
            case 3: {
                if ("value".equals(string2)) {
                    this.incomingType = JmsModelGenerator.stringEDatatype;
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        if (!"http://www.w3.org/2001/XMLSchema-instance".equals(attributes.getURI(i))) continue;
                        if ("type".equals(attributes.getLocalName(i))) {
                            this.incomingType = this.getType(attributes.getValue(i));
                            continue;
                        }
                        if (!"nil".equals(attributes.getLocalName(i))) continue;
                        this.nilObject = true;
                        this.state = 5;
                    }
                    this.state = 4;
                    break;
                }
                SAXException sAXException = new SAXException("Found end element " + string3 + "in JMS Stream message when expecting end of \"value\" element");
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "startElement", sAXException);
                }
                throw sAXException;
            }
            default: {
                SAXException sAXException = new SAXException("Start of element encountered while in state " + stateNames[this.state]);
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "startElement", sAXException);
                }
                throw sAXException;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "startElement");
        }
    }

    private EDataType getType(String string) throws SAXException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getType", (Object)string);
        }
        EDataType eDataType = null;
        String[] stringArray = string.split(":");
        if (stringArray.length != 2) {
            SAXException sAXException = new SAXException("End of element encountered while in state " + stateNames[this.state]);
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getType", sAXException);
            }
            throw sAXException;
        }
        String string2 = (String)this.prefixes.get(stringArray[0]);
        if (!"http://www.w3.org/2001/XMLSchema".equals(string2) && !"http://www.ibm.com/xmlns/prod/websphere/messaging/jms".equals(string2)) {
            SAXException sAXException = new SAXException("Unexpected namespace \"" + string2 + "\" for data type in JMS Stream message");
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getType", sAXException);
            }
            throw sAXException;
        }
        eDataType = (EDataType)JmsModelGenerator.allowedSimpleTypes.get(stringArray[1]);
        if (eDataType == null) {
            SAXException sAXException = new SAXException("Unexpected data type " + string2 + " : " + stringArray[1] + ", " + " in JMS Stream message");
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getType", sAXException);
            }
            throw sAXException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getType", eDataType);
        }
        return eDataType;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "startPrefixMapping", new Object[]{string, string2});
        }
        this.prefixes.put(string, string2);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "startPrefixMapping");
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }
}

