/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo.bean;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.sdo.bean.BeanDataMediatorImpl;
import com.ibm.ws.sib.mfp.sdo.bean.JAXRPCData;
import com.ibm.ws.sib.mfp.sdo.bean.JAXRPCDataImpl;
import com.ibm.ws.sib.mfp.sdo.bean.TypeMapImpl;
import com.ibm.ws.sib.mfp.sdo.soap.SOAPDataMediator;
import com.ibm.ws.sib.mfp.sdo.soap.SOAPDataMediatorImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.sdo.DataMediatorException;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.io.ByteArrayInputStream;
import java.util.List;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.sdo.EProperty;
import org.eclipse.emf.ecore.sdo.EType;
import org.eclipse.emf.ecore.sdo.util.SDOUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class FaultWriter {
    private MessageFactory messageFactory;
    private SOAPMessage soapMessage;
    private SOAPEnvelope soapEnvelope;
    private SOAPFactory soapFactory;
    private BeanDataMediatorImpl beanDataMediator;
    private SOAPDataMediatorImpl soapDataMediator;
    private static TraceComponent tc = SibTr.register(FaultWriter.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");

    FaultWriter(BeanDataMediatorImpl beanDataMediatorImpl, SOAPDataMediatorImpl sOAPDataMediatorImpl) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "<init>");
        }
        this.messageFactory = MessageFactory.newInstance();
        this.soapMessage = this.messageFactory.createMessage();
        this.soapEnvelope = this.soapMessage.getSOAPPart().getEnvelope();
        this.soapFactory = SOAPFactory.newInstance();
        this.beanDataMediator = beanDataMediatorImpl;
        this.soapDataMediator = sOAPDataMediatorImpl;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "<init>");
        }
    }

    JAXRPCData writeFault(DataObject dataObject, TypeMapImpl typeMapImpl) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeFault", new Object[]{dataObject, typeMapImpl});
        }
        JAXRPCData jAXRPCData = null;
        if (dataObject.getString("messageName") != null) {
            try {
                jAXRPCData = this.writeServiceSpecificFault(dataObject, typeMapImpl);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mfp.sdo.bean.FaultWriter.writeFault", (String)"131", (Object)this);
            }
        }
        if (jAXRPCData == null) {
            jAXRPCData = this.writeSOAPFault(dataObject);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeFault", jAXRPCData);
        }
        return jAXRPCData;
    }

    JAXRPCData writeServiceSpecificFault(DataObject dataObject, TypeMapImpl typeMapImpl) throws DataMediatorException {
        EType eType;
        Object object;
        Class clazz;
        DataObject dataObject2 = dataObject.getDataObject("body/detail/any[1]");
        EType eType2 = (EType)dataObject2.getType();
        EProperty eProperty = (EProperty)eType2.getProperties().get(0);
        EClassifier eClassifier = eProperty.getEStructuralFeature().getEType();
        if (eClassifier instanceof EClass) {
            dataObject2 = dataObject2.getDataObject((Property)eProperty);
            eType2 = SDOUtil.adaptType((EClassifier)eClassifier);
        }
        if ((clazz = typeMapImpl.mapModelType(eType2)) == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "writeServiceSpecificFault", (Object)"No exception class");
            }
            return null;
        }
        List list = eType2.getProperties();
        Object[] objectArray = new Object[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            object = (EProperty)list.get(i);
            eType = (EType)object.getType();
            Class clazz2 = typeMapImpl.mapModelType((EType)object.getType());
            if (clazz2 == null) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "writeServiceSpecificFault", (Object)"No part class");
                }
                return null;
            }
            if (!typeMapImpl.isSupportedType((Type)eType)) {
                objectArray[i] = typeMapImpl.isSOAPEncodedArray(eType) ? this.beanDataMediator.instantiateObject(dataObject2.get((Property)object), (EProperty)object, clazz2) : this.beanDataMediator.instantiateObject(dataObject2, (EProperty)object, clazz2);
            }
            objectArray[i] = this.beanDataMediator.writeBean(objectArray[i], dataObject2, (EProperty)object);
        }
        JAXRPCDataImpl jAXRPCDataImpl = null;
        object = null;
        eType = clazz.getConstructors();
        for (int i = 0; i < ((EType)eType).length; ++i) {
            boolean bl = false;
            Class<?>[] classArray = eType[i].getParameterTypes();
            if (classArray.length == objectArray.length) {
                bl = true;
                for (int j = 0; j < classArray.length; ++j) {
                    if (objectArray[j] == null || classArray[j].isInstance(objectArray[j])) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) continue;
            try {
                Object t = eType[i].newInstance(objectArray);
                jAXRPCDataImpl = new JAXRPCDataImpl(new Object[]{t}, new Class[]{clazz}, null);
                break;
            }
            catch (Exception exception) {
                object = exception;
            }
        }
        if (jAXRPCDataImpl == null) {
            FFDCFilter.processException((Throwable)object, (String)"com.ibm.ws.sib.mfp.sdo.bean.FaultWriter.writeServiceSpecificFault", (String)"236", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeServiceSpecificFault", jAXRPCDataImpl);
        }
        return jAXRPCDataImpl;
    }

    JAXRPCData writeSOAPFault(DataObject dataObject) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "writeSOAPFault");
        }
        DataObject dataObject2 = dataObject.getDataObject("body");
        QName qName = (QName)dataObject2.get("faultcode");
        String string = dataObject2.getString("faultstring");
        String string2 = dataObject2.getString("faultactor");
        DataObject dataObject3 = dataObject2.getDataObject("detail");
        Detail detail = null;
        if (null != dataObject3) {
            detail = this.createDetail(dataObject);
        }
        SOAPFaultException sOAPFaultException = new SOAPFaultException(qName, string, string2, detail);
        Object[] objectArray = new Object[]{sOAPFaultException};
        Class[] classArray = new Class[]{SOAPFaultException.class};
        DataHandler[] dataHandlerArray = new DataHandler[]{};
        JAXRPCDataImpl jAXRPCDataImpl = new JAXRPCDataImpl(objectArray, classArray, dataHandlerArray);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "writeSOAPFault");
        }
        return jAXRPCDataImpl;
    }

    private Detail createDetail(DataObject dataObject) throws DataMediatorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createDetail");
        }
        Detail detail = null;
        try {
            detail = this.soapFactory.createDetail();
            SOAPDataMediator.Message message = this.soapDataMediator.writeDetail(dataObject);
            byte[] byArray = message.getData();
            int n = message.getStartOffset();
            int n2 = message.getLength();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(byArray, n, n2));
            this.removeNamespaceAttribute(document);
            NodeList nodeList = document.getFirstChild().getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                Name name = this.soapEnvelope.createName(node.getLocalName(), node.getPrefix(), node.getNamespaceURI());
                DetailEntry detailEntry = detail.addDetailEntry(name);
                NodeList nodeList2 = node.getChildNodes();
                Document document2 = detailEntry.getOwnerDocument();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node2 = document2.importNode(nodeList2.item(j), true);
                    detailEntry.appendChild(node2);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mfp.sdo.bean.FaultWriter.createDetail", (String)"344", (Object)this, (Object[])new Object[]{dataObject.getString("operationName"), dataObject.getString("messageName")});
            String string = nls.getFormattedMessage("FAULT_WRITE_FAILURE_CWSIF0336", new Object[]{dataObject.getString("operationName"), dataObject.getString("messageName")}, "Fault write failure");
            throw new DataMediatorException(string, exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createDetail");
        }
        return detail;
    }

    private void removeNamespaceAttribute(Node node) {
        int n;
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "removeNamespaceAttribute");
        }
        if (node.getNodeType() == 1) {
            object = node.getAttributes();
            n = 0;
            if (object != null) {
                n = object.getLength();
            }
            int n2 = 0;
            while (n2 < n) {
                Node node2 = object.item(n2);
                if (node2.getNodeName().equals("xmlns") || node2.getNodeName().startsWith("xmlns:")) {
                    object.removeNamedItem(node2.getNodeName());
                    --n;
                    continue;
                }
                ++n2;
            }
        }
        if ((object = node.getChildNodes()) != null) {
            for (n = 0; n < object.getLength(); ++n) {
                this.removeNamespaceAttribute(object.item(n));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "removeNamespaceAttribute");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/bean/FaultWriter.java, SIB.mfp, WAS602.SIB, o0610.11 1.12");
        }
    }
}

