/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.mfp.sdo.SdoStore;
import com.ibm.ws.sib.utils.ras.SibTr;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.Type;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEStoreEObjectImpl;
import org.eclipse.emf.ecore.sdo.EProperty;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;

public class OutputHelper {
    private static TraceComponent tc = SibTr.register(OutputHelper.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");

    public static String ref(DataObject dataObject, Property property, Object object) {
        String string = "";
        DataObject dataObject2 = dataObject.getContainer();
        if (dataObject2 != null) {
            Property property2 = dataObject.getContainmentProperty();
            string = OutputHelper.ref(dataObject2, property2, dataObject);
        }
        int n = -1;
        String string2 = property.getName();
        List list = dataObject.getType().getProperties();
        if (!list.contains(property)) {
            block0: for (int i = 0; i < list.size(); ++i) {
                Object object2;
                Property property3 = (Property)list.get(i);
                if (OutputHelper.isVirtual(property3) || !((object2 = dataObject.get(property3)) instanceof Sequence)) continue;
                Sequence sequence = (Sequence)object2;
                for (int j = 0; j < sequence.size(); ++j) {
                    if (sequence.getValue(j) != object) continue;
                    string2 = property3.getName();
                    n = j;
                    continue block0;
                }
            }
        } else if (OutputHelper.isVirtual(property)) {
            ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
            EAttribute eAttribute = extendedMetaData.getMixedFeature(((EObject)dataObject).eClass());
            if (eAttribute == null) {
                eAttribute = ((EProperty)property).getEStructuralFeature();
                while (eAttribute.isDerived()) {
                    eAttribute = extendedMetaData.getGroup((EStructuralFeature)eAttribute);
                }
            }
            string2 = eAttribute.getName();
            Sequence sequence = dataObject.getSequence(string2);
            for (int i = 0; i < sequence.size(); ++i) {
                if (object == null || !object.equals(sequence.getValue(i))) continue;
                n = i;
                break;
            }
        } else if (property.isMany()) {
            List list2 = dataObject.getList(property);
            for (int i = 0; i < list2.size(); ++i) {
                if (list2.get(i) != object) continue;
                n = i;
                break;
            }
        }
        string = n == -1 ? string + "/" + string2 : string + "/" + string2 + "[" + (n + 1) + "]";
        return string;
    }

    public static boolean isVirtual(Property property) {
        EStructuralFeature eStructuralFeature = ((EProperty)property).getEStructuralFeature();
        return eStructuralFeature.isDerived();
    }

    public static String print(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object != null) {
            OutputHelper.format(stringBuffer, object, 0, false);
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }

    public static String trace(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object != null) {
            OutputHelper.format(stringBuffer, object, 0, true);
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }

    private static void format(StringBuffer stringBuffer, DataGraph dataGraph, int n, boolean bl) {
        if (dataGraph == null) {
            stringBuffer.append("Null data graph");
            return;
        }
        stringBuffer.append("(DataGraph) {\n");
        DataObject dataObject = dataGraph.getRootObject();
        OutputHelper.format(stringBuffer, dataObject, n + 1, bl);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
        stringBuffer.append("}");
    }

    private static void format(StringBuffer stringBuffer, DataObject dataObject, int n, boolean bl) {
        int n2;
        if (dataObject == null) {
            stringBuffer.append("Null data object");
            return;
        }
        if (bl && dataObject instanceof DynamicEStoreEObjectImpl && ((DynamicEStoreEObjectImpl)dataObject).eStore() instanceof SdoStore) {
            SdoStore sdoStore = (SdoStore)((DynamicEStoreEObjectImpl)dataObject).eStore();
            stringBuffer.append("(StoreDataObject: " + sdoStore.getClass().toString() + ") {\n");
            stringBuffer.append(sdoStore.dumpState());
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("  ");
            }
            stringBuffer.append("}");
            return;
        }
        Type type = dataObject.getType();
        String string = type.getName();
        stringBuffer.append("(DataObject: " + string + ") {\n");
        List list = type.getProperties();
        for (n2 = 0; n2 < list.size(); ++n2) {
            Property property = (Property)list.get(n2);
            String string2 = property.getName();
            Object object = dataObject.get(property);
            boolean bl2 = property.isContainment();
            boolean bl3 = OutputHelper.isVirtual(property);
            for (int i = 0; i < n + 1; ++i) {
                stringBuffer.append("  ");
            }
            stringBuffer.append(string2);
            stringBuffer.append("=");
            if (bl3 || object instanceof DataObject && !bl2) {
                stringBuffer.append("<ref> " + OutputHelper.ref(dataObject, property, object));
            } else {
                OutputHelper.format(stringBuffer, object, n + 1, bl);
            }
            stringBuffer.append("\n");
        }
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append("  ");
        }
        stringBuffer.append("}");
    }

    private static void format(StringBuffer stringBuffer, Sequence sequence, int n, boolean bl) {
        int n2;
        if (sequence == null) {
            return;
        }
        if (sequence.size() == 0) {
            stringBuffer.append("(Sequence) []");
            return;
        }
        stringBuffer.append("(Sequence) [\n");
        int n3 = sequence.size();
        for (n2 = 0; n2 < n3; ++n2) {
            Property property = sequence.getProperty(n2);
            String string = property.getName();
            Object object = sequence.getValue(n2);
            if (string == null) {
                string = "<text>";
            }
            for (int i = 0; i < n + 1; ++i) {
                stringBuffer.append("  ");
            }
            stringBuffer.append(string);
            stringBuffer.append("=");
            OutputHelper.format(stringBuffer, object, n + 1, bl);
            stringBuffer.append("\n");
        }
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append("  ");
        }
        stringBuffer.append("]");
    }

    private static void format(StringBuffer stringBuffer, List list, int n, boolean bl) {
        if (list.size() == 0) {
            stringBuffer.append("(List) []");
            return;
        }
        stringBuffer.append("(List) [\n");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            for (int i = 0; i < n + 1; ++i) {
                stringBuffer.append("  ");
            }
            OutputHelper.format(stringBuffer, e, n + 1, bl);
            if (iterator.hasNext()) {
                stringBuffer.append(",\n");
                continue;
            }
            stringBuffer.append("\n");
        }
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
        stringBuffer.append("]");
    }

    private static void format(StringBuffer stringBuffer, byte[] byArray, int n) {
        stringBuffer.append("(byte[]) [\n");
        stringBuffer.append(OutputHelper.print(byArray));
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
        stringBuffer.append("]");
    }

    private static void format(StringBuffer stringBuffer, FeatureMap.Entry entry, int n, boolean bl) {
        int n2;
        stringBuffer.append("(FeatureMap.Entry) <\n");
        for (n2 = 0; n2 < n + 1; ++n2) {
            stringBuffer.append("  ");
        }
        stringBuffer.append(entry.getEStructuralFeature().getName());
        stringBuffer.append("=");
        OutputHelper.format(stringBuffer, entry.getValue(), n + 1, bl);
        stringBuffer.append("\n");
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append("  ");
        }
        stringBuffer.append(">");
    }

    private static void format(StringBuffer stringBuffer, BasicEMap.Entry entry, int n, boolean bl) {
        int n2;
        stringBuffer.append("(BasicEMap.Entry) <\n");
        for (n2 = 0; n2 < n + 1; ++n2) {
            stringBuffer.append("  ");
        }
        OutputHelper.format(stringBuffer, entry.getKey(), n + 1, bl);
        stringBuffer.append("=>");
        OutputHelper.format(stringBuffer, entry.getValue(), n + 1, bl);
        stringBuffer.append("\n");
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append("  ");
        }
        stringBuffer.append(">");
    }

    private static void format(StringBuffer stringBuffer, Object object, int n, boolean bl) {
        if (object instanceof List) {
            OutputHelper.format(stringBuffer, (List)object, n, bl);
        } else if (object instanceof byte[]) {
            OutputHelper.format(stringBuffer, (byte[])object, n);
        } else if (object instanceof DataObject) {
            OutputHelper.format(stringBuffer, (DataObject)object, n, bl);
        } else if (object instanceof DataGraph) {
            OutputHelper.format(stringBuffer, (DataGraph)object, n, bl);
        } else if (object instanceof Sequence) {
            OutputHelper.format(stringBuffer, (Sequence)object, n, bl);
        } else if (object instanceof FeatureMap.Entry) {
            OutputHelper.format(stringBuffer, (FeatureMap.Entry)object, n, bl);
        } else if (object instanceof BasicEMap.Entry) {
            OutputHelper.format(stringBuffer, (BasicEMap.Entry)object, n, bl);
        } else {
            stringBuffer.append("(Data)'");
            stringBuffer.append(object);
            stringBuffer.append("'");
        }
    }

    public static String print(byte[] byArray) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (byArray == null) {
            printWriter.write("Null buffer");
        } else {
            OutputHelper.print(printWriter, byArray, 0, byArray.length);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    public static String print(byte[] byArray, int n, int n2) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (byArray == null) {
            printWriter.write("Null buffer");
        } else {
            OutputHelper.print(printWriter, byArray, n, n2);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    private static void print(PrintWriter printWriter, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; i += 16) {
            int n3;
            int n4;
            int n5;
            int n6 = Math.min(i + 16, n2);
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            for (n5 = i; n5 < n6; ++n5) {
                n4 = byArray[n + n5];
                n4 = (n4 + 256) % 256;
                n3 = n4 / 16;
                int n7 = n4 % 16;
                stringBuffer.append((char)(n3 < 10 ? 48 + n3 : 97 + n3 - 10));
                stringBuffer.append((char)(n7 < 10 ? 48 + n7 : 97 + n7 - 10));
                if (n5 % 2 == 1) {
                    stringBuffer.append(' ');
                }
                if (n4 >= 32 && n4 <= 126) {
                    stringBuffer2.append((char)n4);
                    continue;
                }
                stringBuffer2.append('.');
            }
            n5 = 16 - (n6 - i);
            n4 = (n5 * 5 + n5 % 2) / 2;
            n4 += 3;
            for (n3 = 0; n3 < n4; ++n3) {
                stringBuffer.append(' ');
            }
            String string = "0000" + Integer.toHexString(i);
            string = string.substring(string.length() - 4);
            printWriter.print(string);
            printWriter.print(":  ");
            printWriter.print(stringBuffer.toString());
            printWriter.print(stringBuffer2.toString());
            printWriter.print("\n");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.sdo/src/com/ibm/ws/sib/mfp/sdo/OutputHelper.java, SIB.mfp, WAS602.SIB, o0610.11 1.20");
        }
    }
}

