/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.sdo;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIDataGraphException;
import com.ibm.websphere.sib.exception.SIDataGraphFormatMismatchException;
import com.ibm.websphere.sib.exception.SIDataGraphSchemaNotFoundException;
import com.ibm.websphere.sib.exception.SIMessageDomainNotSupportedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.sdo.DataGraphFactory;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceCache;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceCacheFactory;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceNotFoundException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.sdo.DataMediator;
import com.ibm.wsspi.sib.sdo.DataMediatorException;
import com.ibm.wsspi.sib.sdo.DataMediatorNotFoundException;
import com.ibm.wsspi.sib.sdo.DataMediatorRegistry;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.EDataObject;

public final class DataGraphFactoryImpl
extends DataGraphFactory {
    private static final TraceComponent tc = SibTr.register(DataGraphFactoryImpl.class, "SIBMfpApi", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");

    public DataGraph createDataGraph(String string) throws SIMessageDomainNotSupportedException, SIDataGraphSchemaNotFoundException, SIDataGraphException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createDataGraph", (Object)string);
        }
        DataGraph dataGraph = null;
        if (!"JMS:".equals(string)) {
            if (string != null) {
                if (string.equals("JMS:map")) {
                    String string2 = nls.getFormattedMessage("MAP_NOT_SUPPORTED_AS_SDO_CWSIF0500", null, "A JMS Map Message can not be accessed as an SDO DataGraph.");
                    if (tc.isEntryEnabled()) {
                        SibTr.exit(tc, "createDataGraph", (Object)"UnsupportedOperationException");
                    }
                    throw new UnsupportedOperationException(string2);
                }
                try {
                    DataMediator dataMediator = DataMediatorRegistry.instance().getMediator(string);
                    if (dataMediator == null) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "No data mediator found: " + string);
                        }
                        String string3 = nls.getFormattedMessage("NO_DATA_MEDIATOR_CWSIF0362", new Object[]{string}, "Incorrect message format.");
                        if (tc.isEntryEnabled()) {
                            SibTr.exit(tc, "createDataGraph", (Object)"SIMessageDomainNotSupportedException");
                        }
                        throw new SIMessageDomainNotSupportedException(string3);
                    }
                    dataGraph = dataMediator.createDataGraph();
                }
                catch (DataMediatorNotFoundException dataMediatorNotFoundException) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit(tc, "createDataGraph", (Object)"SIMessageDomainNotSupportedException");
                    }
                    throw new SIMessageDomainNotSupportedException(dataMediatorNotFoundException.getMessage(), dataMediatorNotFoundException);
                }
                catch (DataMediatorException dataMediatorException) {
                    for (Throwable throwable = dataMediatorException.getCause(); throwable != null; throwable = throwable.getCause()) {
                        if (!(throwable instanceof ResourceNotFoundException)) continue;
                        if (tc.isEntryEnabled()) {
                            SibTr.exit(tc, "createDataGraph", (Object)"SIDataGraphSchemaNotFoundException");
                        }
                        throw new SIDataGraphSchemaNotFoundException(dataMediatorException.getMessage(), dataMediatorException);
                    }
                    if (tc.isEntryEnabled()) {
                        SibTr.exit(tc, "createDataGraph", (Object)"SIDataGraphException");
                    }
                    throw new SIDataGraphException(dataMediatorException.getMessage(), dataMediatorException);
                }
            } else {
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "createDataGraph", (Object)"NullPointerException");
                }
                throw new NullPointerException();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createDataGraph");
        }
        return dataGraph;
    }

    public DataGraph getDataGraphFor(DataObject dataObject) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getDataGraphFor", dataObject);
        }
        DataGraph dataGraph = null;
        dataGraph = dataObject.getDataGraph();
        if (dataGraph == null) {
            ResourceCacheFactory resourceCacheFactory = ResourceCacheFactory.getInstance();
            ResourceCache resourceCache = resourceCacheFactory.getSdoRepositoryCache();
            dataGraph = resourceCache.createDataGraph(null);
            ((EDataGraph)dataGraph).setERootObject((EObject)dataObject);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getDataGraphFor", dataGraph);
        }
        return dataGraph;
    }

    public DataGraph createDataGraph(byte[] byArray, String string) throws SIMessageDomainNotSupportedException, SIDataGraphSchemaNotFoundException, SIDataGraphFormatMismatchException, SIDataGraphException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createDataGraph", new Object[]{byArray, string});
        }
        EDataGraph eDataGraph = null;
        if ("JMS:".equals(string)) {
            eDataGraph = null;
        } else {
            if (byArray == null) {
                NullPointerException nullPointerException = new NullPointerException();
                String string2 = nls.getFormattedMessage("ERROR_TRANSCODING_FROM_BYTES_CWSIF0502", new Object[]{string, nullPointerException}, "Failed to create a datagraph from the null byte payload");
                throw new SIDataGraphFormatMismatchException(string2, nullPointerException);
            }
            try {
                DataMediator dataMediator = DataMediatorRegistry.instance().getMediator(string);
                DataObject dataObject = dataMediator.readTransform(byArray, string);
                ResourceCacheFactory resourceCacheFactory = ResourceCacheFactory.getInstance();
                ResourceCache resourceCache = resourceCacheFactory.getSdoRepositoryCache();
                eDataGraph = (EDataGraph)resourceCache.createDataGraph(null);
                eDataGraph.setERootObject((EObject)((EDataObject)dataObject));
            }
            catch (DataMediatorException dataMediatorException) {
                FFDCFilter.processException((Throwable)dataMediatorException, (String)"com.ibm.ws.sib.mfp.sdo.DataGraphFactoryImpl.createDataGraph", (String)"230", (Object)this);
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "createDataGraph");
                }
                String string3 = nls.getFormattedMessage("ERROR_TRANSCODING_FROM_BYTES_CWSIF0502", new Object[]{string, dataMediatorException}, "Failed to create a datagraph from the payload bytes");
                throw new SIDataGraphException(string3, dataMediatorException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createDataGraph", eDataGraph);
        }
        return eDataGraph;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.sdo.impl/src/com/ibm/ws/sib/mfp/sdo/DataGraphFactoryImpl.java, SIB.mfp, WAS602.SIB, o0610.11 1.26");
        }
    }
}

