/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop.util;

import com.ibm.ws.sib.mfp.mqinterop.util.PaddedString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class HexString {
    public static char NON_PRINTABLE = (char)46;

    public static void main(String[] stringArray) {
        if (stringArray.length == 1) {
            byte[] byArray = HexString.parseHex(stringArray[0]);
            System.out.println("0x" + HexString.hexString(byArray, ' ', 4));
        } else {
            System.out.println("Usage: java " + HexString.class.getName() + " string");
        }
    }

    static final char getChar(int n) {
        return Character.forDigit(n, 16);
    }

    public static byte[] parseHex(String string) throws NumberFormatException {
        string = HexString.prepare(string);
        byte[] byArray = new byte[string.length() >> 1];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = Character.digit(string.charAt(n++), 16);
            int n3 = Character.digit(string.charAt(n++), 16);
            if (n2 < 0 || n3 < 0) {
                throw new NumberFormatException(HexString.class.getName() + ": Non-hexadecimal character in input");
            }
            byArray[i] = (byte)(n2 << 4 | n3);
        }
        return byArray;
    }

    static String prepare(String string) {
        char[] cArray = new char[string.length()];
        int n = 0;
        int n2 = 0;
        if (string.startsWith("0x") || string.startsWith("0X")) {
            n += 2;
        }
        while (n < cArray.length) {
            char c = string.charAt(n);
            if (!Character.isWhitespace(c)) {
                cArray[n2++] = c;
            }
            ++n;
        }
        if (n2 & true) {
            return "0" + new String(cArray, 0, n2);
        }
        return new String(cArray, 0, n2);
    }

    public static String hexString(char c) {
        StringBuffer stringBuffer = new StringBuffer(4);
        stringBuffer.append(HexString.getChar(c >> 12 & 0xF));
        stringBuffer.append(HexString.getChar(c >> 8 & 0xF));
        stringBuffer.append(HexString.getChar(c >> 4 & 0xF));
        stringBuffer.append(HexString.getChar(c & 0xF));
        return new String(stringBuffer);
    }

    public static String hexString(byte by) {
        StringBuffer stringBuffer = new StringBuffer(2);
        stringBuffer.append(HexString.getChar(by >> 4 & 0xF));
        stringBuffer.append(HexString.getChar(by & 0xF));
        return new String(stringBuffer);
    }

    public static String hexString(short s) {
        StringBuffer stringBuffer = new StringBuffer(4);
        stringBuffer.append(HexString.getChar(s >> 12 & 0xF));
        stringBuffer.append(HexString.getChar(s >> 8 & 0xF));
        stringBuffer.append(HexString.getChar(s >> 4 & 0xF));
        stringBuffer.append(HexString.getChar(s & 0xF));
        return new String(stringBuffer);
    }

    public static String hexString(int n) {
        StringBuffer stringBuffer = new StringBuffer(8);
        stringBuffer.append(HexString.getChar(n >> 28 & 0xF));
        stringBuffer.append(HexString.getChar(n >> 24 & 0xF));
        stringBuffer.append(HexString.getChar(n >> 20 & 0xF));
        stringBuffer.append(HexString.getChar(n >> 16 & 0xF));
        stringBuffer.append(HexString.getChar(n >> 12 & 0xF));
        stringBuffer.append(HexString.getChar(n >> 8 & 0xF));
        stringBuffer.append(HexString.getChar(n >> 4 & 0xF));
        stringBuffer.append(HexString.getChar(n & 0xF));
        return new String(stringBuffer);
    }

    public static String hexString(long l) {
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(HexString.getChar((int)(l >> 60 & 0xFL)));
        stringBuffer.append(HexString.getChar((int)(l >> 56 & 0xFL)));
        stringBuffer.append(HexString.getChar((int)(l >> 52 & 0xFL)));
        stringBuffer.append(HexString.getChar((int)(l >> 48 & 0xFL)));
        stringBuffer.append(HexString.getChar((int)(l >> 44 & 0xFL)));
        stringBuffer.append(HexString.getChar((int)(l >> 40 & 0xFL)));
        stringBuffer.append(HexString.getChar((int)(l >> 36 & 0xFL)));
        stringBuffer.append(HexString.getChar((int)(l >> 32 & 0xFL)));
        stringBuffer.append(HexString.getChar((int)(l >> 28 & 0xFL)));
        stringBuffer.append(HexString.getChar((int)(l >> 24 & 0xFL)));
        stringBuffer.append(HexString.getChar((int)(l >> 20 & 0xFL)));
        stringBuffer.append(HexString.getChar((int)(l >> 16 & 0xFL)));
        stringBuffer.append(HexString.getChar((int)(l >> 12 & 0xFL)));
        stringBuffer.append(HexString.getChar((int)(l >> 8 & 0xFL)));
        stringBuffer.append(HexString.getChar((int)(l >> 4 & 0xFL)));
        stringBuffer.append(HexString.getChar((int)(l & 0xFL)));
        return new String(stringBuffer);
    }

    public static String hexString(byte[] byArray, char c, int n) {
        return HexString.hexString(byArray, 0, byArray.length, c, n);
    }

    public static String hexString(byte[] byArray, int n, int n2, char c, int n3) {
        StringBuffer stringBuffer = new StringBuffer(n2 * 2 + n2 % n3);
        n2 += n;
        for (int i = n; i < n2; ++i) {
            if (i % n3 == 0 && i > 0) {
                stringBuffer.append(c);
            }
            stringBuffer.append(HexString.getChar(byArray[i] >>> 4 & 0xF));
            stringBuffer.append(HexString.getChar(byArray[i] & 0xF));
        }
        return new String(stringBuffer);
    }

    public static String hexString(byte[] byArray) {
        return HexString.hexString(byArray, 0, byArray.length);
    }

    public static String hexString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        n2 += n;
        for (int i = n; i < n2; ++i) {
            stringBuffer.append(HexString.getChar(byArray[i] >> 4 & 0xF));
            stringBuffer.append(HexString.getChar(byArray[i] & 0xF));
        }
        return new String(stringBuffer);
    }

    public static String hexString(String string) {
        return HexString.hexString(string.getBytes());
    }

    public static String printPrintableChars(byte[] byArray) {
        return HexString.printPrintableChars(byArray, 0, byArray.length);
    }

    public static String printPrintableChars(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        for (int i = n; i < n2; ++i) {
            cArray[i] = byArray[i] < 32 || byArray[i] > 127 ? NON_PRINTABLE : (char)byArray[i];
        }
        return new String(cArray);
    }

    public static int displayHexStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        return HexString.displayHexStream(inputStream, outputStream, false);
    }

    public static int displayHexStream(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        byte[] byArray;
        int n = 20;
        int n2 = 0;
        int n3 = 0;
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = byArray = File.separatorChar == '\\' ? new String("\r\n").getBytes() : new String("\n").getBytes();
        while ((n2 = inputStream.read(byArray2)) >= 0) {
            if (bl) {
                outputStream.write(PaddedString.lead(n3, '0', 10).getBytes());
                outputStream.write(58);
                outputStream.write(32);
            }
            if (n2 == n) {
                outputStream.write(HexString.hexString(byArray2, ' ', 4).getBytes());
            } else {
                outputStream.write(PaddedString.pad(HexString.hexString(byArray2, 0, n2, ' ', 4), 44).getBytes());
            }
            outputStream.write(32);
            outputStream.write(39);
            outputStream.write(HexString.printPrintableChars(byArray2, 0, n2).getBytes());
            outputStream.write(39);
            outputStream.write(byArray);
            n3 += n2;
        }
        return n3;
    }
}

