/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop.impl;

import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedField;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

class SingleByteField
extends BufferedField {
    final byte defaultValue;

    public SingleByteField(String string, int n) {
        this(string, n, 0);
    }

    public SingleByteField(String string, int n, byte by) {
        super(string, n);
        this.defaultValue = by;
    }

    public int getFieldType() {
        return 1;
    }

    public int read(BufferedHeader bufferedHeader, DataInput dataInput, int n, int n2) throws IOException {
        this.setByteValue(bufferedHeader, dataInput.readByte());
        return this.size(bufferedHeader);
    }

    public int write(BufferedHeader bufferedHeader, DataOutput dataOutput, int n, int n2) throws IOException {
        dataOutput.writeByte(this.getByteValue(bufferedHeader));
        return this.size(bufferedHeader);
    }

    public int size(BufferedHeader bufferedHeader) {
        return 1;
    }

    public Object getValue(BufferedHeader bufferedHeader) {
        return new Byte(this.getByteValue(bufferedHeader));
    }

    public void setValue(BufferedHeader bufferedHeader, Object object) {
        this.setByteValue(bufferedHeader, object != null ? (Byte)object : this.defaultValue);
    }

    public byte getByteValue(BufferedHeader bufferedHeader) {
        ByteBuffer byteBuffer = this.getBuffer(bufferedHeader);
        return byteBuffer == null ? this.defaultValue : byteBuffer.get();
    }

    public void setByteValue(BufferedHeader bufferedHeader, byte by) {
        this.getBuffer(bufferedHeader, this.size(bufferedHeader)).put(by);
    }

    public int getIntValue(BufferedHeader bufferedHeader) {
        return this.getByteValue(bufferedHeader);
    }

    public String toString() {
        return super.toString() + " (default: " + this.defaultValue + ')';
    }
}

