/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop.impl;

import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedField;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

class LongField
extends BufferedField {
    final long defaultValue;

    public LongField(String string, int n) {
        this(string, n, 0L);
    }

    public LongField(String string, int n, long l) {
        super(string, n);
        this.defaultValue = l;
    }

    public int getFieldType() {
        return 8;
    }

    public int read(BufferedHeader bufferedHeader, DataInput dataInput, int n, int n2) throws IOException {
        this.setLongValue(bufferedHeader, dataInput.readLong());
        return this.size(bufferedHeader);
    }

    public int write(BufferedHeader bufferedHeader, DataOutput dataOutput, int n, int n2) throws IOException {
        if (this.isReversed(n)) {
            dataOutput.writeLong(LongField.reverse(this.getLongValue(bufferedHeader)));
        } else {
            dataOutput.writeLong(this.getLongValue(bufferedHeader));
        }
        return this.size(bufferedHeader);
    }

    public int size(BufferedHeader bufferedHeader) {
        return 8;
    }

    public Object getValue(BufferedHeader bufferedHeader) {
        return new Long(this.getLongValue(bufferedHeader));
    }

    public void setValue(BufferedHeader bufferedHeader, Object object) {
        this.setLongValue(bufferedHeader, object != null ? (Long)object : this.defaultValue);
    }

    public long getLongValue(BufferedHeader bufferedHeader) {
        ByteBuffer byteBuffer = this.getBuffer(bufferedHeader);
        return byteBuffer == null ? this.defaultValue : byteBuffer.getLong();
    }

    public void setLongValue(BufferedHeader bufferedHeader, long l) {
        this.getBuffer(bufferedHeader, this.size(bufferedHeader)).putLong(l);
    }

    public int getIntValue(BufferedHeader bufferedHeader) {
        return (int)this.getLongValue(bufferedHeader);
    }

    public String toString() {
        return super.toString() + " (default: " + this.defaultValue + ')';
    }
}

