/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop.impl;

import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedField;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

class IntField
extends BufferedField {
    static final int SIZE = 4;
    final int defaultValue;

    public IntField(String string, int n) {
        this(string, n, 0);
    }

    public IntField(String string, int n, int n2) {
        super(string, n);
        this.defaultValue = n2;
    }

    public int getFieldType() {
        return 4;
    }

    public int read(BufferedHeader bufferedHeader, DataInput dataInput, int n, int n2) throws IOException {
        this.setIntValue(bufferedHeader, dataInput.readInt());
        return 4;
    }

    public int write(BufferedHeader bufferedHeader, DataOutput dataOutput, int n, int n2) throws IOException {
        if (this.isReversed(n)) {
            dataOutput.writeInt(IntField.reverse(this.getIntValue(bufferedHeader)));
        } else {
            dataOutput.writeInt(this.getIntValue(bufferedHeader));
        }
        return 4;
    }

    public int size(BufferedHeader bufferedHeader) {
        return 4;
    }

    public Object getValue(BufferedHeader bufferedHeader) {
        return new Integer(this.getIntValue(bufferedHeader));
    }

    public void setValue(BufferedHeader bufferedHeader, Object object) {
        this.setIntValue(bufferedHeader, object != null ? (Integer)object : this.defaultValue);
    }

    public int getIntValue(BufferedHeader bufferedHeader) {
        ByteBuffer byteBuffer = this.getBuffer(bufferedHeader);
        if (byteBuffer == null) {
            return this.defaultValue;
        }
        return byteBuffer.getInt();
    }

    public void setIntValue(BufferedHeader bufferedHeader, int n) {
        ByteBuffer byteBuffer = this.getBuffer(bufferedHeader, this.size(bufferedHeader));
        byteBuffer.putInt(n);
    }

    public String toString() {
        return super.toString() + " (default: " + this.defaultValue + ')';
    }
}

