/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop.impl;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.mqinterop.ByteBufferDataOutput;
import com.ibm.ws.sib.mfp.mqinterop.MQHeader;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedField;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeader;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeaderType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.List;

class HeaderArrayField
extends BufferedField {
    final BufferedHeaderType type;
    final Class headerClass;
    final int length;

    public HeaderArrayField(String string, int n, int n2, BufferedHeaderType bufferedHeaderType) {
        this(string, n, n2, bufferedHeaderType, null);
    }

    public HeaderArrayField(String string, int n, int n2, BufferedHeaderType bufferedHeaderType, Class clazz) {
        super(string, n);
        if (bufferedHeaderType.isVariableSize()) {
            throw new IllegalArgumentException("Variable size type (" + bufferedHeaderType.getName() + ") not permitted");
        }
        this.type = bufferedHeaderType;
        this.headerClass = clazz;
        this.length = n2;
    }

    public int getFieldType() {
        return 28;
    }

    public int read(BufferedHeader bufferedHeader, DataInput dataInput, int n, int n2) throws IOException {
        return this.size(bufferedHeader);
    }

    public int write(BufferedHeader bufferedHeader, DataOutput dataOutput, int n, int n2) throws IOException {
        MQHeader[] mQHeaderArray = this.getHeaderArrayValue(bufferedHeader);
        int n3 = 0;
        for (int i = 0; i < mQHeaderArray.length; ++i) {
            n3 += mQHeaderArray[i].write(dataOutput, n, n2);
        }
        return n3;
    }

    public int size(BufferedHeader bufferedHeader) {
        if (bufferedHeader == null) {
            return 0;
        }
        return this.length(bufferedHeader) * this.type.size();
    }

    public MQHeader[] getHeaderArrayValue(BufferedHeader bufferedHeader) {
        MQHeader[] mQHeaderArray = null;
        try {
            if (this.headerClass != null) {
                mQHeaderArray = (BufferedHeader[])Array.newInstance(this.headerClass, this.length(bufferedHeader));
                int n = this.offset;
                for (int i = 0; i < mQHeaderArray.length; ++i) {
                    mQHeaderArray[i] = (BufferedHeader)this.headerClass.newInstance();
                    ((BufferedHeader)mQHeaderArray[i]).setParent(bufferedHeader, n);
                    n += this.type.size();
                }
            } else {
                mQHeaderArray = new BufferedHeader[this.length(bufferedHeader)];
                int n = this.offset;
                for (int i = 0; i < mQHeaderArray.length; ++i) {
                    mQHeaderArray[i] = new BufferedHeader(this.type);
                    ((BufferedHeader)mQHeaderArray[i]).setParent(bufferedHeader, n);
                    n += this.type.size();
                }
            }
        }
        catch (InstantiationException instantiationException) {
            FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.sib.mfp.mqinterop.impl.HeaderArrayField.getHeaderArrayValue", (String)"140", (Object)this);
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.sib.mfp.mqinterop.impl.HeaderArrayField.getHeaderArrayValue", (String)"147", (Object)this);
            illegalAccessException.printStackTrace();
        }
        return mQHeaderArray;
    }

    public void setHeaderArrayValue(BufferedHeader bufferedHeader, MQHeader[] mQHeaderArray) {
        MQHeader[] mQHeaderArray2 = mQHeaderArray;
        ByteBuffer byteBuffer = this.getBuffer(bufferedHeader, mQHeaderArray2.length * this.type.size());
        for (int i = 0; i < mQHeaderArray2.length; ++i) {
            BufferedHeader bufferedHeader2 = (BufferedHeader)mQHeaderArray2[i];
            try {
                if (bufferedHeader2 == null) {
                    new BufferedHeader(this.type).write(new ByteBufferDataOutput(byteBuffer), bufferedHeader.encoding(), bufferedHeader.characterSet());
                    continue;
                }
                if (bufferedHeader2.getType() == this.type) {
                    bufferedHeader2.write(new ByteBufferDataOutput(byteBuffer), bufferedHeader.encoding(), bufferedHeader.characterSet());
                    continue;
                }
                throw new IllegalArgumentException("Value must contain headers of type " + this.type.getName());
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.mfp.mqinterop.impl.HeaderArrayField.setHeaderArrayValue", (String)"189", (Object)this);
                throw new RuntimeException(iOException);
            }
        }
        if (this.length <= 0) {
            bufferedHeader.setIntValue(-this.length, mQHeaderArray2.length);
        }
    }

    public Object getValue(BufferedHeader bufferedHeader) {
        final MQHeader[] mQHeaderArray = this.getHeaderArrayValue(bufferedHeader);
        return new AbstractList(){

            public Object get(int n) {
                return mQHeaderArray[n];
            }

            public int size() {
                return mQHeaderArray.length;
            }
        };
    }

    public void setValue(BufferedHeader bufferedHeader, Object object) {
        this.setValue(bufferedHeader, ((List)object).toArray(new MQHeader[0]));
    }

    public int getIntValue(BufferedHeader bufferedHeader) {
        return 0;
    }

    public boolean isVariableSize() {
        return this.length <= 0;
    }

    int length(BufferedHeader bufferedHeader) {
        if (bufferedHeader == null) {
            return 0;
        }
        if (this.length > 0) {
            return this.length;
        }
        return bufferedHeader.getIntValue(-this.length);
    }
}

