/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop.impl;

import com.ibm.ws.sib.mfp.mqinterop.CCSID;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedField;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;

class CharArrayField
extends BufferedField {
    final String defaultValue;

    public CharArrayField(String string, int n) {
        this(string, n, "");
    }

    public CharArrayField(String string, int n, int n2) {
        super(string, n);
        char[] cArray = new char[n2];
        Arrays.fill(cArray, ' ');
        this.defaultValue = new String(cArray);
    }

    public CharArrayField(String string, int n, String string2) {
        super(string, n);
        this.defaultValue = string2;
    }

    public int getFieldType() {
        return 10;
    }

    public int read(BufferedHeader bufferedHeader, DataInput dataInput, int n, int n2) throws IOException {
        byte[] byArray = new byte[this.size(bufferedHeader)];
        dataInput.readFully(byArray);
        if (bufferedHeader.characterSet() == n2) {
            this.getBuffer(bufferedHeader, byArray.length).put(byArray);
        } else {
            this.setValue(bufferedHeader, new String(byArray, CCSID.getCodepage(n2)));
        }
        return this.size(bufferedHeader);
    }

    public int write(BufferedHeader bufferedHeader, DataOutput dataOutput, int n, int n2) throws IOException {
        byte[] byArray;
        ByteBuffer byteBuffer;
        if (bufferedHeader.characterSet() == n2 && (byteBuffer = this.getBuffer(bufferedHeader)) != null) {
            byArray = new byte[this.defaultValue.length()];
            byteBuffer.get(byArray);
        } else {
            byArray = ((String)this.getValue(bufferedHeader)).getBytes(CCSID.getCodepage(n2));
        }
        dataOutput.write(byArray);
        return byArray.length;
    }

    public int size(BufferedHeader bufferedHeader) {
        return this.defaultValue.length();
    }

    public Object getValue(BufferedHeader bufferedHeader) {
        ByteBuffer byteBuffer = this.getBuffer(bufferedHeader);
        if (byteBuffer == null) {
            return this.defaultValue;
        }
        byte[] byArray = new byte[this.size(bufferedHeader)];
        byteBuffer.get(byArray);
        try {
            return new String(byArray, CCSID.getCodepage(bufferedHeader.characterSet()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unsupported CCSID: " + bufferedHeader.characterSet() + " (" + unsupportedEncodingException.toString() + ')');
        }
    }

    public void setValue(BufferedHeader bufferedHeader, Object object) {
        this.setStringValue(bufferedHeader, (String)object);
    }

    public void setStringValue(BufferedHeader bufferedHeader, String string) {
        try {
            if (string == null) {
                this.setBytesValue(bufferedHeader, null);
            } else {
                this.setBytesValue(bufferedHeader, string.getBytes(CCSID.getCodepage(bufferedHeader.characterSet())));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unsupported CCSID: " + bufferedHeader.characterSet() + " (" + unsupportedEncodingException.toString() + ')');
        }
    }

    public void setBytesValue(BufferedHeader bufferedHeader, byte[] byArray) {
        ByteBuffer byteBuffer = this.getBuffer(bufferedHeader, this.size(bufferedHeader));
        try {
            if (byArray == null) {
                byteBuffer.put(this.defaultValue.getBytes(CCSID.getCodepage(bufferedHeader.characterSet())));
            } else {
                int n = this.defaultValue.length() - byArray.length;
                if (n > 0) {
                    byteBuffer.put(byArray);
                    byte by = " ".getBytes(CCSID.getCodepage(bufferedHeader.characterSet()))[0];
                    while (n-- > 0) {
                        byteBuffer.put(by);
                    }
                } else {
                    byteBuffer.put(byArray, 0, this.defaultValue.length());
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unsupported CCSID: " + bufferedHeader.characterSet() + " (" + unsupportedEncodingException.toString() + ')');
        }
    }

    public int getIntValue(BufferedHeader bufferedHeader) {
        return 0;
    }

    public String toString() {
        return super.toString() + " (default: \"" + this.defaultValue + "\")";
    }
}

