/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop.impl;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;

public class ByteBufferReadableByteChannel
implements ReadableByteChannel {
    private ByteBuffer source;

    public ByteBufferReadableByteChannel(ByteBuffer byteBuffer) {
        this.source = byteBuffer;
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        if (this.source == null) {
            throw new ClosedChannelException();
        }
        try {
            int n;
            int n2 = n = Math.min(this.source.limit() - this.source.position(), byteBuffer.limit() - byteBuffer.position());
            while (n2-- > 0) {
                byteBuffer.put(this.source.get());
            }
            return n;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException(bufferUnderflowException.getMessage());
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new IOException(bufferOverflowException.getMessage());
        }
    }

    public boolean isOpen() {
        return this.source != null;
    }

    public void close() throws IOException {
        this.source = null;
    }
}

