/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.mqinterop.InvalidHeaderValueException;
import com.ibm.ws.sib.mfp.mqinterop.MQHeaderInfo;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedField;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeader;
import com.ibm.ws.sib.mfp.mqinterop.impl.ByteArrayField;
import com.ibm.ws.sib.mfp.mqinterop.impl.CharArrayField;
import com.ibm.ws.sib.mfp.mqinterop.impl.HeaderArrayField;
import com.ibm.ws.sib.mfp.mqinterop.impl.HeaderField;
import com.ibm.ws.sib.mfp.mqinterop.impl.IntArrayField;
import com.ibm.ws.sib.mfp.mqinterop.impl.IntField;
import com.ibm.ws.sib.mfp.mqinterop.impl.IntFieldFixedByteOrder;
import com.ibm.ws.sib.mfp.mqinterop.impl.IntValueTypeRule;
import com.ibm.ws.sib.mfp.mqinterop.impl.LongField;
import com.ibm.ws.sib.mfp.mqinterop.impl.LongFieldFixedByteOrder;
import com.ibm.ws.sib.mfp.mqinterop.impl.MQDataField;
import com.ibm.ws.sib.mfp.mqinterop.impl.ShortField;
import com.ibm.ws.sib.mfp.mqinterop.impl.SingleByteField;
import com.ibm.ws.sib.mfp.mqinterop.impl.StrucIdVersionTypeRule;
import com.ibm.ws.sib.mfp.mqinterop.impl.TypeRule;
import java.nio.ByteOrder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public abstract class BufferedHeaderType
implements MQHeaderInfo {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.mqinterop.CWSJQMessages");
    final String name;
    final BufferedField[] fields;
    final int minSize;
    final int fixedSize;
    final int fixedFieldCount;
    final boolean isVariableSize;
    final TypeRule typeRule;
    private Hashtable names = new Hashtable();
    private RegistrationContext registrationContext = new RegistrationContext();

    protected BufferedHeaderType(String string) {
        this.createFields();
        this.name = string;
        this.fields = this.registrationContext.getRegisteredFields();
        this.fixedSize = this.registrationContext.getFixedSize();
        this.fixedFieldCount = this.registrationContext.getFixedFieldCount();
        this.typeRule = this.registrationContext.getTypeRule();
        this.minSize = this.registrationContext.getMinSize();
        this.isVariableSize = this.fields.length != this.fixedFieldCount;
        this.registrationContext = null;
    }

    protected BufferedHeaderType(String string, BufferedHeaderType bufferedHeaderType, boolean bl) {
        this.registrationContext.setSupertype(bufferedHeaderType, bl);
        this.createFields();
        this.name = string;
        this.fields = this.registrationContext.getRegisteredFields();
        this.fixedSize = this.registrationContext.getFixedSize();
        this.fixedFieldCount = this.registrationContext.getFixedFieldCount();
        this.typeRule = this.registrationContext.getTypeRule();
        this.minSize = this.registrationContext.getMinSize();
        this.isVariableSize = this.fields.length != this.fixedFieldCount;
        Enumeration enumeration = bufferedHeaderType.names.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.names.put(k, bufferedHeaderType.names.get(k));
        }
        this.registrationContext = null;
    }

    protected int nextOffset() {
        try {
            return this.registrationContext.getNextOffset();
        }
        catch (NullPointerException nullPointerException) {
            FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeaderType.nextOffset", (String)"122", (Object)this);
            throw new RuntimeException("Fields can only be created within the createFields method.");
        }
    }

    BufferedField[] getFields() {
        return this.fields;
    }

    public int getFieldCount() {
        return this.fields.length;
    }

    int getFixedFieldCount() {
        return this.fixedFieldCount;
    }

    final boolean isVariableSize() {
        return this.isVariableSize | this.typeRule.next() != null;
    }

    BufferedField getField(int n) {
        try {
            return this.fields[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NoSuchElementException("No field for index " + n + " in type " + this.getName());
        }
    }

    int getFieldIndex(String string) {
        Integer n = (Integer)this.names.get(string);
        if (n == null) {
            throw new NoSuchElementException("No field \"" + string + "\" in type " + this.getName());
        }
        return n;
    }

    public String getName() {
        return this.name;
    }

    public Iterator getFieldInfo() {
        return new Iterator(){
            int index = 0;

            public boolean hasNext() {
                return this.index < BufferedHeaderType.this.fields.length;
            }

            public Object next() {
                return BufferedHeaderType.this.fields[this.index++];
            }

            public void remove() {
                throw new UnsupportedOperationException("Can't remove fields.");
            }
        };
    }

    public int size() {
        if (this.fields.length == 0) {
            return 0;
        }
        BufferedField bufferedField = this.fields[this.fields.length - 1];
        return bufferedField.offset + bufferedField.size(null);
    }

    public void validate(BufferedHeader bufferedHeader) throws InvalidHeaderValueException {
    }

    protected void checkEyecatcher(BufferedHeader bufferedHeader, String string, int n) throws InvalidHeaderValueException {
        String string2 = bufferedHeader.getStringValue(n);
        if (!string.equals(string2)) {
            String string3 = this.getName();
            String string4 = nls.getFormattedMessage("MQ_EYECATCHER_ERROR_CWSJQ0013", new Object[]{string3, string, string2}, "Invalid eyecatcher");
            InvalidHeaderValueException invalidHeaderValueException = new InvalidHeaderValueException(string4);
            FFDCFilter.processException((Throwable)invalidHeaderValueException, (String)"com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeaderType.checkEyecatcher", (String)"258", (Object)this);
            throw invalidHeaderValueException;
        }
    }

    protected void checkVersion(BufferedHeader bufferedHeader, int n, int n2) throws InvalidHeaderValueException {
        int n3 = bufferedHeader.getIntValue(n2);
        if (n != n3) {
            String string = this.getName();
            String string2 = nls.getFormattedMessage("MQ_VERSION_ERROR_CWSJQ0014", new Object[]{string, new Integer(n), new Integer(n3)}, "Invalid version");
            InvalidHeaderValueException invalidHeaderValueException = new InvalidHeaderValueException(string2);
            FFDCFilter.processException((Throwable)invalidHeaderValueException, (String)"com.ibm.ws.sib.mfp.mqinterop.api.impl.BufferedHeaderType.checkVersion", (String)"280", (Object)this);
            throw invalidHeaderValueException;
        }
    }

    protected void checkVersionRange(BufferedHeader bufferedHeader, int n, int n2, int n3) throws InvalidHeaderValueException {
        int n4 = bufferedHeader.getIntValue(n3);
        if (n4 < n || n4 > n2) {
            String string = this.getName();
            String string2 = nls.getFormattedMessage("MQ_VERSION_RANGE_ERROR_CWSJQ0015", new Object[]{string, new Integer(n), new Integer(n2), new Integer(n4)}, "Invalid version (range)");
            InvalidHeaderValueException invalidHeaderValueException = new InvalidHeaderValueException(string2);
            FFDCFilter.processException((Throwable)invalidHeaderValueException, (String)"com.ibm.ws.sib.mfp.mqinterop.api.impl.BufferedHeaderType.checkVersionRange", (String)"303", (Object)this);
            throw invalidHeaderValueException;
        }
    }

    protected void checkExactLength(BufferedHeader bufferedHeader, int n, int n2) throws InvalidHeaderValueException {
        int n3 = bufferedHeader.getIntValue(n2);
        if (n != n3) {
            String string = this.getName();
            String string2 = nls.getFormattedMessage("MQ_LENGTH_ERROR_CWSJQ0016", new Object[]{string, new Integer(n), new Integer(n3)}, "Invalid length (not exact match)");
            InvalidHeaderValueException invalidHeaderValueException = new InvalidHeaderValueException(string2);
            FFDCFilter.processException((Throwable)invalidHeaderValueException, (String)"com.ibm.ws.sib.mfp.mqinterop.api.impl.BufferedHeaderType.checkExactLength", (String)"325", (Object)this);
            throw invalidHeaderValueException;
        }
    }

    protected void checkMinimumLength(BufferedHeader bufferedHeader, int n, int n2) throws InvalidHeaderValueException {
        int n3 = bufferedHeader.getIntValue(n2);
        if (n3 < n) {
            String string = this.getName();
            String string2 = nls.getFormattedMessage("MQ_MIN_LEN_ERROR_CWSJQ0017", new Object[]{string, new Integer(n), new Integer(n3)}, "Invalid length (less than minimum)");
            InvalidHeaderValueException invalidHeaderValueException = new InvalidHeaderValueException(string2);
            FFDCFilter.processException((Throwable)invalidHeaderValueException, (String)"com.ibm.ws.sib.mfp.mqinterop.api.impl.BufferedHeaderType.checkMinimumLength", (String)"347", (Object)this);
            throw invalidHeaderValueException;
        }
    }

    protected void checkByteValue(BufferedHeader bufferedHeader, byte by, int n) throws InvalidHeaderValueException {
        byte by2 = bufferedHeader.getByteValue(n);
        if (by != by2) {
            String string = this.getName();
            String string2 = nls.getFormattedMessage("MQ_BYTE_VALUE_ERROR_CWSJQ0018", new Object[]{string, new Byte(by), new Byte(by2)}, "Invalid byte value");
            InvalidHeaderValueException invalidHeaderValueException = new InvalidHeaderValueException(string2);
            FFDCFilter.processException((Throwable)invalidHeaderValueException, (String)"com.ibm.ws.sib.mfp.mqinterop.api.impl.BufferedHeaderType.checkByteValue", (String)"369", (Object)this);
            throw invalidHeaderValueException;
        }
    }

    protected void checkByteRange(BufferedHeader bufferedHeader, byte by, byte by2, int n) throws InvalidHeaderValueException {
        byte by3 = bufferedHeader.getByteValue(n);
        if (by3 < by || by3 > by2) {
            String string = this.getName();
            String string2 = nls.getFormattedMessage("MQ_BYTE_RANGE_ERROR_CWSJQ0019", new Object[]{string, new Byte(by), new Byte(by2), new Byte(by3)}, "Invalid byte value (range)");
            InvalidHeaderValueException invalidHeaderValueException = new InvalidHeaderValueException(string2);
            FFDCFilter.processException((Throwable)invalidHeaderValueException, (String)"com.ibm.ws.sib.mfp.mqinterop.api.impl.BufferedHeaderType.checkByteRange", (String)"392", (Object)this);
            throw invalidHeaderValueException;
        }
    }

    protected abstract void createFields();

    protected BufferedField createMQLong(String string) {
        return this.register(new IntField(string, this.nextOffset()));
    }

    protected BufferedField createMQLong(String string, int n) {
        return this.register(new IntField(string, this.nextOffset(), n));
    }

    protected BufferedField createMQLong(String string, int n, ByteOrder byteOrder) {
        return this.register(new IntFieldFixedByteOrder(string, this.nextOffset(), n, byteOrder));
    }

    protected BufferedField createMQShort(String string) {
        return this.register(new ShortField(string, this.nextOffset()));
    }

    protected BufferedField createMQShort(String string, short s) {
        return this.register(new ShortField(string, this.nextOffset(), s));
    }

    protected BufferedField createMQLong64(String string) {
        return this.register(new LongField(string, this.nextOffset()));
    }

    protected BufferedField createMQLong64(String string, long l) {
        return this.register(new LongField(string, this.nextOffset(), l));
    }

    protected BufferedField createMQLong64(String string, long l, ByteOrder byteOrder) {
        return this.register(new LongFieldFixedByteOrder(string, this.nextOffset(), l, byteOrder));
    }

    protected BufferedField createMQByte(String string) {
        return this.register(new SingleByteField(string, this.nextOffset()));
    }

    protected BufferedField createMQByte(String string, byte by) {
        return this.register(new SingleByteField(string, this.nextOffset(), by));
    }

    protected BufferedField createMQByte(String string, int n) {
        if (n == 1) {
            return this.register(new SingleByteField(string, this.nextOffset()));
        }
        return this.register(new ByteArrayField(string, this.nextOffset(), n));
    }

    protected BufferedField createMQByte(String string, int n, int n2, int n3) {
        return this.register(new ByteArrayField(string, this.nextOffset(), -n, n2, n3));
    }

    protected BufferedField createMQChar(String string, int n) {
        return this.register(new CharArrayField(string, this.nextOffset(), n));
    }

    protected BufferedField createMQChar(String string, String string2) {
        return this.register(new CharArrayField(string, this.nextOffset(), string2));
    }

    protected BufferedField createMQHeader(String string, BufferedHeaderType bufferedHeaderType) {
        return this.register(new HeaderField(string, this.nextOffset(), bufferedHeaderType));
    }

    protected BufferedField createMQHeader(String string, BufferedHeaderType bufferedHeaderType, Class clazz) {
        return this.register(new HeaderField(string, this.nextOffset(), bufferedHeaderType, clazz));
    }

    protected BufferedField createMQHeaderArray(String string, int n, BufferedHeaderType bufferedHeaderType, Class clazz) {
        return this.register(new HeaderArrayField(string, this.nextOffset(), -n, bufferedHeaderType, clazz));
    }

    protected BufferedField createMQLongArray(String string, int n) {
        return this.register(new IntArrayField(string, this.nextOffset(), -n));
    }

    protected BufferedField createMQData(String string, Class clazz) {
        return this.register(new MQDataField(string, this.nextOffset(), clazz));
    }

    protected void addTypeRule(int n, int n2, BufferedHeaderType bufferedHeaderType) {
        this.register(new IntValueTypeRule(n, n2, bufferedHeaderType));
    }

    protected void addTypeRule(String string, int n, BufferedHeaderType bufferedHeaderType) {
        this.register(new StrucIdVersionTypeRule(string, n, bufferedHeaderType));
    }

    protected void addTypeRule(TypeRule typeRule) {
        this.register(typeRule);
    }

    protected BufferedField register(BufferedField bufferedField) {
        return this.registrationContext.register(bufferedField);
    }

    protected void register(TypeRule typeRule) {
        try {
            this.registrationContext.register(typeRule);
        }
        catch (NullPointerException nullPointerException) {
            FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeaderType.register", (String)"489", (Object)this);
            throw new RuntimeException("Type rules can only be added within the createFields method.");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName() + " (" + this.getFieldCount() + '/' + this.getFixedFieldCount() + " fields, size " + this.size() + " bytes, variable size: " + this.isVariableSize() + ", type rule: " + this.typeRule + ")");
        for (int i = 0; this.fields != null && i < this.fields.length; ++i) {
            stringBuffer.append("\n\t");
            stringBuffer.append(this.fields[i]);
        }
        return new String(stringBuffer);
    }

    class RegistrationContext {
        BufferedHeaderType supertype;
        TypeRule typeRule;
        Vector vFields;
        int nextIndex;
        int nextOffset;
        int fixedSize;
        int fixedFieldCount;
        int minSize;

        RegistrationContext() {
            this.typeRule = new TypeRule(BufferedHeaderType.this);
            this.vFields = new Vector();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setSupertype(BufferedHeaderType bufferedHeaderType, boolean bl) {
            BufferedField[] bufferedFieldArray = bufferedHeaderType.getFields();
            Vector vector = new Vector(bufferedHeaderType.getFieldCount() * 2);
            Vector vector2 = this.vFields;
            synchronized (vector2) {
                for (int i = 0; i < bufferedFieldArray.length; ++i) {
                    this.vFields.addElement(bufferedFieldArray[i]);
                }
            }
            this.nextIndex = bufferedFieldArray.length;
            this.nextOffset = bufferedHeaderType.isVariableSize ? -1 : bufferedHeaderType.fixedSize;
            this.fixedSize = bufferedHeaderType.fixedSize;
            this.fixedFieldCount = bufferedHeaderType.fixedFieldCount;
            this.minSize = bufferedHeaderType.minSize;
            this.typeRule = bufferedHeaderType.typeRule;
            if (bl) {
                this.typeRule.setDefaultType(BufferedHeaderType.this);
            }
            this.supertype = bufferedHeaderType;
        }

        int getNextOffset() {
            return this.nextOffset;
        }

        int getFixedSize() {
            return this.fixedSize;
        }

        int getFixedFieldCount() {
            return this.fixedFieldCount;
        }

        int getMinSize() {
            return this.minSize;
        }

        BufferedField register(BufferedField bufferedField) {
            this.vFields.addElement(bufferedField);
            BufferedHeaderType.this.names.put(bufferedField.getName(), new Integer(this.nextIndex++));
            if (this.nextOffset >= 0 && !bufferedField.isVariableSize()) {
                this.nextOffset += bufferedField.size(null);
                this.fixedSize = this.nextOffset;
                ++this.fixedFieldCount;
                if (this.supertype == null) {
                    this.minSize = this.fixedSize;
                }
            } else {
                this.nextOffset = -1;
                if (this.supertype == null) {
                    this.minSize += bufferedField.size(null);
                }
            }
            return bufferedField;
        }

        BufferedField[] getRegisteredFields() {
            Object[] objectArray = new BufferedField[this.vFields.size()];
            this.vFields.copyInto(objectArray);
            return objectArray;
        }

        void register(TypeRule typeRule) {
            this.typeRule.addTypeRule(typeRule);
        }

        TypeRule getTypeRule() {
            return this.typeRule;
        }
    }
}

