/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop.impl;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.mqinterop.ByteBufferDataInput;
import com.ibm.ws.sib.mfp.mqinterop.ByteBufferDataOutput;
import com.ibm.ws.sib.mfp.mqinterop.CCSID;
import com.ibm.ws.sib.mfp.mqinterop.MQBufferedHeader;
import com.ibm.ws.sib.mfp.mqinterop.MQField;
import com.ibm.ws.sib.mfp.mqinterop.MQFieldInfo;
import com.ibm.ws.sib.mfp.mqinterop.MQHeader;
import com.ibm.ws.sib.mfp.mqinterop.MQHeaderInfo;
import com.ibm.ws.sib.mfp.mqinterop.api.impl.MQPMRImpl;
import com.ibm.ws.sib.mfp.mqinterop.util.HexString;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class AbstractHeader
implements MQHeader,
MQBufferedHeader {
    final String type;
    protected final MQField[] fields;
    protected int encoding;
    protected int characterSet;
    static /* synthetic */ Class class$com$ibm$ws$sib$mfp$mqinterop$MQHeader;
    static /* synthetic */ Class class$com$ibm$ws$sib$mfp$mqinterop$api$impl$MQPMRImpl;

    protected AbstractHeader(String string) {
        this.type = string;
        this.fields = this.createFields();
    }

    protected abstract MQField[] createFields();

    protected MQField getField(int n) throws NoSuchElementException {
        try {
            return this.fields[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NoSuchElementException("No field for index " + n + " in type " + this.type);
        }
    }

    public String getType() {
        return this.type;
    }

    public int fieldCount() {
        return this.fields.length;
    }

    public Object getValue(int n) {
        return this.getField(n).getValue();
    }

    public int getIntValue(int n) {
        return ((IntegerField)this.getField(n)).getIntValue();
    }

    public short getShortValue(int n) {
        return ((Number)this.getValue(n)).shortValue();
    }

    public long getLongValue(int n) {
        return ((Number)this.getValue(n)).longValue();
    }

    public byte getByteValue(int n) {
        return ((ByteField)this.getField(n)).getByteValue();
    }

    public String getStringValue(int n) {
        return (String)this.getValue(n);
    }

    public byte[] getBytesValue(int n) {
        return (byte[])this.getValue(n);
    }

    public int[] getIntArrayValue(int n) {
        return ((IntegerArrayField)this.getField(n)).getIntArrayValue();
    }

    public MQHeader[] getHeaderArrayValue(int n) {
        return ((MQHeaderArrayField)this.getField(n)).getHeaderArrayValue();
    }

    public void setValue(int n, Object object) {
        this.getField(n).setValue(object);
    }

    public void setIntValue(int n, int n2) {
        ((IntegerField)this.getField(n)).setIntValue(n2);
    }

    public void setIntArrayValue(int n, int[] nArray) {
        ((IntegerArrayField)this.getField(n)).setValue(nArray);
    }

    public void setShortValue(int n, short s) {
        this.setValue(n, (Object)new Short(s));
    }

    public void setLongValue(int n, long l) {
        this.setValue(n, (Object)new Long(l));
    }

    public void setByteValue(int n, byte by) {
        this.setValue(n, (Object)new Byte(by));
    }

    public void setStringValue(int n, String string) {
        this.setValue(n, (Object)string);
    }

    public void setBytesValue(int n, byte[] byArray) {
        this.setValue(n, (Object)byArray);
    }

    public void setHeaderArrayValue(int n, MQHeader[] mQHeaderArray) {
        ((MQHeaderArrayField)this.getField(n)).setValue(mQHeaderArray);
    }

    public Object getValue(String string) throws NoSuchElementException {
        int n = string.indexOf(46);
        if (n >= 0) {
            return ((MQHeader)this.getValue(string.substring(0, n))).getValue(string.substring(n + 1));
        }
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].getName().equals(string)) continue;
            return this.fields[i].getValue();
        }
        throw new NoSuchElementException("No such field: '" + string + '\'');
    }

    public int getIntValue(String string) {
        return ((Number)this.getValue(string)).intValue();
    }

    public short getShortValue(String string) {
        return ((Number)this.getValue(string)).shortValue();
    }

    public long getLongValue(String string) {
        return ((Number)this.getValue(string)).longValue();
    }

    public byte getByteValue(String string) {
        return ((Number)this.getValue(string)).byteValue();
    }

    public String getStringValue(String string) {
        return (String)this.getValue(string);
    }

    public byte[] getBytesValue(String string) {
        return (byte[])this.getValue(string);
    }

    public void setValue(String string, Object object) {
        int n = string.indexOf(46);
        if (n < 0) {
            for (int i = 0; i < this.fields.length; ++i) {
                if (!this.fields[i].getName().equals(string)) continue;
                this.fields[i].setValue(object);
                return;
            }
            throw new NoSuchElementException("No such field: '" + string + '\'');
        }
        ((MQHeader)this.getValue(string.substring(0, n))).setValue(string.substring(n + 1), object);
    }

    public void setIntValue(String string, int n) {
        this.setValue(string, (Object)new Integer(n));
    }

    public void setShortValue(String string, short s) {
        this.setValue(string, (Object)new Short(s));
    }

    public void setLongValue(String string, long l) {
        this.setValue(string, (Object)new Long(l));
    }

    public void setByteValue(String string, byte by) {
        this.setValue(string, (Object)new Byte(by));
    }

    public void setStringValue(String string, String string2) {
        this.setValue(string, (Object)string2);
    }

    public void setBytesValue(String string, byte[] byArray) {
        this.setValue(string, (Object)byArray);
    }

    public Iterator fields() {
        return new Iterator(){
            int index = 0;

            public boolean hasNext() {
                return this.index < AbstractHeader.this.fields.length;
            }

            public Object next() {
                return AbstractHeader.this.fields[this.index++];
            }

            public void remove() {
                throw new UnsupportedOperationException("Cannot remove fields");
            }
        };
    }

    public MQHeaderInfo headerInfo() {
        return new AbstractHeaderInfo();
    }

    public int read(DataInput dataInput, int n, int n2) throws IOException {
        int n3 = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            n3 += this.fields[i].read(dataInput, n, n2);
        }
        this.encoding = n;
        this.characterSet = n2;
        return n3;
    }

    public int write(DataOutput dataOutput, int n, int n2) throws IOException {
        int n3 = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            n3 += this.fields[i].write(dataOutput, n, n2);
        }
        return n3;
    }

    public int size() {
        int n = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            n += this.fields[i].size();
        }
        return n;
    }

    public int read(WsByteBuffer wsByteBuffer, int n, int n2) throws IOException {
        return this.read(wsByteBuffer.getWrappedByteBuffer(), n, n2);
    }

    public int write(WsByteBuffer wsByteBuffer, int n, int n2) throws IOException {
        return this.write(wsByteBuffer.getWrappedByteBuffer(), n, n2);
    }

    public int read(ByteBuffer byteBuffer, int n, int n2) throws IOException {
        return this.read(new ByteBufferDataInput(byteBuffer), n, n2);
    }

    public int write(ByteBuffer byteBuffer, int n, int n2) throws IOException {
        return this.write(new ByteBufferDataOutput(byteBuffer), n, n2);
    }

    public int nextEncoding() {
        return this.encoding;
    }

    public int nextCharacterSet() {
        return this.characterSet;
    }

    public String nextFormat() {
        return null;
    }

    public int encoding() {
        return this.encoding;
    }

    public int characterSet() {
        return this.characterSet;
    }

    protected AbstractHeaderField createMQLong(String string) {
        return new IntegerField(string);
    }

    protected AbstractHeaderField createMQLong(String string, int n) {
        return new IntegerField(string, n);
    }

    protected AbstractHeaderField createMQLongArray(String string) {
        return new IntegerArrayField(string);
    }

    protected AbstractHeaderField createMQLongArray(String string, int n) {
        return new IntegerArrayField(string, n);
    }

    protected AbstractHeaderField createSingleByte(String string) {
        return new ByteField(string);
    }

    protected AbstractHeaderField createSingleByte(String string, byte by) {
        return new ByteField(string, by);
    }

    protected AbstractHeaderField createMQByte(String string, int n) {
        return new MQByteField(string, n);
    }

    protected AbstractHeaderField createMQChar(String string, int n) {
        return new MQCharField(string, n);
    }

    protected AbstractHeaderField createMQChar(String string, String string2) {
        return new MQCharField(string, string2);
    }

    protected AbstractHeaderField createMQHeader(String string, MQHeader mQHeader) {
        return new MQHeaderField(string, mQHeader);
    }

    protected AbstractHeaderField createMQHeaderArray(String string, Class clazz) {
        return new MQHeaderArrayField(string, clazz);
    }

    protected MQPMRArrayField createMQPMRArray(String string) {
        return new MQPMRArrayField(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName() + ' ' + this.type);
        Iterator iterator = this.fields();
        while (iterator.hasNext()) {
            stringBuffer.append("\n\t");
            stringBuffer.append(iterator.next());
        }
        return new String(stringBuffer);
    }

    protected class MQPMRArrayField
    extends MQHeaderArrayField {
        int putMsgRecFields;

        public MQPMRArrayField(String string) {
            super(string, class$com$ibm$ws$sib$mfp$mqinterop$api$impl$MQPMRImpl == null ? (class$com$ibm$ws$sib$mfp$mqinterop$api$impl$MQPMRImpl = AbstractHeader.class$("com.ibm.ws.sib.mfp.mqinterop.api.impl.MQPMRImpl")) : class$com$ibm$ws$sib$mfp$mqinterop$api$impl$MQPMRImpl);
        }

        public void setPutMsgRecFields(int n) {
            this.putMsgRecFields = n;
        }

        public int read(DataInput dataInput, int n, int n2) throws IOException {
            int n3 = 0;
            for (int i = 0; i < this.values.length; ++i) {
                MQHeader mQHeader = this.values[i];
                if (mQHeader == null) {
                    this.values[i] = mQHeader = this.newInstance();
                }
                ((MQPMRImpl)this.values[i]).putMsgRecFields(this.putMsgRecFields);
                n3 += mQHeader.read(dataInput, n, n2);
            }
            return n3;
        }

        public int write(DataOutput dataOutput, int n, int n2) throws IOException {
            int n3 = 0;
            for (int i = 0; i < this.values.length; ++i) {
                MQHeader mQHeader = this.values[i];
                if (mQHeader == null) {
                    this.values[i] = mQHeader = this.newInstance();
                }
                ((MQPMRImpl)this.values[i]).putMsgRecFields(this.putMsgRecFields);
                n3 += mQHeader.write(dataOutput, n, n2);
            }
            return n3;
        }

        public int size() {
            int n = 0;
            for (int i = 0; i < this.values.length; ++i) {
                MQHeader mQHeader = this.values[i];
                if (mQHeader == null) {
                    this.values[i] = mQHeader = this.newInstance();
                }
                ((MQPMRImpl)this.values[i]).putMsgRecFields(this.putMsgRecFields);
                n += mQHeader.size();
            }
            return n;
        }
    }

    protected class MQHeaderArrayField
    extends AbstractHeaderField {
        protected Class headerClass;
        protected MQHeader[] values;

        public MQHeaderArrayField(String string, Class clazz) {
            super(string);
            if (!(class$com$ibm$ws$sib$mfp$mqinterop$MQHeader == null ? (class$com$ibm$ws$sib$mfp$mqinterop$MQHeader = AbstractHeader.class$("com.ibm.ws.sib.mfp.mqinterop.MQHeader")) : class$com$ibm$ws$sib$mfp$mqinterop$MQHeader).isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Header class must implement MQHeader interface");
            }
            this.headerClass = clazz;
            this.values = (MQHeader[])Array.newInstance(clazz, 0);
        }

        public int getFieldType() {
            return 28;
        }

        public int read(DataInput dataInput, int n, int n2) throws IOException {
            int n3 = 0;
            for (int i = 0; i < this.values.length; ++i) {
                MQHeader mQHeader = this.values[i];
                if (mQHeader == null) {
                    this.values[i] = mQHeader = this.newInstance();
                }
                n3 += mQHeader.read(dataInput, n, n2);
            }
            return n3;
        }

        public int write(DataOutput dataOutput, int n, int n2) throws IOException {
            int n3 = 0;
            for (int i = 0; i < this.values.length; ++i) {
                MQHeader mQHeader = this.values[i];
                if (mQHeader == null) {
                    this.values[i] = mQHeader = this.newInstance();
                }
                n3 += mQHeader.write(dataOutput, n, n2);
            }
            return n3;
        }

        public int size() {
            int n = 0;
            for (int i = 0; i < this.values.length; ++i) {
                MQHeader mQHeader = this.values[i];
                if (mQHeader == null) {
                    this.values[i] = mQHeader = this.newInstance();
                }
                n += mQHeader.size();
            }
            return n;
        }

        public MQHeader[] getHeaderArrayValue() {
            return (MQHeader[])this.values.clone();
        }

        public Object getValue() {
            MQHeader[] mQHeaderArray = this.values;
            return new AbstractList(this, mQHeaderArray){
                private final /* synthetic */ MQHeader[] val$array;
                private final /* synthetic */ MQHeaderArrayField this$1;
                {
                    this.this$1 = mQHeaderArrayField;
                    this.val$array = mQHeaderArray;
                }

                public Object get(int n) {
                    return this.val$array[n];
                }

                public int size() {
                    return this.val$array.length;
                }
            };
        }

        public void setValue(Object object) {
            this.setValue(((List)object).toArray(new MQHeader[0]));
        }

        public void setValue(MQHeader[] mQHeaderArray) {
            if (mQHeaderArray.getClass().getComponentType() != this.headerClass) {
                throw new IllegalArgumentException("Value must be class " + this.headerClass.getName() + "[]");
            }
            this.values = mQHeaderArray;
        }

        public int getLength() {
            return this.values.length;
        }

        public MQHeaderArrayField setLength(int n) {
            int n2 = this.values.length;
            if (n != n2) {
                this.values = (MQHeader[])Array.newInstance(this.headerClass, n);
                System.arraycopy(this.values, 0, this.values, 0, Math.min(n, n2));
            }
            return this;
        }

        protected MQHeader newInstance() {
            try {
                return (MQHeader)this.headerClass.newInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mfp.mqinterop.impl.AbstractHeader.MQHeaderArrayField.newInstance", (String)"1320", (Object)this);
                throw new RuntimeException("Failed to instantiate header of class " + this.headerClass + " for field " + this.getName() + " in type " + AbstractHeader.this.type, exception);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName() + ' ' + this.getName() + " = {");
            MQHeader[] mQHeaderArray = this.values;
            for (int i = 0; i < mQHeaderArray.length; ++i) {
                stringBuffer.append("\n\t");
                stringBuffer.append(mQHeaderArray[i]);
            }
            stringBuffer.append('}');
            return new String(stringBuffer);
        }
    }

    protected class MQHeaderField
    extends AbstractHeaderField {
        private MQHeader header;

        public MQHeaderField(String string, MQHeader mQHeader) {
            super(string);
            this.header = mQHeader;
        }

        public int getFieldType() {
            return 12;
        }

        public MQHeaderInfo getHeaderType() {
            return this.header.headerInfo();
        }

        public int read(DataInput dataInput, int n, int n2) throws IOException {
            return this.header.read(dataInput, n, n2);
        }

        public int write(DataOutput dataOutput, int n, int n2) throws IOException {
            return this.header.write(dataOutput, n, n2);
        }

        public int size() {
            return this.header.size();
        }

        public Object getValue() {
            return this.header;
        }

        public void setValue(Object object) {
            if (object != null && this.header.getClass().isAssignableFrom(object.getClass())) {
                this.header = (MQHeader)object;
            }
        }

        public String toString() {
            return this.getClass().getName() + ' ' + this.getName() + " = {\"" + this.header + "}\"";
        }
    }

    protected class IntegerArrayField
    extends AbstractHeaderField {
        private int[] value;

        public IntegerArrayField(String string) {
            this(string, 0);
        }

        public IntegerArrayField(String string, int n) {
            super(string);
            this.value = new int[n];
        }

        public int getFieldType() {
            return 20;
        }

        public int read(DataInput dataInput, int n, int n2) throws IOException {
            if (this.isReversed(n)) {
                for (int i = 0; i < this.value.length; ++i) {
                    this.value[i] = this.reverse(dataInput.readInt());
                }
            } else {
                for (int i = 0; i < this.value.length; ++i) {
                    this.value[i] = dataInput.readInt();
                }
            }
            return this.size();
        }

        public int write(DataOutput dataOutput, int n, int n2) throws IOException {
            if (this.isReversed(n)) {
                for (int i = 0; i < this.value.length; ++i) {
                    dataOutput.writeInt(this.reverse(this.value[i]));
                }
            } else {
                for (int i = 0; i < this.value.length; ++i) {
                    dataOutput.writeInt(this.value[i]);
                }
            }
            return this.size();
        }

        public int size() {
            return this.value.length * 4;
        }

        public Object getValue() {
            return new AbstractList(this){
                final int[] array;
                private final /* synthetic */ IntegerArrayField this$1;
                {
                    this.this$1 = integerArrayField;
                    this.array = this.this$1.getIntArrayValue();
                }

                public Object get(int n) {
                    return new Integer(this.array[n]);
                }

                public int size() {
                    return IntegerArrayField.access$100(this.this$1).length;
                }
            };
        }

        public int[] getIntArrayValue() {
            return (int[])this.value.clone();
        }

        public void setValue(Object object) {
            if (object == null) {
                this.setLength(0);
            } else {
                List list = (List)object;
                this.setLength(list.size());
                Iterator iterator = list.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    this.value[n++] = (Integer)iterator.next();
                }
            }
        }

        public void setValue(int[] nArray) {
            if (nArray == null) {
                this.setLength(0);
            } else {
                this.value = nArray;
            }
        }

        public int getLength() {
            return this.value.length;
        }

        public IntegerArrayField setLength(int n) {
            int n2 = this.value.length;
            if (n != n2) {
                this.value = new int[n];
                System.arraycopy(this.value, 0, this.value, 0, Math.min(n, n2));
            }
            return this;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName() + ' ' + this.getName() + " = {");
            if (this.value.length > 0) {
                for (int i = 0; i < this.value.length; ++i) {
                    stringBuffer.append(this.value[i]);
                    stringBuffer.append(", ");
                }
                stringBuffer.setLength(stringBuffer.length() - 2);
            }
            stringBuffer.append('}');
            return new String(stringBuffer);
        }

        static /* synthetic */ int[] access$100(IntegerArrayField integerArrayField) {
            return integerArrayField.value;
        }
    }

    protected class MQCharField
    extends AbstractHeaderField {
        private char[] value;

        public MQCharField(String string, int n) {
            super(string);
            this.value = new char[n];
            Arrays.fill(this.value, ' ');
        }

        public MQCharField(String string, String string2) {
            super(string);
            this.value = string2.toCharArray();
        }

        public int getFieldType() {
            return 10;
        }

        public int read(DataInput dataInput, int n, int n2) throws IOException {
            byte[] byArray = new byte[this.size()];
            dataInput.readFully(byArray);
            this.setStringValue(new String(byArray, CCSID.getCodepage(n2)));
            return this.size();
        }

        public int write(DataOutput dataOutput, int n, int n2) throws IOException {
            dataOutput.write(new String(this.value).getBytes(CCSID.getCodepage(n2)));
            return this.size();
        }

        public int size() {
            return this.value.length;
        }

        public Object getValue() {
            return new String(this.value);
        }

        public void setValue(Object object) {
            try {
                this.setStringValue((String)object);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(classCastException.getMessage());
            }
        }

        public void setStringValue(String string) {
            Arrays.fill(this.value, ' ');
            if (string != null) {
                System.arraycopy(string.toCharArray(), 0, this.value, 0, Math.min(string.length(), this.value.length));
            }
        }

        public int getLength() {
            return this.value.length;
        }

        public MQCharField setLength(int n) {
            int n2 = this.value.length;
            if (n != n2) {
                this.value = new char[n];
                System.arraycopy(this.value, 0, this.value, 0, Math.min(n, n2));
            }
            return this;
        }

        public MQCharField setLength(int n, int n2) {
            int n3 = n2 - n % n2;
            return this.setLength(n + (n3 == n2 ? 0 : n3));
        }

        public String toString() {
            return this.getClass().getName() + ' ' + this.getName() + " = \"" + new String(this.value) + '\"';
        }
    }

    protected class MQByteField
    extends AbstractHeaderField {
        private byte[] value;

        public MQByteField(String string, int n) {
            super(string);
            this.value = new byte[n];
        }

        public int getFieldType() {
            return 11;
        }

        public int read(DataInput dataInput, int n, int n2) throws IOException {
            dataInput.readFully(this.value);
            return this.value.length;
        }

        public int write(DataOutput dataOutput, int n, int n2) throws IOException {
            dataOutput.write(this.value);
            return this.value.length;
        }

        public int size() {
            return this.value.length;
        }

        public Object getValue() {
            return this.value.clone();
        }

        public void setValue(Object object) {
            try {
                this.setBytesValue((byte[])object);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(classCastException.getMessage());
            }
        }

        public void setBytesValue(byte[] byArray) {
            Arrays.fill(this.value, (byte)0);
            if (byArray != null) {
                System.arraycopy(byArray, 0, this.value, 0, Math.min(byArray.length, this.value.length));
            }
        }

        public int getLength() {
            return this.value.length;
        }

        public MQByteField setLength(int n) {
            int n2 = this.value.length;
            if (n != n2) {
                this.value = new byte[n];
                System.arraycopy(this.value, 0, this.value, 0, Math.min(n, n2));
            }
            return this;
        }

        public MQByteField setLength(int n, int n2) {
            int n3 = n2 - n % n2;
            return this.setLength(n + (n3 == n2 ? 0 : n3));
        }

        public String toString() {
            return this.getClass().getName() + ' ' + this.getName() + " = 0x" + HexString.hexString(this.value) + " (" + this.value.length + " bytes)";
        }
    }

    protected class ByteField
    extends AbstractHeaderField {
        private byte value;

        public ByteField(String string) {
            this(string, 0);
        }

        public ByteField(String string, byte by) {
            super(string);
            this.value = by;
        }

        public int getFieldType() {
            return 1;
        }

        public int read(DataInput dataInput, int n, int n2) throws IOException {
            this.value = dataInput.readByte();
            return this.size();
        }

        public int write(DataOutput dataOutput, int n, int n2) throws IOException {
            dataOutput.writeByte(this.value);
            return this.size();
        }

        public int size() {
            return 1;
        }

        public Object getValue() {
            return new Byte(this.value);
        }

        public void setValue(Object object) {
            if (object == null) {
                this.setByteValue((byte)0);
            } else {
                this.setByteValue(((Number)object).byteValue());
            }
        }

        public byte getByteValue() {
            return this.value;
        }

        public void setByteValue(byte by) {
            this.value = by;
        }

        public String toString() {
            return this.getClass().getName() + ' ' + this.getName() + " = " + this.value + " (0x" + HexString.hexString(this.value) + ')';
        }
    }

    protected class IntegerField
    extends AbstractHeaderField {
        private int value;

        public IntegerField(String string) {
            this(string, 0);
        }

        public IntegerField(String string, int n) {
            super(string);
            this.value = n;
        }

        public int getFieldType() {
            return 4;
        }

        public int read(DataInput dataInput, int n, int n2) throws IOException {
            this.value = this.isReversed(n) ? this.reverse(dataInput.readInt()) : dataInput.readInt();
            return this.size();
        }

        public int write(DataOutput dataOutput, int n, int n2) throws IOException {
            if (this.isReversed(n)) {
                dataOutput.writeInt(this.reverse(this.value));
            } else {
                dataOutput.writeInt(this.value);
            }
            return this.size();
        }

        public int size() {
            return 4;
        }

        public Object getValue() {
            return new Integer(this.value);
        }

        public void setValue(Object object) {
            if (object == null) {
                this.setIntValue(0);
            } else {
                this.setIntValue(((Number)object).intValue());
            }
        }

        public int getIntValue() {
            return this.value;
        }

        public void setIntValue(int n) {
            this.value = n;
        }

        public String toString() {
            return this.getClass().getName() + ' ' + this.getName() + " = " + this.value + " (0x" + HexString.hexString(this.value) + ')';
        }
    }

    abstract class AbstractHeaderField
    implements MQField,
    MQFieldInfo {
        final String name;

        protected AbstractHeaderField(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public MQHeaderInfo getHeaderType() {
            return null;
        }

        final boolean isReversed(int n) {
            return (n & 0xF) == 2;
        }

        final short reverse(short s) {
            return (short)(s << 8 & 0xFF00 | s >> 8 & 0xFF);
        }

        final int reverse(int n) {
            return n >> 24 & 0xFF | n >> 8 & 0xFF00 | n << 8 & 0xFF0000 | n << 24 & 0xFF000000;
        }

        final long reverse(long l) {
            return l >> 56 & 0xFFL | l >> 40 & 0xFF00L | l >> 24 & 0xFF0000L | l >> 8 & 0xFF000000L | l << 8 & 0xFF00000000L | l << 24 & 0xFF0000000000L | l << 40 & 0xFF000000000000L | l << 56 & 0xFF00000000000000L;
        }
    }

    class AbstractHeaderInfo
    implements MQHeaderInfo {
        AbstractHeaderInfo() {
        }

        public String getName() {
            return AbstractHeader.this.getType();
        }

        public Iterator getFieldInfo() {
            return new Iterator(this){
                int index;
                private final /* synthetic */ AbstractHeaderInfo this$1;
                {
                    this.this$1 = abstractHeaderInfo;
                    this.index = 0;
                }

                public boolean hasNext() {
                    return this.index < AbstractHeaderInfo.access$000((AbstractHeaderInfo)this.this$1).fields.length;
                }

                public Object next() {
                    return AbstractHeaderInfo.access$000((AbstractHeaderInfo)this.this$1).fields[this.index++];
                }

                public void remove() {
                    throw new UnsupportedOperationException("Can't remove fields.");
                }
            };
        }

        public int getFieldCount() {
            return AbstractHeader.this.fields.length;
        }

        static /* synthetic */ AbstractHeader access$000(AbstractHeaderInfo abstractHeaderInfo) {
            return abstractHeaderInfo.AbstractHeader.this;
        }
    }
}

