/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop.fap.impl;

import com.ibm.ws.sib.mfp.mqinterop.InvalidHeaderValueException;
import com.ibm.ws.sib.mfp.mqinterop.fap.UseridData;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeader;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeaderType;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.DataInput;
import java.io.IOException;

public class UseridDataImpl
extends BufferedHeader
implements UseridData {
    public static final BufferedHeaderType type4 = new BufferedHeaderType("UseridData (FAP level 1-4)"){

        public void createFields() {
            this.createMQChar(UseridData.ID.name, "UID ");
            this.createMQChar(UseridData.UserIdentifier.name, 12);
            this.createMQChar(UseridData.Password.name, 12);
        }

        public void validate(BufferedHeader bufferedHeader) throws InvalidHeaderValueException {
            this.checkEyecatcher(bufferedHeader, "UID ", UseridData.ID.index);
        }
    };
    public static final BufferedHeaderType type5 = new BufferedHeaderType("UseridData (FAP level 5)", type4, true){

        public void createFields() {
            this.createMQChar(UseridData.LongUserid.name, 64);
            this.createMQByte(UseridData.UserSecurity.name, 40);
        }

        public void validate(BufferedHeader bufferedHeader) throws InvalidHeaderValueException {
            this.checkEyecatcher(bufferedHeader, "UID ", UseridData.ID.index);
        }
    };
    int fapLevel;

    public UseridDataImpl() {
        this(5);
    }

    public UseridDataImpl(int n) {
        super(n >= 5 ? type5 : type4);
        this.fapLevel = n;
    }

    public UseridDataImpl(int n, DataInput dataInput, int n2, int n3) throws IOException {
        this(n);
        this.read(dataInput, n2, n3);
    }

    public UseridDataImpl(int n, WsByteBuffer wsByteBuffer, int n2, int n3) throws IOException {
        this(n);
        this.read(wsByteBuffer, n2, n3);
    }

    public int getFapLevel() {
        return this.fapLevel;
    }

    public void setFapLevel(int n) {
        this.fapLevel = n;
        this.setType(n <= 4 ? type4 : type5);
    }

    public String getID() {
        return this.getStringValue(UseridDataImpl.ID.index);
    }

    public String getUserIdentifier() {
        return this.getStringValue(UseridDataImpl.UserIdentifier.index);
    }

    public void setUserIdentifier(String string) {
        this.setStringValue(UseridDataImpl.UserIdentifier.index, string);
    }

    public String getPassword() {
        return this.getStringValue(UseridDataImpl.Password.index);
    }

    public void setPassword(String string) {
        this.setStringValue(UseridDataImpl.Password.index, string);
    }

    public String getLongUserid() {
        return this.getStringValue(UseridDataImpl.LongUserid.index);
    }

    public void setLongUserid(String string) {
        this.setStringValue(UseridDataImpl.LongUserid.index, string);
    }

    public byte[] getUserSecurity() {
        return this.getBytesValue(UseridDataImpl.UserSecurity.index);
    }

    public void setUserSecurity(byte[] byArray) {
        this.setBytesValue(UseridDataImpl.UserSecurity.index, byArray);
    }
}

