/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop.fap.impl;

import com.ibm.ws.sib.mfp.mqinterop.InvalidHeaderValueException;
import com.ibm.ws.sib.mfp.mqinterop.fap.TSH;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeader;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeaderType;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteOrder;

public class TSHImpl
extends BufferedHeader
implements TSH {
    public static final BufferedHeaderType type = new BufferedHeaderType("TSH"){

        protected void createFields() {
            this.createMQChar(TSH.ID.name, "TSH ");
            this.createMQLong(TSH.TransLength.name, 0, ByteOrder.BIG_ENDIAN);
            this.createMQByte(TSH.Encoding.name);
            this.createMQByte(TSH.SegmentType.name);
            this.createMQByte(TSH.ControlFlags1.name);
            this.createMQByte(TSH.ControlFlags2.name);
            this.createMQLong64(TSH.LUWID.name, 0L, ByteOrder.BIG_ENDIAN);
            this.createMQLong(TSH.MQEncoding.name);
            this.createMQShort(TSH.CCSID.name);
            this.createMQShort(TSH.Reserved.name);
        }

        public void validate(BufferedHeader bufferedHeader) throws InvalidHeaderValueException {
            if (bufferedHeader.characterSet() != 0) {
                this.checkEyecatcher(bufferedHeader, "TSH ", TSH.ID.index);
            }
        }
    };

    public TSHImpl() {
        super(type);
    }

    public TSHImpl(DataInput dataInput) throws IOException {
        super(type, dataInput, 0, 0);
    }

    public TSHImpl(WsByteBuffer wsByteBuffer) throws IOException {
        super(type, wsByteBuffer, 0, 0);
    }

    public TSHImpl(int n, byte by, byte by2, byte by3) {
        this();
        this.setTransLength(n);
        this.setEncoding(by);
        this.setSegmentType(by2);
        this.setControlFlags1(by3);
    }

    public int read(DataInput dataInput, int n, int n2) throws IOException {
        int n3 = super.read(dataInput, n, n2);
        this.encoding(this.getEncoding());
        this.characterSet(this.getCCSID());
        return n3;
    }

    public int read(WsByteBuffer wsByteBuffer, int n, int n2) throws IOException {
        int n3 = super.read(wsByteBuffer, n, n2);
        this.encoding(this.getEncoding());
        this.characterSet(this.getCCSID());
        return n3;
    }

    public int nextEncoding() {
        return this.getEncoding() & 0xF;
    }

    public int nextCharacterSet() {
        return this.getCCSID() & 0xFFFF;
    }

    public String getID() {
        return this.getStringValue(TSHImpl.ID.index);
    }

    public int getTransLength() {
        return this.getIntValue(TSHImpl.TransLength.index);
    }

    public void setTransLength(int n) {
        this.setIntValue(TSHImpl.TransLength.index, n);
    }

    public byte getEncoding() {
        return this.getByteValue(TSHImpl.Encoding.index);
    }

    public void setEncoding(byte by) {
        this.setByteValue(TSHImpl.Encoding.index, by);
    }

    public byte getSegmentType() {
        return this.getByteValue(TSHImpl.SegmentType.index);
    }

    public void setSegmentType(byte by) {
        this.setByteValue(TSHImpl.SegmentType.index, by);
    }

    public byte getControlFlags1() {
        return this.getByteValue(TSHImpl.ControlFlags1.index);
    }

    public void setControlFlags1(byte by) {
        this.setByteValue(TSHImpl.ControlFlags1.index, by);
    }

    public long getLUWID() {
        return this.getLongValue(TSHImpl.LUWID.index);
    }

    public void setLUWID(long l) {
        this.setLongValue(TSHImpl.LUWID.index, l);
    }

    public int getMQEncoding() {
        return this.getIntValue(TSHImpl.MQEncoding.index);
    }

    public void setMQEncoding(int n) {
        this.setIntValue(TSHImpl.MQEncoding.index, n);
    }

    public short getCCSID() {
        return this.getShortValue(TSHImpl.CCSID.index);
    }

    public void setCCSID(short s) {
        this.setShortValue(TSHImpl.CCSID.index, s);
    }
}

