/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop.api.impl;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.mqinterop.api.Dt;
import com.ibm.ws.sib.mfp.mqinterop.api.MQRFH2;
import com.ibm.ws.sib.mfp.mqinterop.api.impl.MQRFH2FolderParser;
import com.ibm.ws.sib.mfp.mqinterop.api.impl.MQRFH2Impl;
import com.ibm.ws.sib.mfp.mqinterop.api.impl.RFH2Attribute;
import com.ibm.ws.sib.mfp.mqinterop.util.HexString;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MQRFH2ElementImpl
implements MQRFH2.Element {
    final StringBuffer chars = new StringBuffer();
    final Vector children = new Vector();
    final MQRFH2Impl rfh;
    private String name;
    private RFH2Attribute[] attrs = new RFH2Attribute[0];
    private RFH2Attribute dtAttr;
    private RFH2Attribute nilAttr;
    private RFH2Attribute nameAttr;
    private MQRFH2ElementImpl currentElement;

    private MQRFH2ElementImpl(MQRFH2Impl mQRFH2Impl) {
        this.rfh = mQRFH2Impl;
    }

    MQRFH2ElementImpl(MQRFH2Impl mQRFH2Impl, String string) throws IOException {
        this.rfh = mQRFH2Impl;
        try {
            MQRFH2FolderParser mQRFH2FolderParser = mQRFH2Impl != null ? mQRFH2Impl.getFolderParser() : new MQRFH2FolderParser();
            mQRFH2FolderParser.parseFolder(this, string);
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            FFDCFilter.processException((Throwable)parserConfigurationException, (String)"com.ibm.ws.sib.mfp.mqinterop.api.impl.MQRFH2ElementImpl.MQRFH2ElementImpl", (String)"130", (Object)this);
            throw new IOException(parserConfigurationException.getMessage());
        }
    }

    public MQRFH2ElementImpl(MQRFH2Impl mQRFH2Impl, InputStream inputStream) throws IOException {
        this.rfh = mQRFH2Impl;
        try {
            MQRFH2FolderParser mQRFH2FolderParser = mQRFH2Impl != null ? mQRFH2Impl.getFolderParser() : new MQRFH2FolderParser();
            mQRFH2FolderParser.parseFolder(this, inputStream);
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            FFDCFilter.processException((Throwable)parserConfigurationException, (String)"com.ibm.ws.sib.mfp.mqinterop.api.impl.MQRFH2ElementImpl.MQRFH2ElementImpl", (String)"170", (Object)this);
            throw new IOException(parserConfigurationException.getMessage());
        }
    }

    public MQRFH2ElementImpl(MQRFH2Impl mQRFH2Impl, Reader reader) throws IOException {
        this.rfh = mQRFH2Impl;
        try {
            MQRFH2FolderParser mQRFH2FolderParser = mQRFH2Impl != null ? mQRFH2Impl.getFolderParser() : new MQRFH2FolderParser();
            mQRFH2FolderParser.parseFolder(this, reader);
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            FFDCFilter.processException((Throwable)parserConfigurationException, (String)"com.ibm.ws.sib.mfp.mqinterop.api.impl.MQRFH2ElementImpl.MQRFH2ElementImpl", (String)"210", (Object)this);
            throw new IOException(parserConfigurationException.getMessage());
        }
    }

    public MQRFH2ElementImpl(MQRFH2Impl mQRFH2Impl, String string, Object object) {
        this(mQRFH2Impl, string, object, false);
    }

    public MQRFH2ElementImpl(MQRFH2Impl mQRFH2Impl, String string, Object object, boolean bl) {
        this.rfh = mQRFH2Impl;
        this.name = string;
        this.setValue(object, bl);
    }

    void start(String string, Attributes attributes) {
        if (this.name == null) {
            int n;
            this.name = string;
            this.attrs = new RFH2Attribute[attributes.getLength()];
            for (n = 0; n < this.attrs.length; ++n) {
                this.attrs[n] = new RFH2Attribute(attributes.getQName(n), attributes.getValue(n));
            }
            n = attributes.getIndex("dt");
            if (n >= 0) {
                this.dtAttr = this.attrs[n];
                this.attrs[n] = null;
            }
            if ((n = attributes.getIndex("xsi:nil")) >= 0) {
                this.nilAttr = this.attrs[n];
                this.attrs[n] = null;
            }
            if ((n = attributes.getIndex("name")) >= 0) {
                this.nameAttr = this.attrs[n];
                this.attrs[n] = null;
            }
        } else if (this.currentElement == null) {
            this.currentElement = new MQRFH2ElementImpl(this.rfh);
            this.children.add(this.currentElement);
            this.currentElement.start(string, attributes);
        } else {
            this.currentElement.start(string, attributes);
        }
    }

    void characters(char[] cArray, int n, int n2) {
        if (this.currentElement == null) {
            this.chars.append(cArray, n, n2);
        } else {
            this.currentElement.characters(cArray, n, n2);
        }
    }

    boolean end(String string) {
        if (this.currentElement == null) {
            this.handleUnicodeEscapes();
            return string.equals(this.name);
        }
        if (string.equals(this.currentElement.name)) {
            this.currentElement = null;
            return true;
        }
        return this.currentElement.end(string);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasNameAttr() {
        return this.nameAttr != null;
    }

    public String getNameAttr() {
        if (this.hasNameAttr()) {
            return this.nameAttr.getValue();
        }
        return null;
    }

    public Object getValue() {
        if (this.isNil() || this.chars.length() == 0) {
            return null;
        }
        switch (this.getType()) {
            case 1: {
                return new Byte(this.getByteValue());
            }
            case 2: {
                return new Short(this.getShortValue());
            }
            case 3: {
                return new Character(this.getCharValue());
            }
            case 4: {
                return new Integer(this.getIntValue());
            }
            case 8: {
                return new Long(this.getLongValue());
            }
            case 9: {
                return new Float(this.getFloatValue());
            }
            case 10: {
                return new Double(this.getDoubleValue());
            }
            case 11: {
                return this.getBytesValue();
            }
            case 12: {
                return new Boolean(this.getBooleanValue());
            }
        }
        return new String(this.chars);
    }

    public boolean getBooleanValue() {
        try {
            return this.getIntValue() != 0;
        }
        catch (NumberFormatException numberFormatException) {
            return this.getStringValue().equalsIgnoreCase("true");
        }
    }

    public void setBooleanValue(boolean bl, boolean bl2) {
        this.setValue(bl ? "1" : "0", Dt.DtBOOLEAN, bl2);
    }

    public byte getByteValue() {
        return Byte.parseByte(new String(this.chars));
    }

    public void setByteValue(byte by, boolean bl) {
        this.setValue(Byte.toString(by), Dt.DtBYTE, bl);
    }

    public short getShortValue() {
        return Short.parseShort(new String(this.chars));
    }

    public void setShortValue(short s, boolean bl) {
        this.setValue(Short.toString(s), Dt.DtSHORT, bl);
    }

    public char getCharValue() {
        return this.chars.charAt(0);
    }

    public void setCharValue(char c, boolean bl) {
        this.setValue(Character.toString(c), Dt.DtCHAR, bl);
    }

    public int getIntValue() {
        return Integer.parseInt(new String(this.chars));
    }

    public void setIntValue(int n, boolean bl) {
        this.setValue(Integer.toString(n), Dt.DtINT, bl);
    }

    public long getLongValue() {
        return Long.parseLong(new String(this.chars));
    }

    public void setLongValue(long l, boolean bl) {
        this.setValue(Long.toString(l), Dt.DtLONG, bl);
    }

    public float getFloatValue() {
        return Float.parseFloat(new String(this.chars));
    }

    public void setFloatValue(float f, boolean bl) {
        this.setValue(Float.toString(f), Dt.DtFLOAT, bl);
    }

    public double getDoubleValue() {
        return Double.parseDouble(new String(this.chars));
    }

    public void setDoubleValue(double d, boolean bl) {
        this.setValue(Double.toString(d), Dt.DtDOUBLE, bl);
    }

    public byte[] getBytesValue() {
        return HexString.parseHex(new String(this.chars));
    }

    public void setBytesValue(byte[] byArray, boolean bl) {
        this.setValue(HexString.hexString(byArray), Dt.DtBINHEX, bl);
    }

    public String getStringValue() {
        return new String(this.chars);
    }

    public void setStringValue(String string, boolean bl) {
        this.setValue(string, Dt.DtSTRING, bl);
    }

    public void setValue(Object object, boolean bl) {
        if (object == null) {
            this.setValue(null, Dt.DtUNKNOWN, bl);
        } else if (object instanceof byte[]) {
            this.setValue(HexString.hexString((byte[])object), Dt.DtBINHEX, bl);
        } else if (object instanceof Boolean) {
            boolean bl2 = (Boolean)object;
            this.setValue(bl2 ? "1" : "0", Dt.DtBOOLEAN, bl);
        } else {
            this.setValue(object.toString(), Dt.getDtEntry(object.getClass()), bl);
        }
    }

    private void setValue(String string, Dt dt, boolean bl) {
        this.chars.setLength(0);
        if (string == null) {
            this.dtAttr = null;
            this.nilAttr = bl ? new RFH2Attribute("xsi:nil", "true") : null;
        } else {
            this.dtAttr = bl && dt != null && dt != Dt.DtUNKNOWN ? new RFH2Attribute("dt", dt.name) : null;
            this.nilAttr = null;
            this.chars.append(string);
        }
        this.setChanged();
    }

    public int getType() {
        int n = -1;
        if (this.dtAttr != null) {
            n = Dt.getTypeCode(this.dtAttr.getValue());
        }
        return n;
    }

    public boolean isNil() {
        boolean bl = false;
        if (this.nilAttr != null) {
            bl = this.nilAttr.getValue().equals("true");
        }
        return bl;
    }

    public MQRFH2.Element[] getChildren() {
        Object[] objectArray = new MQRFH2.Element[this.children.size()];
        this.children.copyInto(objectArray);
        return objectArray;
    }

    public List getChildren(String string) {
        ArrayList<MQRFH2.Element> arrayList = new ArrayList<MQRFH2.Element>();
        MQRFH2.Element[] elementArray = this.getChildren();
        for (int i = 0; i < elementArray.length && string != null; ++i) {
            if (!string.equals(elementArray[i].getName())) continue;
            arrayList.add(elementArray[i]);
        }
        return arrayList;
    }

    public MQRFH2.Element getChild(String string) {
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            MQRFH2.Element element = (MQRFH2.Element)iterator.next();
            if (!element.getName().equals(string)) continue;
            return element;
        }
        return null;
    }

    public Object getValue(String string) {
        MQRFH2.Element element = this.getChild(string);
        return element == null ? null : element.getValue();
    }

    public void setValue(String string, Object object) {
        this.setValue(string, object, false);
    }

    public void setValue(String string, Object object, boolean bl) {
        MQRFH2.Element element = this.getChild(string);
        if (element == null) {
            if (object != null) {
                element = new MQRFH2ElementImpl(this.rfh, string, object, bl);
                this.children.addElement(element);
                this.setChanged();
            }
        } else if (object == null) {
            this.children.remove(element);
            this.setChanged();
        } else {
            element.setValue(object, bl);
        }
    }

    public MQRFH2.Element addElement(String string) {
        return this.addElement(string, null);
    }

    public MQRFH2.Element addElement(String string, Object object) {
        return this.addElement(string, object, false);
    }

    public MQRFH2.Element addElement(String string, Object object, boolean bl) {
        MQRFH2ElementImpl mQRFH2ElementImpl = new MQRFH2ElementImpl(this.rfh, string, object, bl);
        this.children.addElement(mQRFH2ElementImpl);
        this.setChanged();
        return mQRFH2ElementImpl;
    }

    public void removeAllElements() {
        this.children.clear();
        this.setChanged();
    }

    public MQRFH2.Element getElement(String string, boolean bl) {
        MQRFH2.Element element = this.getChild(string);
        if (element == null && bl) {
            element = new MQRFH2ElementImpl(this.rfh);
            this.children.add(element);
            ((MQRFH2ElementImpl)element).name = string;
            this.setChanged();
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContent() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.chars);
        Vector vector = this.children;
        synchronized (vector) {
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(((MQRFH2ElementImpl)this.children.elementAt(i)).toXML());
            }
        }
        return new String(stringBuffer);
    }

    private void setChanged() {
        if (this.rfh != null) {
            this.rfh.setChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXML() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('<');
        stringBuffer.append(this.name);
        for (n2 = 0; n2 < this.attrs.length; ++n2) {
            if (this.attrs[n2] == null) continue;
            stringBuffer.append(' ');
            stringBuffer.append(this.attrs[n2].toXML());
        }
        if (this.dtAttr != null) {
            stringBuffer.append(' ');
            stringBuffer.append(this.dtAttr.toXML());
        }
        if (this.nilAttr != null) {
            stringBuffer.append(' ');
            stringBuffer.append(this.nilAttr.toXML());
        }
        stringBuffer.append('>');
        n2 = this.chars.length();
        block9: for (int i = 0; i < n2; ++i) {
            n = this.chars.charAt(i);
            switch (n) {
                case 60: {
                    stringBuffer.append("&lt;");
                    continue block9;
                }
                case 62: {
                    stringBuffer.append("&gt;");
                    continue block9;
                }
                case 38: {
                    stringBuffer.append("&amp;");
                    continue block9;
                }
                default: {
                    stringBuffer.append((char)n);
                }
            }
        }
        Vector vector = this.children;
        synchronized (vector) {
            n = this.children.size();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(((MQRFH2ElementImpl)this.children.elementAt(i)).toXML());
            }
        }
        stringBuffer.append("</");
        stringBuffer.append(this.name);
        stringBuffer.append('>');
        return new String(stringBuffer);
    }

    private void handleUnicodeEscapes() {
        for (int i = 0; i < this.chars.length(); ++i) {
            int n;
            int n2;
            int n3;
            int n4;
            if (this.chars.charAt(i) != '\\' || this.chars.length() - i <= 4 || this.chars.charAt(i + 1) != 'u' || ((n4 = Character.digit(this.chars.charAt(i + 2), 16)) | (n3 = Character.digit(this.chars.charAt(i + 3), 16)) | (n2 = Character.digit(this.chars.charAt(i + 4), 16)) | (n = Character.digit(this.chars.charAt(i + 5), 16))) == -1) continue;
            this.chars.setCharAt(i, (char)(n4 << 12 | n3 << 8 | n2 << 4 | n));
            this.chars.delete(i + 1, i + 6);
        }
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.toXML();
    }
}

