/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop.api.impl;

import com.ibm.ws.sib.mfp.mqinterop.ByteBufferDataOutput;
import com.ibm.ws.sib.mfp.mqinterop.CMQC;
import com.ibm.ws.sib.mfp.mqinterop.InvalidHeaderValueException;
import com.ibm.ws.sib.mfp.mqinterop.api.MQMD;
import com.ibm.ws.sib.mfp.mqinterop.api.MQMD1;
import com.ibm.ws.sib.mfp.mqinterop.api.MQMDE;
import com.ibm.ws.sib.mfp.mqinterop.api.impl.MQMD1Impl;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeader;
import com.ibm.ws.sib.mfp.mqinterop.impl.BufferedHeaderType;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MQMDImpl
extends MQMD1Impl
implements MQMD {
    public static final BufferedHeaderType type1 = MQMD1Impl.type;
    public static final BufferedHeaderType type2 = new BufferedHeaderType("MQMD version 2", type1, true){

        protected void createFields() {
            this.createMQByte(MQMD.GroupId.name, CMQC.MQGI_NONE_ARRAY.length);
            this.createMQLong(MQMD.MsgSeqNumber.name);
            this.createMQLong(MQMD.Offset.name);
            this.createMQLong(MQMD.MsgFlags.name);
            this.createMQLong(MQMD.OriginalLength.name);
            this.addTypeRule(MQMD1.Version.index, 1, type1);
            this.addTypeRule(MQMD1.Version.index, 2, (BufferedHeaderType)this);
        }

        public void validate(BufferedHeader bufferedHeader) throws InvalidHeaderValueException {
            this.checkEyecatcher(bufferedHeader, "MD  ", MQMD1.StrucId.index);
            this.checkVersion(bufferedHeader, 2, MQMD1.Version.index);
        }
    };

    public MQMDImpl() {
        super(type2);
    }

    public MQMDImpl(int n) {
        this();
        if (n != 2) {
            this.setVersion(n);
        }
    }

    public MQMDImpl(DataInput dataInput, int n, int n2) throws IOException {
        this();
        this.read(dataInput, n, n2);
    }

    public MQMDImpl(WsByteBuffer wsByteBuffer, int n, int n2) throws IOException {
        this();
        this.read(wsByteBuffer, n, n2);
    }

    public MQMDImpl(MQMD1Impl mQMD1Impl) throws IOException {
        super(type1);
        ByteBuffer byteBuffer = ByteBuffer.allocate(mQMD1Impl.size());
        mQMD1Impl.write(new ByteBufferDataOutput(byteBuffer), mQMD1Impl.encoding(), mQMD1Impl.characterSet());
        byteBuffer.flip();
        this.read(byteBuffer, mQMD1Impl.encoding(), mQMD1Impl.characterSet());
    }

    public MQMD coalesce(MQMDE mQMDE, boolean bl) {
        if (this.hasExtensionContent() || mQMDE.hasExtensionContent()) {
            this.setVersion(2);
            this.setGroupId(mQMDE.getGroupId());
            this.setMsgSeqNumber(mQMDE.getMsgSeqNumber());
            this.setOffset(mQMDE.getOffset());
            this.setMsgFlags(mQMDE.getMsgFlags());
            this.setOriginalLength(mQMDE.getOriginalLength());
        }
        if (bl) {
            this.setFormat(mQMDE.nextFormat());
            this.setEncoding(mQMDE.nextEncoding());
            this.setCodedCharSetId(mQMDE.nextCharacterSet());
        }
        return this;
    }

    public boolean hasExtensionContent() {
        boolean bl = false;
        if (this.getVersion() >= 2) {
            byte[] byArray = this.getGroupId();
            for (int i = 0; !bl && i < byArray.length; ++i) {
                bl = byArray[i] != 0;
            }
            if (!bl) {
                bl = this.getMsgSeqNumber() != 0 || this.getOffset() != 0 || this.getMsgFlags() != 0 || this.getOriginalLength() != 0;
            }
        }
        return bl;
    }

    public void setVersion(int n) {
        this.setIntValue(MQMDImpl.Version.index, n);
    }

    public byte[] getGroupId() {
        return this.getBytesValue(MQMDImpl.GroupId.index);
    }

    public void setGroupId(byte[] byArray) {
        this.setBytesValue(MQMDImpl.GroupId.index, byArray);
    }

    public int getMsgSeqNumber() {
        return this.getIntValue(MQMDImpl.MsgSeqNumber.index);
    }

    public void setMsgSeqNumber(int n) {
        this.setIntValue(MQMDImpl.MsgSeqNumber.index, n);
    }

    public int getOffset() {
        return this.getIntValue(MQMDImpl.Offset.index);
    }

    public void setOffset(int n) {
        this.setIntValue(MQMDImpl.Offset.index, n);
    }

    public int getMsgFlags() {
        return this.getIntValue(MQMDImpl.MsgFlags.index);
    }

    public void setMsgFlags(int n) {
        this.setIntValue(MQMDImpl.MsgFlags.index, n);
    }

    public int getOriginalLength() {
        return this.getIntValue(MQMDImpl.OriginalLength.index);
    }

    public void setOriginalLength(int n) {
        this.setIntValue(MQMDImpl.OriginalLength.index, n);
    }
}

