/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class CCSID {
    private static final String CCSIDS_FILE = "com/ibm/ws/sib/mfp/mqinterop/CCSID.properties";
    private static final String CP_PREFIX = "Cp";
    private static final String IBM_PREFIX = "IBM-";
    private static final Properties ccsids = new Properties();
    private static final HashMap codepages = new HashMap(64);
    private static Set newCodepages = Collections.synchronizedSet(new HashSet());
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.mqinterop.CWSJQMessages");
    private static String fastCodepage;
    private static String fastCodepage2;
    private static int fastCCSID;
    private static int fastCCSID2;

    public static synchronized String getFastCP(int n) {
        if (fastCCSID == n) {
            return fastCodepage;
        }
        if (fastCCSID2 == n) {
            return fastCodepage2;
        }
        return null;
    }

    public static synchronized void setFastCP(int n, String string) {
        fastCCSID = fastCCSID2;
        fastCodepage = fastCodepage2;
        fastCCSID2 = n;
        fastCodepage2 = string;
    }

    public static String getCodepage(int n) throws UnsupportedEncodingException {
        int n2 = n;
        String string = CCSID.getFastCP(n2);
        if (string != null) {
            return string;
        }
        if (n > 65535 || n < 0) {
            n = CCSID.reverse(n);
        }
        if ((string = (String)codepages.get(new Integer(n))) == null) {
            string = CP_PREFIX + Integer.toString(n);
            try {
                if (!newCodepages.contains(string)) {
                    Charset.forName(string);
                    newCodepages.add(string);
                }
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                FFDCFilter.processException((Throwable)unsupportedCharsetException, (String)"com.ibm.ws.sib.mfp.mqinterop.CCSID.getCodepage", (String)"199");
                String string2 = nls.getFormattedMessage("UNSUPPORTED_CCSID_CWSJQ0007", new Object[]{new Integer(n)}, "Unsupported CCSID: " + n);
                throw new UnsupportedEncodingException(string2);
            }
        }
        CCSID.setFastCP(n2, string);
        return string;
    }

    public static Charset getCharset(int n) throws UnsupportedEncodingException {
        return Charset.forName(CCSID.getCodepage(n));
    }

    public static int getCCSID(String string) throws UnsupportedEncodingException {
        int n = 0;
        String string2 = ccsids.getProperty(string);
        if (string2 != null) {
            try {
                n = new Integer(string2);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.sib.mfp.mqinterop.CCSID.getCCSID", (String)"242");
                String string3 = nls.getFormattedMessage("UNKNOWN_CODEPAGE_CWSJQ0101", new Object[]{string}, "Unknown Codepage: " + string);
                throw new UnsupportedEncodingException(string3);
            }
        } else if (string.startsWith(CP_PREFIX)) {
            try {
                n = new Integer(string.substring(CP_PREFIX.length()));
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.sib.mfp.mqinterop.CCSID.getCCSID", (String)"257");
                String string4 = nls.getFormattedMessage("UNKNOWN_CODEPAGE_CWSJQ0101", new Object[]{string}, "Unknown Codepage: " + string);
                throw new UnsupportedEncodingException(string4);
            }
        } else if (string.startsWith(IBM_PREFIX)) {
            try {
                n = new Integer(string.substring(IBM_PREFIX.length()));
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.sib.mfp.mqinterop.CCSID.getCCSID", (String)"272");
                String string5 = nls.getFormattedMessage("UNKNOWN_CODEPAGE_CWSJQ0101", new Object[]{string}, "Unknown Codepage: " + string);
                throw new UnsupportedEncodingException(string5);
            }
        } else {
            String string6 = nls.getFormattedMessage("UNKNOWN_CODEPAGE_CWSJQ0101", new Object[]{string}, "Unknown Codepage: " + string);
            UnsupportedEncodingException unsupportedEncodingException = new UnsupportedEncodingException(string6);
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.sib.mfp.mqinterop.CCSID.getCCSID", (String)"286");
            throw unsupportedEncodingException;
        }
        return n;
    }

    public static String convert(byte[] byArray, int n) throws UnsupportedEncodingException {
        return new String(byArray, CCSID.getCodepage(n));
    }

    public static String convert(byte[] byArray, int n, int n2, int n3) throws UnsupportedEncodingException {
        return new String(byArray, n, n2, CCSID.getCodepage(n3));
    }

    public static byte[] convert(String string, int n) throws UnsupportedEncodingException {
        return string.getBytes(CCSID.getCodepage(n));
    }

    private static int reverse(int n) {
        return n >> 24 & 0xFF | n >> 8 & 0xFF00 | n << 8 & 0xFF0000 | n << 24 & 0xFF000000;
    }

    static {
        InputStream inputStream = CCSID.class.getClassLoader().getResourceAsStream(CCSIDS_FILE);
        try {
            ccsids.load(inputStream);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.mfp.mqinterop.CCSID.<clinit>", (String)"102");
        }
        Enumeration<?> enumeration = ccsids.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = ccsids.getProperty(string);
            try {
                Charset.forName(string);
                codepages.put(new Integer(string2), string);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.sib.mfp.mqinterop.CCSID.<clinit>", (String)"119");
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {}
        }
        codepages.put(new Integer(0), System.getProperty("file.encoding"));
    }
}

