/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop;

import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public class ByteBufferDataOutput
implements DataOutput {
    final ByteBuffer byteBuffer;

    public ByteBufferDataOutput(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public ByteBufferDataOutput(ByteBuffer byteBuffer, int n) {
        this(byteBuffer);
        this.byteBuffer.position(n);
    }

    public ByteBufferDataOutput(WsByteBuffer wsByteBuffer) {
        this(wsByteBuffer.getWrappedByteBuffer());
    }

    public ByteBufferDataOutput(WsByteBuffer wsByteBuffer, int n) {
        this(wsByteBuffer.getWrappedByteBuffer(), n);
    }

    public void write(byte[] byArray) throws IOException {
        try {
            this.byteBuffer.put(byArray);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new IOException(bufferOverflowException.toString());
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.byteBuffer.put(byArray, n, n2);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new IOException(bufferOverflowException.toString());
        }
    }

    public void write(int n) throws IOException {
        try {
            this.byteBuffer.put((byte)n);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new IOException(bufferOverflowException.toString());
        }
    }

    public void writeBoolean(boolean bl) throws IOException {
        try {
            this.byteBuffer.put(bl ? (byte)1 : 0);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new IOException(bufferOverflowException.toString());
        }
    }

    public void writeByte(int n) throws IOException {
        try {
            this.byteBuffer.put((byte)n);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new IOException(bufferOverflowException.toString());
        }
    }

    public void writeShort(int n) throws IOException {
        try {
            this.byteBuffer.putShort((short)n);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new IOException(bufferOverflowException.toString());
        }
    }

    public void writeChar(int n) throws IOException {
        try {
            this.byteBuffer.putShort((short)n);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new IOException(bufferOverflowException.toString());
        }
    }

    public void writeInt(int n) throws IOException {
        try {
            this.byteBuffer.putInt(n);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new IOException(bufferOverflowException.toString());
        }
    }

    public void writeLong(long l) throws IOException {
        try {
            this.byteBuffer.putLong(l);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new IOException(bufferOverflowException.toString());
        }
    }

    public void writeFloat(float f) throws IOException {
        try {
            this.byteBuffer.putFloat(f);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new IOException(bufferOverflowException.toString());
        }
    }

    public void writeDouble(double d) throws IOException {
        try {
            this.byteBuffer.putDouble(d);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new IOException(bufferOverflowException.toString());
        }
    }

    public void writeBytes(String string) throws IOException {
        try {
            this.byteBuffer.put(string.getBytes());
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new IOException(bufferOverflowException.toString());
        }
    }

    public void writeChars(String string) throws IOException {
        try {
            int n = string == null ? 0 : string.length();
            for (int i = 0; i < n; ++i) {
                this.writeChar(string.charAt(i));
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new IOException(bufferOverflowException.toString());
        }
    }

    public void writeUTF(String string) throws IOException {
        this.writeShort(string == null ? 0 : string.length());
        this.writeBytes(string);
    }
}

