/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqinterop;

import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.CharArrayWriter;
import java.io.DataInput;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class ByteBufferDataInput
implements DataInput {
    final ByteBuffer byteBuffer;

    public ByteBufferDataInput(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public ByteBufferDataInput(WsByteBuffer wsByteBuffer) {
        this(wsByteBuffer.getWrappedByteBuffer());
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public void readFully(byte[] byArray) throws IOException {
        try {
            this.byteBuffer.get(byArray);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException(bufferUnderflowException.toString());
        }
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.byteBuffer.get(byArray, n, n2);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException(bufferUnderflowException.toString());
        }
    }

    public int skipBytes(int n) throws IOException {
        try {
            this.byteBuffer.position(this.byteBuffer.position() + n);
            return this.byteBuffer.position();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.toString());
        }
    }

    public boolean readBoolean() throws IOException {
        try {
            return this.byteBuffer.get() != 0;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException(bufferUnderflowException.toString());
        }
    }

    public byte readByte() throws IOException {
        try {
            return this.byteBuffer.get();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException(bufferUnderflowException.toString());
        }
    }

    public int readUnsignedByte() throws IOException {
        try {
            return this.byteBuffer.get();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException(bufferUnderflowException.toString());
        }
    }

    public short readShort() throws IOException {
        try {
            return this.byteBuffer.getShort();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException(bufferUnderflowException.toString());
        }
    }

    public int readUnsignedShort() throws IOException {
        try {
            return this.byteBuffer.getShort();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException(bufferUnderflowException.toString());
        }
    }

    public char readChar() throws IOException {
        try {
            return this.byteBuffer.getChar();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException(bufferUnderflowException.toString());
        }
    }

    public int readInt() throws IOException {
        try {
            return this.byteBuffer.getInt();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException(bufferUnderflowException.toString());
        }
    }

    public long readLong() throws IOException {
        try {
            return this.byteBuffer.getLong();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException(bufferUnderflowException.toString());
        }
    }

    public float readFloat() throws IOException {
        try {
            return this.byteBuffer.getFloat();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException(bufferUnderflowException.toString());
        }
    }

    public double readDouble() throws IOException {
        try {
            return this.byteBuffer.getDouble();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException(bufferUnderflowException.toString());
        }
    }

    public String readLine() throws IOException {
        try {
            char c;
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            boolean bl = false;
            while (this.byteBuffer.position() < this.byteBuffer.limit() && (c = this.byteBuffer.getChar()) != '\n' && c != '\r') {
            }
            return new String(charArrayWriter.toCharArray());
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException(bufferUnderflowException.toString());
        }
    }

    public String readUTF() throws IOException {
        try {
            byte[] byArray = new byte[this.byteBuffer.getShort()];
            this.byteBuffer.get(byArray);
            return new String(byArray);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException(bufferUnderflowException.toString());
        }
    }
}

