/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqimpl.resolver;

import com.ibm.websphere.sib.SIApiConstants;
import com.ibm.ws.sib.mfp.mqimpl.MQJsApiEncapsulation;
import com.ibm.ws.sib.mfp.mqimpl.resolver.MQFieldResolver;
import com.ibm.ws.sib.mfp.mqinterop.api.MQMD1;

public final class MQMDReportValueResolver
extends MQFieldResolver {
    final int mask;
    final int reportNoData;
    final int reportWithData;
    final int reportFullData;

    public MQMDReportValueResolver(int n, int n2, int n3) {
        this.mask = n | n2 | n3;
        this.reportNoData = n;
        this.reportWithData = n2;
        this.reportFullData = n3;
    }

    public String getName() {
        return MQMD1.Report.name;
    }

    public boolean isPresent(MQJsApiEncapsulation mQJsApiEncapsulation) {
        return this.isPresent(mQJsApiEncapsulation.getMD());
    }

    public boolean isPresent(MQMD1 mQMD1) {
        return (mQMD1.getReport() & this.mask) != 0;
    }

    public Object getValue(MQJsApiEncapsulation mQJsApiEncapsulation) {
        return this.getValue(mQJsApiEncapsulation.getMD());
    }

    public final Object getValue(MQMD1 mQMD1) {
        int n = mQMD1.getReport() & this.mask;
        if (n == this.reportFullData) {
            return SIApiConstants.REPORT_WITH_FULL_DATA;
        }
        if (n == this.reportWithData) {
            return SIApiConstants.REPORT_WITH_DATA;
        }
        if (n == this.reportNoData) {
            return SIApiConstants.REPORT_NO_DATA;
        }
        return null;
    }

    public void setValue(MQJsApiEncapsulation mQJsApiEncapsulation, Object object) {
        this.setValue(mQJsApiEncapsulation.getMD(), object);
    }

    public final void setValue(MQMD1 mQMD1, Object object) {
        if (object == null) {
            mQMD1.setReport(mQMD1.getReport() & ~this.mask);
        } else {
            this.setByteValue(mQMD1, (byte)((Byte)object));
        }
    }

    public byte getByteValue(MQJsApiEncapsulation mQJsApiEncapsulation) {
        Byte by = (Byte)this.getValue(mQJsApiEncapsulation);
        return by == null ? (byte)-1 : (byte)by;
    }

    public void setByteValue(MQJsApiEncapsulation mQJsApiEncapsulation, byte by) {
        this.setByteValue(mQJsApiEncapsulation.getMD(), by);
    }

    private final void setByteValue(MQMD1 mQMD1, byte by) {
        if (by == SIApiConstants.REPORT_WITH_FULL_DATA) {
            mQMD1.setReport(mQMD1.getReport() | this.reportFullData);
        } else if (by == SIApiConstants.REPORT_WITH_DATA) {
            mQMD1.setReport(mQMD1.getReport() | this.reportWithData);
        } else if (by == SIApiConstants.REPORT_NO_DATA) {
            mQMD1.setReport(mQMD1.getReport() | this.reportNoData);
        } else {
            throw new IllegalArgumentException("Invalid value for report: " + by);
        }
    }
}

