/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqimpl;

import com.ibm.websphere.sib.Reliability;

public class ReliabilityMapping {
    private Reliability reliability;
    private String rfhFieldValue;
    private int persistence;
    private static final ReliabilityMapping[] mappings = new ReliabilityMapping[Reliability.MAX_INDEX + 1];

    public static final String getRfhFieldValue(Reliability reliability) {
        return ReliabilityMapping.getMapping((Reliability)reliability).rfhFieldValue;
    }

    public static final int getPersistence(Reliability reliability) {
        return ReliabilityMapping.getMapping((Reliability)reliability).persistence;
    }

    private static final ReliabilityMapping getMapping(Reliability reliability) {
        if (reliability != null && ReliabilityMapping.mappings[reliability.getIndex()].reliability == reliability) {
            return mappings[reliability.getIndex()];
        }
        throw new ArrayIndexOutOfBoundsException("Invalid reliability: " + reliability);
    }

    private ReliabilityMapping(Reliability reliability, int n) {
        this.reliability = reliability;
        this.rfhFieldValue = Integer.toString(n);
        this.persistence = n;
    }

    static {
        ReliabilityMapping.mappings[Reliability.BEST_EFFORT_NONPERSISTENT.getIndex()] = new ReliabilityMapping(Reliability.BEST_EFFORT_NONPERSISTENT, 0);
        ReliabilityMapping.mappings[Reliability.EXPRESS_NONPERSISTENT.getIndex()] = new ReliabilityMapping(Reliability.EXPRESS_NONPERSISTENT, 0);
        ReliabilityMapping.mappings[Reliability.RELIABLE_NONPERSISTENT.getIndex()] = new ReliabilityMapping(Reliability.RELIABLE_NONPERSISTENT, 0);
        ReliabilityMapping.mappings[Reliability.RELIABLE_PERSISTENT.getIndex()] = new ReliabilityMapping(Reliability.RELIABLE_PERSISTENT, 1);
        ReliabilityMapping.mappings[Reliability.ASSURED_PERSISTENT.getIndex()] = new ReliabilityMapping(Reliability.ASSURED_PERSISTENT, 1);
    }
}

