/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqimpl;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.mqimpl.MQBrokerSubscriptionNativePart;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class BrokerAdminMessageHandler
extends DefaultHandler {
    static final SAXParser parser;
    static final DateFormat dateFormat;
    protected List list;
    protected String brokerUuid;
    protected String brokerName;
    protected String topicName = null;
    protected byte type = (byte)-1;

    BrokerAdminMessageHandler() {
    }

    protected void parse(InputStream inputStream) throws IOException {
        try {
            parser.parse(inputStream, (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            FFDCFilter.processException((Throwable)sAXException, (String)"com.ibm.ws.sib.mfp.mqimpl.BrokerAdminMessageHandler.parse", (String)"630", (Object)this);
            throw new IOException(sAXException.toString());
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if ("Topic".equals(string3)) {
            if (this.list == null) {
                this.list = new ArrayList();
            }
            this.topicName = attributes.getValue("name");
        } else if (this.brokerUuid == null && "Broker".equals(string3)) {
            this.brokerUuid = attributes.getValue("uuid");
            if ("?".equals(this.brokerUuid)) {
                this.type = 0;
            }
            this.brokerName = attributes.getValue("label");
        } else if ("LogEntry".equals(string3)) {
            if ("2045".equals(attributes.getValue("number"))) {
                this.type = 1;
            }
        } else if ("AllSubscriptions".equals(string3)) {
            this.type = (byte)2;
        } else if ("Subscription".equals(string3)) {
            int n = 0;
            if ("true".equals(attributes.getValue("localOnly"))) {
                n |= 1;
            }
            if ("true".equals(attributes.getValue("pubOnReqOnly"))) {
                n |= 0x200;
            }
            if ("true".equals(attributes.getValue("informIfRet"))) {
                n |= 0x400;
            }
            this.list.add(new MQBrokerSubscriptionNativePart(this.topicName, attributes.getValue("clientId"), attributes.getValue("subscriptionPoint"), attributes.getValue("filter"), attributes.getValue("user"), this.getTimestamp(attributes.getValue("createTimeStamp")), this.getTimestamp(attributes.getValue("expiryTimeStamp")), n));
            this.type = (byte)3;
        }
    }

    protected final Date getTimestamp(String string) {
        try {
            if (string == null || "0".equals(string)) {
                return null;
            }
            return dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    static {
        dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT+0:00"));
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(false);
            parser = sAXParserFactory.newSAXParser();
        }
        catch (SAXException sAXException) {
            FFDCFilter.processException((Throwable)sAXException, (String)"com.ibm.ws.sib.mfp.mqimpl.BrokerAdminMessageHandler.<clinit>", (String)"607");
            throw new RuntimeException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            FFDCFilter.processException((Throwable)parserConfigurationException, (String)"com.ibm.ws.sib.mfp.mqimpl.BrokerAdminMessageHandler.<clinit>", (String)"615");
            throw new RuntimeException(parserConfigurationException);
        }
    }
}

