/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.mqcontrol;

import com.ibm.ws.sib.mfp.mqinterop.api.MQRFH2;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PscOption {
    final String name;
    final int value;
    public static final int MQPSC_OPTS_COMMON_MASK = 15;
    public static final int MQPSC_OPTS_NONE = 0;
    public static final int MQPSC_OPTS_LOCAL = 1;
    public static final int MQPSC_OPTS_CORREL_ID_AS_IDENTITY = 2;
    public static final int MQPSC_OPTS_FULL_RESPONSE = 4;
    public static final PscOption MQPSC_LOCAL = new PscOption("Local", 1);
    public static final PscOption MQPSC_CORREL_ID_AS_IDENTITY = new PscOption("CorrelAsId", 2);
    public static final PscOption MQPSC_FULL_RESPONSE = new PscOption("FullResp", 4);
    public static final int MQPSC_OPTS_PUBLICATION_MASK = 240;
    public static final int MQPSC_OPTS_RETAIN_PUB = 16;
    public static final int MQPSC_OPTS_IS_RETAINED_PUB = 32;
    public static final int MQPSC_OPTS_OTHER_SUBS_ONLY = 64;
    public static final PscOption MQPSC_RETAIN_PUB = new PscOption("RetainPub", 16);
    public static final PscOption MQPSC_IS_RETAINED_PUB = new PscOption("IsRetainedPub", 32);
    public static final PscOption MQPSC_OTHER_SUBS_ONLY = new PscOption("OtherSubsOnly", 64);
    public static final int MQPSC_OPTS_SUBSCRIPTION_MASK = 3840;
    public static final int MQPSC_OPTS_NEW_PUBS_ONLY = 256;
    public static final int MQPSC_OPTS_PUB_ON_REQUEST_ONLY = 512;
    public static final int MQPSC_OPTS_INFORM_IF_RETAINED = 1024;
    public static final int MQPSC_OPTS_DEREGISTER_ALL = 2048;
    public static final PscOption MQPSC_NEW_PUBS_ONLY = new PscOption("NewPubsOnly", 256);
    public static final PscOption MQPSC_PUB_ON_REQUEST_ONLY = new PscOption("PubOnReqOnly", 512);
    public static final PscOption MQPSC_INFORM_IF_RETAINED = new PscOption("InformIfRet", 1024);
    public static final PscOption MQPSC_DEREGISTER_ALL = new PscOption("DeregAll", 2048);
    public static final int MQPSC_OPTS_PERSISTENCE_MASK = 61440;
    public static final int MQPSC_OPTS_NON_PERSISTENT = 0;
    public static final int MQPSC_OPTS_PERSISTENT = 4096;
    public static final int MQPSC_OPTS_PERSISTENT_AS_Q = 8192;
    public static final int MQPSC_OPTS_PERSISTENT_AS_PUBLISH = 12288;
    public static final PscOption MQPSC_PERSISTENT = new PscOption("Pers", 4096);
    public static final PscOption MQPSC_NON_PERSISTENT = new PscOption("NonPers", 0);
    public static final PscOption MQPSC_PERSISTENT_AS_Q = new PscOption("PersAsQueue", 8192);
    public static final PscOption MQPSC_PERSISTENT_AS_PUBLISH = new PscOption("PersAsPub", 12288);
    public static final PscOption MQPSCR_OK = new PscOption("ok", 0);
    public static final PscOption MQPSCR_WARNING = new PscOption("warning", 1);
    public static final PscOption MQPSCR_ERROR = new PscOption("error", 2);
    static Map map = new HashMap();

    public static int getOptions(MQRFH2 mQRFH2, int n) throws IOException {
        List list;
        MQRFH2.Element element = mQRFH2.getFolder("psc", false);
        int n2 = 0;
        if (element == null) {
            return 0;
        }
        switch (n) {
            case 1: {
                list = element.getChildren("PubOpt");
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                list = element.getChildren("RegOpt");
                break;
            }
            case 5: {
                list = element.getChildren("DelOpt");
                break;
            }
            default: {
                return 0;
            }
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MQRFH2.Element element2 = (MQRFH2.Element)iterator.next();
            PscOption pscOption = PscOption.getOption((String)element2.getValue());
            if (pscOption == null) continue;
            n2 |= pscOption.toInt();
        }
        return n2;
    }

    public static void setOptions(MQRFH2 mQRFH2, int n, int n2) throws IOException {
        MQRFH2.Element element = mQRFH2.getFolder("psc", true);
        switch (n2) {
            case 1: {
                element.setValue("PubOpt", null);
                PscOption.setOption(element, "PubOpt", MQPSC_RETAIN_PUB, n);
                PscOption.setOption(element, "PubOpt", MQPSC_IS_RETAINED_PUB, n);
                PscOption.setOption(element, "PubOpt", MQPSC_OTHER_SUBS_ONLY, n);
                PscOption.setOption(element, "PubOpt", MQPSC_CORREL_ID_AS_IDENTITY, n);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                element.setValue("PubOpt", null);
                PscOption.setOption(element, "RegOpt", MQPSC_NEW_PUBS_ONLY, n);
                PscOption.setOption(element, "RegOpt", MQPSC_PUB_ON_REQUEST_ONLY, n);
                PscOption.setOption(element, "RegOpt", MQPSC_INFORM_IF_RETAINED, n);
                PscOption.setOption(element, "RegOpt", MQPSC_LOCAL, n);
                PscOption.setOption(element, "RegOpt", MQPSC_CORREL_ID_AS_IDENTITY, n);
                PscOption.setOption(element, "RegOpt", MQPSC_FULL_RESPONSE, n);
                break;
            }
            case 5: {
                element.setValue("PubOpt", null);
                PscOption.setOption(element, "RegOpt", MQPSC_DEREGISTER_ALL, n);
                PscOption.setOption(element, "RegOpt", MQPSC_LOCAL, n);
                PscOption.setOption(element, "RegOpt", MQPSC_CORREL_ID_AS_IDENTITY, n);
                PscOption.setOption(element, "RegOpt", MQPSC_FULL_RESPONSE, n);
                break;
            }
            default: {
                return;
            }
        }
    }

    public static PscOption getOption(String string) {
        return string == null ? null : (PscOption)map.get(string);
    }

    public static void setOption(MQRFH2.Element element, String string, PscOption pscOption, int n) {
        if ((pscOption.value & n) == pscOption.value) {
            element.addElement(string, pscOption.name);
        }
    }

    private PscOption(String string, int n) {
        this.name = string;
        this.value = n;
    }

    public int toInt() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getClass().getName() + ' ' + this.name + '=' + this.value;
    }

    static {
        PscOption[] pscOptionArray = new PscOption[]{MQPSC_CORREL_ID_AS_IDENTITY, MQPSC_LOCAL, MQPSC_RETAIN_PUB, MQPSC_IS_RETAINED_PUB, MQPSC_OTHER_SUBS_ONLY, MQPSC_NEW_PUBS_ONLY, MQPSC_PUB_ON_REQUEST_ONLY, MQPSC_INFORM_IF_RETAINED, MQPSC_PERSISTENT, MQPSC_NON_PERSISTENT, MQPSC_PERSISTENT_AS_Q, MQPSC_PERSISTENT_AS_PUBLISH, MQPSC_DEREGISTER_ALL, MQPSCR_OK, MQPSCR_WARNING, MQPSCR_ERROR};
        for (int i = 0; i < pscOptionArray.length; ++i) {
            map.put(pscOptionArray[i].getName(), pscOptionArray[i]);
        }
    }
}

