/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf.tools;

import com.ibm.ws.sib.mfp.jmf.JMFRegistry;
import com.ibm.ws.sib.mfp.jmf.JMFRepeatedType;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.mfp.jmf.JMFTupleType;
import com.ibm.ws.sib.mfp.jmf.JMFType;
import com.ibm.ws.sib.mfp.jmf.JMFVariantType;
import com.ibm.ws.sib.mfp.jmf.parser.JSParser;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;

public final class JSchemaTool {
    private JSchemaTool() {
    }

    public static void main(String[] stringArray) throws IOException, IllegalArgumentException {
        int n;
        if (stringArray.length < 3) {
            System.err.println("Syntax: JSchemaTool <source-file> <package> <class> [-accessors]");
            System.exit(-1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        boolean bl = false;
        if (stringArray.length > 3 && stringArray[3].equals("-accessors")) {
            bl = true;
        }
        if (string3.endsWith(".java")) {
            string3 = string3.substring(0, string3.lastIndexOf(46));
        }
        if ((n = string3.lastIndexOf(47)) == -1) {
            n = string3.lastIndexOf(92);
        }
        String string4 = string3.substring(n + 1);
        JMFType jMFType = JSParser.parse(new FileReader(string));
        JSchemaTool.createSchema(jMFType, string, string3, string2, string4);
        if (bl) {
            JSchemaTool.createAccessors(jMFType, string, string3, string2, string4);
        }
    }

    static void createSchema(JMFType jMFType, String string, String string2, String string3, String string4) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(jMFType.toString()));
        String string5 = bufferedReader.readLine();
        if (string5 == null) {
            System.err.println(string + " is empty");
            System.exit(-1);
        }
        string5 = string5.trim();
        String string6 = bufferedReader.readLine();
        while (string6 != null) {
            string5 = string5 + " " + string6.trim();
            string6 = bufferedReader.readLine();
        }
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(string2 + ".java"));
        printWriter.println("// Generated from " + string + ": do not edit directly");
        printWriter.println("package " + string3 + ";");
        printWriter.println("import com.ibm.ws.sib.mfp.jmf.impl.JSchema;");
        printWriter.println("import com.ibm.ws.sib.mfp.jmf.impl.JSType;");
        printWriter.println("import com.ibm.ws.sib.mfp.jmf.parser.JSParser;");
        printWriter.println("import java.io.StringReader;");
        printWriter.println("public final class " + string4 + " extends JSchema {");
        printWriter.println("  public " + string4 + "() {");
        printWriter.print("    super((JSType) JSParser.parse(new StringReader(\"");
        printWriter.print(string5);
        printWriter.println("\")));");
        printWriter.println("  }");
        printWriter.println("}");
        printWriter.close();
    }

    static void createAccessors(JMFType jMFType, String string, String string2, String string3, String string4) throws IOException {
        int n;
        if (string2.endsWith("Schema")) {
            string2 = string2.substring(0, string2.lastIndexOf(83));
        }
        if ((n = (string2 = string2 + "Access").lastIndexOf(47)) == -1) {
            n = string2.lastIndexOf(92);
        }
        String string5 = string2.substring(n + 1);
        JMFSchema jMFSchema = JMFRegistry.instance.createJMFSchema(jMFType);
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(string2 + ".java"));
        printWriter.println("// Generated from " + string + ": do not edit directly");
        printWriter.println("package " + string3 + ";");
        printWriter.println("import com.ibm.ws.sib.mfp.jmf.impl.JSchema;");
        printWriter.println("public final class " + string5 + " {");
        printWriter.println("  public static JSchema schema = new " + string4 + "();");
        JSchemaTool.writeAllAccessors(printWriter, jMFSchema, jMFType);
        printWriter.println("}");
        printWriter.close();
    }

    static void writeAllAccessors(PrintWriter printWriter, JMFSchema jMFSchema, JMFType jMFType) {
        if (jMFType instanceof JMFTupleType) {
            JMFTupleType jMFTupleType = (JMFTupleType)jMFType;
            for (int i = 0; i < jMFTupleType.getFieldCount(); ++i) {
                JSchemaTool.writeAllAccessors(printWriter, jMFSchema, jMFTupleType.getField(i));
            }
        } else if (jMFType instanceof JMFVariantType) {
            int n;
            JMFVariantType jMFVariantType = (JMFVariantType)jMFType;
            JSchemaTool.writeAccessor(printWriter, jMFSchema, jMFVariantType);
            for (n = 0; n < jMFVariantType.getCaseCount(); ++n) {
                JSchemaTool.writeSelector(printWriter, jMFSchema, jMFVariantType, jMFVariantType.getCase(n));
            }
            for (n = 0; n < jMFVariantType.getCaseCount(); ++n) {
                JSchemaTool.writeAllAccessors(printWriter, jMFSchema, jMFVariantType.getCase(n));
            }
        } else if (jMFType instanceof JMFRepeatedType) {
            JMFRepeatedType jMFRepeatedType = (JMFRepeatedType)jMFType;
            JSchemaTool.writeAllAccessors(printWriter, jMFSchema, jMFRepeatedType.getItemType());
        } else {
            JSchemaTool.writeAccessor(printWriter, jMFSchema, jMFType);
        }
    }

    static void writeAccessor(PrintWriter printWriter, JMFSchema jMFSchema, JMFType jMFType) {
        String string = jMFType.getFeatureName();
        if (string != null && string.length() > 0) {
            String string2 = jMFSchema.getPathName(jMFType);
            String string3 = string2.toUpperCase().replace('/', '_');
            string3 = string3.replaceAll("\\[\\d*\\]\\_?", "");
            int n = jMFSchema.getAccessor(string2);
            printWriter.println("  public final static int " + string3 + " = " + n + ";");
        }
    }

    static void writeSelector(PrintWriter printWriter, JMFSchema jMFSchema, JMFType jMFType, JMFType jMFType2) {
        while (jMFType2 instanceof JMFRepeatedType) {
            jMFType2 = ((JMFRepeatedType)jMFType2).getItemType();
        }
        String string = jMFType2.getFeatureName();
        if (string != null && string.length() > 0) {
            String string2 = jMFSchema.getPathName(jMFType);
            String string3 = jMFSchema.getPathName(jMFType2);
            String string4 = "IS_" + string3.toUpperCase().replace('/', '_');
            string4 = string4.replaceAll("\\[\\d*\\]\\_?", "");
            int n = jMFSchema.getCaseIndex(jMFSchema.getAccessor(string2), string);
            printWriter.println("  public final static int " + string4 + " = " + n + ";");
        }
    }
}

