/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf.tools;

import com.ibm.ws.sib.mfp.jmf.JMFException;
import com.ibm.ws.sib.mfp.jmf.JMFFieldDef;
import com.ibm.ws.sib.mfp.jmf.JMFList;
import com.ibm.ws.sib.mfp.jmf.JMFMessage;
import com.ibm.ws.sib.mfp.jmf.JMFNativePart;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.mfp.jmf.impl.JSDynamic;
import com.ibm.ws.sib.mfp.jmf.impl.JSEnum;
import com.ibm.ws.sib.mfp.jmf.impl.JSField;
import com.ibm.ws.sib.mfp.jmf.impl.JSPrimitive;
import com.ibm.ws.sib.mfp.jmf.impl.JSType;
import com.ibm.ws.sib.mfp.jmf.impl.JSVariant;
import com.ibm.ws.sib.mfp.jmf.impl.JSchema;
import com.ibm.ws.sib.mfp.jmf.impl.MessageMap;
import com.ibm.ws.sib.mfp.util.ArrayUtil;
import com.ibm.ws.sib.mfp.util.HexUtil;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.Calendar;

public final class JSFormatter {
    private JSFormatter() {
    }

    public static String format(MessageMap messageMap, JMFSchema jMFSchema) {
        JSField jSField;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        JSVariant[] jSVariantArray = ((JSchema)jMFSchema).getVariants();
        JSField[] jSFieldArray = ((JSchema)jMFSchema).getFields();
        stringBuffer.append("MultiChoice Code=").append(messageMap.multiChoice);
        stringBuffer.append(", Offset Table Size=").append(messageMap.offsetsNeeded);
        stringBuffer.append("\nVariant settings:\n");
        for (n = 0; n < messageMap.choiceCodes.length; ++n) {
            int n2 = messageMap.choiceCodes[n];
            if (n2 == -1) continue;
            jSField = jSVariantArray[n];
            String string = jSField.getCase(n2).getFeatureName();
            if (string == null || string.length() == 0) {
                string = "[" + n2 + "]";
            }
            stringBuffer.append(" ").append(JSFormatter.getUsefulName((JSchema)jMFSchema, jSField)).append("=").append(string).append("\n");
        }
        stringBuffer.append("Field offsets:\n");
        for (n = 0; n < messageMap.fields.length; ++n) {
            MessageMap.Remap remap = messageMap.fields[n];
            if (remap == null) continue;
            jSField = jSFieldArray[n];
            stringBuffer.append(" ");
            stringBuffer.append(JSFormatter.getUsefulName((JSchema)jMFSchema, jSField));
            stringBuffer.append("(").append(JSFormatter.getUsefulType(jSField)).append(")");
            stringBuffer.append(": ").append(JSFormatter.format(remap));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private static String getUsefulName(JSchema jSchema, JSField jSField) {
        String string = jSchema.getPathName(jSField);
        if (string.length() == 0) {
            string = "<root>";
        }
        return string;
    }

    private static String getUsefulType(JSField jSField) {
        String string = "";
        for (int i = 0; i < jSField.getIndirection() + 1; ++i) {
            string = string + "List of ";
        }
        if (jSField instanceof JSEnum) {
            return string + "Enum";
        }
        if (jSField instanceof JSDynamic) {
            return string + "Dynamic";
        }
        if (jSField instanceof JSVariant) {
            return string + "Variant Box";
        }
        return string + ((JSPrimitive)jSField).getXSDTypeName();
    }

    private static String format(MessageMap.Remap remap) {
        String string = "";
        if (remap.offsetIndex > -1) {
            string = string + "[" + remap.offsetIndex + "]";
        }
        string = string + "+" + remap.fixedIncr;
        return string;
    }

    public static String format(JMFSchema jMFSchema, BigInteger bigInteger) {
        return JSFormatter.format(new MessageMap((JSchema)jMFSchema, bigInteger), jMFSchema);
    }

    public static String format(JMFSchema jMFSchema, String string, BigInteger bigInteger) {
        int n = jMFSchema.getAccessor(string);
        if (n == -1) {
            return null;
        }
        JMFFieldDef jMFFieldDef = jMFSchema.getFieldDef(n);
        if (!(jMFFieldDef instanceof JSVariant)) {
            return null;
        }
        JSVariant jSVariant = ((JSVariant)jMFFieldDef).getBoxedBy();
        if (jSVariant == null) {
            return null;
        }
        JSchema jSchema = (JSchema)jSVariant.getBoxed();
        if (jSchema == null) {
            return null;
        }
        return JSFormatter.format(jSchema, bigInteger);
    }

    public static void schemaBook(JMFSchema jMFSchema, PrintWriter printWriter) {
        printWriter.println("Schema Book for " + JSFormatter.format(jMFSchema));
        printWriter.println();
        JSFormatter.printBook((JSchema)jMFSchema, printWriter);
        JSField[] jSFieldArray = ((JSchema)jMFSchema).getFields();
        for (int i = 0; i < jSFieldArray.length; ++i) {
            if (!(jSFieldArray[i] instanceof JSVariant)) continue;
            JSVariant jSVariant = (JSVariant)jSFieldArray[i];
            printWriter.println("Maps for boxed variant " + jMFSchema.getPathName(jSVariant));
            printWriter.println();
            JSFormatter.printBook((JSchema)jSVariant.getBoxed(), printWriter);
        }
    }

    private static void printBook(JSchema jSchema, PrintWriter printWriter) {
        BigInteger bigInteger = BigInteger.ZERO;
        while (bigInteger.compareTo(((JSType)jSchema.getJMFType()).getMultiChoiceCount()) < 0) {
            printWriter.println(JSFormatter.format(new MessageMap(jSchema, bigInteger), jSchema));
            printWriter.println();
            bigInteger = bigInteger.add(BigInteger.ONE);
        }
    }

    public static String format(JMFMessage jMFMessage) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("JMFMessage: JMF version=").append(jMFMessage.getJMFEncodingVersion());
            JMFSchema[] jMFSchemaArray = jMFMessage.getSchemata();
            JMFSchema jMFSchema = jMFMessage.getEncodingSchema();
            stringBuffer.append(", Schema=").append(JSFormatter.format(jMFSchemaArray[0])).append("\n");
            if (jMFSchemaArray.length > 1) {
                stringBuffer.append("Also uses:");
                for (int i = 1; i < jMFSchemaArray.length; ++i) {
                    stringBuffer.append(" ").append(JSFormatter.format(jMFSchemaArray[i]));
                }
                stringBuffer.append("\n");
            }
            stringBuffer.append("Length=");
            try {
                stringBuffer.append(jMFMessage.getEncodedLength()).append("\n");
            }
            catch (Exception exception) {
                stringBuffer.append("getEncodedLength failed, Exception: ");
                stringBuffer.append(exception.toString()).append("\n");
            }
            JSFormatter.format(stringBuffer, jMFMessage, "  ");
        }
        catch (Exception exception) {
            stringBuffer.append("\nMessage probably corrupted. Exception: ");
            stringBuffer.append(exception.toString());
        }
        return stringBuffer.toString();
    }

    public static String format(JMFNativePart jMFNativePart) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("JMFNativePart: Schema=").append(JSFormatter.format(jMFNativePart.getEncodingSchema())).append("\n");
            JSFormatter.format(stringBuffer, jMFNativePart, "  ");
        }
        catch (Exception exception) {
            stringBuffer.append("\nMessage probably corrupted. Exception: ");
            stringBuffer.append(exception.toString());
        }
        return stringBuffer.toString();
    }

    private static String format(JMFSchema jMFSchema) {
        if (jMFSchema == null) {
            return "null schema";
        }
        byte[] byArray = new byte[8];
        ArrayUtil.writeLong(byArray, 0, jMFSchema.getID());
        return jMFSchema.getName() + "(" + HexUtil.toString(byArray) + ")";
    }

    private static void format(StringBuffer stringBuffer, JMFNativePart jMFNativePart, String string) throws JMFException {
        JSchema jSchema = (JSchema)jMFNativePart.getJMFSchema();
        JSField[] jSFieldArray = jSchema.getFields();
        JSFormatter.formatVariants(stringBuffer, jMFNativePart, jSFieldArray.length, jSchema.getVariants(), string);
        JSFormatter.formatFields(stringBuffer, jMFNativePart, jSFieldArray, string);
    }

    private static void formatVariants(StringBuffer stringBuffer, JMFNativePart jMFNativePart, int n, JSVariant[] jSVariantArray, String string) throws JMFException {
        JSchema jSchema = (JSchema)jMFNativePart.getJMFSchema();
        stringBuffer.append(string).append("Variants:\n");
        for (int i = 0; i < jSVariantArray.length; ++i) {
            if (!jMFNativePart.isPresent(n + i)) continue;
            JSVariant jSVariant = jSVariantArray[i];
            String string2 = jSchema.getPathName(jSVariant);
            if (string2 == null || string2.length() == 0) {
                string2 = "<unnamed>";
            }
            stringBuffer.append(string).append(string2).append("=");
            String string3 = jSVariant.getCase(jMFNativePart.getInt(n + i)).getFeatureName();
            if (string3 != null && string3.length() > 0) {
                stringBuffer.append(string3);
            } else {
                stringBuffer.append(jMFNativePart.getValue(n + i));
            }
            stringBuffer.append("\n");
        }
    }

    private static void formatFields(StringBuffer stringBuffer, JMFNativePart jMFNativePart, JSField[] jSFieldArray, String string) throws JMFException {
        JSchema jSchema = (JSchema)jMFNativePart.getJMFSchema();
        stringBuffer.append(string).append("Fields:\n");
        for (int i = 0; i < jSFieldArray.length; ++i) {
            if (!jMFNativePart.isPresent(i)) continue;
            String string2 = jSchema.getPathName(jSFieldArray[i]);
            if (string2 == null || string2.length() == 0) {
                string2 = "<unnamed>";
            }
            stringBuffer.append(string).append(string2).append("=");
            JSFormatter.formatValue(stringBuffer, jMFNativePart.getValue(i), string);
        }
    }

    private static void formatValue(StringBuffer stringBuffer, Object object, String string) throws JMFException {
        if (object instanceof JMFNativePart) {
            JMFNativePart jMFNativePart = (JMFNativePart)object;
            stringBuffer.append("JMFNativePart, Schema=").append(JSFormatter.format(jMFNativePart.getEncodingSchema())).append(":\n");
            JSFormatter.format(stringBuffer, jMFNativePart, string + "  ");
        } else if (object instanceof JMFList) {
            JMFList jMFList = (JMFList)object;
            stringBuffer.append("JSList, size=").append(jMFList.size()).append(":\n");
            JSFormatter.format(stringBuffer, jMFList, string + "  ");
        } else {
            if (object instanceof Calendar) {
                stringBuffer.append(DateFormat.getDateTimeInstance().format(((Calendar)object).getTime()));
            } else if (object instanceof byte[]) {
                stringBuffer.append(HexUtil.toString((byte[])object));
            } else {
                stringBuffer.append(object);
            }
            stringBuffer.append("\n");
        }
    }

    private static void format(StringBuffer stringBuffer, JMFList jMFList, String string) throws JMFException {
        for (int i = 0; i < jMFList.size(); ++i) {
            stringBuffer.append(string).append("[").append(i).append("] ");
            if (jMFList.isPresent(i)) {
                JSFormatter.formatValue(stringBuffer, jMFList.get(i), string);
                continue;
            }
            stringBuffer.append("<missing>\n");
        }
    }
}

