/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf.impl;

import com.ibm.ws.sib.mfp.jmf.JMFMessageCorruptionException;
import com.ibm.ws.sib.mfp.jmf.JMFModelNotImplementedException;
import com.ibm.ws.sib.mfp.jmf.JMFNativePart;
import com.ibm.ws.sib.mfp.jmf.JMFSchemaViolationException;
import com.ibm.ws.sib.mfp.jmf.JMFUninitializedAccessException;
import com.ibm.ws.sib.mfp.jmf.impl.JSBoxedListImpl;
import com.ibm.ws.sib.mfp.jmf.impl.JSVaryingList;

class JSBoxManager {
    private JMFNativePart part;
    private int[][] boxed;
    private JSBoxedListImpl[] boxedCache;

    JSBoxManager(JMFNativePart jMFNativePart, int[][] nArray) {
        this.part = jMFNativePart;
        this.boxed = nArray;
        this.reset();
    }

    void reset() {
        this.boxedCache = new JSBoxedListImpl[this.boxed.length];
    }

    void cleanupBoxedCache(int n) {
        for (int i = 0; i < this.boxedCache.length; ++i) {
            if (this.boxed[i][0] != n) continue;
            this.boxedCache[i] = null;
        }
    }

    int getBoxAccessor(int n) {
        return this.boxed[n][0];
    }

    Object getBoxedlValue(int n) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException, JMFUninitializedAccessException {
        JSBoxedListImpl jSBoxedListImpl = this.boxedCache[n];
        if (jSBoxedListImpl != null) {
            return jSBoxedListImpl;
        }
        JSVaryingList jSVaryingList = (JSVaryingList)this.part.getValue(this.boxed[n][0]);
        this.boxedCache[n] = jSBoxedListImpl = JSBoxedListImpl.create(jSVaryingList, this.boxed[n][1]);
        return jSBoxedListImpl;
    }

    void setBoxedValue(int n, Object object) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException, JMFUninitializedAccessException {
        if (object == this.boxedCache[n]) {
            return;
        }
        int n2 = this.boxed[n][0];
        JSVaryingList jSVaryingList = this.part.isPresent(n2) ? (JSVaryingList)this.part.getValue(n2) : (JSVaryingList)this.part.createBoxList(n2, object);
        this.boxedCache[n] = JSBoxedListImpl.create(jSVaryingList, this.boxed[n][1], object);
    }
}

