/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.jmf.JMFAddress;
import com.ibm.ws.sib.mfp.jmf.JMFMessage;
import com.ibm.ws.sib.mfp.jmf.JMFMessageCorruptionException;
import com.ibm.ws.sib.mfp.jmf.JMFModelNotImplementedException;
import com.ibm.ws.sib.mfp.jmf.JMFSchemaViolationException;
import com.ibm.ws.sib.mfp.jmf.JMFUninitializedAccessException;
import com.ibm.ws.sib.mfp.jmf.impl.JSCoder;
import com.ibm.ws.sib.mfp.jmf.impl.JSListCoder;
import com.ibm.ws.sib.mfp.util.ArrayUtil;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public final class JSBaseTypes {
    private static TraceComponent tc = SibTr.register(class$com$ibm$ws$sib$mfp$jmf$impl$JSBaseTypes == null ? (class$com$ibm$ws$sib$mfp$jmf$impl$JSBaseTypes = JSBaseTypes.class$("com.ibm.ws.sib.mfp.jmf.impl.JSBaseTypes")) : class$com$ibm$ws$sib$mfp$jmf$impl$JSBaseTypes, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static JSCoder StringCoder;
    private static JSCoder ByteArrayCoder;
    private static JSCoder Byte8Coder;
    private static JSCoder Byte12Coder;
    private static JSCoder DecimalCoder;
    private static JSCoder DateCoder;
    private static JSCoder BigIntegerCoder;
    private static JSCoder IDREFCoder;
    private static JSCoder SimpleListCoder;
    private static JSCoder AnySimpleTypeCoder;
    private static JSCoder QNameCoder;
    Class javaClass;
    int javaClassSize;
    int length;
    JSCoder coder;
    static JSBaseTypes[] baseTypes;
    static Map xsdTypeNames;
    static HashMap classTypes;
    static /* synthetic */ Class class$com$ibm$ws$sib$mfp$jmf$impl$JSBaseTypes;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$com$ibm$ws$sib$mfp$jmf$JMFAddress;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$javax$xml$namespace$QName;

    private JSBaseTypes(Class clazz, int n, int n2, JSCoder jSCoder) {
        this.javaClass = clazz;
        this.javaClassSize = n;
        this.length = n2;
        this.coder = jSCoder;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.jmf/src/com/ibm/ws/sib/mfp/jmf/impl/JSBaseTypes.java, SIB.mfp, WAS602.SIB, o0610.11 1.26");
        }
        StringCoder = new JSCoder(){

            public int getEncodedLength(Object object, int n, JMFMessage jMFMessage) {
                if (object == null) {
                    return 4;
                }
                try {
                    return 4 + ((String)object).getBytes("UTF8").length;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"StringCoder.getEncodedLength", (String)"126");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                    illegalArgumentException.initCause(unsupportedEncodingException);
                    throw illegalArgumentException;
                }
            }

            public Object validate(Object object, int n) throws JMFSchemaViolationException {
                if (object instanceof String || object == null) {
                    return object;
                }
                throw new JMFSchemaViolationException(object.getClass().getName());
            }

            public int encode(byte[] byArray, int n, Object object, int n2, JMFMessage jMFMessage) {
                if (object == null) {
                    ArrayUtil.writeInt(byArray, n, -1);
                    return n + 4;
                }
                if (object instanceof StringBuffer) {
                    object = ((StringBuffer)object).toString();
                }
                try {
                    byte[] byArray2 = ((String)object).getBytes("UTF8");
                    ArrayUtil.writeInt(byArray, n, byArray2.length);
                    System.arraycopy(byArray2, 0, byArray, n + 4, byArray2.length);
                    return n + 4 + byArray2.length;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"StringCoder.encode", (String)"154");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                    illegalArgumentException.initCause(unsupportedEncodingException);
                    throw illegalArgumentException;
                }
            }

            public Object decode(byte[] byArray, int n, int n2, JMFMessage jMFMessage) throws JMFMessageCorruptionException {
                String string;
                int n3 = ArrayUtil.readInt(byArray, n);
                if (n3 == -1) {
                    return null;
                }
                JSListCoder.sanityCheck(n3, byArray, n);
                n += 4;
                try {
                    string = new String(byArray, n, n3, "UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"StringCoder.decode", (String)"171");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                    illegalArgumentException.initCause(unsupportedEncodingException);
                    throw illegalArgumentException;
                }
                return string;
            }

            public Object copy(Object object, int n) {
                return object;
            }
        };
        ByteArrayCoder = new JSCoder(){

            public int getEncodedLength(Object object, int n, JMFMessage jMFMessage) {
                if (object == null) {
                    return 4;
                }
                return ((byte[])object).length + 4;
            }

            public Object validate(Object object, int n) throws JMFSchemaViolationException {
                if (object instanceof byte[] || object == null) {
                    return object;
                }
                throw new JMFSchemaViolationException(object.getClass().getName());
            }

            public int encode(byte[] byArray, int n, Object object, int n2, JMFMessage jMFMessage) {
                if (object == null) {
                    ArrayUtil.writeInt(byArray, n, -1);
                    return n + 4;
                }
                byte[] byArray2 = (byte[])object;
                ArrayUtil.writeInt(byArray, n, byArray2.length);
                System.arraycopy(byArray2, 0, byArray, n + 4, byArray2.length);
                return n + 4 + byArray2.length;
            }

            public Object decode(byte[] byArray, int n, int n2, JMFMessage jMFMessage) throws JMFMessageCorruptionException {
                int n3 = ArrayUtil.readInt(byArray, n);
                if (n3 == -1) {
                    return null;
                }
                JSListCoder.sanityCheck(n3, byArray, n);
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, n + 4, byArray2, 0, n3);
                return byArray2;
            }

            public Object copy(Object object, int n) {
                return object;
            }
        };
        Byte8Coder = new ByteFixedCoder(8);
        Byte12Coder = new ByteFixedCoder(12);
        DecimalCoder = new JSCoder(){

            public int getEncodedLength(Object object, int n, JMFMessage jMFMessage) {
                return 8 + ((BigDecimal)object).unscaledValue().bitLength() / 8 + 1;
            }

            public Object validate(Object object, int n) throws JMFSchemaViolationException {
                if (object instanceof BigDecimal) {
                    return object;
                }
                if (object == null) {
                    throw new JMFSchemaViolationException("BigDecimal==null");
                }
                throw new JMFSchemaViolationException(object.getClass().getName());
            }

            public int encode(byte[] byArray, int n, Object object, int n2, JMFMessage jMFMessage) {
                BigDecimal bigDecimal = (BigDecimal)object;
                byte[] byArray2 = bigDecimal.unscaledValue().toByteArray();
                ArrayUtil.writeInt(byArray, n, byArray2.length + 4);
                ArrayUtil.writeInt(byArray, n + 4, bigDecimal.scale());
                System.arraycopy(byArray2, 0, byArray, n + 8, byArray2.length);
                return n + 8 + byArray2.length;
            }

            public Object decode(byte[] byArray, int n, int n2, JMFMessage jMFMessage) throws JMFMessageCorruptionException {
                int n3 = ArrayUtil.readInt(byArray, n);
                JSListCoder.sanityCheck(n3, byArray, n);
                int n4 = ArrayUtil.readInt(byArray, n + 4);
                byte[] byArray2 = new byte[n3 -= 4];
                System.arraycopy(byArray, n + 8, byArray2, 0, n3);
                return new BigDecimal(new BigInteger(byArray2), n4);
            }

            public Object copy(Object object, int n) {
                return object;
            }
        };
        DateCoder = new JSCoder(){

            public int getEncodedLength(Object object, int n, JMFMessage jMFMessage) {
                return 8;
            }

            public Object validate(Object object, int n) throws JMFSchemaViolationException {
                if (object instanceof Date) {
                    return object;
                }
                if (object == null) {
                    throw new JMFSchemaViolationException("Date==null");
                }
                throw new JMFSchemaViolationException(object.getClass().getName());
            }

            public int encode(byte[] byArray, int n, Object object, int n2, JMFMessage jMFMessage) {
                if (object == null) {
                    throw new NullPointerException();
                }
                ArrayUtil.writeLong(byArray, n, ((Date)object).getTime());
                return n + 8;
            }

            public Object decode(byte[] byArray, int n, int n2, JMFMessage jMFMessage) {
                return new Date(ArrayUtil.readLong(byArray, n));
            }

            public Object copy(Object object, int n) {
                return ((Date)object).clone();
            }
        };
        BigIntegerCoder = new JSCoder(){

            public int getEncodedLength(Object object, int n, JMFMessage jMFMessage) {
                return 4 + ((BigInteger)object).bitLength() / 8 + 1;
            }

            public Object validate(Object object, int n) throws JMFSchemaViolationException {
                if (object instanceof BigInteger) {
                    return object;
                }
                if (object == null) {
                    throw new JMFSchemaViolationException("BigInteger==null");
                }
                throw new JMFSchemaViolationException(object.getClass().getName());
            }

            public int encode(byte[] byArray, int n, Object object, int n2, JMFMessage jMFMessage) {
                byte[] byArray2 = ((BigInteger)object).toByteArray();
                ArrayUtil.writeInt(byArray, n, byArray2.length);
                System.arraycopy(byArray2, 0, byArray, n + 4, byArray2.length);
                return n + 4 + byArray2.length;
            }

            public Object decode(byte[] byArray, int n, int n2, JMFMessage jMFMessage) throws JMFMessageCorruptionException {
                int n3 = ArrayUtil.readInt(byArray, n);
                JSListCoder.sanityCheck(n3, byArray, n);
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, n + 4, byArray2, 0, n3);
                return new BigInteger(byArray2);
            }

            public Object copy(Object object, int n) {
                return object;
            }
        };
        IDREFCoder = new JSCoder(){

            public int getEncodedLength(Object object, int n, JMFMessage jMFMessage) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
                if (object != null) {
                    object = ((JMFAddress)object).getContent();
                }
                return ByteArrayCoder.getEncodedLength(object, n, jMFMessage);
            }

            public int encode(byte[] byArray, int n, Object object, int n2, JMFMessage jMFMessage) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
                if (object != null) {
                    object = ((JMFAddress)object).getContent();
                }
                return ByteArrayCoder.encode(byArray, n, object, n2, jMFMessage);
            }

            public Object decode(byte[] byArray, int n, int n2, JMFMessage jMFMessage) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
                Object object = ByteArrayCoder.decode(byArray, n, n2, jMFMessage);
                if (object != null) {
                    object = new JMFAddress((byte[])object);
                }
                return object;
            }

            public Object validate(Object object, int n) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
                if (object instanceof JMFAddress || object == null) {
                    return object;
                }
                throw new JMFSchemaViolationException(object.getClass().getName());
            }

            public Object copy(Object object, int n) throws JMFSchemaViolationException {
                return new JMFAddress((JMFAddress)object);
            }
        };
        SimpleListCoder = new JSCoder(){

            public int getEncodedLength(Object object, int n, JMFMessage jMFMessage) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
                int n2 = 8;
                List list = (List)object;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    n2 += AnySimpleTypeCoder.getEncodedLength(iterator.next(), n, jMFMessage);
                }
                return n2;
            }

            public int encode(byte[] byArray, int n, Object object, int n2, JMFMessage jMFMessage) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
                List list = (List)object;
                ArrayUtil.writeInt(byArray, n + 4, list.size());
                int n3 = n + 8;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    n3 = AnySimpleTypeCoder.encode(byArray, n3, iterator.next(), n2, jMFMessage);
                }
                ArrayUtil.writeInt(byArray, n, n3 - n - 4);
                return n3;
            }

            public Object decode(byte[] byArray, int n, int n2, JMFMessage jMFMessage) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                int n3 = ArrayUtil.readInt(byArray, n + 4);
                int n4 = n + 8;
                for (int i = 0; i < n3; ++i) {
                    arrayList.add(AnySimpleTypeCoder.decode(byArray, n4, n2, jMFMessage));
                    n4 += 4 + ArrayUtil.readInt(byArray, n4);
                }
                return arrayList;
            }

            public Object validate(Object object, int n) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
                if (object instanceof List) {
                    return object;
                }
                if (object == null) {
                    throw new JMFSchemaViolationException("List==null");
                }
                throw new JMFSchemaViolationException(object.getClass().getName());
            }

            public Object copy(Object object, int n) throws JMFSchemaViolationException {
                return new ArrayList((List)object);
            }
        };
        AnySimpleTypeCoder = new JSCoder(){

            private int getTypeInfo(Object object) throws JMFSchemaViolationException {
                if (object == null) {
                    return 9;
                }
                if (object instanceof List) {
                    return 16;
                }
                Class<?> clazz = object.getClass();
                Integer n = (Integer)classTypes.get(clazz);
                if (n == null) {
                    throw new JMFSchemaViolationException(object.getClass().getName());
                }
                return n;
            }

            public int getEncodedLength(Object object, int n, JMFMessage jMFMessage) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
                JSBaseTypes jSBaseTypes = baseTypes[this.getTypeInfo(object)];
                return 5 + jSBaseTypes.coder.getEncodedLength(object, 0, jMFMessage);
            }

            public Object validate(Object object, int n) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
                JSBaseTypes jSBaseTypes = baseTypes[this.getTypeInfo(object)];
                return jSBaseTypes.coder.validate(object, 0);
            }

            public int encode(byte[] byArray, int n, Object object, int n2, JMFMessage jMFMessage) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
                int n3 = this.getTypeInfo(object);
                JSBaseTypes jSBaseTypes = baseTypes[n3];
                ArrayUtil.writeInt(byArray, n, 1 + jSBaseTypes.coder.getEncodedLength(object, 0, jMFMessage));
                byArray[n + 4] = (byte)n3;
                return jSBaseTypes.coder.encode(byArray, n + 5, object, 0, jMFMessage);
            }

            public Object decode(byte[] byArray, int n, int n2, JMFMessage jMFMessage) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
                byte by = byArray[n + 4];
                return JSBaseTypes.baseTypes[by].coder.decode(byArray, n + 5, 0, jMFMessage);
            }

            public Object copy(Object object, int n) throws JMFSchemaViolationException {
                JSBaseTypes jSBaseTypes = baseTypes[this.getTypeInfo(object)];
                return jSBaseTypes.coder.copy(object, 0);
            }
        };
        QNameCoder = new JSCoder(){

            public int getEncodedLength(Object object, int n, JMFMessage jMFMessage) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
                String string = null;
                String string2 = null;
                String string3 = null;
                if (object != null) {
                    QName qName = (QName)object;
                    string = qName.getNamespaceURI();
                    string2 = qName.getLocalPart();
                    string3 = qName.getPrefix();
                }
                int n2 = StringCoder.getEncodedLength(string, n, jMFMessage) + StringCoder.getEncodedLength(string2, n, jMFMessage) + StringCoder.getEncodedLength(string3, n, jMFMessage);
                return n2;
            }

            public Object validate(Object object, int n) throws JMFSchemaViolationException {
                if (object instanceof QName || object == null) {
                    return object;
                }
                throw new JMFSchemaViolationException(object.getClass().getName());
            }

            public int encode(byte[] byArray, int n, Object object, int n2, JMFMessage jMFMessage) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
                String string = null;
                String string2 = null;
                String string3 = null;
                if (object != null) {
                    QName qName = (QName)object;
                    string = qName.getNamespaceURI();
                    string2 = qName.getLocalPart();
                    string3 = qName.getPrefix();
                }
                n = StringCoder.encode(byArray, n, string, n2, jMFMessage);
                n = StringCoder.encode(byArray, n, string2, n2, jMFMessage);
                n = StringCoder.encode(byArray, n, string3, n2, jMFMessage);
                return n;
            }

            public Object decode(byte[] byArray, int n, int n2, JMFMessage jMFMessage) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
                int n3 = n;
                int n4 = ArrayUtil.readInt(byArray, n3);
                int n5 = n3 + 4;
                if (n4 != -1) {
                    n5 += n4;
                }
                n4 = ArrayUtil.readInt(byArray, n5);
                int n6 = n5 + 4;
                if (n4 != -1) {
                    n6 += n4;
                }
                String string = (String)StringCoder.decode(byArray, n3, n2, jMFMessage);
                String string2 = (String)StringCoder.decode(byArray, n5, n2, jMFMessage);
                String string3 = (String)StringCoder.decode(byArray, n6, n2, jMFMessage);
                QName qName = new QName(string, string2, string3);
                return qName;
            }

            public Object copy(Object object, int n) {
                return object;
            }
        };
        baseTypes = new JSBaseTypes[]{null, new JSBaseTypes(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JSBaseTypes.class$("java.lang.Boolean")) : class$java$lang$Boolean, -1, 1, JSCoder.BOOLEAN), new JSBaseTypes(class$java$lang$Byte == null ? (class$java$lang$Byte = JSBaseTypes.class$("java.lang.Byte")) : class$java$lang$Byte, -1, 1, JSCoder.BYTE), new JSBaseTypes(class$java$lang$Short == null ? (class$java$lang$Short = JSBaseTypes.class$("java.lang.Short")) : class$java$lang$Short, -1, 2, JSCoder.SHORT), new JSBaseTypes(class$java$lang$Character == null ? (class$java$lang$Character = JSBaseTypes.class$("java.lang.Character")) : class$java$lang$Character, -1, 2, JSCoder.CHAR), new JSBaseTypes(class$java$lang$Integer == null ? (class$java$lang$Integer = JSBaseTypes.class$("java.lang.Integer")) : class$java$lang$Integer, -1, 4, JSCoder.INT), new JSBaseTypes(class$java$lang$Long == null ? (class$java$lang$Long = JSBaseTypes.class$("java.lang.Long")) : class$java$lang$Long, -1, 8, JSCoder.LONG), new JSBaseTypes(class$java$lang$Float == null ? (class$java$lang$Float = JSBaseTypes.class$("java.lang.Float")) : class$java$lang$Float, -1, 4, JSCoder.FLOAT), new JSBaseTypes(class$java$lang$Double == null ? (class$java$lang$Double = JSBaseTypes.class$("java.lang.Double")) : class$java$lang$Double, -1, 8, JSCoder.DOUBLE), new JSBaseTypes(class$java$lang$String == null ? (class$java$lang$String = JSBaseTypes.class$("java.lang.String")) : class$java$lang$String, -1, -1, StringCoder), new JSBaseTypes(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JSBaseTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, -1, -1, DecimalCoder), new JSBaseTypes(class$java$util$Date == null ? (class$java$util$Date = JSBaseTypes.class$("java.util.Date")) : class$java$util$Date, -1, 8, DateCoder), new JSBaseTypes(array$B == null ? (array$B = JSBaseTypes.class$("[B")) : array$B, -1, -1, ByteArrayCoder), new JSBaseTypes(class$java$lang$Object == null ? (class$java$lang$Object = JSBaseTypes.class$("java.lang.Object")) : class$java$lang$Object, -1, -1, AnySimpleTypeCoder), new JSBaseTypes(class$java$math$BigInteger == null ? (class$java$math$BigInteger = JSBaseTypes.class$("java.math.BigInteger")) : class$java$math$BigInteger, -1, -1, BigIntegerCoder), new JSBaseTypes(class$com$ibm$ws$sib$mfp$jmf$JMFAddress == null ? (class$com$ibm$ws$sib$mfp$jmf$JMFAddress = JSBaseTypes.class$("com.ibm.ws.sib.mfp.jmf.JMFAddress")) : class$com$ibm$ws$sib$mfp$jmf$JMFAddress, -1, -1, IDREFCoder), new JSBaseTypes(class$java$util$List == null ? (class$java$util$List = JSBaseTypes.class$("java.util.List")) : class$java$util$List, -1, -1, SimpleListCoder), new JSBaseTypes(array$B == null ? (array$B = JSBaseTypes.class$("[B")) : array$B, 8, 9, Byte8Coder), new JSBaseTypes(array$B == null ? (array$B = JSBaseTypes.class$("[B")) : array$B, 12, 13, Byte12Coder), new JSBaseTypes(class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = JSBaseTypes.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName, -1, -1, QNameCoder)};
        xsdTypeNames = new HashMap();
        xsdTypeNames.put("boolean", new Integer(1));
        xsdTypeNames.put("byte", new Integer(2));
        xsdTypeNames.put("short", new Integer(3));
        xsdTypeNames.put("unsignedShort", new Integer(4));
        xsdTypeNames.put("int", new Integer(5));
        xsdTypeNames.put("long", new Integer(6));
        xsdTypeNames.put("float", new Integer(7));
        xsdTypeNames.put("double", new Integer(8));
        xsdTypeNames.put("string", new Integer(9));
        xsdTypeNames.put("decimal", new Integer(10));
        xsdTypeNames.put("duration", new Integer(11));
        xsdTypeNames.put("dateTime", new Integer(11));
        xsdTypeNames.put("time", new Integer(11));
        xsdTypeNames.put("date", new Integer(11));
        xsdTypeNames.put("gYearMonth", new Integer(11));
        xsdTypeNames.put("gYear", new Integer(11));
        xsdTypeNames.put("gMonthDay", new Integer(11));
        xsdTypeNames.put("gDay", new Integer(11));
        xsdTypeNames.put("gMonth", new Integer(11));
        xsdTypeNames.put("hexBinary", new Integer(12));
        xsdTypeNames.put("base64Binary", new Integer(12));
        xsdTypeNames.put("anyURI", new Integer(9));
        xsdTypeNames.put("QName", new Integer(19));
        xsdTypeNames.put("NOTATION", new Integer(9));
        xsdTypeNames.put("normalizedString", new Integer(9));
        xsdTypeNames.put("token", new Integer(9));
        xsdTypeNames.put("language", new Integer(9));
        xsdTypeNames.put("NMTOKEN", new Integer(9));
        xsdTypeNames.put("NMTOKENS", new Integer(16));
        xsdTypeNames.put("Name", new Integer(9));
        xsdTypeNames.put("NCName", new Integer(9));
        xsdTypeNames.put("ID", new Integer(9));
        xsdTypeNames.put("IDREF", new Integer(15));
        xsdTypeNames.put("IDREFS", new Integer(16));
        xsdTypeNames.put("ENTITY", new Integer(9));
        xsdTypeNames.put("ENTITIES", new Integer(16));
        xsdTypeNames.put("integer", new Integer(14));
        xsdTypeNames.put("positiveInteger", new Integer(14));
        xsdTypeNames.put("nonPositiveInteger", new Integer(14));
        xsdTypeNames.put("negativeInteger", new Integer(14));
        xsdTypeNames.put("nonNegativeInteger", new Integer(14));
        xsdTypeNames.put("unsignedLong", new Integer(14));
        xsdTypeNames.put("unsignedInt", new Integer(6));
        xsdTypeNames.put("anySimpleType", new Integer(13));
        xsdTypeNames.put("byte8", new Integer(17));
        xsdTypeNames.put("byte12", new Integer(18));
        classTypes = new HashMap();
        for (int i = baseTypes.length - 1; i > 0; --i) {
            classTypes.put(JSBaseTypes.baseTypes[i].javaClass, new Integer(i));
        }
        classTypes.put(Boolean.TYPE, new Integer(1));
        classTypes.put(Byte.TYPE, new Integer(2));
        classTypes.put(Short.TYPE, new Integer(3));
        classTypes.put(Character.TYPE, new Integer(4));
        classTypes.put(Integer.TYPE, new Integer(5));
        classTypes.put(Long.TYPE, new Integer(6));
        classTypes.put(Float.TYPE, new Integer(7));
        classTypes.put(Double.TYPE, new Integer(8));
    }

    private static class ByteFixedCoder
    implements JSCoder {
        private int size;

        ByteFixedCoder(int n) {
            this.size = n;
        }

        public int getEncodedLength(Object object, int n, JMFMessage jMFMessage) {
            return this.size + 1;
        }

        public Object validate(Object object, int n) throws JMFSchemaViolationException {
            if (object == null) {
                return object;
            }
            if (object instanceof byte[]) {
                if (((byte[])object).length == this.size) {
                    return object;
                }
                throw new JMFSchemaViolationException("byte" + this.size + " size: " + ((byte[])object).length);
            }
            throw new JMFSchemaViolationException(object.getClass().getName());
        }

        public int encode(byte[] byArray, int n, Object object, int n2, JMFMessage jMFMessage) {
            if (object == null) {
                byArray[n] = 0;
            } else {
                byArray[n] = (byte)this.size;
                System.arraycopy((byte[])object, 0, byArray, n + 1, this.size);
            }
            return n + 1 + this.size;
        }

        public Object decode(byte[] byArray, int n, int n2, JMFMessage jMFMessage) throws JMFMessageCorruptionException {
            byte by = byArray[n];
            if (by == 0) {
                return null;
            }
            if (by != this.size) {
                throw new JMFMessageCorruptionException("Bad length: " + by + " at offset " + n);
            }
            byte[] byArray2 = new byte[this.size];
            System.arraycopy(byArray, n + 1, byArray2, 0, this.size);
            return byArray2;
        }

        public Object copy(Object object, int n) {
            return object;
        }
    }
}

