/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.mfp.jmf.JMFSchemaViolationException;
import com.ibm.ws.sib.mfp.jmf.JMFType;
import com.ibm.ws.sib.mfp.jmf.impl.JSDynamic;
import com.ibm.ws.sib.mfp.jmf.impl.JSEnum;
import com.ibm.ws.sib.mfp.jmf.impl.JSField;
import com.ibm.ws.sib.mfp.jmf.impl.JSPrimitive;
import com.ibm.ws.sib.mfp.jmf.impl.JSRepeated;
import com.ibm.ws.sib.mfp.jmf.impl.JSTuple;
import com.ibm.ws.sib.mfp.jmf.impl.JSType;
import com.ibm.ws.sib.mfp.jmf.impl.JSVariant;
import com.ibm.ws.sib.mfp.jmf.impl.JSchema;
import com.ibm.ws.sib.mfp.util.ArrayUtil;
import com.ibm.ws.sib.mfp.util.HashedArray;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class CompatibilityMap
implements HashedArray.Element {
    private static TraceComponent tc = SibTr.register(class$com$ibm$ws$sib$mfp$jmf$impl$CompatibilityMap == null ? (class$com$ibm$ws$sib$mfp$jmf$impl$CompatibilityMap = CompatibilityMap.class$("com.ibm.ws.sib.mfp.jmf.impl.CompatibilityMap")) : class$com$ibm$ws$sib$mfp$jmf$impl$CompatibilityMap, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    public long accessSchemaId;
    public int[] indices;
    public int varBias;
    public int[][] setCases;
    public int[][] getCases;
    private byte[] encodedForm;
    static /* synthetic */ Class class$com$ibm$ws$sib$mfp$jmf$impl$CompatibilityMap;

    public CompatibilityMap(byte[] byArray, int n, int n2) {
        int n3;
        int[] nArray;
        int n4;
        int n5;
        this.encodedForm = new byte[n2];
        System.arraycopy(byArray, n, this.encodedForm, 0, n2);
        this.accessSchemaId = ArrayUtil.readLong(byArray, n);
        int[] nArray2 = new int[]{n + 8, n + n2};
        this.indices = new int[JSType.getCount(byArray, nArray2)];
        for (n5 = 0; n5 < this.indices.length; ++n5) {
            this.indices[n5] = JSType.getCount(byArray, nArray2);
        }
        this.varBias = JSType.getCount(byArray, nArray2);
        this.setCases = new int[JSType.getCount(byArray, nArray2)][];
        for (n5 = 0; n5 < this.setCases.length; ++n5) {
            n4 = JSType.getCount(byArray, nArray2);
            if (n4 == -1) continue;
            nArray = new int[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                nArray[n3] = JSType.getCount(byArray, nArray2);
            }
            this.setCases[n5] = nArray;
        }
        this.getCases = new int[JSType.getCount(byArray, nArray2)][];
        for (n5 = 0; n5 < this.getCases.length; ++n5) {
            n4 = JSType.getCount(byArray, nArray2);
            if (n4 == -1) continue;
            nArray = new int[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                nArray[n3] = JSType.getCount(byArray, nArray2);
            }
            this.getCases[n5] = nArray;
        }
    }

    public byte[] toEncodedForm() {
        if (this.encodedForm == null) {
            this.encodedForm = new byte[this.encodedSize()];
            ArrayUtil.writeLong(this.encodedForm, 0, this.accessSchemaId);
            this.encode(this.encodedForm, new int[]{8, this.encodedForm.length});
        }
        return this.encodedForm;
    }

    private void encode(byte[] byArray, int[] nArray) {
        int n;
        int[] nArray2;
        int n2;
        JSType.setCount(byArray, nArray, this.indices.length);
        for (n2 = 0; n2 < this.indices.length; ++n2) {
            JSType.setCount(byArray, nArray, this.indices[n2]);
        }
        JSType.setCount(byArray, nArray, this.varBias);
        JSType.setCount(byArray, nArray, this.setCases.length);
        for (n2 = 0; n2 < this.setCases.length; ++n2) {
            nArray2 = this.setCases[n2];
            if (nArray2 == null) {
                JSType.setCount(byArray, nArray, -1);
                continue;
            }
            JSType.setCount(byArray, nArray, nArray2.length);
            for (n = 0; n < nArray2.length; ++n) {
                JSType.setCount(byArray, nArray, nArray2[n]);
            }
        }
        JSType.setCount(byArray, nArray, this.getCases.length);
        for (n2 = 0; n2 < this.getCases.length; ++n2) {
            nArray2 = this.getCases[n2];
            if (nArray2 == null) {
                JSType.setCount(byArray, nArray, -1);
                continue;
            }
            JSType.setCount(byArray, nArray, nArray2.length);
            for (n = 0; n < nArray2.length; ++n) {
                JSType.setCount(byArray, nArray, nArray2[n]);
            }
        }
    }

    private int encodedSize() {
        int[] nArray;
        int n;
        int n2 = 16 + 2 * this.indices.length;
        for (n = 0; n < this.setCases.length; ++n) {
            nArray = this.setCases[n];
            n2 += 2;
            if (nArray == null) continue;
            n2 += 2 * nArray.length;
        }
        for (n = 0; n < this.getCases.length; ++n) {
            nArray = this.getCases[n];
            n2 += 2;
            if (nArray == null) continue;
            n2 += 2 * nArray.length;
        }
        return n2;
    }

    public CompatibilityMap(JSchema jSchema, JSchema jSchema2) throws JMFSchemaViolationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "CompatibilityMap");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "access Schema:   " + jSchema.getJMFType());
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "encoding Schema: " + jSchema2.getJMFType());
        }
        this.accessSchemaId = jSchema.getID();
        this.indices = new int[jSchema.getFields().length + jSchema.getVariants().length];
        this.varBias = jSchema2.getFields().length;
        this.setCases = new int[jSchema2.getVariants().length][];
        this.getCases = new int[this.setCases.length][];
        for (int i = 0; i < this.indices.length; ++i) {
            this.indices[i] = -1;
        }
        this.recordCompatibilityInfo(jSchema.getJMFType(), jSchema, jSchema2.getJMFType(), jSchema2);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "CompatibilityMap");
        }
    }

    private static void violation(JMFType jMFType, JMFType jMFType2) throws JMFSchemaViolationException {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Violation:  from = " + jMFType.getFeatureName() + " : " + jMFType + ", to = " + jMFType2.getFeatureName() + " : " + jMFType2);
        }
        throw new JMFSchemaViolationException(jMFType.getFeatureName() + " not compatible with " + jMFType2.getFeatureName());
    }

    private void recordCompatibilityInfo(JMFType jMFType, JSchema jSchema, JMFType jMFType2, JSchema jSchema2) throws JMFSchemaViolationException {
        if (jMFType instanceof JSPrimitive) {
            if (jMFType2 instanceof JSPrimitive) {
                this.recordCompatibilityInfo((JSPrimitive)jMFType, jSchema, (JSPrimitive)jMFType2, jSchema2);
            } else if (jMFType2 instanceof JSVariant) {
                this.checkForDeletingVariant(jMFType, (JSVariant)jMFType2, false, jSchema, jSchema2);
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Compatibility violation (type mismatch) for JSPrimitive");
                }
                CompatibilityMap.violation(jMFType, jMFType2);
            }
        } else if (jMFType instanceof JSEnum) {
            if (jMFType2 instanceof JSEnum) {
                this.recordCompatibilityInfo((JSEnum)jMFType, jSchema, (JSEnum)jMFType2, jSchema2);
            } else if (jMFType2 instanceof JSVariant) {
                this.checkForDeletingVariant(jMFType, (JSVariant)jMFType2, false, jSchema, jSchema2);
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Compatibility violation (type mismatch) for JSEnum");
                }
                CompatibilityMap.violation(jMFType, jMFType2);
            }
        } else if (jMFType instanceof JSDynamic) {
            if (jMFType2 instanceof JSDynamic) {
                this.recordOnePair((JSField)jMFType, jSchema, (JSField)jMFType2, jSchema2);
            } else if (jMFType2 instanceof JSVariant) {
                this.checkForDeletingVariant(jMFType, (JSVariant)jMFType2, false, jSchema, jSchema2);
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Compatibility violation (type mismatch) for JSDynamic");
                }
                CompatibilityMap.violation(jMFType, jMFType2);
            }
        } else if (jMFType instanceof JSRepeated) {
            if (jMFType2 instanceof JSRepeated) {
                this.recordCompatibilityInfo(((JSRepeated)jMFType).getItemType(), jSchema, ((JSRepeated)jMFType2).getItemType(), jSchema2);
            } else if (jMFType2 instanceof JSVariant) {
                this.checkForDeletingVariant(jMFType, (JSVariant)jMFType2, false, jSchema, jSchema2);
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Compatibility violation (type mismatch) for JSRepeated");
                }
                CompatibilityMap.violation(jMFType, jMFType2);
            }
        } else if (jMFType instanceof JSTuple) {
            if (jMFType2 instanceof JSTuple) {
                this.recordCompatibilityInfo((JSTuple)jMFType, jSchema, (JSTuple)jMFType2, jSchema2);
            } else if (jMFType2 instanceof JSVariant) {
                this.checkForDeletingVariant(jMFType, (JSVariant)jMFType2, false, jSchema, jSchema2);
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Compatibility violation (type mismatch) for JSTuple");
                }
                CompatibilityMap.violation(jMFType, jMFType2);
            }
        } else if (jMFType instanceof JSVariant) {
            JSVariant jSVariant = (JSVariant)jMFType;
            if (jMFType2 instanceof JSVariant) {
                JSVariant jSVariant2 = (JSVariant)jMFType2;
                this.recordCompatibilityInfo(jSVariant, jSchema, jSVariant2, jSchema2);
            } else {
                this.checkForDeletingVariant(jMFType2, jSVariant, true, jSchema, jSchema2);
            }
        }
    }

    private void recordCompatibilityInfo(JSPrimitive jSPrimitive, JSchema jSchema, JSPrimitive jSPrimitive2, JSchema jSchema2) throws JMFSchemaViolationException {
        if (jSPrimitive.getTypeCode() == jSPrimitive2.getTypeCode()) {
            this.recordOnePair(jSPrimitive, jSchema, jSPrimitive2, jSchema2);
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Compatibility violation (primitive type mismatch): access " + jSPrimitive + ", access TypeCode " + jSPrimitive.getTypeCode() + ", encoding " + jSPrimitive2 + ", encoding TypeCode " + jSPrimitive2.getTypeCode());
            }
            CompatibilityMap.violation(jSPrimitive, jSPrimitive2);
        }
    }

    private void recordCompatibilityInfo(JSEnum jSEnum, JSchema jSchema, JSEnum jSEnum2, JSchema jSchema2) throws JMFSchemaViolationException {
        if (jSEnum.getEnumeratorCount() == jSEnum2.getEnumeratorCount()) {
            this.recordOnePair(jSEnum, jSchema, jSEnum2, jSchema2);
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Compatibility violation (enumeration type mismatch): access " + jSEnum + ", access EnumeratorCount " + jSEnum.getEnumeratorCount() + ", encoding " + jSEnum2 + ", encoding EnumeratorCount " + jSEnum2.getEnumeratorCount());
            }
            CompatibilityMap.violation(jSEnum, jSEnum2);
        }
    }

    private void recordOnePair(JSField jSField, JSchema jSchema, JSField jSField2, JSchema jSchema2) {
        int n = jSField.getAccessor(jSchema);
        if (n >= this.indices.length) {
            return;
        }
        this.indices[n] = jSField2.getAccessor(jSchema2);
    }

    private boolean isEmpty(JMFType jMFType) {
        return jMFType instanceof JSTuple && ((JSTuple)jMFType).getFieldCount() == 0;
    }

    private void checkForDeletingVariant(JMFType jMFType, JSVariant jSVariant, boolean bl, JSchema jSchema, JSchema jSchema2) throws JMFSchemaViolationException {
        if (jSVariant.getCaseCount() != 2) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Compatibility violation (deleting variant): var CaseCount = " + jSVariant.getCaseCount() + ", varIsAccess " + bl);
            }
            if (bl) {
                CompatibilityMap.violation(jSVariant, jMFType);
            } else {
                CompatibilityMap.violation(jMFType, jSVariant);
            }
        }
        if (this.isEmpty(jSVariant.getCase(1))) {
            JMFType jMFType2 = jSVariant.getCase(0);
            if (bl) {
                this.recordCompatibilityInfo(jMFType2, jSchema, jMFType, jSchema2);
            } else {
                this.recordCompatibilityInfo(jMFType, jSchema, jMFType2, jSchema2);
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Compatibility violation (deleting variant): var Case(1) not empty");
            }
            if (bl) {
                CompatibilityMap.violation(jSVariant, jMFType);
            } else {
                CompatibilityMap.violation(jMFType, jSVariant);
            }
        }
    }

    private void recordCompatibilityInfo(JSVariant jSVariant, JSchema jSchema, JSVariant jSVariant2, JSchema jSchema2) throws JMFSchemaViolationException {
        int n;
        int n2;
        int n3 = jSVariant.getBoxAccessor(jSchema);
        int n4 = jSVariant2.getBoxAccessor(jSchema2);
        if (n3 != -1 && n4 != -1) {
            if (n3 < this.indices.length) {
                this.indices[n3] = n4;
            }
        } else if (n3 != -1 || n4 != -1) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Compatibility violation (variants): box mismatch " + n3 + " != " + n4);
            }
            CompatibilityMap.violation(jSVariant, jSVariant2);
        } else {
            this.recordOnePair(jSVariant, jSchema, jSVariant2, jSchema2);
        }
        if (!((n2 = jSVariant.getCaseCount()) == (n = jSVariant2.getCaseCount()) || this.isEmpty(jSVariant.getCase(0)) && this.isEmpty(jSVariant2.getCase(0)))) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Compatibility violation (variants): mismatch case count plus first not empty");
            }
            CompatibilityMap.violation(jSVariant, jSVariant2);
        }
        int n5 = jSVariant2.getAccessor(jSchema2) - this.varBias;
        int[] nArray = null;
        int[] nArray2 = null;
        if (n5 < this.getCases.length) {
            nArray2 = new int[n];
            this.getCases[n5] = nArray2;
            nArray = new int[n2];
            this.setCases[n5] = nArray;
        }
        for (int i = 0; i < (n2 > n ? n : n2); ++i) {
            if (nArray != null) {
                nArray[i] = i;
                nArray2[i] = i;
            }
            this.recordCompatibilityInfo(jSVariant.getCase(i), jSchema, jSVariant2.getCase(i), jSchema2);
        }
    }

    private void recordCompatibilityInfo(JSTuple jSTuple, JSchema jSchema, JSTuple jSTuple2, JSchema jSchema2) throws JMFSchemaViolationException {
        int n;
        int n2;
        int n3 = jSTuple.getFieldCount();
        int n4 = n2 = n3 < (n = jSTuple2.getFieldCount()) ? n3 : n;
        if (n3 > n2) {
            CompatibilityMap.checkExtraFields(jSTuple, n2, n3);
        } else if (n > n2) {
            CompatibilityMap.checkExtraFields(jSTuple2, n2, n);
        }
        for (int i = 0; i < n2; ++i) {
            this.recordCompatibilityInfo(jSTuple.getField(i), jSchema, jSTuple2.getField(i), jSchema2);
        }
    }

    private static void checkExtraFields(JSTuple jSTuple, int n, int n2) throws JMFSchemaViolationException {
        for (int i = n; i < n2; ++i) {
            JMFType jMFType;
            JMFType jMFType2 = jSTuple.getField(i);
            if (jMFType2 instanceof JSVariant && (jMFType = ((JSVariant)jMFType2).getCase(0)) instanceof JSTuple && ((JSTuple)jMFType).getFieldCount() == 0) continue;
            throw new JMFSchemaViolationException(jMFType2.getFeatureName() + " not defaulting variant");
        }
    }

    public long getIndex() {
        return this.accessSchemaId;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.jmf/src/com/ibm/ws/sib/mfp/jmf/impl/CompatibilityMap.java, SIB.mfp, WAS602.SIB, o0610.11 1.11");
        }
    }
}

