/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsJmsBytesMessage;
import com.ibm.ws.sib.mfp.JsJmsMapMessage;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.JsJmsObjectMessage;
import com.ibm.ws.sib.mfp.JsJmsStreamMessage;
import com.ibm.ws.sib.mfp.JsJmsTextMessage;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.mfp.WebJsMessageEncoder;
import com.ibm.ws.sib.mfp.impl.JsJmsMapMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsJmsStreamMessageImpl;
import com.ibm.ws.sib.mfp.impl.MessageImpl;
import com.ibm.ws.sib.mfp.util.HexString;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WebJsJmsMessageEncoderImpl
implements WebJsMessageEncoder {
    private static TraceComponent tc = SibTr.register(class$com$ibm$ws$sib$mfp$impl$WebJsJmsMessageEncoderImpl == null ? (class$com$ibm$ws$sib$mfp$impl$WebJsJmsMessageEncoderImpl = WebJsJmsMessageEncoderImpl.class$("com.ibm.ws.sib.mfp.impl.WebJsJmsMessageEncoderImpl")) : class$com$ibm$ws$sib$mfp$impl$WebJsJmsMessageEncoderImpl, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private JsJmsMessage jmsMsg;
    static /* synthetic */ Class class$com$ibm$ws$sib$mfp$impl$WebJsJmsMessageEncoderImpl;

    WebJsJmsMessageEncoderImpl(JsJmsMessage jsJmsMessage) {
        this.jmsMsg = jsJmsMessage;
    }

    public String encodeForWebClient() throws MessageEncodeFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "encodeForWebClient");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Encoding Web Message", (Object)((MessageImpl)((Object)this.jmsMsg)).debugMsg());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(1);
        stringBuffer.append('~');
        byte[] byArray = this.jmsMsg.getCorrelationIdAsBytes();
        if (byArray != null) {
            HexString.binToHex(byArray, 0, byArray.length, stringBuffer);
        }
        stringBuffer.append('~');
        String string = this.jmsMsg.getJmsxAppId();
        if (string == null || string.equals("Service Integration Bus")) {
            string = "SIB";
        }
        this.URLEncode(stringBuffer, string);
        stringBuffer.append('~');
        stringBuffer.append(this.jmsMsg.getFormat());
        stringBuffer.append('~');
        String string2 = this.jmsMsg.getDiscriminator();
        if (string2 != null) {
            this.URLEncode(stringBuffer, string2);
        }
        stringBuffer.append('~');
        Set set = this.jmsMsg.getPropertyNameSet();
        boolean bl = true;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            Object object = this.jmsMsg.getObjectProperty(string3);
            if (object == null) continue;
            this.encodePair(stringBuffer, string3, object, bl);
            bl = false;
        }
        if (this.jmsMsg instanceof JsJmsTextMessage) {
            this.encodeTextBody(stringBuffer, (JsJmsTextMessage)this.jmsMsg);
        } else if (this.jmsMsg instanceof JsJmsBytesMessage) {
            this.encodeBytesBody(stringBuffer, (JsJmsBytesMessage)this.jmsMsg);
        } else if (this.jmsMsg instanceof JsJmsObjectMessage) {
            this.encodeObjectBody(stringBuffer, (JsJmsObjectMessage)this.jmsMsg);
        } else if (this.jmsMsg instanceof JsJmsStreamMessage) {
            this.encodeStreamBody(stringBuffer, (JsJmsStreamMessage)this.jmsMsg);
        } else if (this.jmsMsg instanceof JsJmsMapMessage) {
            this.encodeMapBody(stringBuffer, (JsJmsMapMessage)this.jmsMsg);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Encoded as web data", stringBuffer);
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "encodeForWebClient");
        }
        return stringBuffer.toString();
    }

    private void encodeTextBody(StringBuffer stringBuffer, JsJmsTextMessage jsJmsTextMessage) {
        String string;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "encodeTextBody");
        }
        if ((string = jsJmsTextMessage.getText()) != null) {
            stringBuffer.append('~');
            this.URLEncode(stringBuffer, string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "encodeTextBody");
        }
    }

    private void encodeBytesBody(StringBuffer stringBuffer, JsJmsBytesMessage jsJmsBytesMessage) {
        byte[] byArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "encodeBytesBody");
        }
        if ((byArray = jsJmsBytesMessage.getBytes()) != null) {
            stringBuffer.append('~');
            HexString.binToHex(byArray, 0, byArray.length, stringBuffer);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "encodeBytesBody");
        }
    }

    private void encodeObjectBody(StringBuffer stringBuffer, JsJmsObjectMessage jsJmsObjectMessage) {
        byte[] byArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "encodeObjectBody");
        }
        if ((byArray = jsJmsObjectMessage.getSerializedObject()) != null) {
            stringBuffer.append('~');
            HexString.binToHex(byArray, 0, byArray.length, stringBuffer);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "encodeObjectBody");
        }
    }

    private void encodeStreamBody(StringBuffer stringBuffer, JsJmsStreamMessage jsJmsStreamMessage) {
        List list;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "encodeStreamBody");
        }
        if ((list = ((JsJmsStreamMessageImpl)jsJmsStreamMessage).getBodyList()).size() > 0) {
            stringBuffer.append('~');
            for (int i = 0; i < list.size(); ++i) {
                this.encodeObject(stringBuffer, list.get(i));
                if (i >= list.size() - 1) continue;
                stringBuffer.append('&');
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "encodeStreamBody");
        }
    }

    private void encodeMapBody(StringBuffer stringBuffer, JsJmsMapMessage jsJmsMapMessage) {
        Map map;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "encodeMapBody");
        }
        if ((map = ((JsJmsMapMessageImpl)jsJmsMapMessage).getBodyMap()).size() > 0) {
            stringBuffer.append('~');
            Set set = map.entrySet();
            boolean bl = true;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.encodePair(stringBuffer, (String)entry.getKey(), entry.getValue(), bl);
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "encodeMapBody");
        }
    }

    private void encodePair(StringBuffer stringBuffer, String string, Object object, boolean bl) {
        if (!bl) {
            stringBuffer.append('&');
        }
        this.URLEncode(stringBuffer, string);
        stringBuffer.append('=');
        this.encodeObject(stringBuffer, object);
    }

    private void encodeObject(StringBuffer stringBuffer, Object object) {
        if (object != null) {
            if (object instanceof byte[]) {
                stringBuffer.append("[]");
                HexString.binToHex((byte[])object, 0, ((byte[])object).length, stringBuffer);
            } else {
                this.URLEncode(stringBuffer, object.toString());
            }
        }
    }

    private void URLEncode(StringBuffer stringBuffer, String string) {
        try {
            String string2 = URLEncoder.encode(string, "UTF8");
            if (string2.indexOf(43) != -1) {
                string2 = string2.replaceAll("\\+", "%20");
            }
            stringBuffer.append(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.sib.mfp.impl.WebJsJmsMessageEncoderImpl.URLEncode", (String)"261");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.impl/src/com/ibm/ws/sib/mfp/impl/WebJsJmsMessageEncoderImpl.java, SIB.mfp, WAS602.SIB, o0610.11 1.7");
        }
    }
}

