/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.sdo.config.repository.impl.RepositoryRuntimeException;
import com.ibm.ws.sib.mfp.JsSdoMessage;
import com.ibm.ws.sib.mfp.MfpConstants;
import com.ibm.ws.sib.mfp.jmf.JMFMessage;
import com.ibm.ws.sib.mfp.jmf.tools.JSFormatter;
import com.ibm.ws.sib.mfp.sdo.OutputHelper;
import com.ibm.ws.sib.mfp.sdo.SdoStore;
import com.ibm.ws.sib.mfp.sdo.resource.ResourceException;
import com.ibm.ws.sib.utils.ffdc.SibDiagnosticModule;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sdo.config.repository.SDORepository;
import commonj.sdo.DataGraph;
import java.util.Iterator;
import java.util.List;

public class MfpDiagnostics
extends SibDiagnosticModule {
    private static TraceComponent tc = SibTr.register(class$com$ibm$ws$sib$mfp$impl$MfpDiagnostics == null ? (class$com$ibm$ws$sib$mfp$impl$MfpDiagnostics = MfpDiagnostics.class$("com.ibm.ws.sib.mfp.impl.MfpDiagnostics")) : class$com$ibm$ws$sib$mfp$impl$MfpDiagnostics, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static MfpDiagnostics singleton;
    private static String[] packageList;
    private static final int BUFFER_MAX = 4096;
    static /* synthetic */ Class class$com$ibm$ws$sib$mfp$impl$MfpDiagnostics;

    private MfpDiagnostics() {
    }

    public static MfpDiagnostics initialize() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "initialize");
        }
        if (singleton == null) {
            singleton = new MfpDiagnostics();
            singleton.register(packageList);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "initialize");
        }
        return singleton;
    }

    public void ffdcDumpDefault(Throwable throwable, IncidentStream incidentStream, Object object, Object[] objectArray, String string) {
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "ffdcDumpDefault");
        }
        super.captureDefaultInformation(incidentStream);
        if (object instanceof SdoStore) {
            object2 = ((SdoStore)object).dumpState();
            incidentStream.writeLine("SdoStore", (String)object2);
        }
        if (throwable instanceof ResourceException || throwable instanceof RepositoryRuntimeException) {
            object2 = SDORepository.instance();
            if (object2 == null) {
                incidentStream.writeLine("Contents of repository", "no repository instance available");
            } else {
                List list = ((SDORepository)object2).listResources();
                if (list == null) {
                    incidentStream.writeLine("Contents of repository", "null resource list");
                } else {
                    Iterator iterator = list.iterator();
                    incidentStream.writeLine("Contents of repository", "");
                    StringBuffer stringBuffer = new StringBuffer();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (e == null || !(e instanceof String)) continue;
                        stringBuffer.append((String)e);
                        stringBuffer.append("\n");
                    }
                    incidentStream.writeLine("locations:", (Object)stringBuffer);
                }
            }
        }
        if (objectArray != null && objectArray.length > 0) {
            if (objectArray[0] instanceof Object[]) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!(objectArray[i] instanceof Object[])) continue;
                    this.dumpUsefulStuff(incidentStream, (Object[])objectArray[i]);
                }
            } else {
                this.dumpUsefulStuff(incidentStream, objectArray);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "ffdcDumpDefault");
        }
    }

    private void dumpUsefulStuff(IncidentStream incidentStream, Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            if (objectArray[0] == MfpConstants.DM_BUFFER && objectArray.length >= 4) {
                this.dumpJmfBuffer(incidentStream, (byte[])objectArray[1], (Integer)objectArray[2], (Integer)objectArray[3]);
            } else if (objectArray[0] == MfpConstants.DM_MESSAGE && objectArray.length >= 2) {
                this.dumpJmfMessage(incidentStream, (JMFMessage)objectArray[1], objectArray[2]);
            }
        }
    }

    private void dumpJmfBuffer(IncidentStream incidentStream, byte[] byArray, int n, int n2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "dumpJmfBuffer");
        }
        if (byArray != null) {
            if (n + n2 > byArray.length) {
                n2 = byArray.length - n;
            }
            try {
                String string = SibTr.formatBytes(byArray, n, n2 > 4096 ? 4096 : n2);
                incidentStream.writeLine("JMF data buffer", string);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "dumpJmfBuffer failed: " + exception);
                }
            }
        } else {
            incidentStream.writeLine("No JMF buffer data available", "");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "dumpJmfBuffer");
        }
    }

    private void dumpJmfMessage(IncidentStream incidentStream, JMFMessage jMFMessage, Object object) {
        block8: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "dumpJmfMessage");
            }
            if (object != null) {
                incidentStream.writeLine("Message is of class: ", object.getClass().getName());
            }
            if (jMFMessage != null) {
                try {
                    String string = JSFormatter.format(jMFMessage);
                    incidentStream.writeLine("JMF message", string);
                    if (object == null || !(object instanceof JsSdoMessage)) break block8;
                    DataGraph dataGraph = ((JsSdoMessage)object).getDataGraph();
                    if (dataGraph != null) {
                        string = OutputHelper.trace(dataGraph);
                        incidentStream.writeLine("SDO payload", string);
                        break block8;
                    }
                    incidentStream.writeLine("No SDO payload available", "");
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "dumpJmfMessage failed: " + exception);
                    }
                    break block8;
                }
            }
            incidentStream.writeLine("No JMF message available", "");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "dumpJmfMessage");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.impl/src/com/ibm/ws/sib/mfp/impl/MfpDiagnostics.java, SIB.mfp, WAS602.SIB, o0610.11 1.16");
        }
        singleton = null;
        packageList = new String[]{"com.ibm.ws.sib.mfp"};
    }
}

