/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jms.MQRequestReplyUtils;
import com.ibm.ws.sib.mfp.JmsBodyType;
import com.ibm.ws.sib.mfp.JsApiMessage;
import com.ibm.ws.sib.mfp.JsJmsBytesMessage;
import com.ibm.ws.sib.mfp.JsJmsMapMessage;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.JsJmsMessageFactory;
import com.ibm.ws.sib.mfp.JsJmsObjectMessage;
import com.ibm.ws.sib.mfp.JsJmsStreamMessage;
import com.ibm.ws.sib.mfp.JsJmsTextMessage;
import com.ibm.ws.sib.mfp.PersistenceType;
import com.ibm.ws.sib.mfp.impl.JsApiMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsJmsMessageFactoryImpl;
import com.ibm.ws.sib.mfp.impl.MQJsApiMessageEncoderImpl;
import com.ibm.ws.sib.mfp.impl.MessageImpl;
import com.ibm.ws.sib.mfp.jmf.JMFException;
import com.ibm.ws.sib.mfp.mqcontrol.MQBrokerCommand;
import com.ibm.ws.sib.mfp.mqcontrol.MQPublicationInfo;
import com.ibm.ws.sib.mfp.mqimpl.ByteBufferArrayInputStream;
import com.ibm.ws.sib.mfp.mqimpl.DestinationAddressEncoder;
import com.ibm.ws.sib.mfp.mqimpl.MA88ElementWriter;
import com.ibm.ws.sib.mfp.mqimpl.MQJmsMessageEncapsulation;
import com.ibm.ws.sib.mfp.mqimpl.MQJsApiEncapsulation;
import com.ibm.ws.sib.mfp.mqimpl.resolver.MQJmsPropertiesMap;
import com.ibm.ws.sib.mfp.mqinterop.ByteBufferDataOutput;
import com.ibm.ws.sib.mfp.mqinterop.CCSID;
import com.ibm.ws.sib.mfp.mqinterop.MQBufferedHeader;
import com.ibm.ws.sib.mfp.mqinterop.MQHeaderContext;
import com.ibm.ws.sib.mfp.mqinterop.MQHeaderFactory;
import com.ibm.ws.sib.mfp.mqinterop.api.MQMD1;
import com.ibm.ws.sib.mfp.mqinterop.api.MQMDE;
import com.ibm.ws.sib.mfp.mqinterop.api.MQRFH2;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class MQJsJmsMessageEncoderImpl
extends MQJsApiMessageEncoderImpl {
    private static final TraceComponent tc = SibTr.register(class$com$ibm$ws$sib$mfp$impl$MQJsJmsMessageEncoderImpl == null ? (class$com$ibm$ws$sib$mfp$impl$MQJsJmsMessageEncoderImpl = MQJsJmsMessageEncoderImpl.class$("com.ibm.ws.sib.mfp.impl.MQJsJmsMessageEncoderImpl")) : class$com$ibm$ws$sib$mfp$impl$MQJsJmsMessageEncoderImpl, null, null);
    public static final String $ssccid = "@(#) 1.73 SIB/ws/code/sib.mfp.impl/src/com/ibm/ws/sib/mfp/impl/MQJsJmsMessageEncoderImpl.java, SIB.mfp, WAS602.SIB, o0610.11 05/05/23 12:40:42 [3/13/06 13:57:01]";
    static final int TSH_SIZE = 28;
    static final int MSH_SIZE = 20;
    static final int MQAPI_SIZE = 16;
    static final int XQH_SIZE = 428;
    static final int MQMD1_SIZE = 324;
    static final String PROVIDER_SPECIFIC_PROPERTY_PREFIX = "JMS_";
    static final DateFormat pubTimeFormat = new SimpleDateFormat("yyyyMMddHHmmssSS");
    private static final JsJmsMessageFactoryImpl jmsFactory = MQJsJmsMessageEncoderImpl.getJmsFactory();
    static /* synthetic */ Class class$com$ibm$ws$sib$mfp$impl$MQJsJmsMessageEncoderImpl;

    private static JsJmsMessageFactoryImpl getJmsFactory() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getJmsFactory");
        }
        try {
            JsJmsMessageFactoryImpl jsJmsMessageFactoryImpl = (JsJmsMessageFactoryImpl)JsJmsMessageFactory.getInstance();
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getJmsFactory", jsJmsMessageFactoryImpl);
            }
            return jsJmsMessageFactoryImpl;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mfp.impl.MQJsJmsMessageEncoderImpl.getJmsFactory", (String)"71");
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getJmsFactory", null);
            }
            return null;
        }
    }

    public MQJsJmsMessageEncoderImpl(JsJmsMessage jsJmsMessage, String string, String string2, String string3, String string4, int n, int n2) {
        super(jsJmsMessage, string, string2, string3, string4, n, n2);
    }

    public final InputStream getMQMessageBodyStream(MQMD1 mQMD1, MQMDE mQMDE, boolean bl) throws IOException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getMQMessageBodyStream", new Object[]{this, mQMD1, mQMDE, new Boolean(bl)});
        }
        Object object2 = ((MessageImpl)((Object)this.message)).jmo.getField(9);
        Object object3 = ((MessageImpl)((Object)this.message)).jmo.getPayloadPart().getField(1);
        MQRFH2 mQRFH2 = this.getRFH(mQMD1, mQMDE, bl);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        MQBufferedHeader mQBufferedHeader = mQMD1;
        if (mQMDE != null) {
            object = ByteBuffer.allocate(mQMDE.size());
            mQMDE.write(new ByteBufferDataOutput((ByteBuffer)object), mQMD1.nextEncoding(), mQMD1.nextCharacterSet());
            arrayList.add(object);
            mQBufferedHeader = mQMDE;
        }
        if (mQRFH2 != null) {
            this.updateRFH(mQRFH2, this.message);
            object = ByteBuffer.allocate(mQRFH2.size());
            mQRFH2.write(new ByteBufferDataOutput((ByteBuffer)object), mQBufferedHeader.nextEncoding(), mQBufferedHeader.nextCharacterSet());
            arrayList.add(object);
            mQBufferedHeader = mQRFH2;
        }
        if (object3 instanceof MQJmsMessageEncapsulation) {
            object = (MQJmsMessageEncapsulation)object3;
            try {
                ((MQJmsMessageEncapsulation)object).unassemble();
            }
            catch (JMFException jMFException) {
                FFDCFilter.processException((Throwable)jMFException, (String)"com.ibm.ws.sib.mfp.impl.MQJsJmsMessageEncoderImpl.getMQMessageBodyStream", (String)"235", (Object)this);
                IOException iOException = new IOException();
                iOException.initCause(jMFException);
                throw iOException;
            }
            ByteBuffer[] byteBufferArray = ((MQJmsMessageEncapsulation)object).getBuffers();
            for (int i = 0; i < byteBufferArray.length; ++i) {
                arrayList.add(byteBufferArray[i]);
            }
        } else {
            switch (((JsJmsMessage)this.message).getBodyType().toInt()) {
                case 5: {
                    object = this.constructTextMessageBody(mQBufferedHeader);
                    break;
                }
                case 1: {
                    object = this.constructBytesMessageBody(mQBufferedHeader);
                    break;
                }
                case 3: {
                    object = this.constructObjectMessageBody(mQBufferedHeader);
                    break;
                }
                case 2: {
                    object = this.constructMapMessageBody(mQBufferedHeader);
                    break;
                }
                case 4: {
                    object = this.constructStreamMessageBody(mQBufferedHeader);
                    break;
                }
                case 0: {
                    object = new byte[0];
                    break;
                }
                default: {
                    RuntimeException runtimeException = new RuntimeException("Unknown JMS message type: " + ((JsJmsMessage)this.message).getBodyType().toInt());
                    throw runtimeException;
                }
            }
            arrayList.add(ByteBuffer.wrap((byte[])object));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "   - rfh [after write; may be null]: " + mQRFH2);
        }
        object = new ByteBufferArrayInputStream(arrayList);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getMQMessageBodyStream", object);
        }
        return object;
    }

    protected MQMD1 constructMD(JsApiMessage jsApiMessage, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "constructMD", new Object[]{this, jsApiMessage, new Boolean(bl)});
        }
        MQMD1 mQMD1 = super.constructMD(jsApiMessage, bl);
        MQPublicationInfo mQPublicationInfo = ((JsJmsMessage)jsApiMessage).getMQPublicationInfo();
        if (mQPublicationInfo != null) {
            mQMD1.setReplyToQMgr(mQPublicationInfo.getReplyQueueManagerName());
            mQMD1.setReplyToQ(mQPublicationInfo.getReplyQueueName());
        }
        if (bl) {
            mQMD1.setFormat("MQHRF2  ");
        } else if (jsApiMessage instanceof JsJmsTextMessage) {
            mQMD1.setFormat("MQSTR   ");
        }
        mQMD1.setPutApplType(31);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "constructMD", mQMD1);
        }
        return mQMD1;
    }

    protected void updateMD(MQMD1 mQMD1, JsApiMessage jsApiMessage, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "updateMD", new Object[]{this, mQMD1, jsApiMessage, new Boolean(bl)});
        }
        super.updateMD(mQMD1, jsApiMessage, bl);
        mQMD1.setPutApplName(((JsJmsMessage)jsApiMessage).getJmsxAppId());
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "updateMD");
        }
    }

    private void updateRFH(MQRFH2 mQRFH2, JsApiMessage jsApiMessage) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "updateRFH", new Object[]{this, mQRFH2, jsApiMessage});
        }
        JmsBodyType jmsBodyType = ((JsJmsMessage)jsApiMessage).getBodyType();
        switch (jmsBodyType.toInt()) {
            case 2: 
            case 4: 
            case 5: {
                mQRFH2.setFormat("MQSTR   ");
                break;
            }
            default: {
                mQRFH2.setFormat("        ");
            }
        }
        List list = jsApiMessage.getForwardRoutingPath();
        if (list != null && list.size() > 0) {
            mQRFH2.setFieldValues("sib", "Frp", DestinationAddressEncoder.getEncodedList(list));
        } else {
            object4 = mQRFH2.getFolder("sib", false);
            if (object4 != null) {
                mQRFH2.setFieldValues("sib", "Frp", null);
            }
        }
        object4 = jsApiMessage.getReverseRoutingPath();
        if (object4 != null && object4.size() > 0) {
            mQRFH2.setFieldValues("sib", "Rrp", DestinationAddressEncoder.getEncodedList((List)object4));
        } else {
            object3 = mQRFH2.getFolder("sib", false);
            if (object3 != null) {
                mQRFH2.setFieldValues("sib", "Rrp", null);
            }
        }
        object3 = ((JsJmsMessage)jsApiMessage).getJmsType();
        if (object3 != null && ((String)object3).startsWith("mcd:") && (jmsBodyType == JmsBodyType.TEXT || jmsBodyType == JmsBodyType.BYTES)) {
            this.setMcdFolderFromURI(mQRFH2.getFolder("mcd", true), (String)object3);
        } else {
            object2 = null;
            switch (jmsBodyType.toInt()) {
                case 1: {
                    object2 = "jms_bytes";
                    break;
                }
                case 5: {
                    object2 = "jms_text";
                    break;
                }
                case 4: {
                    object2 = "jms_stream";
                    break;
                }
                case 2: {
                    object2 = "jms_map";
                    break;
                }
                case 3: {
                    object2 = "jms_object";
                    break;
                }
                case 0: {
                    object2 = "jms_none";
                }
            }
            mQRFH2.setFieldValue("mcd", "Msd", object2);
            mQRFH2.setFieldValue("mcd", "Type", object3);
        }
        try {
            object2 = MQRequestReplyUtils.getInstance();
            mQRFH2.setFieldValue("jms", "Dst", ((MQRequestReplyUtils)object2).getMA88DstString((JsJmsMessage)jsApiMessage, this.targetQueueName, this.targetQMgrName));
            mQRFH2.setFieldValue("jms", "Rto", ((MQRequestReplyUtils)object2).getMA88RtoString((JsJmsMessage)jsApiMessage, this.virtualQMgrName));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mfp.impl.MQJsJmsMessageEncoderImpl.updateRFH", (String)"483", (Object)this);
        }
        if (((JsJmsMessage)jsApiMessage).getJmsDeliveryMode() == PersistenceType.PERSISTENT) {
            mQRFH2.setFieldValue("jms", "Dlv", Integer.toString(2));
        } else {
            mQRFH2.setFieldValue("jms", "Dlv", Integer.toString(1));
        }
        mQRFH2.setFieldValue("jms", "Tms", String.valueOf(jsApiMessage.getTimestamp()));
        object2 = jsApiMessage.getARMCorrelator();
        if (object2 != null) {
            mQRFH2.setFieldValue("mqema", "Arm", object2);
        }
        if ((object2 = jsApiMessage.getRMCorrelator()) != null) {
            mQRFH2.setFieldValue("mqema", "Wrm", object2);
        }
        if ((object = ((JsApiMessageImpl)jsApiMessage).getTransportVersion()) != null) {
            mQRFH2.setFieldValue("usr", "transportVersion", object, true);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "updateRFH");
        }
    }

    private MQRFH2 getRFH(MQMD1 mQMD1, MQMDE mQMDE, boolean bl) throws IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getRFH", new Object[]{this, mQMD1, mQMDE, new Boolean(bl)});
        }
        Object object = ((MessageImpl)((Object)this.message)).jmo.getField(9);
        MQRFH2 mQRFH2 = null;
        if (((JsJmsMessage)this.message).getMQPublicationInfo() != null) {
            bl = true;
        }
        if (object instanceof MQJsApiEncapsulation) {
            MQJsApiEncapsulation mQJsApiEncapsulation = (MQJsApiEncapsulation)object;
            mQRFH2 = mQJsApiEncapsulation.getPropagateRfh(mQMD1, mQMDE, bl);
        } else if (bl) {
            mQRFH2 = this.constructRFH(mQMD1, mQMDE);
        }
        if (mQRFH2 != null) {
            if (mQMDE == null) {
                mQMD1.setFormat("MQHRF2  ");
            } else {
                mQMDE.setFormat("MQHRF2  ");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getRFH", mQRFH2);
        }
        return mQRFH2;
    }

    private MQRFH2 constructRFH(MQMD1 mQMD1, MQMDE mQMDE) throws IOException {
        Object object;
        Object object2;
        String string;
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "constructRFH", new Object[]{this, mQMD1, mQMDE});
        }
        JsJmsMessage jsJmsMessage = (JsJmsMessage)this.message;
        MQHeaderFactory mQHeaderFactory = MQHeaderFactory.instance();
        MQRFH2 mQRFH2 = mQHeaderFactory.createMQRFH2();
        int n2 = this.encoding == 0 ? 273 : this.encoding;
        int n3 = n = this.characterSet == 0 ? 1208 : this.characterSet;
        if (mQMDE == null) {
            mQRFH2.setEncoding(mQMD1.nextEncoding());
            mQRFH2.setCodedCharSetId(mQMD1.nextCharacterSet());
            mQMD1.setEncoding(n2);
            mQMD1.setCodedCharSetId(n);
        } else {
            mQRFH2.setEncoding(mQMDE.nextEncoding());
            mQRFH2.setCodedCharSetId(mQMDE.nextCharacterSet());
            mQMDE.setEncoding(n2);
            mQMDE.setCodedCharSetId(n);
        }
        mQRFH2.setFieldValue("jms", "Exp", jsJmsMessage.getJmsExpiration());
        mQRFH2.setFieldValue("jms", "Dst", jsJmsMessage.getJmsDestination());
        mQRFH2.setFieldValue("jms", "Rto", jsJmsMessage.getJmsReplyTo());
        PersistenceType persistenceType = jsJmsMessage.getJmsDeliveryMode();
        if (persistenceType == PersistenceType.PERSISTENT) {
            mQRFH2.setFieldValue("jms", "Dlv", Integer.toString(1));
        } else {
            mQRFH2.setFieldValue("jms", "Dlv", Integer.toString(0));
        }
        MQJmsPropertiesMap mQJmsPropertiesMap = MQJmsPropertiesMap.instance;
        MQJsApiEncapsulation mQJsApiEncapsulation = new MQJsApiEncapsulation(mQMD1, mQRFH2, true, false);
        String string2 = mQMD1.getFormat();
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<Object> iterator = jsJmsMessage.getPropertyNameSet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object2 = jsJmsMessage.getObjectProperty(string);
            if (mQJmsPropertiesMap.isMappedProperty(string)) {
                mQJmsPropertiesMap.setValue(mQJsApiEncapsulation, string, object2);
                continue;
            }
            if (string.startsWith(PROVIDER_SPECIFIC_PROPERTY_PREFIX) || string.startsWith("JMSX") && !string.equals("JMSXGroupID") && !string.equals("JMXSGroupSeq") || string.equals("transportVersion")) continue;
            stringBuffer.append(mQHeaderFactory.createMQRFH2Element(string, object2, true).toXML());
        }
        if (stringBuffer.length() != 0) {
            mQRFH2.setFolderContent("usr", new String(stringBuffer));
        }
        stringBuffer = new StringBuffer();
        iterator = ((JsApiMessageImpl)((Object)jsJmsMessage)).getOtherUserPropertyMap().keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object2 = ((JsApiMessageImpl)((Object)jsJmsMessage)).getOtherUserPropertyMap().get(string);
            stringBuffer.append(mQHeaderFactory.createMQRFH2Element(string, object2, true).toXML());
        }
        mQRFH2.setFolderContent("sib_usr", new String(stringBuffer));
        stringBuffer = new StringBuffer();
        iterator = ((JsApiMessageImpl)((Object)jsJmsMessage)).getSystemContextMap().keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object2 = ((JsApiMessageImpl)((Object)jsJmsMessage)).getSystemContextMap().get(string);
            stringBuffer.append(mQHeaderFactory.createMQRFH2Element(string, object2, true).toXML());
        }
        mQRFH2.setFolderContent("sib_context", new String(stringBuffer));
        mQMD1.setFormat(string2);
        string = jsJmsMessage.getCorrelationId();
        if (string != null && !string.startsWith("ID:")) {
            mQRFH2.setFieldValue("jms", "Cid", string);
        }
        if ((object2 = jsJmsMessage.getMQPublicationInfo()) != null) {
            object = mQRFH2.getFolder("psc", true);
            object.setValue("Command", MQBrokerCommand.PUBLISH.getName());
            Iterator iterator2 = object2.getTopics().iterator();
            while (iterator2.hasNext()) {
                object.addElement("Topic", iterator2.next());
            }
            object.setValue("SubPoint", object2.getSubscriptionPoint());
            object.setValue("Filter", object2.getFilter());
            int n4 = object2.getOptions();
            if ((n4 & 0x10) == 16) {
                object.addElement("PubOpt", "RetainPub");
            }
            if ((n4 & 0x20) == 32) {
                object.addElement("PubOpt", "IsRetainedPub");
            }
            if ((n4 & 1) == 1) {
                object.addElement("PubOpt", "Local");
            }
            if ((n4 & 0x40) == 64) {
                object.addElement("PubOpt", "OtherSubsOnly");
            }
            if ((n4 & 2) == 2) {
                object.addElement("PubOpt", "CorrelAsId");
            }
            if ((n4 & 4) == 4) {
                object.addElement("RegOpt", "FullResp");
            }
            object.setValue("QMgrName", object2.getQueueManagerName());
            object.setValue("QName", object2.getQueueName());
            if (object2.getPubTime() != 0L) {
                object.setValue("PubTime", pubTimeFormat.format(new Date(object2.getPubTime())));
            }
            if (object2.getSeqNum() != 0) {
                object.setValue("SeqNum", Integer.toString(object2.getSeqNum()));
            }
        }
        if ((object = jsJmsMessage.getReplyDiscriminator()) != null) {
            mQRFH2.setFieldValue("sib", "RTopic", object);
        }
        if ((object = jsJmsMessage.getReplyPriority()) != null) {
            mQRFH2.setFieldValue("sib", "RPri", object);
        }
        if ((object = jsJmsMessage.getReplyReliability()) != null && object != Reliability.NONE) {
            mQRFH2.setFieldValue("sib", "RPer", Integer.toString(((Reliability)object).toInt()));
        }
        if ((object = jsJmsMessage.getReplyTimeToLive()) != null) {
            mQRFH2.setFieldValue("sib", "RTTL", object.toString());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "constructRFH", mQRFH2);
        }
        return mQRFH2;
    }

    private byte[] constructTextMessageBody(MQHeaderContext mQHeaderContext) throws UnsupportedEncodingException {
        JsJmsTextMessage jsJmsTextMessage;
        String string;
        byte[] byArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "constructTextMessageBody", new Object[]{this, mQHeaderContext});
        }
        byte[] byArray2 = byArray = (string = (jsJmsTextMessage = (JsJmsTextMessage)jmsFactory.createInboundJmsMessage(((MessageImpl)((Object)this.message)).jmo, 5)).getText()) == null ? new byte[]{} : string.getBytes(CCSID.getCodepage(mQHeaderContext.nextCharacterSet()));
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "constructTextMessageBody", byArray);
        }
        return byArray;
    }

    private byte[] constructBytesMessageBody(MQHeaderContext mQHeaderContext) {
        JsJmsBytesMessage jsJmsBytesMessage;
        byte[] byArray;
        byte[] byArray2;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "constructBytesMessageBody", new Object[]{this, mQHeaderContext});
        }
        byte[] byArray3 = byArray2 = (byArray = (jsJmsBytesMessage = (JsJmsBytesMessage)jmsFactory.createInboundJmsMessage(((MessageImpl)((Object)this.message)).jmo, 1)).getBytes()) == null ? new byte[]{} : byArray;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "constructBytesMessageBody", byArray2);
        }
        return byArray2;
    }

    private byte[] constructStreamMessageBody(MQHeaderContext mQHeaderContext) throws UnsupportedEncodingException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "constructStreamMessageBody", new Object[]{this, mQHeaderContext});
        }
        JsJmsStreamMessage jsJmsStreamMessage = (JsJmsStreamMessage)jmsFactory.createInboundJmsMessage(((MessageImpl)((Object)this.message)).jmo, 4);
        StringBuffer stringBuffer = new StringBuffer("<stream>");
        jsJmsStreamMessage.reset();
        Object object = jsJmsStreamMessage.readObject();
        while (object != JsJmsStreamMessage.END_OF_STREAM) {
            MA88ElementWriter.appendStreamElement(stringBuffer, object);
            object = jsJmsStreamMessage.readObject();
        }
        stringBuffer.append("</stream>");
        object = new String(stringBuffer).getBytes(CCSID.getCodepage(mQHeaderContext.nextCharacterSet()));
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "constructStreamMessageBody", object);
        }
        return object;
    }

    private byte[] constructMapMessageBody(MQHeaderContext mQHeaderContext) throws UnsupportedEncodingException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "constructMapMessageBody", new Object[]{this, mQHeaderContext});
        }
        JsJmsMapMessage jsJmsMapMessage = (JsJmsMapMessage)jmsFactory.createInboundJmsMessage(((MessageImpl)((Object)this.message)).jmo, 2);
        Enumeration enumeration = jsJmsMapMessage.getMapNames();
        StringBuffer stringBuffer = new StringBuffer("<map>");
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            MA88ElementWriter.appendMapElement(stringBuffer, (String)object, jsJmsMapMessage.getObject((String)object));
        }
        stringBuffer.append("</map>");
        object = new String(stringBuffer).getBytes(CCSID.getCodepage(mQHeaderContext.nextCharacterSet()));
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "constructMapMessageBody", object);
        }
        return object;
    }

    private byte[] constructObjectMessageBody(MQHeaderContext mQHeaderContext) {
        JsJmsObjectMessage jsJmsObjectMessage;
        byte[] byArray;
        byte[] byArray2;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "constructObjectMessageBody", new Object[]{this, mQHeaderContext});
        }
        byte[] byArray3 = byArray2 = (byArray = (jsJmsObjectMessage = (JsJmsObjectMessage)jmsFactory.createInboundJmsMessage(((MessageImpl)((Object)this.message)).jmo, 3)).getSerializedObject()) == null ? new byte[]{} : byArray;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "constructObjectMessageBody", byArray2);
        }
        return byArray2;
    }

    private void setMcdFolderFromURI(MQRFH2.Element element, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setMcdFolderFromURI", new Object[]{this, element, string});
        }
        try {
            StringTokenizer stringTokenizer;
            URI uRI = new URI(string);
            String string2 = uRI.getAuthority();
            String string3 = null;
            String string4 = null;
            String string5 = null;
            if (uRI.getPath() != null) {
                stringTokenizer = new StringTokenizer(uRI.getPath(), "/");
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken();
                }
            }
            if (uRI.getQuery() != null && (stringTokenizer = new StringTokenizer(uRI.getQuery(), "=&")).hasMoreTokens() && stringTokenizer.nextToken().equals("format") && stringTokenizer.hasMoreTokens()) {
                string5 = stringTokenizer.nextToken();
            }
            element.setValue("Msd", string2);
            element.setValue("Set", string3);
            element.setValue("Type", string4);
            element.setValue("Fmt", string5);
        }
        catch (URISyntaxException uRISyntaxException) {
            element.setValue("Type", string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setMcdFolderFromURI");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#) 1.73 SIB/ws/code/sib.mfp.impl/src/com/ibm/ws/sib/mfp/impl/MQJsJmsMessageEncoderImpl.java, SIB.mfp, WAS602.SIB, o0610.11 05/05/23 12:40:42 [3/13/06 13:57:01]");
        }
        pubTimeFormat.setTimeZone(TimeZone.getTimeZone("GMT+0:00"));
    }
}

