/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.CommsConnection;
import com.ibm.ws.sib.comms.NoCapacityException;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.mfp.MessagePart;
import com.ibm.ws.sib.mfp.MfpConstants;
import com.ibm.ws.sib.mfp.impl.JsMsgPart;
import com.ibm.ws.sib.mfp.impl.MessageImpl;
import com.ibm.ws.sib.mfp.impl.MessagePartImpl;
import com.ibm.ws.sib.mfp.impl.SchemaManager;
import com.ibm.ws.sib.mfp.jmf.JMFEncapsulation;
import com.ibm.ws.sib.mfp.jmf.JMFException;
import com.ibm.ws.sib.mfp.jmf.JMFMessage;
import com.ibm.ws.sib.mfp.jmf.JMFMessageCorruptionException;
import com.ibm.ws.sib.mfp.jmf.JMFModelNotImplementedException;
import com.ibm.ws.sib.mfp.jmf.JMFNativePart;
import com.ibm.ws.sib.mfp.jmf.JMFPart;
import com.ibm.ws.sib.mfp.jmf.JMFRegistry;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.mfp.jmf.JMFSchemaViolationException;
import com.ibm.ws.sib.mfp.jmf.JMFUninitializedAccessException;
import com.ibm.ws.sib.mfp.jmf.impl.JSMessageImpl;
import com.ibm.ws.sib.mfp.jmf.tools.JSFormatter;
import com.ibm.ws.sib.mfp.schema.JsApiAccess;
import com.ibm.ws.sib.mfp.util.ArrayUtil;
import com.ibm.ws.sib.mfp.util.HexUtil;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import java.util.ArrayList;
import java.util.List;

class JsMsgObject {
    private static TraceComponent tc = SibTr.register(class$com$ibm$ws$sib$mfp$impl$JsMsgObject == null ? (class$com$ibm$ws$sib$mfp$impl$JsMsgObject = JsMsgObject.class$("com.ibm.ws.sib.mfp.impl.JsMsgObject")) : class$com$ibm$ws$sib$mfp$impl$JsMsgObject, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final int IDS_LENGTH;
    protected MessageImpl theMessage;
    protected int originalLength;
    private JsMsgPart headerPart;
    private JsMsgPart payloadPart = null;
    static /* synthetic */ Class class$com$ibm$ws$sib$mfp$impl$JsMsgObject;

    JsMsgObject(JMFSchema jMFSchema) throws MessageDecodeFailedException {
        this.initialize(jMFSchema, null, 0, 0, null, null, 0, 0, null);
    }

    JsMsgObject(JMFSchema jMFSchema, JMFSchema jMFSchema2) throws MessageDecodeFailedException {
        this.initialize(jMFSchema, null, 0, 0, jMFSchema2, null, 0, 0, null);
    }

    JsMsgObject(JMFSchema jMFSchema, byte[] byArray, int n, int n2) throws MessageDecodeFailedException {
        this.initialize(jMFSchema, byArray, n, n2, null, null, 0, 0, null);
    }

    JsMsgObject(JMFSchema jMFSchema, JMFSchema jMFSchema2, byte[] byArray, int n, int n2) throws MessageDecodeFailedException {
        this(jMFSchema, jMFSchema2, byArray, n, n2, null);
    }

    JsMsgObject(JMFSchema jMFSchema, JMFSchema jMFSchema2, byte[] byArray, int n, int n2, CommsConnection commsConnection) throws MessageDecodeFailedException {
        if (byArray.length - n < n2 || n2 < IDS_LENGTH + ArrayUtil.INT_SIZE) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Message buffer size too small: " + byArray.length);
            }
            throw new MessageDecodeFailedException("Invalid message buffer (buffer size too small)");
        }
        int n3 = IDS_LENGTH + ArrayUtil.INT_SIZE + ArrayUtil.readInt(byArray, n + IDS_LENGTH);
        if (n3 < n2) {
            this.initialize(jMFSchema, byArray, n, n3, jMFSchema2, byArray, n + n3, n2 - n3, commsConnection);
        } else if (jMFSchema2 == null) {
            this.initialize(jMFSchema, byArray, n, n3, null, null, 0, 0, commsConnection);
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "decode failed: encoded payload missing");
            }
            MessageDecodeFailedException messageDecodeFailedException = new MessageDecodeFailedException();
            FFDCFilter.processException((Throwable)messageDecodeFailedException, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.initialize", (String)"jmo350", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, byArray, new Integer(n), new Integer(n2)});
            throw messageDecodeFailedException;
        }
    }

    JsMsgObject(JMFSchema jMFSchema, JMFSchema jMFSchema2, List list) throws MessageDecodeFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "JsMsgObject", (Object)"for restore/deserialize");
        }
        byte[] byArray = (byte[])list.get(0);
        if (list.size() > 1) {
            byte[] byArray2 = (byte[])list.get(1);
            this.initialize(jMFSchema, byArray, 0, byArray.length, jMFSchema2, byArray2, 0, byArray2.length, null);
        } else {
            this.initialize(jMFSchema, byArray, 0, byArray.length, null, null, 0, 0, null);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "JsMsgObject");
        }
    }

    private void initialize(JMFSchema jMFSchema, byte[] byArray, int n, int n2, JMFSchema jMFSchema2, byte[] byArray2, int n3, int n4, CommsConnection commsConnection) throws MessageDecodeFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "initialize");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "parameters: ", new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4)});
        }
        if (byArray != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Decoding message from byte buffer(s)");
            }
            if (tc.isDebugEnabled()) {
                String string = SibTr.formatBytes(byArray, n, n2);
                String string2 = null;
                if (byArray2 != null) {
                    string2 = SibTr.formatBytes(byArray2, n3, n4);
                }
                SibTr.debug(tc, "buffers: ", new Object[]{string, string2});
            }
            this.originalLength = n2 + n4;
            if (byArray.length - n < n2 || n2 < IDS_LENGTH + ArrayUtil.INT_SIZE) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Message buffer size too small: " + byArray.length);
                }
                throw new MessageDecodeFailedException("Invalid message buffer (buffer size too small)");
            }
            short s = ArrayUtil.readShort(byArray, n);
            long l = ArrayUtil.readLong(byArray, n += ArrayUtil.SHORT_SIZE);
            short s2 = ArrayUtil.readShort(byArray, n += ArrayUtil.LONG_SIZE);
            long l2 = ArrayUtil.readLong(byArray, n += ArrayUtil.SHORT_SIZE);
            int n5 = ArrayUtil.readInt(byArray, n += ArrayUtil.LONG_SIZE);
            this.headerPart = new JsMsgPart(this.initializePart(jMFSchema, s, l, byArray, n += ArrayUtil.INT_SIZE, n5, commsConnection));
            try {
                if (n4 > 0) {
                    this.payloadPart = new JsMsgPart(this.initializePart(jMFSchema2, s2, l2, byArray2, n3, n4, commsConnection));
                }
            }
            catch (MessageDecodeFailedException messageDecodeFailedException) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Decoded JMF Message Header", (Object)this.debugMsgPart(this.headerPart));
                }
                throw messageDecodeFailedException;
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Decoded JMF Message", (Object)this.debugMsg());
            }
        } else if (jMFSchema != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Creating new empty header message: Schema=" + this.debugSchema(jMFSchema));
            }
            this.headerPart = new JsMsgPart(JMFRegistry.instance.newMessage(jMFSchema));
            if (jMFSchema2 != null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Creating new empty payload: Schema=" + this.debugSchema(jMFSchema2));
                }
                this.payloadPart = new JsMsgPart(JMFRegistry.instance.newMessage(jMFSchema2));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "initialize");
        }
    }

    private JMFNativePart initializePart(JMFSchema jMFSchema, short s, long l, byte[] byArray, int n, int n2, CommsConnection commsConnection) throws MessageDecodeFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "initializePart");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "parameters: ", new Object[]{new Short(s), this.debugId(l), new Integer(n), new Integer(n2)});
        }
        JMFMessage jMFMessage = null;
        try {
            if (jMFSchema == null) {
                jMFSchema = JMFRegistry.instance.retrieve(l);
            }
            if (commsConnection != null) {
                long[] lArray = JMFRegistry.instance.checkSchemata(s, byArray, n);
                byte[] byArray2 = null;
                int n3 = 0;
                if (jMFSchema == null) {
                    byArray2 = new byte[(lArray.length + 1) * 8];
                    ArrayUtil.writeLong(byArray2, n3, l);
                    n3 += 8;
                } else if (lArray.length > 0) {
                    byArray2 = new byte[lArray.length * 8];
                }
                for (int i = 0; i < lArray.length; ++i) {
                    ArrayUtil.writeLong(byArray2, n3, lArray[i]);
                    n3 += 8;
                }
                if (byArray2 != null) {
                    byte[] byArray3 = null;
                    try {
                        byArray3 = commsConnection.requestMFPSchemata(byArray2);
                    }
                    catch (SIConnectionDroppedException sIConnectionDroppedException) {
                        FFDCFilter.processException((Throwable)sIConnectionDroppedException, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.initializePart", (String)"jmo400", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, byArray, new Integer(n), new Integer(n2)});
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "decode failed: " + sIConnectionDroppedException);
                        }
                        throw new MessageDecodeFailedException(sIConnectionDroppedException);
                    }
                    catch (NoCapacityException noCapacityException) {
                        FFDCFilter.processException((Throwable)noCapacityException, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.initializePart", (String)"jmo401", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, byArray, new Integer(n), new Integer(n2)});
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "decode failed: " + noCapacityException);
                        }
                        throw new MessageDecodeFailedException(noCapacityException);
                    }
                    catch (SIConnectionLostException sIConnectionLostException) {
                        FFDCFilter.processException((Throwable)sIConnectionLostException, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.initializePart", (String)"jmo402", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, byArray, new Integer(n), new Integer(n2)});
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "decode failed: " + sIConnectionLostException);
                        }
                        throw new MessageDecodeFailedException(sIConnectionLostException);
                    }
                    catch (SIConnectionUnavailableException sIConnectionUnavailableException) {
                        FFDCFilter.processException((Throwable)sIConnectionUnavailableException, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.initializePart", (String)"jmo403", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, byArray, new Integer(n), new Integer(n2)});
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "decode failed: " + sIConnectionUnavailableException);
                        }
                        throw new MessageDecodeFailedException(sIConnectionUnavailableException);
                    }
                    catch (SIErrorException sIErrorException) {
                        FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.initialize", (String)"jmo404", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, byArray, new Integer(n), new Integer(n2)});
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "decode failed: " + sIErrorException);
                        }
                        throw new MessageDecodeFailedException(sIErrorException);
                    }
                    if (byArray3 != null) {
                        SchemaManager.receiveSchemas(commsConnection, byArray3);
                    }
                    if (jMFSchema == null) {
                        jMFSchema = JMFRegistry.instance.retrieve(l);
                    }
                }
                if (jMFSchema == null) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Unable to retrieve message schema " + this.debugId(l));
                    }
                    MessageDecodeFailedException messageDecodeFailedException = new MessageDecodeFailedException("No schema registered for schema id " + this.debugId(l));
                    FFDCFilter.processException((Throwable)messageDecodeFailedException, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.initializePart", (String)"jmo425", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, byArray, new Integer(n), new Integer(n2)});
                    throw messageDecodeFailedException;
                }
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Decoding: JMF version=" + s + " encoding schema=" + this.debugId(l) + " access schema=" + this.debugId(jMFSchema.getID()));
            }
            jMFMessage = JMFRegistry.instance.decode(jMFSchema, s, l, byArray, n, n2);
        }
        catch (JMFException jMFException) {
            FFDCFilter.processException((Throwable)jMFException, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.initializePart", (String)"jmo450", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, byArray, new Integer(n), new Integer(n2)});
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "decode failed: " + jMFException);
            }
            throw new MessageDecodeFailedException(jMFException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "initializePart");
        }
        return jMFMessage;
    }

    void setMessage(MessageImpl messageImpl) {
        this.theMessage = messageImpl;
    }

    synchronized List encode(Object object) throws MessageEncodeFailedException {
        Object object2;
        byte[] byArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "encode");
        }
        if (object != null && !(object instanceof CommsConnection)) {
            throw new MessageEncodeFailedException("Incorrect connection object: " + object.getClass());
        }
        ArrayList<byte[]> arrayList = null;
        try {
            this.theMessage.updateDataFields();
            if (object != null) {
                SchemaManager.sendSchemas((CommsConnection)object, ((JMFMessage)this.headerPart.jmfPart).getSchemata());
                if (this.payloadPart != null) {
                    SchemaManager.sendSchemas((CommsConnection)object, ((JMFMessage)this.payloadPart.jmfPart).getSchemata());
                }
            }
            byArray = new byte[IDS_LENGTH + ArrayUtil.INT_SIZE + ((JMFMessage)this.headerPart.jmfPart).getEncodedLength()];
            int n = this.encodeIds(byArray, 0);
            this.encodePart(this.headerPart, true, byArray, n);
            if (this.payloadPart != null) {
                object2 = this.encodePart(this.payloadPart);
                arrayList = new ArrayList(2);
                arrayList.add(0, byArray);
                arrayList.add(1, (byte[])object2);
            } else {
                arrayList = new ArrayList<byte[]>(1);
                arrayList.add(0, byArray);
            }
        }
        catch (MessageEncodeFailedException messageEncodeFailedException) {
            FFDCFilter.processException((Throwable)messageEncodeFailedException, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.encode", (String)"jmo500", (Object)this, (Object[])new Object[]{MfpConstants.DM_MESSAGE, null, this.theMessage});
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "encode failed: " + messageEncodeFailedException);
            }
            throw messageEncodeFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.encode", (String)"jmo550", (Object)this, (Object[])new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage});
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "encode failed: " + exception);
            }
            throw new MessageEncodeFailedException(exception);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Encoded JMF Message", (Object)this.debugMsg());
        }
        if (tc.isDebugEnabled()) {
            byArray = (byte[])arrayList.get(0);
            String string = SibTr.formatBytes(byArray, 0, byArray.length);
            object2 = null;
            if (arrayList.size() > 1) {
                byte[] byArray2 = (byte[])arrayList.get(1);
                object2 = SibTr.formatBytes(byArray2, 0, byArray2.length);
            }
            SibTr.debug(tc, "buffers: ", new Object[]{string, object2});
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "encode");
        }
        return arrayList;
    }

    synchronized List encodeFast(Object object) throws MessageEncodeFailedException {
        Object object2;
        Object object3;
        Object object4;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "encodeFast");
        }
        if (object != null && !(object instanceof CommsConnection)) {
            throw new MessageEncodeFailedException("Incorrect connection object: " + object.getClass());
        }
        ArrayList<Object> arrayList = null;
        try {
            this.theMessage.updateDataFields();
            if (object != null) {
                SchemaManager.sendSchemas((CommsConnection)object, ((JMFMessage)this.headerPart.jmfPart).getSchemata());
                if (this.payloadPart != null) {
                    SchemaManager.sendSchemas((CommsConnection)object, ((JMFMessage)this.payloadPart.jmfPart).getSchemata());
                }
            }
            object4 = new byte[IDS_LENGTH + ArrayUtil.INT_SIZE + ((JMFMessage)this.headerPart.jmfPart).getEncodedLength()];
            int n = this.encodeIds((byte[])object4, 0);
            this.encodePart(this.headerPart, true, (byte[])object4, n);
            object3 = new MessagePartImpl((byte[])object4, 0, ((byte[])object4).length);
            object2 = null;
            if (this.payloadPart != null) {
                int n2;
                Object object5;
                int n3 = 0;
                if (this.payloadPart.jmfPart instanceof JSMessageImpl) {
                    object5 = (JSMessageImpl)this.payloadPart.jmfPart;
                    if (!((JSMessageImpl)object5).isAssembled()) {
                        object2 = this.encodePart(this.payloadPart);
                        n2 = 0;
                        n3 = ((byte[])object2).length;
                    } else {
                        object2 = ((JSMessageImpl)object5).getContents();
                        n2 = ((JSMessageImpl)object5).getMessageOffSet();
                        n3 = ((JSMessageImpl)object5).getLength();
                    }
                } else {
                    object2 = this.encodePart(this.payloadPart);
                    n2 = 0;
                    n3 = ((byte[])object2).length;
                }
                object5 = new MessagePartImpl((byte[])object2, n2, n3);
                arrayList = new ArrayList(2);
                arrayList.add(0, object3);
                arrayList.add(1, object5);
            } else {
                arrayList = new ArrayList<Object>(1);
                arrayList.add(0, object3);
            }
        }
        catch (MessageEncodeFailedException messageEncodeFailedException) {
            FFDCFilter.processException((Throwable)messageEncodeFailedException, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.encodeFast", (String)"jmo560", (Object)this, (Object[])new Object[]{MfpConstants.DM_MESSAGE, null, this.theMessage});
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "encode failed: " + messageEncodeFailedException);
            }
            throw messageEncodeFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.encodeFast", (String)"jmo570", (Object)this, (Object[])new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage});
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "encode failed: " + exception);
            }
            throw new MessageEncodeFailedException(exception);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Encoded JMF Message", (Object)this.debugMsg());
        }
        if (tc.isDebugEnabled()) {
            object4 = (MessagePart)arrayList.get(0);
            byte[] byArray = object4.getBytes();
            object3 = SibTr.formatBytes(byArray, 0, byArray.length);
            object2 = null;
            if (arrayList.size() > 1) {
                MessagePart messagePart = (MessagePart)arrayList.get(1);
                byte[] byArray2 = messagePart.getBytes();
                object2 = SibTr.formatBytes(byArray2, 0, byArray2.length);
            }
            SibTr.debug(tc, "messageParts: ", new Object[]{object3, object2});
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "encodeFast");
        }
        return arrayList;
    }

    synchronized int flatten(byte[] byArray, int n) throws MessageEncodeFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "flatten");
        }
        int n2 = n;
        try {
            this.theMessage.updateDataFields();
            n2 += this.encodeIds(byArray, n2);
            n2 += this.encodePart(this.headerPart, true, byArray, n2);
            if (this.payloadPart != null) {
                n2 += this.encodePart(this.payloadPart, false, byArray, n2);
            }
        }
        catch (MessageEncodeFailedException messageEncodeFailedException) {
            FFDCFilter.processException((Throwable)messageEncodeFailedException, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.flatten", (String)"jmo580", (Object)this, (Object[])new Object[]{MfpConstants.DM_MESSAGE, null, this.theMessage});
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "flatten failed: " + messageEncodeFailedException);
            }
            throw messageEncodeFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.flatten", (String)"jmo590", (Object)this, (Object[])new Object[]{new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage}, new Object[]{MfpConstants.DM_MESSAGE, this.payloadPart.jmfPart, this.theMessage}});
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "flatten failed: " + exception);
            }
            throw new MessageEncodeFailedException(exception);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Encoded JMF Message", (Object)this.debugMsg());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "flatten", new Integer(n2 - n));
        }
        return n2 - n;
    }

    private final int encodeIds(byte[] byArray, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "encodeIds");
        }
        int n2 = n;
        ArrayUtil.writeShort(byArray, n2, ((JMFMessage)this.headerPart.jmfPart).getJMFEncodingVersion());
        ArrayUtil.writeLong(byArray, n2 += ArrayUtil.SHORT_SIZE, this.headerPart.jmfPart.getEncodingSchema().getID());
        n2 += ArrayUtil.LONG_SIZE;
        if (this.payloadPart != null) {
            ArrayUtil.writeShort(byArray, n2, ((JMFMessage)this.payloadPart.jmfPart).getJMFEncodingVersion());
            ArrayUtil.writeLong(byArray, n2 += ArrayUtil.SHORT_SIZE, this.payloadPart.jmfPart.getEncodingSchema().getID());
            n2 += ArrayUtil.LONG_SIZE;
        } else {
            ArrayUtil.writeShort(byArray, n2, (short)0);
            ArrayUtil.writeLong(byArray, n2 += ArrayUtil.SHORT_SIZE, 0L);
            n2 += ArrayUtil.LONG_SIZE;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "encodeIds", new Integer(n2 - n));
        }
        return n2 - n;
    }

    private final int encodePart(JsMsgPart jsMsgPart, boolean bl, byte[] byArray, int n) throws MessageEncodeFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "encodePart");
        }
        JMFMessage jMFMessage = (JMFMessage)jsMsgPart.jmfPart;
        int n2 = 0;
        int n3 = n;
        try {
            n2 = jMFMessage.getEncodedLength();
            if (bl) {
                ArrayUtil.writeInt(byArray, n, n2);
                n3 += ArrayUtil.INT_SIZE;
            }
            jMFMessage.toByteArray(byArray, n3, n2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.encodePart", (String)"jmo600", (Object)this, (Object[])new Object[]{new Object[]{MfpConstants.DM_MESSAGE, jMFMessage, this.theMessage}, new Object[]{MfpConstants.DM_BUFFER, byArray, new Integer(n), new Integer(n2 + ArrayUtil.INT_SIZE)}});
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "encode failed: " + exception);
            }
            throw new MessageEncodeFailedException(exception);
        }
        n2 += n3 - n;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "encodePart", new Integer(n2));
        }
        return n2;
    }

    private final byte[] encodePart(JsMsgPart jsMsgPart) throws MessageEncodeFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "encodePart");
        }
        JMFMessage jMFMessage = (JMFMessage)jsMsgPart.jmfPart;
        byte[] byArray = null;
        int n = 0;
        try {
            n = jMFMessage.getEncodedLength();
            byArray = jMFMessage.toByteArray(n);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.encodePart", (String)"jmo620", (Object)this, (Object[])new Object[]{new Object[]{MfpConstants.DM_MESSAGE, jMFMessage, this.theMessage}, new Object[]{MfpConstants.DM_BUFFER, byArray, new Integer(0), new Integer(n)}});
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "encode failed: " + exception);
            }
            throw new MessageEncodeFailedException(exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "encodePart", new Integer(n));
        }
        return byArray;
    }

    synchronized int getEncodedLength() throws MessageEncodeFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getEncodedLength");
        }
        int n = IDS_LENGTH;
        n += ArrayUtil.INT_SIZE;
        try {
            this.theMessage.updateDataFields();
            n += ((JMFMessage)this.headerPart.jmfPart).getEncodedLength();
            if (this.payloadPart != null) {
                n += ((JMFMessage)this.payloadPart.jmfPart).getEncodedLength();
            }
        }
        catch (JMFException jMFException) {
            FFDCFilter.processException((Throwable)jMFException, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.getEncodedLength", (String)"jmo650", (Object)this, (Object[])new Object[]{new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage}, new Object[]{MfpConstants.DM_MESSAGE, this.payloadPart.jmfPart, this.theMessage}});
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "getEncodedLength failed: " + jMFException);
            }
            throw new MessageEncodeFailedException(jMFException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getEncodedLength", new Integer(n));
        }
        return n;
    }

    JMFSchema[] getEncodingSchemas() throws MessageEncodeFailedException {
        JMFSchema[] jMFSchemaArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getEncodingSchemas");
        }
        try {
            JMFSchema[] jMFSchemaArray2 = ((JMFMessage)this.headerPart.jmfPart).getSchemata();
            JMFSchema[] jMFSchemaArray3 = null;
            int n = jMFSchemaArray2.length;
            if (this.payloadPart != null) {
                jMFSchemaArray3 = ((JMFMessage)this.payloadPart.jmfPart).getSchemata();
                n += jMFSchemaArray3.length;
            }
            jMFSchemaArray = new JMFSchema[n];
            System.arraycopy(jMFSchemaArray2, 0, jMFSchemaArray, 0, jMFSchemaArray2.length);
            if (this.payloadPart != null) {
                System.arraycopy(jMFSchemaArray3, 0, jMFSchemaArray, jMFSchemaArray2.length, jMFSchemaArray3.length);
            }
        }
        catch (JMFException jMFException) {
            FFDCFilter.processException((Throwable)jMFException, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.getEncodingSchemas", (String)"jmo700", (Object)this, (Object[])new Object[]{new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage}, new Object[]{MfpConstants.DM_MESSAGE, this.payloadPart.jmfPart, this.theMessage}});
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "getEncodingSchemas failed: " + jMFException);
            }
            throw new MessageEncodeFailedException(jMFException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getEncodingSchemas");
        }
        return jMFSchemaArray;
    }

    JsMsgObject getCopy() throws MessageCopyFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getCopy");
        }
        JsMsgObject jsMsgObject = null;
        try {
            this.theMessage.updateDataFields();
            this.theMessage.clearPartCaches();
            jsMsgObject = new JsMsgObject(null);
            jsMsgObject.headerPart = new JsMsgPart(((JMFMessage)this.headerPart.jmfPart).copy());
            jsMsgObject.payloadPart = new JsMsgPart(((JMFMessage)this.payloadPart.jmfPart).copy());
        }
        catch (MessageDecodeFailedException messageDecodeFailedException) {
            FFDCFilter.processException((Throwable)messageDecodeFailedException, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.getCopy", (String)"jmo800", (Object)this, (Object[])new Object[]{new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage}, new Object[]{MfpConstants.DM_MESSAGE, this.payloadPart.jmfPart, this.theMessage}});
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "copy failed: " + messageDecodeFailedException);
            }
            throw new MessageCopyFailedException(messageDecodeFailedException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getCopy");
        }
        return jsMsgObject;
    }

    JsMsgObject transcribeToJmf() throws MessageCopyFailedException {
        Object object;
        JMFNativePart jMFNativePart;
        JMFPart jMFPart;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "transcribeToJmf");
        }
        JsMsgObject jsMsgObject = this.getCopy();
        if (this.headerPart != null && this.headerPart.getIntField(10) == 1) {
            object2 = this.getPart(9, JsApiAccess.schema);
            jMFPart = ((JsMsgPart)object2).jmfPart;
            if (jMFPart instanceof JMFEncapsulation) {
                jMFNativePart = JMFRegistry.instance.newNativePart(JsApiAccess.schema);
                jsMsgObject.setField(9, jMFNativePart);
                object = (JMFEncapsulation)jMFPart;
                try {
                    object.transcribe(jMFNativePart, true);
                }
                catch (JMFSchemaViolationException jMFSchemaViolationException) {
                    FFDCFilter.processException((Throwable)jMFSchemaViolationException, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.transcribeToJmf", (String)"jmo880", (Object)this, (Object[])new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage});
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "transcribe headers failed: " + jMFSchemaViolationException);
                    }
                    throw new MessageCopyFailedException(jMFSchemaViolationException);
                }
                catch (JMFModelNotImplementedException jMFModelNotImplementedException) {
                    FFDCFilter.processException((Throwable)jMFModelNotImplementedException, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.transcribeToJmf", (String)"jmo881", (Object)this, (Object[])new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage});
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "transcribe headers failed: " + jMFModelNotImplementedException);
                    }
                    throw new MessageCopyFailedException(jMFModelNotImplementedException);
                }
                catch (JMFUninitializedAccessException jMFUninitializedAccessException) {
                    FFDCFilter.processException((Throwable)jMFUninitializedAccessException, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.transcribeToJmf", (String)"jmo882", (Object)this, (Object[])new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage});
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "transcribe headers failed: " + jMFUninitializedAccessException);
                    }
                    throw new MessageCopyFailedException(jMFUninitializedAccessException);
                }
                catch (JMFMessageCorruptionException jMFMessageCorruptionException) {
                    FFDCFilter.processException((Throwable)jMFMessageCorruptionException, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.transcribeToJmf", (String)"jmo883", (Object)this, (Object[])new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage});
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "transcribe headers failed: " + jMFMessageCorruptionException);
                    }
                    throw new MessageCopyFailedException(jMFMessageCorruptionException);
                }
            }
        }
        if (this.payloadPart != null && this.payloadPart.getIntField(2) == 1 && (object2 = this.payloadPart.getField(1)) instanceof JMFEncapsulation) {
            jMFPart = (JMFEncapsulation)object2;
            jMFNativePart = jMFPart.getNativePart();
            object = jMFNativePart.getEncodingSchema();
            JMFNativePart jMFNativePart2 = JMFRegistry.instance.newNativePart((JMFSchema)object);
            JsMsgPart jsMsgPart = jsMsgObject.getPayloadPart();
            jsMsgPart.setField(1, jMFNativePart2);
            try {
                jMFPart.transcribe(jMFNativePart2, true);
            }
            catch (JMFSchemaViolationException jMFSchemaViolationException) {
                FFDCFilter.processException((Throwable)jMFSchemaViolationException, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.transcribeToJmf", (String)"jmo890", (Object)this, (Object[])new Object[]{new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage}, new Object[]{MfpConstants.DM_MESSAGE, this.payloadPart.jmfPart, this.theMessage}});
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "transcribe payload failed: " + jMFSchemaViolationException);
                }
                throw new MessageCopyFailedException(jMFSchemaViolationException);
            }
            catch (JMFModelNotImplementedException jMFModelNotImplementedException) {
                FFDCFilter.processException((Throwable)jMFModelNotImplementedException, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.transcribeToJmf", (String)"jmo891", (Object)this, (Object[])new Object[]{new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage}, new Object[]{MfpConstants.DM_MESSAGE, this.payloadPart.jmfPart, this.theMessage}});
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "transcribe payload failed: " + jMFModelNotImplementedException);
                }
                throw new MessageCopyFailedException(jMFModelNotImplementedException);
            }
            catch (JMFUninitializedAccessException jMFUninitializedAccessException) {
                FFDCFilter.processException((Throwable)jMFUninitializedAccessException, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.transcribeToJmf", (String)"jmo892", (Object)this, (Object[])new Object[]{new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage}, new Object[]{MfpConstants.DM_MESSAGE, this.payloadPart.jmfPart, this.theMessage}});
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "transcribe payload failed: " + jMFUninitializedAccessException);
                }
                throw new MessageCopyFailedException(jMFUninitializedAccessException);
            }
            catch (JMFMessageCorruptionException jMFMessageCorruptionException) {
                FFDCFilter.processException((Throwable)jMFMessageCorruptionException, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.transcribeToJmf", (String)"jmo893", (Object)this, (Object[])new Object[]{new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage}, new Object[]{MfpConstants.DM_MESSAGE, this.payloadPart.jmfPart, this.theMessage}});
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "transcribe payload failed: " + jMFMessageCorruptionException);
                }
                throw new MessageCopyFailedException(jMFMessageCorruptionException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "transcribeToJmf", jsMsgObject);
        }
        return jsMsgObject;
    }

    int getOriginalLength() {
        return this.originalLength;
    }

    final JsMsgPart getHeaderPart() {
        return this.headerPart;
    }

    final JsMsgPart getPayloadPart() {
        return this.payloadPart;
    }

    void setField(int n, Object object) {
        this.headerPart.setField(n, object);
    }

    Object getField(int n) {
        return this.headerPart.getField(n);
    }

    void setIntField(int n, int n2) {
        this.headerPart.setIntField(n, n2);
    }

    int getIntField(int n) {
        return this.headerPart.getIntField(n);
    }

    void setLongField(int n, long l) {
        this.headerPart.setLongField(n, l);
    }

    long getLongField(int n) {
        return this.headerPart.getLongField(n);
    }

    void setBooleanField(int n, boolean bl) {
        this.headerPart.setBooleanField(n, bl);
    }

    boolean getBooleanField(int n) {
        return this.headerPart.getBooleanField(n);
    }

    void setChoiceField(int n, int n2) {
        this.headerPart.setChoiceField(n, n2);
    }

    int getChoiceField(int n) {
        return this.headerPart.getChoiceField(n);
    }

    void setPart(int n, JMFSchema jMFSchema) {
        this.headerPart.setPart(n, jMFSchema);
    }

    JsMsgPart getPart(int n, JMFSchema jMFSchema) {
        JsMsgPart jsMsgPart = this.headerPart.getPart(n, jMFSchema);
        if (jsMsgPart == null) {
            MessageDecodeFailedException messageDecodeFailedException = new MessageDecodeFailedException();
            FFDCFilter.processException((Throwable)messageDecodeFailedException, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.getPart", (String)"jmo900", (Object)this, (Object[])new Object[]{MfpConstants.DM_MESSAGE, jsMsgPart, this.theMessage});
        }
        return jsMsgPart;
    }

    final String debugMsg() {
        StringBuffer stringBuffer = new StringBuffer(JSFormatter.format((JMFMessage)this.headerPart.jmfPart));
        if (this.payloadPart != null) {
            stringBuffer.append(JSFormatter.format((JMFMessage)this.payloadPart.jmfPart));
        }
        return stringBuffer.toString();
    }

    final String debugMsgPart(JsMsgPart jsMsgPart) {
        return JSFormatter.format((JMFMessage)jsMsgPart.jmfPart);
    }

    final String debugSchema(JMFSchema jMFSchema) {
        if (jMFSchema != null) {
            return jMFSchema.getName() + "(" + this.debugId(jMFSchema.getID()) + ")";
        }
        return "<null>";
    }

    final String debugId(long l) {
        byte[] byArray = new byte[8];
        ArrayUtil.writeLong(byArray, 0, l);
        return HexUtil.toString(byArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.impl/src/com/ibm/ws/sib/mfp/impl/JsMsgObject.java, SIB.mfp, WAS602.SIB, o0610.11 1.61");
        }
        IDS_LENGTH = ArrayUtil.SHORT_SIZE + ArrayUtil.LONG_SIZE + ArrayUtil.SHORT_SIZE + ArrayUtil.LONG_SIZE;
    }
}

