/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIDataGraphSchemaNotFoundException;
import com.ibm.websphere.sib.exception.SIMessageException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.matchspace.BadMessageFormatMatchingException;
import com.ibm.ws.sib.matchspace.Identifier;
import com.ibm.ws.sib.matchspace.MatchSpaceKey;
import com.ibm.ws.sib.mfp.IncorrectMessageTypeException;
import com.ibm.ws.sib.mfp.JsApiMessage;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.JsJmsMessageFactory;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.JsSdoMessage;
import com.ibm.ws.sib.mfp.MQJsMessageEncoder;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.mfp.MessageType;
import com.ibm.ws.sib.mfp.ProducerType;
import com.ibm.ws.sib.mfp.WebJsMessageEncoder;
import com.ibm.ws.sib.mfp.control.SubscriptionMessage;
import com.ibm.ws.sib.mfp.impl.JsHdrsImpl;
import com.ibm.ws.sib.mfp.impl.JsJmsMessageFactoryImpl;
import com.ibm.ws.sib.mfp.impl.JsJmsMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsJmsSdoBytesMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsJmsSdoTextMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsMsgObject;
import com.ibm.ws.sib.mfp.impl.JsMsgPart;
import com.ibm.ws.sib.mfp.impl.JsSdoMessageImpl;
import com.ibm.ws.sib.mfp.impl.SchemaStore;
import com.ibm.ws.sib.mfp.impl.SubscriptionMessageImpl;
import com.ibm.ws.sib.mfp.impl.TrmMessageFactoryImpl;
import com.ibm.ws.sib.mfp.impl.TrmMessageImpl;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.mfp.schema.JmsBytesBodyAccess;
import com.ibm.ws.sib.mfp.schema.JmsTextBodyAccess;
import com.ibm.ws.sib.mfp.schema.JsApiAccess;
import com.ibm.ws.sib.mfp.trm.TrmMessage;
import com.ibm.ws.sib.mfp.trm.TrmMessageFactory;
import com.ibm.ws.sib.mfp.util.ArrayUtil;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.sdo.JmsBodyAdapter;
import com.ibm.wsspi.sib.sdo.JmsBodyAdapterException;
import com.ibm.wsspi.sib.sdo.JmsBodyAdapterRegistry;
import commonj.sdo.DataGraph;
import java.io.UnsupportedEncodingException;
import java.util.List;

class JsMessageImpl
extends JsHdrsImpl
implements JsMessage,
MatchSpaceKey {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = SibTr.register(class$com$ibm$ws$sib$mfp$impl$JsMessageImpl == null ? (class$com$ibm$ws$sib$mfp$impl$JsMessageImpl = JsMessageImpl.class$("com.ibm.ws.sib.mfp.impl.JsMessageImpl")) : class$com$ibm$ws$sib$mfp$impl$JsMessageImpl, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final TraceNLS exceptionMessages = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    private static final JsJmsMessageFactoryImpl jmsFactory = JsMessageImpl.getJmsFactory();
    private static final TrmMessageFactoryImpl trmFactory = JsMessageImpl.getTrmFactory();
    private static final String SEPARATOR = "_";
    private transient int approxLength = -1;
    private transient JsMsgPart api = null;
    private transient JsMsgPart payload = null;
    static /* synthetic */ Class class$com$ibm$ws$sib$mfp$impl$JsMessageImpl;

    private static JsJmsMessageFactoryImpl getJmsFactory() {
        try {
            return (JsJmsMessageFactoryImpl)JsJmsMessageFactory.getInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mfp.impl.JsMessageImpl.getJmsFactory", (String)"jsm101");
            return null;
        }
    }

    private static TrmMessageFactoryImpl getTrmFactory() {
        try {
            return (TrmMessageFactoryImpl)TrmMessageFactory.getInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mfp.impl.JsMessageImpl.getTrmFactory", (String)"jsm102");
            return null;
        }
    }

    JsMessageImpl() {
    }

    JsMessageImpl(int n) throws MessageDecodeFailedException {
        super(n);
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "<init>");
        }
    }

    JsMessageImpl(JsMsgObject jsMsgObject) {
        super(jsMsgObject);
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "<init>, inbound jmo ");
        }
        if (jsMsgObject.getOriginalLength() != 0) {
            this.approxLength = jsMsgObject.getOriginalLength();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final JsJmsMessage makeInboundJmsMessage() throws IncorrectMessageTypeException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "makeInboundJmsMessage");
        }
        JsJmsMessageImpl jsJmsMessageImpl = null;
        this.updateDataFields();
        if (this.getJsMessageType() == MessageType.JMS) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Incoming message was created by JMS");
            }
            if (this instanceof JsJmsMessageImpl) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Incoming message is already a JsJmsMessage");
                }
                jsJmsMessageImpl = (JsJmsMessageImpl)this;
            } else {
                jsJmsMessageImpl = (JsJmsMessageImpl)jmsFactory.createInboundJmsMessage(this.jmo, this.getSubtype());
            }
        } else {
            if (this.getProducerType() == ProducerType.API) {
                if (this.getJsMessageType() == MessageType.SDO) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Incoming message is SDO and will be viewed as JMS");
                    }
                    String string = ((JsApiMessage)((Object)this)).getFormat();
                    try {
                        JmsBodyAdapter jmsBodyAdapter = JmsBodyAdapterRegistry.instance().getBodyAdapter(string);
                        DataGraph dataGraph = ((JsSdoMessage)((Object)this)).getDataGraph();
                        int n = jmsBodyAdapter.bodyType(string);
                        switch (n) {
                            case 0: {
                                jsJmsMessageImpl = new JsJmsSdoBytesMessageImpl(this.jmo);
                                break;
                            }
                            case 1: {
                                jsJmsMessageImpl = new JsJmsSdoTextMessageImpl(this.jmo);
                                break;
                            }
                            default: {
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug(tc, "Unsupported JMS message type " + n + " returned by adapter for format " + string);
                                }
                                String string2 = nls.getFormattedMessage("UNEXPECTED_MESSAGE_FORMAT_CWSIF0103", new Object[]{this.getJsMessageType(), string, new Integer(n)}, "A Message with format " + string + " can not be represented as JMS Message as adapapter type " + n + " is not valid.");
                                IncorrectMessageTypeException incorrectMessageTypeException = new IncorrectMessageTypeException(string2);
                                FFDCFilter.processException((Throwable)incorrectMessageTypeException, (String)"com.ibm.ws.sib.mfp.impl.JsMessageImpl.makeInboundJmsMessage", (String)"jsm1000");
                                throw incorrectMessageTypeException;
                            }
                        }
                        this.setJsMessageType(MessageType.JMS);
                    }
                    catch (SIDataGraphSchemaNotFoundException sIDataGraphSchemaNotFoundException) {
                        FFDCFilter.processException((Throwable)sIDataGraphSchemaNotFoundException, (String)"com.ibm.ws.sib.mfp.impl.JsMessageImpl.makeInboundJmsMessage", (String)"jsm1001");
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Got SIException:" + sIDataGraphSchemaNotFoundException.getMessage());
                        }
                        throw new IncorrectMessageTypeException(sIDataGraphSchemaNotFoundException);
                    }
                    catch (SIMessageException sIMessageException) {
                        FFDCFilter.processException((Throwable)sIMessageException, (String)"com.ibm.ws.sib.mfp.impl.JsMessageImpl.makeInboundJmsMessage", (String)"jsm1002");
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Got SIMessageException:" + sIMessageException.getMessage());
                        }
                        throw new IncorrectMessageTypeException(sIMessageException);
                    }
                    catch (JmsBodyAdapterException jmsBodyAdapterException) {
                        FFDCFilter.processException((Throwable)jmsBodyAdapterException, (String)"com.ibm.ws.sib.mfp.impl.JsMessageImpl.makeInboundJmsMessage", (String)"jsm1003");
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Cannot create JMS adapter for format: " + string);
                        }
                        throw new IncorrectMessageTypeException(jmsBodyAdapterException);
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Other API Messages are not yet supported");
                    }
                    String string = nls.getFormattedMessage("UNEXPECTED_MESSAGE_TYPE_CWSIF0102", new Object[]{this.getJsMessageType(), MessageType.JMS}, "The Message can not be represented as JMS Message");
                    throw new IncorrectMessageTypeException(string);
                }
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Not a JMS or SDO Message");
            }
            String string = nls.getFormattedMessage("UNEXPECTED_MESSAGE_TYPE_CWSIF0102", new Object[]{this.getJsMessageType(), MessageType.JMS}, "The Message can not be represented as JMS Message");
            throw new IncorrectMessageTypeException(string);
        }
        jsJmsMessageImpl.setDerivedJmsFields();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "makeInboundJmsMessage");
        }
        return jsJmsMessageImpl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final JsSdoMessage makeInboundSdoMessage() throws IncorrectMessageTypeException {
        JsSdoMessageImpl jsSdoMessageImpl;
        block14: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "makeInboundSdoMessage");
            }
            jsSdoMessageImpl = null;
            this.updateDataFields();
            if (this.getJsMessageType() == MessageType.SDO) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Incoming message is of type SDO");
                }
                if (this instanceof JsSdoMessageImpl) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "Incoming message is already a JsSdoMessage");
                    }
                    jsSdoMessageImpl = (JsSdoMessageImpl)this;
                } else {
                    jsSdoMessageImpl = new JsSdoMessageImpl(this.jmo);
                }
            } else {
                if (this.getProducerType() == ProducerType.API) {
                    if (this.getJsMessageType() == MessageType.JMS) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Incoming message is JMS and will be viewed as SDO");
                        }
                        jsSdoMessageImpl = new JsSdoMessageImpl(this.jmo);
                        break block14;
                    } else {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(tc, "Other API Messages are not yet supported");
                        }
                        String string = nls.getFormattedMessage("UNEXPECTED_MESSAGE_TYPE_CWSIF0102", new Object[]{this.getJsMessageType(), MessageType.SDO}, "The Message can not be represented as SDO Message");
                        throw new IncorrectMessageTypeException(string);
                    }
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Not a JMS or SDO Message");
                }
                String string = nls.getFormattedMessage("UNEXPECTED_MESSAGE_TYPE_CWSIF0102", new Object[]{this.getJsMessageType(), MessageType.SDO}, "The Message can not be represented as SDO Message");
                throw new IncorrectMessageTypeException(string);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "makeInboundSdoMessage");
        }
        return jsSdoMessageImpl;
    }

    public final TrmMessage makeInboundTrmMessage() throws IncorrectMessageTypeException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "makeInboundTrmMessage");
        }
        TrmMessage trmMessage = null;
        this.updateDataFields();
        if (this.getJsMessageType() == MessageType.TRM) {
            if (this instanceof TrmMessageImpl) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Incoming message is already a TrmMessage");
                }
                trmMessage = (TrmMessageImpl)this;
            } else {
                trmMessage = trmFactory.createInboundTrmMessage(this.jmo, this.getSubtype());
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Not a TRM Message");
            }
            String string = nls.getFormattedMessage("UNEXPECTED_MESSAGE_TYPE_CWSIF0102", new Object[]{this.getJsMessageType(), MessageType.TRM}, "The Message is not a TRM Message");
            throw new IncorrectMessageTypeException(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "makeInboundTrmMessage");
        }
        return trmMessage;
    }

    public final SubscriptionMessage makeInboundSubscriptionMessage() throws IncorrectMessageTypeException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "makeInboundSubscriptionMessage");
        }
        SubscriptionMessageImpl subscriptionMessageImpl = null;
        this.updateDataFields();
        if (this.getJsMessageType() == MessageType.SUBSCRIPTION) {
            if (this instanceof SubscriptionMessageImpl) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Incoming message is already a SubscriptionMessage");
                }
                subscriptionMessageImpl = (SubscriptionMessageImpl)this;
            } else {
                subscriptionMessageImpl = new SubscriptionMessageImpl(this.jmo);
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Not a SUBSCRIPTION Message");
            }
            String string = nls.getFormattedMessage("UNEXPECTED_MESSAGE_TYPE_CWSIF0102", new Object[]{this.getJsMessageType(), MessageType.SUBSCRIPTION}, "The Message is not a SUBSCRIPTION Message");
            throw new IncorrectMessageTypeException(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "makeInboundSubscriptionMessage");
        }
        return subscriptionMessageImpl;
    }

    public final JsMessage getSent() throws MessageCopyFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getSent");
        }
        JsMsgObject jsMsgObject = this.jmo.getCopy();
        JsMessageImpl jsMessageImpl = this.createNew(jsMsgObject);
        if (jsMessageImpl.approxLength == -1) {
            jsMessageImpl.approxLength = this.approxLength;
        }
        this.approxLength = -1;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getSent");
        }
        return jsMessageImpl;
    }

    public final JsMessage getReceived() throws MessageCopyFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getReceived");
        }
        JsMsgObject jsMsgObject = this.jmo.getCopy();
        JsMessageImpl jsMessageImpl = this.createNew(jsMsgObject);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getReceived");
        }
        return jsMessageImpl;
    }

    public final List encode(Object object) throws MessageEncodeFailedException {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "encode");
        }
        return this.jmo.encode(object);
    }

    public final List encodeFast(Object object) throws MessageEncodeFailedException {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "encode");
        }
        return this.jmo.encodeFast(object);
    }

    public final int getEncodedLength() throws MessageEncodeFailedException {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getEncodedLength");
        }
        this.approxLength = n = this.jmo.getEncodedLength();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getEncodedLength", new Integer(n));
        }
        return n;
    }

    public JsMessage transcribeToJmf() throws MessageCopyFailedException, IncorrectMessageTypeException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "transcribeToJmf");
        }
        JsMsgObject jsMsgObject = null;
        if (this instanceof JsJmsSdoBytesMessageImpl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Transcribing from JsJmsSdoBytesMessageImpl");
            }
            jsMsgObject = this.jmo.getCopy();
            object = ((JsJmsSdoBytesMessageImpl)this).getBytes();
            JsMsgPart jsMsgPart = jsMsgObject.getPayloadPart();
            jsMsgPart.setPart(1, JmsBytesBodyAccess.schema);
            JsMsgPart jsMsgPart2 = jsMsgPart.getPart(1, JmsBytesBodyAccess.schema);
            jsMsgPart2.setField(0, object);
        } else if (this instanceof JsJmsSdoTextMessageImpl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Transcribing from JsJmsSdoTextMessageImpl");
            }
            jsMsgObject = this.jmo.getCopy();
            object = ((JsJmsSdoTextMessageImpl)this).getText();
            JsMsgPart jsMsgPart = jsMsgObject.getPayloadPart();
            jsMsgPart.setPart(1, JmsTextBodyAccess.schema);
            JsMsgPart jsMsgPart3 = jsMsgPart.getPart(1, JmsTextBodyAccess.schema);
            jsMsgPart3.setField(0, object);
        } else if (this instanceof JsJmsMessageImpl) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Transcribing from JsJmsMessageImpl");
            }
            jsMsgObject = this.jmo.transcribeToJmf();
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Non-JMS Messages are not yet supported");
            }
            String string = nls.getFormattedMessage("UNEXPECTED_MESSAGE_TYPE_CWSIF0102", new Object[]{this.getJsMessageType(), MessageType.JMS}, "The Message can not be represented as a pure JMF Message");
            throw new IncorrectMessageTypeException(string);
        }
        object = this.createNewGeneralized(jsMsgObject);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "transcribeToJmf", object);
        }
        return object;
    }

    public final byte[] flatten(Object object) throws MessageEncodeFailedException {
        long[] lArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "flatten");
        }
        if (object != null) {
            if (!(object instanceof MessageStore)) {
                throw new IllegalArgumentException("store is not a MessageStore instance");
            }
            JMFSchema[] jMFSchemaArray = this.jmo.getEncodingSchemas();
            SchemaStore.saveSchemas((MessageStore)object, jMFSchemaArray);
            lArray = new long[jMFSchemaArray.length];
            for (int i = 0; i < jMFSchemaArray.length; ++i) {
                lArray[i] = jMFSchemaArray[i].getID();
            }
        } else {
            lArray = new long[]{};
        }
        int n = 0;
        n += ArrayUtil.INT_SIZE;
        byte[] byArray = null;
        try {
            byArray = this.getClass().getName().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.sib.mfp.impl.JsMessageImpl.flatten", (String)"jsm100");
            byArray = this.getClass().getName().getBytes();
        }
        n += byArray.length;
        n += ArrayUtil.INT_SIZE;
        n += lArray.length * ArrayUtil.LONG_SIZE;
        byte[] byArray2 = new byte[n += this.jmo.getEncodedLength()];
        int n2 = 0;
        ArrayUtil.writeInt(byArray2, n2, byArray.length);
        ArrayUtil.writeBytes(byArray2, n2 += ArrayUtil.INT_SIZE, byArray);
        ArrayUtil.writeInt(byArray2, n2 += byArray.length, lArray.length);
        n2 += ArrayUtil.INT_SIZE;
        for (int i = 0; i < lArray.length; ++i) {
            ArrayUtil.writeLong(byArray2, n2, lArray[i]);
            n2 += ArrayUtil.LONG_SIZE;
        }
        this.jmo.flatten(byArray2, n2);
        this.approxLength = n;
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "flatten");
        }
        return byArray2;
    }

    public int getApproximateLength() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getApproximateLength");
        }
        if (this.approxLength == -1) {
            this.approxLength = this.guessApproxLength();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getApproximateLength", new Integer(this.approxLength));
        }
        return this.approxLength;
    }

    protected void setApproximateLength(int n) {
        this.approxLength = n;
    }

    public MQJsMessageEncoder getMQEncoder(String string, String string2, String string3, String string4, int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public WebJsMessageEncoder getWebEncoder() {
        throw new UnsupportedOperationException();
    }

    int guessApproxLength() {
        int n = super.guessApproxLength();
        n += 200;
        List list = (List)this.getHdr2().getField(0);
        List list2 = (List)this.getHdr2().getField(4);
        int n2 = 0;
        if (list != null) {
            n2 += list.size();
        }
        if (list2 != null) {
            n2 += list2.size();
        }
        return n += n2 * 50;
    }

    public Object getIdentifierValue(Identifier identifier, boolean bl) throws BadMessageFormatMatchingException {
        throw new BadMessageFormatMatchingException(nls.getFormattedMessage("NOT_API_MESSAGE_CWSIF0101", new Object[]{this.getSystemMessageId()}, "Message selectors are not supported for message " + this.getSystemMessageId()));
    }

    final synchronized JsMsgPart getApi() {
        if (this.api == null) {
            this.api = this.jmo.getPart(9, JsApiAccess.schema);
        }
        return this.api;
    }

    final synchronized JsMsgPart getPayload(JMFSchema jMFSchema) {
        if (this.payload == null) {
            this.payload = this.jmo.getPayloadPart().getPart(1, jMFSchema);
        }
        return this.payload;
    }

    final synchronized void clearPartCaches() {
        super.clearPartCaches();
        this.payload = null;
        this.api = null;
    }

    private final JsMessageImpl createNew(JsMsgObject jsMsgObject) throws MessageCopyFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createNew");
        }
        JsMessageImpl jsMessageImpl = null;
        Class<?> clazz = this.getClass();
        try {
            jsMessageImpl = (JsMessageImpl)clazz.newInstance();
            jsMessageImpl.setJmo(jsMsgObject);
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.sib.mfp.impl.JsMessageImpl.createNew", (String)"jsm1600");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "IllegalAccessException " + illegalAccessException.getMessage() + " instantiating class " + clazz.getName());
            }
            throw new MessageCopyFailedException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.sib.mfp.impl.JsMessageImpl.createNew", (String)"jsm1610");
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "InstantiationException " + instantiationException.getMessage() + " instantiating class " + clazz.getName());
            }
            throw new MessageCopyFailedException(instantiationException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createNew", jsMessageImpl.getClass());
        }
        return jsMessageImpl;
    }

    private final JsMessageImpl createNewGeneralized(JsMsgObject jsMsgObject) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createNewGeneralized");
        }
        JsMessageImpl jsMessageImpl = null;
        jsMessageImpl = new JsMessageImpl(jsMsgObject);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createNewGeneralized", jsMessageImpl);
        }
        return jsMessageImpl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp.impl/src/com/ibm/ws/sib/mfp/impl/JsMessageImpl.java, SIB.mfp, WAS602.SIB, o0610.11 1.133");
        }
    }
}

