/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jms.JmsInternalsFactory;
import com.ibm.ws.sib.api.jms.JmsSharedUtils;
import com.ibm.ws.sib.matchspace.BadMessageFormatMatchingException;
import com.ibm.ws.sib.matchspace.Identifier;
import com.ibm.ws.sib.mfp.JsApiMessage;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.impl.JsApiHdrsImpl;
import com.ibm.ws.sib.mfp.impl.JsMsgMap;
import com.ibm.ws.sib.mfp.impl.JsMsgObject;
import com.ibm.ws.sib.mfp.impl.MQBrokerControlInfoAdapter;
import com.ibm.ws.sib.mfp.mqcontrol.MQBrokerMessageFactory;
import com.ibm.ws.sib.mfp.mqcontrol.MQPublicationInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.WsObjectInputStream;
import com.ibm.wsspi.sib.core.SelectorDomain;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;

abstract class JsApiMessageImpl
extends JsApiHdrsImpl
implements JsApiMessage {
    private static final long serialVersionUID = 1L;
    private static TraceComponent tc = SibTr.register(class$com$ibm$ws$sib$mfp$impl$JsApiMessageImpl == null ? (class$com$ibm$ws$sib$mfp$impl$JsApiMessageImpl = JsApiMessageImpl.class$("com.ibm.ws.sib.mfp.impl.JsApiMessageImpl")) : class$com$ibm$ws$sib$mfp$impl$JsApiMessageImpl, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    public static final String $ssccid = "@(#) 1.70 SIB/ws/code/sib.mfp.impl/src/com/ibm/ws/sib/mfp/impl/JsApiMessageImpl.java, SIB.mfp, WAS602.SIB, o0610.11 05/03/30 02:50:25 [3/13/06 13:33:15]";
    private static final String ID_STRING = "ID:";
    private static final JmsSharedUtils jmsUtils;
    private static final String USER_PREFIX = "user.";
    private static final int USER_PREFIX_LENGTH;
    private static final String SI_PREFIX = "SI_";
    private static final int SI_PREFIX_LENGTH;
    private static final String SI_REPORT = "Report";
    private static final int SI_REPORT_LENGTH;
    private static final int SI_REPORT_OFFSET;
    private static final String SI_EXCEPTION = "Exception";
    private static final int SI_EXCEPTION_LENGTH;
    private static final int SI_EXCEPTION_OFFSET;
    static final String JMS_PREFIX = "JMS";
    static final int JMS_LENGTH = 3;
    static final char JMSX_EXTRA_PREFIX = 'X';
    static final int JMSX_LENGTH = 4;
    static final String JMS_IBM_EXTRA_PREFIX = "_IBM_";
    static final int JMS_IBM_LENGTH = 8;
    static final String REPORT = "Report_";
    static final int REPORT_LENGTH;
    static final int REPORT_OFFSET;
    private static final Set SETTABLE_JMSX;
    private static final Set SETTABLE_JMS_IBM;
    private static final byte HEADER_BYTE_0 = -34;
    private static final byte HEADER_BYTE_1 = -83;
    private transient JsMsgMap jmsSystemPropertyMap = null;
    private transient JsMsgMap jmsUserPropertyMap = null;
    private transient JsMsgMap otherUserPropertyMap = null;
    private transient JsMsgMap systemContextMap = null;
    static /* synthetic */ Class class$com$ibm$ws$sib$mfp$impl$JsApiMessageImpl;

    JsApiMessageImpl() {
    }

    JsApiMessageImpl(int n) throws MessageDecodeFailedException {
        super(n);
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "<init>");
        }
    }

    JsApiMessageImpl(JsMsgObject jsMsgObject) {
        super(jsMsgObject);
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "<init>, inbound jmo ");
        }
    }

    int guessApproxLength() {
        int n = super.guessApproxLength();
        List list = (List)this.getApi().getField(38);
        List list2 = (List)this.getApi().getField(40);
        List list3 = (List)this.getApi().getField(36);
        int n2 = 0;
        if (list != null) {
            n2 += list.size();
        }
        if (list2 != null) {
            n2 += list2.size();
        }
        if (list3 != null) {
            n2 += list3.size();
        }
        return n += n2 * 40;
    }

    public final Serializable getMessageProperty(String string) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getMessageProperty", (Object)string);
        }
        Serializable serializable = null;
        if (string != null) {
            if (string.startsWith(USER_PREFIX)) {
                String string2 = string.substring(USER_PREFIX_LENGTH);
                serializable = this.getUserProperty(string2, false);
            } else if (string.startsWith(SI_PREFIX)) {
                serializable = this.getSIProperty(string, false);
            } else if (string.startsWith(JMS_PREFIX)) {
                serializable = this.getJMSSystemProperty(string, false);
            } else {
                throw new IllegalArgumentException(string);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getMessageProperty");
        }
        return serializable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setMessageProperty(String string, Serializable serializable) throws IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setMessageProperty", (Object)string);
        }
        if (string != null) {
            if (serializable != null) {
                if (string.startsWith(USER_PREFIX)) {
                    this.setUserProperty(string.substring(USER_PREFIX_LENGTH), serializable);
                } else if (string.startsWith(SI_PREFIX)) {
                    this.setSIProperty(string, serializable);
                } else {
                    if (!string.startsWith(JMS_PREFIX)) throw new IllegalArgumentException(string);
                    this.setJMSSystemProperty(string, serializable);
                }
            } else {
                this.deleteMessageProperty(string);
            }
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit(tc, "setMessageProperty");
    }

    public final void deleteMessageProperty(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "deleteMessageProperty", (Object)string);
        }
        if (string != null) {
            if (string.startsWith(USER_PREFIX)) {
                String string2 = string.substring(USER_PREFIX_LENGTH);
                this.deleteUserProperty(string2);
            } else if (string.startsWith(SI_PREFIX)) {
                this.deleteSIProperty(string);
            } else if (string.startsWith(JMS_PREFIX)) {
                this.deleteJMSSystemProperty(string);
            } else {
                throw new IllegalArgumentException(string);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "deleteMessageProperty");
        }
    }

    public final void clearMessageProperties() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "clearMessageProperties");
        }
        this.getJmsSystemPropertyMap().clear();
        this.getJmsUserPropertyMap().clear();
        this.getOtherUserPropertyMap().clear();
        this.clearSmokeAndMirrorsProperties();
        this.setJmsType(null);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "clearMessageProperties");
        }
    }

    public final Serializable getUserProperty(String string) throws IOException, ClassNotFoundException {
        if (string != null) {
            return this.getUserProperty(string, false);
        }
        return null;
    }

    public final void setUserProperty(String string, Serializable serializable) throws IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setUserProperty", (Object)string);
        }
        if (string != null) {
            if (serializable != null) {
                boolean bl = string.equals("transportVersion");
                if (this.isValidForJms(serializable)) {
                    if (bl) {
                        this.setTransportVersion(serializable);
                        this.getOtherUserPropertyMap().remove(string);
                    } else {
                        this.getJmsUserPropertyMap().put(string, serializable);
                        this.getOtherUserPropertyMap().remove(string);
                    }
                } else {
                    this.getOtherUserPropertyMap().put(string, this.flattenMapObject(serializable));
                    if (bl) {
                        this.clearTransportVersion();
                    } else {
                        this.getJmsUserPropertyMap().remove(string);
                    }
                }
            } else {
                this.deleteUserProperty(string);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setUserProperty");
        }
    }

    public final void deleteUserProperty(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "deleteUserProperty", (Object)string);
        }
        if (string != null) {
            if (string.equals("transportVersion")) {
                if (this.isTransportVersionSet()) {
                    this.clearTransportVersion();
                } else {
                    this.getOtherUserPropertyMap().remove(string);
                }
            } else if (this.getJmsUserPropertyMap().remove(string) == null) {
                this.getOtherUserPropertyMap().remove(string);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "deleteUserProperty");
        }
    }

    public final void clearUserProperties() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "clearUserProperties");
        }
        this.getJmsUserPropertyMap().clear();
        this.getOtherUserPropertyMap().clear();
        this.clearTransportVersion();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "clearUserProperties");
        }
    }

    public final List getUserPropertyNames() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getUserPropertyNames");
        }
        ArrayList arrayList = new ArrayList(this.getJmsUserPropertyMap().keySet());
        arrayList.addAll(this.getOtherUserPropertyMap().keySet());
        if (this.isTransportVersionSet()) {
            arrayList.add("transportVersion");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getUserPropertyNames", arrayList);
        }
        return arrayList;
    }

    public boolean userPropertyExists(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "userPropertyExists", (Object)string);
        }
        boolean bl = false;
        if (string != null) {
            if (string.equals("transportVersion") && this.isTransportVersionSet()) {
                bl = true;
            } else if (this.getJmsUserPropertyMap().containsKey(string)) {
                bl = true;
            } else if (this.getOtherUserPropertyMap().containsKey(string)) {
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "userPropertyExists", new Boolean(bl));
        }
        return bl;
    }

    public final Serializable getSystemContextItem(String string) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getSystemContextItem", (Object)string);
        }
        Serializable serializable = null;
        if (string != null) {
            serializable = (Serializable)this.getSystemContextMap().get(string);
            if (!(serializable == null || serializable instanceof String || serializable instanceof Number || serializable instanceof Boolean)) {
                serializable = this.restoreMapObject((byte[])serializable);
            }
        } else {
            throw new IllegalArgumentException("null");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getSystemContextItem", serializable);
        }
        return serializable;
    }

    public void putSystemContextItem(String string, Serializable serializable) throws IllegalArgumentException, IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "putSystemContextItem", new Object[]{string, serializable});
        }
        if (string != null) {
            if (serializable != null) {
                if (this.isValidForJms(serializable)) {
                    this.getSystemContextMap().put(string, serializable);
                } else {
                    this.getSystemContextMap().put(string, this.flattenMapObject(serializable));
                }
            } else {
                this.getSystemContextMap().remove(string);
            }
        } else {
            throw new IllegalArgumentException("null");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "putSystemContextItem");
        }
    }

    public Object getIdentifierValue(Identifier identifier, boolean bl) throws BadMessageFormatMatchingException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getIdentifierValue", (Object)identifier.getName());
        }
        SelectorDomain selectorDomain = SelectorDomain.getSelectorDomain(identifier.getSelectorDomain());
        String string = identifier.getName();
        Object object = null;
        if (string.startsWith(JMS_PREFIX)) {
            if (!(string.equals("JMSDestination") || string.equals("JMSReplyTo") || string.equals("JMS_IBM_ExceptionMessage"))) {
                object = this.getJMSSystemProperty(string, true);
            }
        } else if (selectorDomain == SelectorDomain.JMS) {
            object = this.getJmsUserPropertyMap().get(string);
            if (object == null && string.equals("transportVersion")) {
                object = this.getTransportVersion();
            }
        } else if (selectorDomain == SelectorDomain.SIMESSAGE) {
            if (string.startsWith(SI_PREFIX)) {
                if (!string.equals("SI_ExceptionInserts")) {
                    object = this.getSIProperty(string, true);
                }
            } else if (string.startsWith(USER_PREFIX)) {
                String string2 = string.substring(USER_PREFIX_LENGTH);
                try {
                    object = this.getUserProperty(string2, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (object != null && !bl) {
            object = this.typeCheck(object, identifier.getType());
        }
        if (object == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getIdentifierValue", null);
            }
        } else if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getIdentifierValue", new Object[]{object, object.getClass()});
        }
        return object;
    }

    private final Object typeCheck(Object object, int n) {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "typecheck: value = " + object + ", " + object.getClass() + " , type=" + n);
        }
        switch (n) {
            case 0: {
                return object;
            }
            case -5: {
                return object instanceof String ? object : null;
            }
            case -6: {
                return object instanceof Boolean ? object : null;
            }
        }
        return object instanceof Number ? object : null;
    }

    final Map getJmsSystemPropertyMap() {
        if (this.jmsSystemPropertyMap == null) {
            List list = (List)this.getApi().getField(36);
            List list2 = (List)this.getApi().getField(37);
            this.jmsSystemPropertyMap = new JsMsgMap(list, list2);
        }
        return this.jmsSystemPropertyMap;
    }

    final Map getJmsUserPropertyMap() {
        if (this.jmsUserPropertyMap == null) {
            List list = (List)this.getApi().getField(38);
            List list2 = (List)this.getApi().getField(39);
            this.jmsUserPropertyMap = new JsMsgMap(list, list2);
        }
        return this.jmsUserPropertyMap;
    }

    final Map getOtherUserPropertyMap() {
        if (this.otherUserPropertyMap == null) {
            List list = (List)this.getApi().getField(40);
            List list2 = (List)this.getApi().getField(41);
            this.otherUserPropertyMap = new JsMsgMap(list, list2);
        }
        return this.otherUserPropertyMap;
    }

    final Map getSystemContextMap() {
        if (this.systemContextMap == null) {
            List list = (List)this.getApi().getField(42);
            List list2 = (List)this.getApi().getField(43);
            this.systemContextMap = new JsMsgMap(list, list2);
        }
        return this.systemContextMap;
    }

    void updateDataFields() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "updateDataFields");
        }
        super.updateDataFields();
        if (this.jmsSystemPropertyMap != null && this.jmsSystemPropertyMap.isChanged()) {
            this.getApi().setField(36, this.jmsSystemPropertyMap.getKeyList());
            this.getApi().setField(37, this.jmsSystemPropertyMap.getValueList());
        }
        if (this.jmsUserPropertyMap != null && this.jmsUserPropertyMap.isChanged()) {
            this.getApi().setField(38, this.jmsUserPropertyMap.getKeyList());
            this.getApi().setField(39, this.jmsUserPropertyMap.getValueList());
        }
        if (this.otherUserPropertyMap != null && this.otherUserPropertyMap.isChanged()) {
            this.getApi().setField(40, this.otherUserPropertyMap.getKeyList());
            this.getApi().setField(41, this.otherUserPropertyMap.getValueList());
        }
        if (this.systemContextMap != null && this.systemContextMap.isChanged()) {
            this.getApi().setField(42, this.systemContextMap.getKeyList());
            this.getApi().setField(43, this.systemContextMap.getValueList());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "updateDataFields");
        }
    }

    private final Serializable getUserProperty(String string, boolean bl) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getUserProperty", new Object[]{string, new Boolean(bl)});
        }
        Serializable serializable = null;
        serializable = string.equals("transportVersion") && this.isTransportVersionSet() ? (Serializable)this.getTransportVersion() : (Serializable)this.getJmsUserPropertyMap().get(string);
        if (serializable == null && (serializable = (Serializable)this.getOtherUserPropertyMap().get(string)) != null && !bl) {
            serializable = this.restoreMapObject((byte[])serializable);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getUserProperty", serializable);
        }
        return serializable;
    }

    private final Serializable getSIProperty(String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getSIProperty", (Object)string);
        }
        Object object = null;
        if (string.regionMatches(SI_PREFIX_LENGTH, SI_REPORT, 0, SI_REPORT_LENGTH)) {
            int n = string.length() - SI_REPORT_OFFSET;
            if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportExpiration", SI_REPORT_OFFSET, n)) {
                object = this.getReportExpiry();
            } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportException", SI_REPORT_OFFSET, n)) {
                object = this.getReportException();
            } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportCOA", SI_REPORT_OFFSET, n)) {
                object = this.getReportCOA();
            } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportCOD", SI_REPORT_OFFSET, n)) {
                object = this.getReportCOD();
            } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportPAN", SI_REPORT_OFFSET, n)) {
                object = this.getReportPAN();
            } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportNAN", SI_REPORT_OFFSET, n)) {
                object = this.getReportNAN();
            } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportPassMsgID", SI_REPORT_OFFSET, n)) {
                object = this.getReportPassMsgId();
            } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportPassCorrelID", SI_REPORT_OFFSET, n)) {
                object = this.getReportPassCorrelId();
            } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportDiscardMsg", SI_REPORT_OFFSET, n)) {
                object = this.getReportDiscardMsg();
            } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportFeedback", SI_REPORT_OFFSET, n)) {
                object = this.getReportFeedback();
            } else if (!bl) {
                throw new IllegalArgumentException(string);
            }
        } else if (string.regionMatches(SI_PREFIX_LENGTH, SI_EXCEPTION, 0, SI_EXCEPTION_LENGTH)) {
            int n = string.length() - SI_EXCEPTION_OFFSET;
            if (string.regionMatches(SI_EXCEPTION_OFFSET, "SI_ExceptionReason", SI_EXCEPTION_OFFSET, n)) {
                object = this.getExceptionReason();
            } else if (string.regionMatches(SI_EXCEPTION_OFFSET, "SI_ExceptionInserts", SI_EXCEPTION_OFFSET, n)) {
                object = this.getExceptionInserts();
            } else if (string.regionMatches(SI_EXCEPTION_OFFSET, "SI_ExceptionTimestamp", SI_EXCEPTION_OFFSET, n)) {
                object = this.getExceptionTimestamp();
            } else if (string.regionMatches(SI_EXCEPTION_OFFSET, "SI_ExceptionProblemDestination", SI_EXCEPTION_OFFSET, n)) {
                object = this.getExceptionProblemDestination();
            } else if (!bl) {
                throw new IllegalArgumentException(string);
            }
        } else if (bl) {
            int n = string.length() - SI_PREFIX_LENGTH;
            if (string.regionMatches(SI_PREFIX_LENGTH, "SI_NextDestination", SI_PREFIX_LENGTH, n)) {
                List list = this.getForwardRoutingPath();
                if (list != null && list.size() > 0) {
                    object = ((JsDestinationAddress)list.get(0)).getDestinationName();
                }
            } else if (string.regionMatches(SI_PREFIX_LENGTH, "SI_SystemMessageID", SI_PREFIX_LENGTH, n)) {
                object = this.getSystemMessageId();
            } else if (string.regionMatches(SI_PREFIX_LENGTH, "SI_Reliability", SI_PREFIX_LENGTH, n)) {
                object = this.getReliability().toString();
            } else if (string.regionMatches(SI_PREFIX_LENGTH, "SI_Priority", SI_PREFIX_LENGTH, n)) {
                object = this.getPriority();
            } else if (string.regionMatches(SI_PREFIX_LENGTH, "SI_TimeToLive", SI_PREFIX_LENGTH, n)) {
                object = this.getTimeToLive();
            } else if (string.regionMatches(SI_PREFIX_LENGTH, "SI_Discriminator", SI_PREFIX_LENGTH, n)) {
                object = this.getDiscriminator();
            } else if (string.regionMatches(SI_PREFIX_LENGTH, "SI_ReplyReliability", SI_PREFIX_LENGTH, n)) {
                Reliability reliability = this.getReplyReliability();
                object = reliability == null ? null : reliability.toString();
            } else if (string.regionMatches(SI_PREFIX_LENGTH, "SI_ReplyPriority", SI_PREFIX_LENGTH, n)) {
                object = this.getReplyPriority();
            } else if (string.regionMatches(SI_PREFIX_LENGTH, "SI_ReplyTimeToLive", SI_PREFIX_LENGTH, n)) {
                object = this.getReplyTimeToLive();
            } else if (string.regionMatches(SI_PREFIX_LENGTH, "SI_ReplyDiscriminator", SI_PREFIX_LENGTH, n)) {
                object = this.getReplyDiscriminator();
            } else if (string.regionMatches(SI_PREFIX_LENGTH, "SI_RedeliveredCount", SI_PREFIX_LENGTH, n)) {
                object = this.getRedeliveredCount();
            } else if (string.regionMatches(SI_PREFIX_LENGTH, "SI_MessageID", SI_PREFIX_LENGTH, n)) {
                object = this.getApiMessageId();
            } else if (string.regionMatches(SI_PREFIX_LENGTH, "SI_CorrelationID", SI_PREFIX_LENGTH, n)) {
                object = this.getCorrelationId();
            } else if (string.regionMatches(SI_PREFIX_LENGTH, "SI_UserID", SI_PREFIX_LENGTH, n)) {
                object = this.getUserid();
            } else if (string.regionMatches(SI_PREFIX_LENGTH, "SI_Format", SI_PREFIX_LENGTH, n)) {
                object = this.getFormat();
            }
        } else {
            throw new IllegalArgumentException(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getSIProperty", object);
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void setSIProperty(String string, Serializable serializable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setSIProperty", new Object[]{string, serializable});
        }
        if (!string.regionMatches(SI_PREFIX_LENGTH, SI_REPORT, 0, SI_REPORT_LENGTH)) throw new IllegalArgumentException(string);
        int n = string.length() - SI_REPORT_OFFSET;
        if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportExpiration", SI_REPORT_OFFSET, n)) {
            this.setReportExpiry((Byte)serializable);
        } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportException", SI_REPORT_OFFSET, n)) {
            this.setReportException((Byte)serializable);
        } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportCOA", SI_REPORT_OFFSET, n)) {
            this.setReportCOA((Byte)serializable);
        } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportCOD", SI_REPORT_OFFSET, n)) {
            this.setReportCOD((Byte)serializable);
        } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportPAN", SI_REPORT_OFFSET, n)) {
            this.setReportPAN((Boolean)serializable);
        } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportNAN", SI_REPORT_OFFSET, n)) {
            this.setReportNAN((Boolean)serializable);
        } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportPassMsgID", SI_REPORT_OFFSET, n)) {
            this.setReportPassMsgId((Boolean)serializable);
        } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportPassCorrelID", SI_REPORT_OFFSET, n)) {
            this.setReportPassCorrelId((Boolean)serializable);
        } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportDiscardMsg", SI_REPORT_OFFSET, n)) {
            this.setReportDiscardMsg((Boolean)serializable);
        } else {
            if (!string.regionMatches(SI_REPORT_OFFSET, "SI_ReportFeedback", SI_REPORT_OFFSET, n)) throw new IllegalArgumentException(string);
            this.setReportFeedback((Integer)serializable);
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit(tc, "setSIProperty");
    }

    private final void deleteSIProperty(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "deleteSIProperty", (Object)string);
        }
        if (string.regionMatches(SI_PREFIX_LENGTH, SI_REPORT, 0, SI_REPORT_LENGTH)) {
            int n = string.length() - SI_REPORT_OFFSET;
            if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportExpiration", SI_REPORT_OFFSET, n)) {
                this.getHdr2().setChoiceField(59, 0);
            } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportCOA", SI_REPORT_OFFSET, n)) {
                this.getHdr2().setChoiceField(61, 0);
            } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportCOD", SI_REPORT_OFFSET, n)) {
                this.getHdr2().setChoiceField(60, 0);
            } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportException", SI_REPORT_OFFSET, n)) {
                this.getApi().setChoiceField(51, 0);
            } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportPAN", SI_REPORT_OFFSET, n)) {
                this.getApi().setChoiceField(52, 0);
            } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportNAN", SI_REPORT_OFFSET, n)) {
                this.getApi().setChoiceField(53, 0);
            } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportPassMsgID", SI_REPORT_OFFSET, n)) {
                this.getApi().setChoiceField(54, 0);
            } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportPassCorrelID", SI_REPORT_OFFSET, n)) {
                this.getApi().setChoiceField(55, 0);
            } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportDiscardMsg", SI_REPORT_OFFSET, n)) {
                this.getApi().setChoiceField(56, 0);
            } else if (string.regionMatches(SI_REPORT_OFFSET, "SI_ReportFeedback", SI_REPORT_OFFSET, n)) {
                this.getApi().setChoiceField(57, 0);
                this.getApi().setChoiceField(60, 0);
            }
        } else {
            throw new IllegalArgumentException(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "deleteSIProperty");
        }
    }

    final Serializable getJMSSystemProperty(String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getJMSSystemProperty", (Object)string);
        }
        Object object = null;
        if (string.charAt(3) == 'X') {
            int n = string.length() - 4;
            object = string.regionMatches(4, "JMSXDeliveryCount", 4, n) ? new Integer(this.getJmsxDeliveryCount()) : (string.regionMatches(4, "JMSXAppID", 4, n) ? this.getJmsxAppId() : (string.regionMatches(4, "JMSXUserID", 4, n) ? this.getUserid() : (Serializable)this.getJmsSystemPropertyMap().get(string)));
        } else if (string.startsWith(JMS_IBM_EXTRA_PREFIX, 3)) {
            if (string.regionMatches(8, REPORT, 0, REPORT_LENGTH)) {
                int n = string.length() - REPORT_OFFSET;
                if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Expiration", REPORT_OFFSET, n)) {
                    object = this.getReportExpiry();
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Exception", REPORT_OFFSET, n)) {
                    object = this.getReportException();
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_COA", REPORT_OFFSET, n)) {
                    object = this.getReportCOA();
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_COD", REPORT_OFFSET, n)) {
                    object = this.getReportCOD();
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_PAN", REPORT_OFFSET, n)) {
                    object = this.getReportPAN();
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_NAN", REPORT_OFFSET, n)) {
                    object = this.getReportNAN();
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Pass_Msg_ID", REPORT_OFFSET, n)) {
                    object = this.getReportPassMsgId();
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Pass_Correl_ID", REPORT_OFFSET, n)) {
                    object = this.getReportPassCorrelId();
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Discard_Msg", REPORT_OFFSET, n)) {
                    object = this.getReportDiscardMsg();
                }
            } else {
                int n = string.length() - 8;
                if (string.regionMatches(8, "JMS_IBM_ExceptionReason", 8, n)) {
                    object = this.getExceptionReason();
                } else if (string.regionMatches(8, "JMS_IBM_ExceptionTimestamp", 8, n)) {
                    object = this.getExceptionTimestamp();
                } else if (string.regionMatches(8, "JMS_IBM_ExceptionProblemDestination", 8, n)) {
                    object = this.getExceptionProblemDestination();
                } else if (string.regionMatches(8, "JMS_IBM_ExceptionMessage", 8, n)) {
                    object = this.getExceptionMessage();
                } else if (string.regionMatches(8, "JMS_IBM_Feedback", 8, n)) {
                    object = this.getReportFeedback();
                    object = jmsUtils.convertJSFeedbackToMQ((Integer)object);
                } else {
                    object = string.regionMatches(8, "JMS_IBM_System_MessageID", 8, n) ? this.getSystemMessageId() : (Serializable)this.getJmsSystemPropertyMap().get(string);
                }
            }
        } else {
            int n = string.length() - 3;
            if (string.regionMatches(3, "JMSDestination", 3, n)) {
                object = this.getJmsDestination();
                if (object != null && !bl) {
                    byte[] byArray = new byte[((byte[])object).length];
                    System.arraycopy((byte[])object, 0, byArray, 0, ((byte[])object).length);
                    object = byArray;
                }
            } else if (string.regionMatches(3, "JMSDeliveryMode", 3, n)) {
                object = this.getJmsDeliveryMode().toString();
            } else if (string.regionMatches(3, "JMSMessageID", 3, n)) {
                object = this.getApiMessageId();
            } else if (string.regionMatches(3, "JMSTimestamp", 3, n)) {
                object = this.getTimestamp();
            } else if (string.regionMatches(3, "JMSExpiration", 3, n)) {
                object = this.getJmsExpiration();
            } else if (string.regionMatches(3, "JMSRedelivered", 3, n)) {
                object = this.getJmsRedelivered();
            } else if (string.regionMatches(3, "JMSPriority", 3, n)) {
                object = this.getPriority();
            } else if (string.regionMatches(3, "JMSReplyTo", 3, n)) {
                object = this.getJmsReplyTo();
                if (object != null && !bl) {
                    byte[] byArray = new byte[((byte[])object).length];
                    System.arraycopy((byte[])object, 0, byArray, 0, ((byte[])object).length);
                    object = byArray;
                }
            } else if (string.regionMatches(3, "JMSCorrelationID", 3, n)) {
                object = this.getCorrelationId();
            } else if (string.regionMatches(3, "JMSType", 3, n)) {
                object = this.getJmsType();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getJMSSystemProperty", object);
        }
        return object;
    }

    final void setJMSSystemProperty(String string, Serializable serializable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setJMSSystemProperty", new Object[]{string, serializable});
        }
        if (string.charAt(3) == 'X') {
            if (!SETTABLE_JMSX.contains(string)) {
                throw new IllegalArgumentException(string);
            }
            if (string.equals("JMSXAppID")) {
                this.setJmsxAppId((String)((Object)serializable));
            } else if (string.equals("JMSXUserID")) {
                this.setUserid((String)((Object)serializable));
            } else {
                this.getJmsSystemPropertyMap().put(string, serializable);
            }
        } else if (string.startsWith(JMS_IBM_EXTRA_PREFIX, 3)) {
            if (!SETTABLE_JMS_IBM.contains(string)) {
                throw new IllegalArgumentException(string);
            }
            if (string.regionMatches(8, REPORT, 0, REPORT_LENGTH)) {
                int n = string.length() - REPORT_OFFSET;
                if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Expiration", REPORT_OFFSET, n)) {
                    this.setReportExpiry((Byte)serializable);
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_COA", REPORT_OFFSET, n)) {
                    this.setReportCOA((Byte)serializable);
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_COD", REPORT_OFFSET, n)) {
                    this.setReportCOD((Byte)serializable);
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Exception", REPORT_OFFSET, n)) {
                    this.setReportException((Byte)serializable);
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_PAN", REPORT_OFFSET, n)) {
                    this.setReportPAN((Boolean)serializable);
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_NAN", REPORT_OFFSET, n)) {
                    this.setReportNAN((Boolean)serializable);
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Pass_Msg_ID", REPORT_OFFSET, n)) {
                    this.setReportPassMsgId((Boolean)serializable);
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Pass_Correl_ID", REPORT_OFFSET, n)) {
                    this.setReportPassCorrelId((Boolean)serializable);
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Discard_Msg", REPORT_OFFSET, n)) {
                    this.setReportDiscardMsg((Boolean)serializable);
                }
            } else {
                int n = string.length() - 8;
                if (string.regionMatches(8, "JMS_IBM_Feedback", 8, n)) {
                    this.setReportFeedback(jmsUtils.convertMQFeedbackToJS((Integer)serializable));
                } else {
                    this.getJmsSystemPropertyMap().put(string, serializable);
                }
            }
        } else if (string.equals("JMSType")) {
            this.setJmsType((String)((Object)serializable));
        } else {
            throw new IllegalArgumentException(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setJMSSystemProperty");
        }
    }

    private final void deleteJMSSystemProperty(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "deleteJMSSystemProperty", (Object)string);
        }
        if (string.charAt(3) == 'X') {
            if (!SETTABLE_JMSX.contains(string)) {
                throw new IllegalArgumentException(string);
            }
            if (string.equals("JMSXAppID")) {
                this.setJmsxAppId(null);
            } else if (string.equals("JMSXUserID")) {
                this.setUserid(null);
            } else {
                this.getJmsSystemPropertyMap().remove(string);
            }
        } else if (string.startsWith(JMS_IBM_EXTRA_PREFIX, 3)) {
            if (!SETTABLE_JMS_IBM.contains(string)) {
                throw new IllegalArgumentException(string);
            }
            if (string.regionMatches(8, REPORT, 0, REPORT_LENGTH)) {
                int n = string.length() - REPORT_OFFSET;
                if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Expiration", REPORT_OFFSET, n)) {
                    this.getHdr2().setChoiceField(59, 0);
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_COA", REPORT_OFFSET, n)) {
                    this.getHdr2().setChoiceField(61, 0);
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_COD", REPORT_OFFSET, n)) {
                    this.getHdr2().setChoiceField(60, 0);
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Exception", REPORT_OFFSET, n)) {
                    this.getApi().setChoiceField(51, 0);
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_PAN", REPORT_OFFSET, n)) {
                    this.getApi().setChoiceField(52, 0);
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_NAN", REPORT_OFFSET, n)) {
                    this.getApi().setChoiceField(53, 0);
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Pass_Msg_ID", REPORT_OFFSET, n)) {
                    this.getApi().setChoiceField(54, 0);
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Pass_Correl_ID", REPORT_OFFSET, n)) {
                    this.getApi().setChoiceField(55, 0);
                } else if (string.regionMatches(REPORT_OFFSET, "JMS_IBM_Report_Discard_Msg", REPORT_OFFSET, n)) {
                    this.getApi().setChoiceField(56, 0);
                }
            } else {
                int n = string.length() - 8;
                if (string.regionMatches(8, "JMS_IBM_Feedback", 8, n)) {
                    this.getApi().setChoiceField(57, 0);
                    this.getApi().setChoiceField(60, 0);
                } else {
                    this.getJmsSystemPropertyMap().remove(string);
                }
            }
        } else if (string.equals("JMSType")) {
            this.setJmsType(null);
        } else {
            throw new IllegalArgumentException(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "deleteJMSSystemProperty");
        }
    }

    final void clearSmokeAndMirrorsProperties() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "clearSmokeAndMirrorsProperties");
        }
        this.getHdr2().setChoiceField(56, 0);
        this.setUserid(null);
        this.getApi().setChoiceField(57, 0);
        this.getApi().setChoiceField(60, 0);
        this.getHdr2().setChoiceField(59, 0);
        this.getHdr2().setChoiceField(61, 0);
        this.getHdr2().setChoiceField(60, 0);
        this.getApi().setChoiceField(51, 0);
        this.getApi().setChoiceField(52, 0);
        this.getApi().setChoiceField(53, 0);
        this.getApi().setChoiceField(54, 0);
        this.getApi().setChoiceField(55, 0);
        this.getApi().setChoiceField(56, 0);
        this.getHdr2().setChoiceField(74, 0);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "clearSmokeAndMirrorsProperties");
        }
    }

    private byte[] flattenMapObject(Serializable serializable) throws IOException {
        byte[] byArray = null;
        if (serializable instanceof byte[]) {
            byArray = new byte[((byte[])serializable).length + 2];
            byArray[0] = -34;
            byArray[1] = -83;
            System.arraycopy((byte[])serializable, 0, byArray, 2, ((byte[])serializable).length);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            objectOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    private Serializable restoreMapObject(byte[] byArray) throws IOException, ClassNotFoundException {
        Object object = null;
        if (byArray[0] == -34 && byArray[1] == -83) {
            object = new byte[byArray.length - 2];
            System.arraycopy(byArray, 2, object, 0, ((byte[])object).length);
        } else {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            WsObjectInputStream wsObjectInputStream = new WsObjectInputStream((InputStream)byteArrayInputStream);
            object = (Serializable)wsObjectInputStream.readObject();
            wsObjectInputStream.close();
        }
        return object;
    }

    private final boolean isValidForJms(Object object) {
        return object instanceof String || object instanceof Boolean || object instanceof Number && !(object instanceof BigInteger) && !(object instanceof BigDecimal);
    }

    final boolean isTransportVersionSet() {
        return this.getHdr2().getChoiceField(74) == 1;
    }

    final Object getTransportVersion() {
        return this.getHdr2().getField(55);
    }

    final void setTransportVersion(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setTransportVersion", object);
        }
        this.getHdr2().setField(55, object);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setTransportVersion");
        }
    }

    final void clearTransportVersion() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "clearTransportVersion");
        }
        this.getHdr2().setChoiceField(74, 0);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "clearTransportVersion");
        }
    }

    public MQPublicationInfo getMQPublicationInfo() {
        if (this.getApi().getIntField(58) == 1) {
            return new MQBrokerControlInfoAdapter(this);
        }
        return null;
    }

    public void setMQPublicationInfo(MQPublicationInfo mQPublicationInfo) {
        if (mQPublicationInfo == null) {
            this.getApi().setChoiceField(58, 0);
        } else {
            this.getApi().setField(16, mQPublicationInfo.getTopics());
            this.getApi().setField(17, mQPublicationInfo.getSubscriptionPoint());
            this.getApi().setField(18, null);
            this.getApi().setIntField(19, mQPublicationInfo.getOptions());
            this.getApi().setLongField(20, mQPublicationInfo.getPubTime());
            this.getApi().setIntField(21, mQPublicationInfo.getSeqNum());
            this.getApi().setField(22, mQPublicationInfo.getQueueManagerName());
            this.getApi().setField(23, mQPublicationInfo.getQueueName());
            this.getApi().setChoiceField(59, 0);
            this.getApi().setField(24, mQPublicationInfo.getReplyQueueManagerName());
            this.getApi().setField(25, mQPublicationInfo.getReplyQueueName());
        }
    }

    public void setMQPublicationInfo(String string, String string2, int n) {
        MQPublicationInfo mQPublicationInfo = MQBrokerMessageFactory.instance().createPublicationInfo();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        mQPublicationInfo.setTopics(arrayList);
        mQPublicationInfo.setSubscriptionPoint(string2);
        mQPublicationInfo.setOptions(n);
        this.setMQPublicationInfo(mQPublicationInfo);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        USER_PREFIX_LENGTH = USER_PREFIX.length();
        SI_PREFIX_LENGTH = SI_PREFIX.length();
        SI_REPORT_LENGTH = SI_REPORT.length();
        SI_REPORT_OFFSET = SI_PREFIX_LENGTH + SI_REPORT_LENGTH;
        SI_EXCEPTION_LENGTH = SI_EXCEPTION.length();
        SI_EXCEPTION_OFFSET = SI_PREFIX_LENGTH + SI_EXCEPTION_LENGTH;
        REPORT_LENGTH = REPORT.length();
        REPORT_OFFSET = 8 + REPORT_LENGTH;
        SETTABLE_JMSX = new HashSet(4);
        SETTABLE_JMS_IBM = new HashSet(18);
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#) 1.70 SIB/ws/code/sib.mfp.impl/src/com/ibm/ws/sib/mfp/impl/JsApiMessageImpl.java, SIB.mfp, WAS602.SIB, o0610.11 05/03/30 02:50:25 [3/13/06 13:33:15]");
        }
        SETTABLE_JMSX.add("JMSXAppID");
        SETTABLE_JMSX.add("JMSXUserID");
        SETTABLE_JMSX.add("JMSXGroupID");
        SETTABLE_JMSX.add("JMSXGroupSeq");
        SETTABLE_JMS_IBM.add("JMS_IBM_Report_Exception");
        SETTABLE_JMS_IBM.add("JMS_IBM_Report_Expiration");
        SETTABLE_JMS_IBM.add("JMS_IBM_Report_COA");
        SETTABLE_JMS_IBM.add("JMS_IBM_Report_COD");
        SETTABLE_JMS_IBM.add("JMS_IBM_Report_PAN");
        SETTABLE_JMS_IBM.add("JMS_IBM_Report_NAN");
        SETTABLE_JMS_IBM.add("JMS_IBM_Report_Pass_Msg_ID");
        SETTABLE_JMS_IBM.add("JMS_IBM_Report_Pass_Correl_ID");
        SETTABLE_JMS_IBM.add("JMS_IBM_Report_Discard_Msg");
        SETTABLE_JMS_IBM.add("JMS_IBM_Feedback");
        SETTABLE_JMS_IBM.add("JMS_IBM_Format");
        SETTABLE_JMS_IBM.add("JMS_IBM_MsgType");
        SETTABLE_JMS_IBM.add("JMS_IBM_PutApplType");
        SETTABLE_JMS_IBM.add("JMS_IBM_Last_Msg_In_Group");
        SETTABLE_JMS_IBM.add("JMS_IBM_PutDate");
        SETTABLE_JMS_IBM.add("JMS_IBM_PutTime");
        SETTABLE_JMS_IBM.add("JMS_IBM_Encoding");
        SETTABLE_JMS_IBM.add("JMS_IBM_Character_Set");
        try {
            jmsUtils = JmsInternalsFactory.getSharedUtils();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.sib.mfp.impl.JsApiMessageImpl.<clinit>", (String)"202");
            throw new NoClassDefFoundError(jMSException.toString());
        }
    }
}

