/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.MessageRestoreFailedException;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.util.List;

public abstract class JsMessageFactory {
    private static TraceComponent tc = SibTr.register(JsMessageFactory.class, "SIBMfp", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static JsMessageFactory instance = null;
    private static Exception createException = null;

    public static JsMessageFactory getInstance() throws Exception {
        if (instance == null) {
            throw createException;
        }
        return instance;
    }

    public abstract JsMessage createInboundJsMessage(byte[] var1, int var2, int var3) throws MessageDecodeFailedException;

    public abstract JsMessage createInboundJsMessage(byte[] var1, int var2, int var3, Object var4) throws MessageDecodeFailedException;

    public abstract JsMessage createInboundMQClientMessage(List var1, String var2, String var3, Reliability var4, Reliability var5) throws IOException, MessageDecodeFailedException;

    public abstract JsMessage createInboundMQClientMessage(List var1, String var2, String var3, Reliability var4, Reliability var5, boolean var6) throws IOException, MessageDecodeFailedException;

    public abstract JsMessage createInboundMQLinkMessage(List var1, String var2, String var3, String var4, Reliability var5, Reliability var6) throws IOException, MessageDecodeFailedException;

    public abstract JsMessage createInboundMQLinkMessage(List var1, String var2, String var3, String var4, Reliability var5, Reliability var6, boolean var7) throws IOException, MessageDecodeFailedException;

    public abstract JsMessage createInboundWebMessage(String var1) throws MessageDecodeFailedException;

    public abstract JsMessage restoreJsMessage(byte[] var1, Object var2) throws MessageRestoreFailedException;

    private static void createFactoryInstance() throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createFactoryInstance");
        }
        try {
            Class<?> clazz = Class.forName("com.ibm.ws.sib.mfp.impl.JsMessageFactoryImpl");
            instance = (JsMessageFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.mfp.JsMessageFactory.createFactoryInstance", (String)"134");
            SibTr.error(tc, "UNABLE_TO_CREATE_FACTORY_CWSIF0001", exception);
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createFactoryInstance");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.mfp/src/com/ibm/ws/sib/mfp/JsMessageFactory.java, SIB.mfp, WAS602.SIB, o0610.11 1.35");
        }
        try {
            JsMessageFactory.createFactoryInstance();
        }
        catch (Exception exception) {
            createException = exception;
        }
    }
}

