/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl.rldispatcher;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.pmi.CommsPMI;
import com.ibm.ws.sib.comms.pmi.StatsUpdateListener;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.DispatchQueue;
import com.ibm.ws.sib.jfapchannel.Dispatchable;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.ConversationImpl;
import com.ibm.ws.sib.jfapchannel.impl.rldispatcher.AbstractInvocation;
import com.ibm.ws.sib.jfapchannel.impl.rldispatcher.ReceiveListenerDispatchBarrier;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class ReceiveListenerDispatchQueue
implements DispatchQueue,
Runnable {
    private static final TraceComponent tc = SibTr.register(ReceiveListenerDispatchQueue.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private ArrayList queue = new ArrayList();
    private ReceiveListenerDispatchBarrier barrier = new ReceiveListenerDispatchBarrier();
    private int allQueuedBytes = 0;
    private static int MAX_QUEUE_SIZE;
    private static int meBufferedReadBytes;
    private static int clientBufferedReadBytes;
    private boolean running = false;
    private boolean waitForMoreWork = false;
    private List emptyDispatchQueues;
    private static int rldThreadRepoolDelay;
    private static StatsUpdateListener clientStatsListener;
    private static StatsUpdateListener meStatsListener;

    protected ReceiveListenerDispatchQueue(List list) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>", list);
        }
        this.emptyDispatchQueues = list;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueue(AbstractInvocation abstractInvocation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "enqueue", abstractInvocation);
        }
        if (abstractInvocation.getConnection() != null) {
            if (abstractInvocation.getConnection().getConversationType() == Conversation.ME) {
                meBufferedReadBytes += abstractInvocation.getSize();
            } else if (abstractInvocation.getConnection().getConversationType() == Conversation.CLIENT) {
                clientBufferedReadBytes += abstractInvocation.getSize();
            }
        }
        this.queue.add(abstractInvocation);
        ReceiveListenerDispatchBarrier receiveListenerDispatchBarrier = this.barrier;
        synchronized (receiveListenerDispatchBarrier) {
            this.allQueuedBytes += abstractInvocation.getSize();
            if (this.allQueuedBytes >= MAX_QUEUE_SIZE) {
                this.barrier.lock();
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Locked the barrier: " + this.allQueuedBytes + " >= " + MAX_QUEUE_SIZE);
                }
            } else if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Leaving barrier unlocked: " + this.allQueuedBytes + " < " + MAX_QUEUE_SIZE);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "enqueue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractInvocation dequeue() {
        AbstractInvocation abstractInvocation;
        Connection connection;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "dequeue");
        }
        if ((connection = (abstractInvocation = (AbstractInvocation)this.queue.remove(0)).getConnection()) != null) {
            if (connection.getConversationType() == Conversation.ME) {
                meBufferedReadBytes -= abstractInvocation.getSize();
            } else if (connection.getConversationType() == Conversation.CLIENT) {
                clientBufferedReadBytes -= abstractInvocation.getSize();
            }
        }
        ReceiveListenerDispatchBarrier receiveListenerDispatchBarrier = this.barrier;
        synchronized (receiveListenerDispatchBarrier) {
            this.allQueuedBytes -= abstractInvocation.getSize();
            if (this.allQueuedBytes < MAX_QUEUE_SIZE) {
                if (this.barrier.unlock()) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Unlocked the barrier: " + this.allQueuedBytes + " < " + MAX_QUEUE_SIZE);
                    }
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "Barrier already unlocked: " + this.allQueuedBytes + " < " + MAX_QUEUE_SIZE);
                }
            } else if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Leaving barrier locekd: " + this.allQueuedBytes + " >= " + MAX_QUEUE_SIZE);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "dequeue", abstractInvocation);
        }
        return abstractInvocation;
    }

    protected AbstractInvocation head() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "head");
        }
        AbstractInvocation abstractInvocation = (AbstractInvocation)this.queue.get(0);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "head", abstractInvocation);
        }
        return abstractInvocation;
    }

    protected boolean isEmpty() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "isEmpty");
        }
        boolean bl = this.queue.isEmpty();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "isEmpty", "" + bl);
        }
        return bl;
    }

    protected ReceiveListenerDispatchBarrier getBarrier() {
        return this.barrier;
    }

    protected synchronized boolean wakeupAnyWaitingThread() {
        if (this.running) {
            this.waitForMoreWork = false;
            this.notify();
        }
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block53: {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "run");
            }
            try {
                boolean bl;
                do {
                    Object object;
                    Object object2;
                    boolean bl2;
                    AbstractInvocation abstractInvocation = null;
                    Dispatchable dispatchable = null;
                    ReceiveListenerDispatchQueue receiveListenerDispatchQueue = this;
                    synchronized (receiveListenerDispatchQueue) {
                        this.running = true;
                        this.waitForMoreWork = true;
                        bl2 = this.isEmpty();
                        if (!bl2) {
                            abstractInvocation = this.head();
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "queueEmpty=" + bl2 + " invocation=" + abstractInvocation);
                    }
                    while (!bl2) {
                        dispatchable = abstractInvocation.getDispatchable();
                        boolean bl3 = false;
                        object2 = abstractInvocation;
                        synchronized (object2) {
                            abstractInvocation.decrementReferenceCount();
                            if (abstractInvocation.getReferenceCount() == 0 && abstractInvocation.isReady()) {
                                abstractInvocation.invoke();
                                object = (ConversationImpl)abstractInvocation.getConversation();
                                Object object3 = ((ConversationImpl)object).getTotalOutstandingRequestCountLock();
                                synchronized (object3) {
                                    AbstractInvocation abstractInvocation2;
                                    ((ConversationImpl)object).decrementTotalOutstandingCount();
                                    if (((ConversationImpl)object).getTotalOutstandingRequestCount() == 0 && (abstractInvocation2 = ((ConversationImpl)object).getErrorOccurredInvocation()) != null) {
                                        abstractInvocation2.invoke();
                                        abstractInvocation2.repool();
                                        ((ConversationImpl)object).setErrorOccurredInvocation(null);
                                    }
                                }
                                bl3 = true;
                            } else if (tc.isDebugEnabled()) {
                                SibTr.debug(this, tc, "Not invoking at this time", abstractInvocation);
                            }
                        }
                        object2 = this;
                        synchronized (object2) {
                            this.dequeue();
                            if (bl3) {
                                abstractInvocation.repool();
                            }
                            object = dispatchable.getDispatchLockObject();
                            synchronized (object) {
                                dispatchable.decrementDispatchQueueRefCount();
                                if (dispatchable.getDispatchQueueRefCount() == 0) {
                                    dispatchable.setDispatchQueue(null);
                                }
                            }
                            bl2 = this.isEmpty();
                            if (!bl2) {
                                abstractInvocation = this.head();
                            }
                            if (tc.isDebugEnabled()) {
                                SibTr.debug(this, tc, "refCount = " + dispatchable.getDispatchQueueRefCount() + " queueEmpty=" + bl2 + " invocation=" + abstractInvocation);
                            }
                        }
                    }
                    boolean bl4 = false;
                    bl = true;
                    object2 = this.emptyDispatchQueues;
                    synchronized (object2) {
                        object = this;
                        synchronized (object) {
                            if (this.isEmpty()) {
                                this.emptyDispatchQueues.add(this);
                                bl4 = true;
                            } else {
                                bl = false;
                                bl2 = false;
                            }
                        }
                    }
                    if (!bl4) continue;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "Added queue to empty list (" + this + ")");
                    }
                    object2 = this;
                    synchronized (object2) {
                        if (this.isEmpty() && this.waitForMoreWork) {
                            while (true) {
                                try {
                                    if (tc.isDebugEnabled()) {
                                        SibTr.debug(this, tc, "Queue waiting up to " + rldThreadRepoolDelay + " seconds for new work to arrive");
                                    }
                                    this.wait(rldThreadRepoolDelay);
                                }
                                catch (InterruptedException interruptedException) {
                                    continue;
                                }
                                break;
                            }
                        }
                        if (!(bl = this.isEmpty())) {
                            abstractInvocation = this.head();
                            if (tc.isDebugEnabled()) {
                                SibTr.debug(this, tc, "Queue woken up by new work arriving");
                            }
                        } else {
                            this.running = false;
                            if (tc.isDebugEnabled()) {
                                SibTr.debug(this, tc, "Queue timed out waiting for new work, thread will be repooled.");
                            }
                        }
                    }
                } while (!bl);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.rldispatcher.DispatchRunnable", (String)"00230001", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "RLDispatchThread threw an exception: ", throwable);
                }
                if (!tc.isEventEnabled()) break block53;
                SibTr.exception((Object)this, tc, throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "run");
        }
    }

    static {
        meBufferedReadBytes = 0;
        clientBufferedReadBytes = 0;
        clientStatsListener = new StatsUpdateListener(){

            public int statChanged() {
                return clientBufferedReadBytes;
            }
        };
        meStatsListener = new StatsUpdateListener(){

            public int statChanged() {
                return meBufferedReadBytes;
            }
        };
        CommsPMI.getClientStats().addBufferedReadsUpdateListener(clientStatsListener);
        CommsPMI.getMEStats().addBufferedReadsUpdateListener(meStatsListener);
        try {
            String string = "com.ibm.ws.sib.jfapchannel.RL_DISPATCHER_MAXQUEUESIZE";
            String string2 = RuntimeInfo.getProperty(string);
            if (string2 != null) {
                com.ibm.ws.sib.utils.Runtime.changedPropertyValue(string, string2);
                MAX_QUEUE_SIZE = Integer.parseInt(string2);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "From file: Queue Size: " + MAX_QUEUE_SIZE);
                }
            } else {
                Runtime runtime = Runtime.getRuntime();
                long l = runtime.maxMemory();
                long l2 = runtime.freeMemory();
                long l3 = l - l2;
                long l4 = (long)((double)l3 * 0.2);
                int n = Integer.parseInt(RuntimeInfo.getProperty("com.ibm.ws.sib.jfapchannel.MAX_CONCURRENT_DISPATCHES", "32"));
                MAX_QUEUE_SIZE = (int)(l4 / (long)n);
                if (tc.isDebugEnabled()) {
                    NumberFormat numberFormat = NumberFormat.getInstance();
                    SibTr.debug(tc, "Max memory : " + numberFormat.format(l));
                    SibTr.debug(tc, "Free memory: " + numberFormat.format(l2));
                    SibTr.debug(tc, "Available  : " + numberFormat.format(l3));
                    SibTr.debug(tc, "20%        : " + numberFormat.format(l4));
                    SibTr.debug(tc, "Queues     : " + n);
                    SibTr.debug(tc, "Queue size : " + numberFormat.format(MAX_QUEUE_SIZE));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            rldThreadRepoolDelay = Integer.parseInt(RuntimeInfo.getProperty("com.ibm.ws.sib.jfapchannel.impl.rldRepoolThreadDelayProperty", "10000"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

