/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl.octracker;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.impl.OutboundConnection;
import com.ibm.ws.sib.jfapchannel.impl.octracker.ConnectionData;
import com.ibm.ws.sib.jfapchannel.impl.octracker.ConnectionDataGroup;
import com.ibm.ws.sib.jfapchannel.impl.octracker.EndPointDescriptor;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.OutboundChannelDefinition;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChannelFrameworkException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;

public class OutboundConnectionTracker {
    private static final TraceComponent tc = SibTr.register(OutboundConnectionTracker.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final TraceNLS nls;
    private int conversationsPerConnection;
    private HashMap endPointToGroupMap = new HashMap();
    private ChannelFramework channelFramework;
    private BridgeServiceEndPointDescriptor bridgeServiceDescriptor = new BridgeServiceEndPointDescriptor();

    public OutboundConnectionTracker(ChannelFramework channelFramework) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>", channelFramework);
        }
        this.channelFramework = channelFramework;
        this.conversationsPerConnection = 20;
        try {
            this.conversationsPerConnection = Integer.parseInt(RuntimeInfo.getProperty("com.ibm.ws.sib.jfapchannel.CONVERSATIONS_PER_CONNECTION"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.conversationsPerConnection < 1) {
            this.conversationsPerConnection = 1;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "conversationsPerConnection=" + this.conversationsPerConnection);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConversation(OutboundConnection outboundConnection) {
        ConnectionData connectionData;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "close", outboundConnection);
        }
        if ((connectionData = outboundConnection.getConnectionData()) != null) {
            EndPointDescriptor endPointDescriptor = connectionData.getEndPointDescriptor();
            HashMap hashMap = this.endPointToGroupMap;
            synchronized (hashMap) {
                ConnectionDataGroup connectionDataGroup = (ConnectionDataGroup)this.endPointToGroupMap.get(endPointDescriptor);
                if (connectionDataGroup == null || connectionDataGroup != connectionData.getConnectionDataGroup()) {
                    if (connectionDataGroup == null && tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "group == nul");
                    } else {
                        SibTr.debug(this, tc, "group != connectionData.getConnectionDataGroup()");
                    }
                    throw new SIErrorException(nls.getFormattedMessage("OUTCONNTRACKER_INTERNAL_SICJ0064", null, "OUTCONNTRACKER_INTERNAL_SICJ0064"));
                }
                connectionDataGroup.close(outboundConnection);
                if (connectionDataGroup.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "group: " + connectionDataGroup + " has become empty");
                    }
                    this.endPointToGroupMap.remove(connectionDataGroup.getEndPointDescriptor());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conversation connect(CFEndPoint cFEndPoint, ConversationReceiveListener conversationReceiveListener) throws SIResourceException {
        ConnectionDataGroup connectionDataGroup;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "connect", new Object[]{cFEndPoint, conversationReceiveListener});
        }
        CFEndPointDescriptor cFEndPointDescriptor = new CFEndPointDescriptor(cFEndPoint);
        Object object = this.endPointToGroupMap;
        synchronized (object) {
            connectionDataGroup = (ConnectionDataGroup)this.endPointToGroupMap.get(cFEndPointDescriptor);
            OutboundChannelDefinition[] outboundChannelDefinitionArray = cFEndPoint.getOutboundChannelDefs();
            if (outboundChannelDefinitionArray.length < 1) {
                throw new SIErrorException(nls.getFormattedMessage("OUTCONNTRACKER_INTERNAL_SICJ0064", null, "OUTCONNTRACKER_INTERNAL_SICJ0064"));
            }
            Map map = outboundChannelDefinitionArray[0].getOutboundChannelProperties();
            int n = this.determineHeartbeatInterval(map);
            int n2 = this.determineHeartbeatTimeout(map);
            if (connectionDataGroup == null) {
                connectionDataGroup = new ConnectionDataGroup(this, cFEndPointDescriptor, this.conversationsPerConnection, this.channelFramework, n, n2);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "created new connection data group: " + connectionDataGroup);
                }
                this.endPointToGroupMap.put(cFEndPointDescriptor, connectionDataGroup);
            }
            connectionDataGroup.connectionPending();
        }
        object = connectionDataGroup.connect(cFEndPoint, conversationReceiveListener);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "connect", object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conversation connect(InetSocketAddress inetSocketAddress, ConversationReceiveListener conversationReceiveListener, String string) throws SIResourceException {
        ConnectionDataGroup connectionDataGroup;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "connect", new Object[]{inetSocketAddress, conversationReceiveListener, string});
        }
        HostPortEndPointDescriptor hostPortEndPointDescriptor = new HostPortEndPointDescriptor(inetSocketAddress, string);
        Object object = this.endPointToGroupMap;
        synchronized (object) {
            connectionDataGroup = (ConnectionDataGroup)this.endPointToGroupMap.get(hostPortEndPointDescriptor);
            if (connectionDataGroup == null) {
                try {
                    ChainData chainData = this.channelFramework.getChain(string);
                    VirtualConnectionFactory virtualConnectionFactory = this.channelFramework.getOutboundVCFactory(string);
                    if (chainData == null || virtualConnectionFactory == null) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(this, tc, "Unknown chain name: " + string);
                        }
                        throw new SIErrorException(nls.getFormattedMessage("OUTCONNTRACKER_INTERNAL_SICJ0064", null, "OUTCONNTRACKER_INTERNAL_SICJ0064"));
                    }
                    ChannelData[] channelDataArray = chainData.getChannelList();
                    Map map = null;
                    if (channelDataArray.length <= 0) {
                        throw new SIErrorException(nls.getFormattedMessage("OUTCONNTRACKER_INTERNAL_SICJ0064", null, "OUTCONNTRACKER_INTERNAL_SICJ0064"));
                    }
                    map = channelDataArray[0].getPropertyBag();
                    int n = this.determineHeartbeatInterval(map);
                    int n2 = this.determineHeartbeatTimeout(map);
                    connectionDataGroup = new ConnectionDataGroup(this, virtualConnectionFactory, hostPortEndPointDescriptor, this.conversationsPerConnection, n, n2);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "created new connection data group: " + connectionDataGroup);
                    }
                    this.endPointToGroupMap.put(hostPortEndPointDescriptor, connectionDataGroup);
                }
                catch (ChannelFrameworkException channelFrameworkException) {
                    if (tc.isEventEnabled()) {
                        SibTr.exception((Object)this, tc, (Exception)((Object)channelFrameworkException));
                    }
                    throw new SIErrorException(nls.getFormattedMessage("OUTCONNTRACKER_INTERNAL_SICJ0064", null, "OUTCONNTRACKER_INTERNAL_SICJ0064"), channelFrameworkException);
                }
            }
            connectionDataGroup.connectionPending();
        }
        object = connectionDataGroup.connect(inetSocketAddress, string, conversationReceiveListener);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "connect", object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conversation connect(ConversationReceiveListener conversationReceiveListener) throws SIResourceException {
        ConnectionDataGroup connectionDataGroup;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "connect", conversationReceiveListener);
        }
        BridgeServiceEndPointDescriptor bridgeServiceEndPointDescriptor = this.bridgeServiceDescriptor;
        String string = "_OutboundTCPProxyBridgeService";
        Object object = this.endPointToGroupMap;
        synchronized (object) {
            connectionDataGroup = (ConnectionDataGroup)this.endPointToGroupMap.get(bridgeServiceEndPointDescriptor);
            if (connectionDataGroup == null) {
                try {
                    ChainData chainData = this.channelFramework.getChain(string);
                    VirtualConnectionFactory virtualConnectionFactory = this.channelFramework.getOutboundVCFactory(string);
                    if (chainData == null || virtualConnectionFactory == null) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug(this, tc, "Unknown chain name: " + string);
                        }
                        throw new SIErrorException(nls.getFormattedMessage("OUTCONNTRACKER_INTERNAL_SICJ0064", null, "OUTCONNTRACKER_INTERNAL_SICJ0064"));
                    }
                    ChannelData[] channelDataArray = chainData.getChannelList();
                    Map map = null;
                    if (channelDataArray.length <= 0) {
                        throw new SIErrorException(nls.getFormattedMessage("OUTCONNTRACKER_INTERNAL_SICJ0064", null, "OUTCONNTRACKER_INTERNAL_SICJ0064"));
                    }
                    map = channelDataArray[0].getPropertyBag();
                    int n = this.determineHeartbeatInterval(map);
                    int n2 = this.determineHeartbeatTimeout(map);
                    connectionDataGroup = new ConnectionDataGroup(this, virtualConnectionFactory, bridgeServiceEndPointDescriptor, this.channelFramework);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "created new connection data group: " + connectionDataGroup);
                    }
                    this.endPointToGroupMap.put(bridgeServiceEndPointDescriptor, connectionDataGroup);
                }
                catch (ChannelFrameworkException channelFrameworkException) {
                    if (tc.isEventEnabled()) {
                        SibTr.exception((Object)this, tc, (Exception)((Object)channelFrameworkException));
                    }
                    throw new SIErrorException(nls.getFormattedMessage("OUTCONNTRACKER_INTERNAL_SICJ0064", null, "OUTCONNTRACKER_INTERNAL_SICJ0064"), channelFrameworkException);
                }
            }
            connectionDataGroup.connectionPending();
        }
        object = connectionDataGroup.connect(conversationReceiveListener);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "connect", object);
        }
        return object;
    }

    private int determineHeartbeatInterval(Map map) {
        String string;
        int n = 300;
        try {
            n = Integer.parseInt(RuntimeInfo.getProperty("com.ibm.ws.sib.jfapchannel.HEARTBEAT_INTERVAL", "" + n));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (map != null && (string = (String)map.get("com.ibm.ws.sib.jfapchannel.HEARTBEAT_INTERVAL_PROPERTY")) != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    private int determineHeartbeatTimeout(Map map) {
        String string;
        int n = 7;
        try {
            n = Integer.parseInt(RuntimeInfo.getProperty("com.ibm.ws.sib.jfapchannel.HEARTBEAT_TIMEOUT", "" + n));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (map != null && (string = (String)map.get("com.ibm.ws.sib.jfapchannel.HEARTBEAT_TIMEOUT_PROPERTY")) != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public Conversation cloneConversation(OutboundConnection outboundConnection, ConversationReceiveListener conversationReceiveListener) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "cloneConversation", new Object[]{outboundConnection, conversationReceiveListener});
        }
        Conversation conversation = outboundConnection.getConnectionData().getConnectionDataGroup().clone(outboundConnection, conversationReceiveListener);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "cloneConversation", conversation);
        }
        return conversation;
    }

    public void purge(OutboundConnection outboundConnection, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "purge", new Object[]{outboundConnection, "" + bl});
        }
        outboundConnection.getConnectionData().getConnectionDataGroup().purge(outboundConnection, bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "purge");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#) SIB/ws/code/sib.jfapchannel.impl/src/com/ibm/ws/sib/jfapchannel/impl/octracker/OutboundConnectionTracker.java, SIB.comms, WAS602.SIB, o0610.11 1.18");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    }

    private class BridgeServiceEndPointDescriptor
    extends EndPointDescriptor {
        private BridgeServiceEndPointDescriptor() {
        }
    }

    private class HostPortEndPointDescriptor
    extends EndPointDescriptor {
        private InetSocketAddress address;
        private String chainName;

        protected HostPortEndPointDescriptor(InetSocketAddress inetSocketAddress, String string) {
            this.address = inetSocketAddress;
            this.chainName = string;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof HostPortEndPointDescriptor) {
                HostPortEndPointDescriptor hostPortEndPointDescriptor = (HostPortEndPointDescriptor)object;
                bl = hostPortEndPointDescriptor.address.equals(this.address) && hostPortEndPointDescriptor.chainName.equals(this.chainName);
            }
            return bl;
        }

        public int hashCode() {
            return this.address.hashCode() ^ this.chainName.hashCode();
        }
    }

    private class CFEndPointDescriptor
    extends EndPointDescriptor {
        private CFEndPoint cfEndPoint;

        protected CFEndPointDescriptor(CFEndPoint cFEndPoint) {
            this.cfEndPoint = cFEndPoint;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof CFEndPointDescriptor) {
                CFEndPoint cFEndPoint = ((CFEndPointDescriptor)object).cfEndPoint;
                bl = this.isEqual(cFEndPoint.getAddress(), this.cfEndPoint.getAddress()) && this.isEqual(cFEndPoint.getName(), this.cfEndPoint.getName()) && cFEndPoint.getPort() == this.cfEndPoint.getPort() && cFEndPoint.isLocal() == this.cfEndPoint.isLocal() && cFEndPoint.isSSLEnabled() == this.cfEndPoint.isSSLEnabled();
            }
            return bl;
        }

        public int hashCode() {
            int n = 0;
            if (this.cfEndPoint.getAddress() != null) {
                n ^= this.cfEndPoint.getAddress().hashCode();
            }
            if (this.cfEndPoint.getName() != null) {
                n ^= this.cfEndPoint.getName().hashCode();
            }
            if (n == 0) {
                n = this.cfEndPoint.hashCode();
            }
            return n;
        }

        private boolean isEqual(Object object, Object object2) {
            if (object == null && object2 == null) {
                return true;
            }
            if (object == null && object2 != null || object != null && object2 == null) {
                return false;
            }
            return object.equals(object2);
        }
    }
}

