/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl.octracker;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.OutboundConnection;
import com.ibm.ws.sib.jfapchannel.impl.octracker.EndPointDescriptor;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;
import java.util.LinkedList;

public class IdleConnectionPool
implements AlarmListener {
    private static final TraceComponent tc = SibTr.register(IdleConnectionPool.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static IdleConnectionPool instance = null;
    private static final int DEFAULT_CONNECTION_CLOSE_TIMEOUT = 10000;
    private int connectionCloseTimeout;
    private HashMap descriptorToConnectionListMap = new HashMap();

    private IdleConnectionPool() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>");
        }
        this.connectionCloseTimeout = 10000;
        try {
            this.connectionCloseTimeout = Integer.parseInt(RuntimeInfo.getProperty("com.ibm.ws.sib.jfapchannel.CONNECTION_CLOSE_TIMEOUT", "10000"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.connectionCloseTimeout < 0) {
            this.connectionCloseTimeout = 0;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "connection close timeout = " + this.connectionCloseTimeout);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(OutboundConnection outboundConnection, EndPointDescriptor endPointDescriptor) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "add", new Object[]{outboundConnection, endPointDescriptor});
        }
        if (this.connectionCloseTimeout == 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "close timeout == 0, closing immediately");
            }
            outboundConnection.physicalClose(true);
        } else {
            LinkedList<Object[]> linkedList = null;
            Object[] objectArray = null;
            IdleConnectionPool idleConnectionPool = this;
            synchronized (idleConnectionPool) {
                linkedList = (LinkedList<Object[]>)this.descriptorToConnectionListMap.get(endPointDescriptor);
                if (linkedList == null) {
                    linkedList = new LinkedList<Object[]>();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "pool does not contain other connections for this endpoint, adding new list: " + linkedList);
                    }
                    this.descriptorToConnectionListMap.put(endPointDescriptor, linkedList);
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "connections already present in list: " + linkedList + " are", linkedList.toArray());
                }
                AlarmValid alarmValid = new AlarmValid();
                objectArray = new Object[]{outboundConnection, alarmValid};
                linkedList.addLast(objectArray);
            }
            AlarmManager.createDeferrable((long)this.connectionCloseTimeout, (AlarmListener)this, (Object)new Object[]{linkedList, objectArray});
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "add");
        }
    }

    public synchronized OutboundConnection remove(EndPointDescriptor endPointDescriptor) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "remove", endPointDescriptor);
        }
        LinkedList linkedList = (LinkedList)this.descriptorToConnectionListMap.get(endPointDescriptor);
        OutboundConnection outboundConnection = null;
        if (linkedList != null && linkedList.size() > 0) {
            Object[] objectArray = (Object[])linkedList.removeFirst();
            outboundConnection = (OutboundConnection)objectArray[0];
            ((AlarmValid)objectArray[1]).invalidate();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "remove", outboundConnection);
        }
        return outboundConnection;
    }

    public static IdleConnectionPool getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "alarm", object);
        }
        boolean bl = false;
        boolean bl2 = false;
        Object[] objectArray = null;
        Object object2 = this;
        synchronized (object2) {
            Object[] objectArray2 = (Object[])object;
            LinkedList linkedList = (LinkedList)objectArray2[0];
            objectArray = (Object[])objectArray2[1];
            bl = ((AlarmValid)objectArray[1]).isValid();
            if (bl) {
                bl2 = linkedList.remove(objectArray);
            }
        }
        if (bl2) {
            object2 = (OutboundConnection)objectArray[0];
            ((Connection)object2).physicalClose(true);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "alarm");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#) SIB/ws/code/sib.jfapchannel.impl/src/com/ibm/ws/sib/jfapchannel/impl/octracker/IdleConnectionPool.java, SIB.comms, WAS602.SIB, o0610.11 1.6");
        }
        instance = new IdleConnectionPool();
    }

    private class AlarmValid {
        private boolean valid = true;

        private AlarmValid() {
        }

        protected synchronized boolean isValid() {
            return this.valid;
        }

        protected synchronized void invalidate() {
            this.valid = false;
        }
    }
}

