/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.jfapchannel.SendListener;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.TransmissionData;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.ObjectPool;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.util.NoSuchElementException;

public class TransmissionDataIterator {
    private static final TraceComponent tc = SibTr.register(TransmissionDataIterator.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static ObjectPool pool;
    private TransmissionData xmitData = new TransmissionData(this);
    private Connection connection;
    private boolean isUserRequest;
    private boolean transmissionsRemaining;
    private JFapChannelConstants.TransmissionLayout layout;
    private WsByteBuffer[] data;
    private int priority;
    private boolean isPooled;
    private boolean isExchange;
    private int segmentType;
    private int conversationId;
    private int requestNumber;
    private Conversation conversation;
    private SendListener sendListener;
    private boolean isTerminal;
    private int size;
    private int bytesRemaining;

    private TransmissionDataIterator() {
    }

    private void setFields(Connection connection, WsByteBuffer[] wsByteBufferArray, int n, boolean bl, boolean bl2, int n2, int n3, int n4, Conversation conversation, SendListener sendListener, boolean bl3, int n5) {
        this.connection = connection;
        this.data = wsByteBufferArray;
        this.priority = n;
        this.isPooled = bl;
        this.isExchange = bl2;
        this.segmentType = n2;
        this.conversationId = n3;
        this.requestNumber = n4;
        this.conversation = conversation;
        this.sendListener = sendListener;
        this.isTerminal = bl3;
        this.size = n5;
        this.bytesRemaining = n5;
    }

    private void reset(Connection connection, WsByteBuffer[] wsByteBufferArray, int n, boolean bl, boolean bl2, int n2, int n3, int n4, Conversation conversation, SendListener sendListener, boolean bl3, boolean bl4, int n5) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "reset", new Object[]{connection, wsByteBufferArray, "" + n, "" + bl, "" + bl2, "" + n2, "" + n3, "" + n4, conversation, sendListener, "" + bl3, "" + bl4, "" + n5});
        }
        this.isUserRequest = bl3;
        this.setFields(connection, wsByteBufferArray, n, bl, bl2, n2, n3, n4, conversation, sendListener, bl4, n5);
        int n6 = n5 + 10 + 4;
        this.transmissionsRemaining = true;
        if (n6 > connection.getMaxTransmissionSize()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "segmenting");
            }
            this.layout = JFapChannelConstants.XMIT_SEGMENT_START;
        } else {
            this.layout = JFapChannelConstants.XMIT_CONVERSATION;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "reset");
        }
    }

    private void reset(Connection connection, WsByteBuffer[] wsByteBufferArray, int n, boolean bl, boolean bl2, int n2, SendListener sendListener, boolean bl3, boolean bl4, int n3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "reset", new Object[]{connection, wsByteBufferArray, "" + n, "" + bl, "" + bl2, "" + n2, sendListener, "" + bl3, "" + bl4, "" + n3});
        }
        this.isUserRequest = bl3;
        this.setFields(connection, wsByteBufferArray, n, bl, bl2, n2, 0, 0, null, sendListener, bl4, n3);
        this.layout = JFapChannelConstants.XMIT_PRIMARY_ONLY;
        this.transmissionsRemaining = true;
        int n4 = n3 + 10 + 4;
        if (n4 > connection.getMaxTransmissionSize()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "size of primary transmission > max transmission size");
            }
            throw new SIErrorException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"TRANSDATAIT_INTERNAL_SICJ0061", null, (String)"TRANSDATAIT_INTERNAL_SICJ0061"));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "reset");
        }
    }

    public boolean hasNext() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "hasNext");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "hasNext", "" + this.transmissionsRemaining);
        }
        return this.transmissionsRemaining;
    }

    public TransmissionData next() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "next");
        }
        if (!this.transmissionsRemaining) {
            throw new NoSuchElementException();
        }
        this.xmitData.reset(this.data, this.isUserRequest, this.isTerminal, this.connection);
        if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "layout=" + this.layout);
        }
        if (this.layout == JFapChannelConstants.XMIT_PRIMARY_ONLY) {
            int n = this.size + 10;
            this.xmitData.setLayoutToPrimary(n, this.priority, this.isPooled, this.isExchange, this.connection.getNextRequestNumber(), this.segmentType, this.sendListener);
            this.bytesRemaining = 0;
            this.layout = JFapChannelConstants.XMIT_LAYOUT_UNKNOWN;
            this.transmissionsRemaining = false;
        } else if (this.layout == JFapChannelConstants.XMIT_CONVERSATION) {
            int n = this.size + 10 + 4;
            this.xmitData.setLayoutToConversation(n, this.priority, this.isPooled, this.isExchange, this.connection.getNextRequestNumber(), this.segmentType, this.conversationId, this.requestNumber, this.conversation, this.sendListener);
            this.bytesRemaining = 0;
            this.layout = JFapChannelConstants.XMIT_LAYOUT_UNKNOWN;
            this.transmissionsRemaining = false;
        } else if (this.layout == JFapChannelConstants.XMIT_SEGMENT_START) {
            int n = this.connection.getMaxTransmissionSize();
            this.xmitData.setLayoutToStartSegment(n, this.priority, this.isPooled, this.isExchange, this.connection.getNextRequestNumber(), this.segmentType, this.conversationId, this.requestNumber, this.size);
            this.bytesRemaining -= this.connection.getMaxTransmissionSize() - 26;
            int n2 = this.connection.getMaxTransmissionSize() - 26;
            this.layout = this.bytesRemaining <= n2 ? JFapChannelConstants.XMIT_SEGMENT_END : JFapChannelConstants.XMIT_SEGMENT_MIDDLE;
        } else if (this.layout == JFapChannelConstants.XMIT_SEGMENT_MIDDLE) {
            int n = this.connection.getMaxTransmissionSize();
            this.xmitData.setLayoutToMiddleSegment(n, this.priority, this.isPooled, this.isExchange, this.connection.getNextRequestNumber(), this.conversationId, this.requestNumber);
            this.bytesRemaining -= this.connection.getMaxTransmissionSize() - 14;
            int n3 = this.connection.getMaxTransmissionSize() - 14;
            if (this.bytesRemaining <= n3) {
                this.layout = JFapChannelConstants.XMIT_SEGMENT_END;
            }
        } else if (this.layout == JFapChannelConstants.XMIT_SEGMENT_END) {
            int n = this.bytesRemaining + 10 + 4;
            this.xmitData.setLayoutToEndSegment(n, this.priority, this.isPooled, this.isExchange, this.connection.getNextRequestNumber(), this.conversationId, this.requestNumber, this.conversation, this.sendListener);
            this.bytesRemaining = 0;
            this.layout = JFapChannelConstants.XMIT_LAYOUT_UNKNOWN;
            this.transmissionsRemaining = false;
        } else if (tc.isDebugEnabled()) {
            SibTr.debug(this, tc, "invalid layout: " + this.layout);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "next", this.xmitData);
        }
        return this.xmitData;
    }

    protected static TransmissionDataIterator allocateFromPool(Connection connection, WsByteBuffer[] wsByteBufferArray, int n, boolean bl, boolean bl2, int n2, int n3, int n4, Conversation conversation, SendListener sendListener, boolean bl3, boolean bl4, int n5) {
        TransmissionDataIterator transmissionDataIterator;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "allocateFromPool");
        }
        if ((transmissionDataIterator = null) == null) {
            transmissionDataIterator = new TransmissionDataIterator();
        }
        transmissionDataIterator.reset(connection, wsByteBufferArray, n, bl, bl2, n2, n3, n4, conversation, sendListener, bl3, bl4, n5);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "allocateFromPool", transmissionDataIterator);
        }
        return transmissionDataIterator;
    }

    protected static TransmissionDataIterator allocateFromPool(Connection connection, WsByteBuffer[] wsByteBufferArray, int n, boolean bl, boolean bl2, int n2, SendListener sendListener, boolean bl3, boolean bl4, int n3) {
        TransmissionDataIterator transmissionDataIterator;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "allocateFromPool");
        }
        if ((transmissionDataIterator = null) == null) {
            transmissionDataIterator = new TransmissionDataIterator();
        }
        transmissionDataIterator.reset(connection, wsByteBufferArray, n, bl, bl2, n2, sendListener, bl3, bl4, n3);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "allocateFromPool", transmissionDataIterator);
        }
        return transmissionDataIterator;
    }

    protected void release() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "release");
        }
        if (!this.transmissionsRemaining) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "no more transmissions remaining - repooling");
            }
            if (this.data != null) {
                for (int i = 0; i < this.data.length; ++i) {
                    WsByteBuffer wsByteBuffer = this.data[i];
                    if (wsByteBuffer == null) continue;
                    wsByteBuffer.release();
                }
            }
            this.connection = null;
            this.conversation = null;
            this.data = null;
            this.sendListener = null;
            pool.add((Object)this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "release");
        }
    }

    protected int getPriority() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getPriority");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getPriority", "" + this.priority);
        }
        return this.priority;
    }

    protected void setPriority(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setPriority", "" + n);
        }
        this.priority = n;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setPriority");
        }
    }

    protected boolean isUserRequest() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "isUserRequest");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "isUserRequest", "" + this.isUserRequest);
        }
        return this.isUserRequest;
    }

    protected int getSize() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getSize");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getSize", "" + this.size);
        }
        return this.size;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#) SIB/ws/code/sib.jfapchannel.impl/src/com/ibm/ws/sib/jfapchannel/impl/TransmissionDataIterator.java, SIB.comms, WAS602.SIB, o0610.11 1.12");
        }
        pool = new ObjectPool("Transmission Data Iterator Pool", 100);
    }
}

