/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.jfapchannel.SendListener;
import com.ibm.ws.sib.jfapchannel.impl.BufferPoolManagerReference;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.JFapUtils;
import com.ibm.ws.sib.jfapchannel.impl.TransmissionDataIterator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;

public class TransmissionData {
    private static final TraceComponent tc = SibTr.register(TransmissionData.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private WsByteBuffer[] xmitDataBuffers;
    private int currentXmitDataBufferIndex;
    private Connection connection;
    private Conversation conversation;
    private SendListener sendListener;
    private boolean isUserRequest;
    private boolean isTerminal;
    private WsByteBuffer headerScratchSpace;
    private int transmissionRemaining;
    private static final int STATE_BUILDING_PRIMARY_HEADER = 0;
    private static final int STATE_BUILDING_CONVERSATION_HEADER = 1;
    private static final int STATE_BUILDING_SEGMENT_HEADER = 2;
    private static final int STATE_BUILDING_PAYLOAD = 3;
    private static final int STATE_ERROR = 4;
    private int state = 0;
    private boolean exhausedXmitBuffer = false;
    private boolean transmissionBuilt = false;
    private TransmissionDataIterator iterator = null;
    private JFapChannelConstants.TransmissionLayout layout;
    private PrimaryHeaderFields primaryHeaderFields = new PrimaryHeaderFields();
    private ConversationHeaderFields conversationHeaderFields = new ConversationHeaderFields();
    private SegmentedTransmissionHeaderFields segmentedTransmissionHeaderFields = new SegmentedTransmissionHeaderFields();

    protected TransmissionData(TransmissionDataIterator transmissionDataIterator) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>");
        }
        this.iterator = transmissionDataIterator;
        int n = Math.max(10, 4);
        n = Math.max(n, 12);
        this.headerScratchSpace = BufferPoolManagerReference.getInstance().allocate(n);
        this.headerScratchSpace.clear();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    protected void reset(WsByteBuffer[] wsByteBufferArray, boolean bl, boolean bl2, Connection connection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "reset", new Object[]{wsByteBufferArray, "" + bl, "" + bl2, connection});
        }
        this.isUserRequest = bl;
        this.isTerminal = bl2;
        this.connection = connection;
        this.xmitDataBuffers = wsByteBufferArray;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "reset");
        }
    }

    protected void setLayoutToPrimary(int n, int n2, boolean bl, boolean bl2, int n3, int n4, SendListener sendListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setLayoutToPrimary", new Object[]{"" + n, "" + n2, "" + bl, "" + bl2, "" + n3, "" + n4, sendListener});
        }
        this.primaryHeaderFields.segmentLength = n;
        this.primaryHeaderFields.priority = n2;
        this.primaryHeaderFields.isPooled = bl;
        this.primaryHeaderFields.isExchange = bl2;
        this.primaryHeaderFields.packetNumber = n3;
        this.primaryHeaderFields.segmentType = n4;
        this.sendListener = sendListener;
        this.transmissionRemaining = n;
        this.layout = JFapChannelConstants.XMIT_PRIMARY_ONLY;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setLayoutToPrimary");
        }
    }

    protected void setLayoutToConversation(int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, Conversation conversation, SendListener sendListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setLayoutToConversation", new Object[]{"" + n, "" + n2, "" + bl, "" + bl2, "" + n3, "" + n4, "" + n5, "" + n6, conversation, sendListener});
        }
        this.setLayoutToPrimary(n, n2, bl, bl2, n3, n4, sendListener);
        this.conversationHeaderFields.conversationId = n5;
        this.conversationHeaderFields.requestNumber = n6;
        this.conversation = conversation;
        this.transmissionRemaining = n;
        this.layout = JFapChannelConstants.XMIT_CONVERSATION;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setLayoutToConversation");
        }
    }

    protected void setLayoutToStartSegment(int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setLayoutToStartSegment", new Object[]{"" + n, "" + n2, "" + bl, "" + bl2, "" + n3, "" + n4, "" + n5, "" + n6, "" + l});
        }
        this.setLayoutToConversation(n, n2, bl, bl2, n3, n4, n5, n6, null, null);
        this.segmentedTransmissionHeaderFields.totalLength = l;
        this.segmentedTransmissionHeaderFields.segmentType = n4;
        this.transmissionRemaining = n;
        this.primaryHeaderFields.segmentType = 3;
        this.layout = JFapChannelConstants.XMIT_SEGMENT_START;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setLayoutToStartSegment");
        }
    }

    protected void setLayoutToMiddleSegment(int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setLayoutToMiddleSegment", new Object[]{"" + n, "" + n2, "" + bl, "" + bl2, "" + n3, "" + n4, "" + n5});
        }
        this.setLayoutToConversation(n, n2, bl, bl2, n3, 4, n4, n5, null, null);
        this.layout = JFapChannelConstants.XMIT_SEGMENT_MIDDLE;
        this.transmissionRemaining = n;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "setLayoutToMiddleSegment");
        }
    }

    protected void setLayoutToEndSegment(int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, Conversation conversation, SendListener sendListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "setLayoutToSegmentEnd", new Object[]{"" + n, "" + n2, "" + bl, "" + bl2, "" + n3, "" + n4, "" + n5, conversation, sendListener});
        }
        this.setLayoutToConversation(n, n2, bl, bl2, n3, 5, n4, n5, conversation, sendListener);
        this.layout = JFapChannelConstants.XMIT_SEGMENT_END;
        this.transmissionRemaining = n;
    }

    boolean buildTransmission(WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "buildTransmission", wsByteBuffer);
        }
        SIErrorException sIErrorException = null;
        block7: while (!this.exhausedXmitBuffer && !this.transmissionBuilt && sIErrorException == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "state=" + this.state + " layout=" + this.layout);
            }
            switch (this.state) {
                case 0: {
                    if (!this.buildHeader(this.primaryHeaderFields, wsByteBuffer)) continue block7;
                    if (this.layout == JFapChannelConstants.XMIT_PRIMARY_ONLY) {
                        this.state = 3;
                        continue block7;
                    }
                    if (this.layout == JFapChannelConstants.XMIT_CONVERSATION) {
                        this.state = 1;
                        continue block7;
                    }
                    if (this.layout == JFapChannelConstants.XMIT_SEGMENT_START) {
                        this.state = 1;
                        continue block7;
                    }
                    if (this.layout == JFapChannelConstants.XMIT_SEGMENT_MIDDLE) {
                        this.state = 1;
                        continue block7;
                    }
                    if (this.layout == JFapChannelConstants.XMIT_SEGMENT_END) {
                        this.state = 1;
                        continue block7;
                    }
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "unexpected layout: " + this.layout + " in state: " + this.state);
                    }
                    this.state = 4;
                    sIErrorException = new SIErrorException("unexpected layout: " + this.layout + " in state: " + this.state);
                    continue block7;
                }
                case 1: {
                    if (!this.buildHeader(this.conversationHeaderFields, wsByteBuffer)) continue block7;
                    if (this.layout == JFapChannelConstants.XMIT_CONVERSATION) {
                        this.state = 3;
                        continue block7;
                    }
                    if (this.layout == JFapChannelConstants.XMIT_SEGMENT_START) {
                        this.state = 2;
                        continue block7;
                    }
                    if (this.layout == JFapChannelConstants.XMIT_SEGMENT_MIDDLE) {
                        this.state = 3;
                        continue block7;
                    }
                    if (this.layout == JFapChannelConstants.XMIT_SEGMENT_END) {
                        this.state = 3;
                        continue block7;
                    }
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "unexpected layout: " + this.layout + " in state: " + this.state);
                    }
                    this.state = 4;
                    sIErrorException = new SIErrorException("unexpected layout: " + this.layout + " in state: " + this.state);
                    continue block7;
                }
                case 2: {
                    if (!this.buildHeader(this.segmentedTransmissionHeaderFields, wsByteBuffer)) continue block7;
                    if (this.layout == JFapChannelConstants.XMIT_SEGMENT_START) {
                        this.state = 3;
                        continue block7;
                    }
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(this, tc, "unexpected layout: " + this.layout + " in state: " + this.state);
                    }
                    this.state = 4;
                    sIErrorException = new SIErrorException("unexpected layout: " + this.layout + " in state: " + this.state);
                    continue block7;
                }
                case 3: {
                    if (!this.buildPayload(wsByteBuffer)) continue block7;
                    this.transmissionBuilt = true;
                    this.state = 0;
                    this.currentXmitDataBufferIndex = 0;
                    this.headerScratchSpace.clear();
                    continue block7;
                }
                case 4: {
                    if (sIErrorException == null) {
                        sIErrorException = new SIErrorException("Entered error state without exception been set");
                    }
                    this.connection.invalidate(true, sIErrorException, "error building transmission");
                    continue block7;
                }
            }
        }
        boolean bl = this.transmissionBuilt;
        if (this.transmissionBuilt) {
            this.transmissionBuilt = false;
        }
        this.exhausedXmitBuffer = false;
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "buildTransmission", "" + bl);
        }
        return bl;
    }

    protected Conversation getConversation() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getConversation");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getConversation", this.conversation);
        }
        return this.conversation;
    }

    protected boolean isPooledBuffers() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "isPooledBuffers");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "isPooledBuffers", "" + this.primaryHeaderFields.isPooled);
        }
        return this.primaryHeaderFields.isPooled;
    }

    protected int getPriority() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getPriority");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getPriority", "" + this.primaryHeaderFields.priority);
        }
        return this.primaryHeaderFields.priority;
    }

    protected SendListener getSendListener() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getSendListener");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getSendListener", this.sendListener);
        }
        return this.sendListener;
    }

    protected boolean isUserRequest() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "isUserRequest");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "isUserRequest", "" + this.isUserRequest);
        }
        return this.isUserRequest;
    }

    protected boolean isTerminal() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "isTermainl");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "isTermainl", "" + this.isTerminal);
        }
        return this.isTerminal;
    }

    protected int getSize() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getSize");
        }
        int n = 0;
        if (this.layout == JFapChannelConstants.XMIT_PRIMARY_ONLY) {
            n = 10;
        } else if (this.layout == JFapChannelConstants.XMIT_CONVERSATION) {
            n = 14;
        } else if (this.layout == JFapChannelConstants.XMIT_SEGMENT_START) {
            n = 26;
        } else if (this.layout == JFapChannelConstants.XMIT_SEGMENT_MIDDLE) {
            n = 14;
        } else if (this.layout == JFapChannelConstants.XMIT_SEGMENT_END) {
            n = 14;
        } else {
            throw new SIErrorException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"TRANSDATA_INTERNAL_SICJ0060", null, (String)"TRANSDATA_INTERNAL_SICJ0060"));
        }
        int n2 = this.primaryHeaderFields.segmentLength - n;
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getSize", "" + n2);
        }
        return n2;
    }

    private boolean buildHeader(HeaderFields headerFields, WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "buildHeader", new Object[]{headerFields, wsByteBuffer});
        }
        if (tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, wsByteBuffer, "xmitBuffer");
        }
        boolean bl = false;
        WsByteBuffer wsByteBuffer2 = null;
        if (this.headerScratchSpace.position() == 0) {
            if (tc.isDebugEnabled()) {
                JFapUtils.debugTraceWsByteBufferInfo(this, tc, this.headerScratchSpace, "headerScratchSpace");
            }
            if (wsByteBuffer.remaining() >= headerFields.sizeof()) {
                wsByteBuffer2 = wsByteBuffer;
                headerFields.writeToBuffer(wsByteBuffer);
                bl = true;
            } else {
                wsByteBuffer2 = this.headerScratchSpace;
                headerFields.writeToBuffer(this.headerScratchSpace);
                this.headerScratchSpace.flip();
            }
        } else {
            wsByteBuffer2 = this.headerScratchSpace;
        }
        if (!bl) {
            int n = wsByteBuffer2.remaining();
            int n2 = JFapUtils.copyWsByteBuffer(wsByteBuffer2, wsByteBuffer, n);
            boolean bl2 = bl = n2 == n;
        }
        if (bl) {
            this.headerScratchSpace.clear();
            this.transmissionRemaining -= headerFields.sizeof();
        } else {
            this.exhausedXmitBuffer = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "buildHeader", "" + bl);
        }
        return bl;
    }

    private boolean buildPayload(WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "buildPayload", wsByteBuffer);
        }
        if (tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, wsByteBuffer, "xmitBuffer");
        }
        boolean bl = false;
        if (this.xmitDataBuffers.length == 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "payload finished");
            }
            bl = true;
        } else {
            int n;
            int n2;
            do {
                if ((n = this.xmitDataBuffers[this.currentXmitDataBufferIndex].remaining()) > this.transmissionRemaining) {
                    n = this.transmissionRemaining;
                }
                n2 = JFapUtils.copyWsByteBuffer(this.xmitDataBuffers[this.currentXmitDataBufferIndex], wsByteBuffer, n);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "amountToCopy=" + n + " amountCopied=" + n2 + " currentXmitDataBufferIndex=" + this.currentXmitDataBufferIndex);
                }
                this.transmissionRemaining -= n2;
                if (n2 == n) {
                    ++this.currentXmitDataBufferIndex;
                    boolean bl2 = bl = this.currentXmitDataBufferIndex == this.xmitDataBuffers.length;
                }
                if (n2 >= n && this.transmissionRemaining >= 1) continue;
                this.exhausedXmitBuffer = true;
            } while (n2 == n && !bl && !this.exhausedXmitBuffer);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "buildPayload", "" + bl);
        }
        return bl;
    }

    protected void release() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "release");
        }
        this.iterator.release();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "release");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#) SIB/ws/code/sib.jfapchannel.impl/src/com/ibm/ws/sib/jfapchannel/impl/TransmissionData.java, SIB.comms, WAS602.SIB, o0610.11 1.13");
        }
    }

    private class SegmentedTransmissionHeaderFields
    extends HeaderFields {
        private long totalLength;
        int segmentType;

        protected SegmentedTransmissionHeaderFields() {
            super(12);
        }

        protected void writeToBuffer(WsByteBuffer wsByteBuffer) {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "SegmentedTransmissionHeaderFields.writeToBuffer");
            }
            wsByteBuffer.putLong(this.totalLength);
            wsByteBuffer.put((byte)this.segmentType);
            wsByteBuffer.put((byte)0);
            wsByteBuffer.putShort((short)0);
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "SegmentedTransmissionHeaderFields.writeToBuffer");
            }
        }
    }

    private class ConversationHeaderFields
    extends HeaderFields {
        private int conversationId;
        private int requestNumber;

        protected ConversationHeaderFields() {
            super(4);
        }

        protected void writeToBuffer(WsByteBuffer wsByteBuffer) {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "ConversationHeaderFields.writeToBuffer");
            }
            wsByteBuffer.putShort((short)this.conversationId);
            wsByteBuffer.putShort((short)this.requestNumber);
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "ConversationHeaderFields.writeToBuffer");
            }
        }
    }

    private class PrimaryHeaderFields
    extends HeaderFields {
        int segmentLength;
        int priority;
        boolean isPooled;
        boolean isExchange;
        int packetNumber;
        int segmentType;

        protected PrimaryHeaderFields() {
            super(10);
        }

        protected void writeToBuffer(WsByteBuffer wsByteBuffer) {
            if (tc.isEntryEnabled()) {
                SibTr.entry(this, tc, "PrimaryHeaderFields.writeToBuffer");
            }
            wsByteBuffer.putShort((short)-16657);
            wsByteBuffer.putInt(this.segmentLength);
            short s = (short)(this.priority & 0xF);
            if (this.isPooled) {
                s = (short)(s | 0x1000);
            }
            if (this.isExchange) {
                s = (short)(s | 0x4000);
            }
            wsByteBuffer.putShort(s);
            wsByteBuffer.put((byte)this.packetNumber);
            wsByteBuffer.put((byte)this.segmentType);
            if (tc.isEntryEnabled()) {
                SibTr.exit(this, tc, "PrimaryHeaderFields.writeToBuffer");
            }
        }
    }

    private abstract class HeaderFields {
        private int sizeof;

        protected HeaderFields(int n) {
            this.sizeof = n;
        }

        protected int sizeof() {
            return this.sizeof;
        }

        protected abstract void writeToBuffer(WsByteBuffer var1);
    }
}

