/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.jfapchannel.AcceptListener;
import com.ibm.ws.sib.jfapchannel.AcceptListenerFactory;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.ListenerPort;
import com.ibm.ws.sib.jfapchannel.ServerConnectionManager;
import com.ibm.ws.sib.jfapchannel.impl.BufferPoolManagerReference;
import com.ibm.ws.sib.jfapchannel.impl.ChannelFrameworkReference;
import com.ibm.ws.sib.jfapchannel.impl.ListenerPortImpl;
import com.ibm.ws.sib.jfapchannel.impl.octracker.OutboundConnectionTracker;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Hashtable;

public class ServerConnectionManagerImpl
extends ServerConnectionManager {
    private static final TraceComponent tc = SibTr.register(ServerConnectionManagerImpl.class, "SIBJFapChannel", "com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private Hashtable portToListenerMap = null;
    private static OutboundConnectionTracker connectionTracker = null;
    private static final ServerConnectionManagerState STATE_UNITIALISED = new ServerConnectionManagerState("uninitialised");
    private static final ServerConnectionManagerState STATE_INITIALISED = new ServerConnectionManagerState("initialised");
    private static final ServerConnectionManagerState STATE_INITIALISATION_FAILED = new ServerConnectionManagerState("initialisation_failed");
    private static ServerConnectionManagerState state = STATE_UNITIALISED;
    private static volatile int defaultHeartbeatInterval = 300;
    private static volatile int defaultHeartbeatTimeout = 7;
    private static ChannelFramework framework = null;
    private static AcceptListenerFactory acceptListenerFactory;

    public ServerConnectionManagerImpl() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "<init>");
        }
        this.portToListenerMap = new Hashtable();
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "<init>");
        }
    }

    protected ListenerPort listen(int n, AcceptListener acceptListener, String string) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "listen", new Object[]{"" + n, acceptListener});
        }
        if (state != STATE_INITIALISED) {
            if (state == STATE_UNITIALISED) {
                throw new SIErrorException(nls.getFormattedMessage("SVRCONNMGR_INTERNAL_SICJ0059", null, "SVRCONNMGR_INTERNAL_SICJ0059"));
            }
            String string2 = nls.getFormattedMessage("EXCP_LISTEN_FAIL_NO_CF_SICJ0008", null, null);
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "listen failed because comms failed to initialise");
            }
            throw new SIResourceException(string2);
        }
        if (acceptListener == null) {
            throw new SIErrorException(nls.getFormattedMessage("SVRCONNMGR_INTERNAL_SICJ0059", null, "SVRCONNMGR_INTERNAL_SICJ0059"));
        }
        if (string == null) {
            throw new SIErrorException(nls.getFormattedMessage("SVRCONNMGR_INTERNAL_SICJ0059", null, "SVRCONNMGR_INTERNAL_SICJ0059"));
        }
        String string3 = "tcp.channel.inbound.port." + n;
        String string4 = "jfap.channel.inbound.port." + n;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.sib.jfapchannel.impl.ServerConnectionManager.listen", (String)"00120001");
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "Exception finding tcp channel factory via reflection");
            }
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, tc, classNotFoundException);
            }
            throw new SIErrorException(nls.getFormattedMessage("SVRCONNMGR_INTERNAL_SICJ0059", null, "SVRCONNMGR_INTERNAL_SICJ0059"), classNotFoundException);
        }
        ListenerPortImpl listenerPortImpl = null;
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "framework=" + framework + " tcpChannelFactory=" + clazz);
        }
        if (framework != null && clazz != null) {
            try {
                HashMap hashMap = new HashMap();
                framework.updateAllChannelFactoryProperties(clazz, hashMap);
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                hashMap2.put("port", "" + n);
                framework.addChannel(string3, clazz, hashMap2, 10);
                HashMap<String, AcceptListener> hashMap3 = new HashMap<String, AcceptListener>();
                hashMap3.put("jfapchannel.ACCEPT_LISTENER", acceptListener);
                Class<?> clazz2 = null;
                try {
                    clazz2 = Class.forName("com.ibm.ws.sib.jfapchannel.impl.WSJFapChannelFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (tc.isEventEnabled()) {
                        SibTr.exception(tc, classNotFoundException);
                    }
                    throw new SIErrorException(nls.getFormattedMessage("SVRCONNMGR_INTERNAL_SICJ0059", null, "SVRCONNMGR_INTERNAL_SICJ0059"), classNotFoundException);
                }
                framework.addChannel(string4, clazz2, hashMap3, 10);
                String[] stringArray = new String[]{string3, string4};
                framework.addChain(string, FlowType.INBOUND, stringArray);
                framework.initChain(string);
                framework.startChain(string);
                listenerPortImpl = new ListenerPortImpl(string, acceptListener, n);
                this.portToListenerMap.put(new Integer(n), listenerPortImpl);
            }
            catch (ChainException chainException) {
                FFDCFilter.processException((Throwable)chainException, (String)"com.ibm.ws.sib.jfapchannel.impl.ServerConnectionManagerImpl.initialise", (String)"00120002", (Object[])new Object[]{clazz, framework});
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "caught exception initialising channel framework");
                }
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, tc, (Exception)((Object)chainException));
                }
                throw new SIErrorException(nls.getFormattedMessage("SVRCONNMGR_INTERNAL_SICJ0059", null, "SVRCONNMGR_INTERNAL_SICJ0059"), chainException);
            }
            catch (ChannelException channelException) {
                FFDCFilter.processException((Throwable)channelException, (String)"com.ibm.ws.sib.jfapchannel.impl.ServerConnectionManagerImpl.initialise", (String)"00120003", (Object[])new Object[]{clazz, framework});
                if (tc.isDebugEnabled()) {
                    SibTr.debug(this, tc, "caught exception initialising channel framework");
                }
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, tc, (Exception)((Object)channelException));
                }
                throw new SIErrorException(nls.getFormattedMessage("SVRCONNMGR_INTERNAL_SICJ0059", null, "SVRCONNMGR_INTERNAL_SICJ0059"), channelException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "listen", listenerPortImpl);
        }
        return listenerPortImpl;
    }

    protected ListenerPort listen(int n, AcceptListener acceptListener) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "listen", new Object[]{"" + n, acceptListener});
        }
        ListenerPort listenerPort = this.listen(n, acceptListener, "JStreamUnitTestDefaultInboundMessaging" + n);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "listen", listenerPort);
        }
        return listenerPort;
    }

    protected ListenerPort listen(int n, String string) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "listen", new Object[]{"" + n, string});
        }
        ListenerPort listenerPort = this.listen(n, acceptListenerFactory.manufactureAcceptListener(), string);
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "listen", listenerPort);
        }
        return listenerPort;
    }

    public void closeAll(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "closeAll", "" + bl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "closeAll");
        }
    }

    public static void initialise(AcceptListenerFactory acceptListenerFactory) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "initalise");
        }
        ServerConnectionManagerImpl.acceptListenerFactory = acceptListenerFactory;
        framework = ChannelFrameworkReference.getInstance();
        if (framework == null) {
            state = STATE_INITIALISATION_FAILED;
        } else {
            state = STATE_INITIALISED;
            connectionTracker = new OutboundConnectionTracker(framework);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "initalise");
        }
    }

    public Conversation connect(InetSocketAddress inetSocketAddress, ConversationReceiveListener conversationReceiveListener, String string) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "connect", new Object[]{inetSocketAddress, conversationReceiveListener, string});
        }
        if (state == STATE_UNITIALISED) {
            throw new SIErrorException(nls.getFormattedMessage("SVRCONNMGR_INTERNAL_SICJ0059", null, "SVRCONNMGR_INTERNAL_SICJ0059"));
        }
        if (state == STATE_INITIALISATION_FAILED) {
            String string2 = nls.getFormattedMessage("EXCP_CONN_FAIL_NO_CF_SICJ0007", null, null);
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "connection failed because comms failed to initialise");
            }
            throw new SIResourceException(string2);
        }
        Conversation conversation = connectionTracker.connect(inetSocketAddress, conversationReceiveListener, string);
        if (conversation != null) {
            conversation.setConversationType(Conversation.ME);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "connect", conversation);
        }
        return conversation;
    }

    public Conversation connect(CFEndPoint cFEndPoint, ConversationReceiveListener conversationReceiveListener) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "connect", new Object[]{cFEndPoint, conversationReceiveListener});
        }
        if (state == STATE_UNITIALISED) {
            throw new SIErrorException(nls.getFormattedMessage("SVRCONNMGR_INTERNAL_SICJ0059", null, "SVRCONNMGR_INTERNAL_SICJ0059"));
        }
        if (state == STATE_INITIALISATION_FAILED) {
            String string = nls.getFormattedMessage("EXCP_CONN_FAIL_NO_CF_SICJ0007", null, null);
            if (tc.isDebugEnabled()) {
                SibTr.debug(this, tc, "connection failed because comms failed to initialise");
            }
            throw new SIResourceException(string);
        }
        Conversation conversation = connectionTracker.connect(cFEndPoint, conversationReceiveListener);
        if (conversation != null) {
            conversation.setConversationType(Conversation.ME);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "connect", conversation);
        }
        return conversation;
    }

    public WsByteBufferPoolManager getBufferPoolManager() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(this, tc, "getBufferPoolManager");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(this, tc, "getBufferPoolManager");
        }
        return BufferPoolManagerReference.getInstance();
    }

    protected static AcceptListenerFactory getAcceptListenerFactory() {
        return acceptListenerFactory;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "@(#) SIB/ws/code/sib.jfapchannel.impl/src/com/ibm/ws/sib/jfapchannel/impl/ServerConnectionManagerImpl.java, SIB.comms, WAS602.SIB, o0610.11 1.42");
        }
    }

    private static final class ServerConnectionManagerState {
        private String description;

        private ServerConnectionManagerState(String string) {
            this.description = string;
        }

        public String toString() {
            return this.description;
        }
    }
}

